/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMatrixReadOnly.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrixInit.h"
#include "JSDOMMatrixReadOnly.h"
#include "JSDOMOperation.h"
#include "JSDOMPoint.h"
#include "JSDOMPointInit.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyConstructorFunction_fromMatrix);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyConstructorFunction_fromFloat32Array);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyConstructorFunction_fromFloat64Array);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_translate);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_scale);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_scale3d);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_scaleNonUniform);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_rotate);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_rotateFromVector);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_rotateAxisAngle);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_skewX);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_skewY);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_multiply);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_flipX);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_flipY);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_inverse);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_transformPoint);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_toFloat32Array);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_toFloat64Array);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_toJSON);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_toString);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnlyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_a);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_b);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_c);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_d);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_e);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_f);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m11);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m12);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m13);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m14);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m21);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m22);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m23);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m24);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m31);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m32);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m33);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m34);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m41);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m42);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m43);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m44);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_is2D);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixReadOnly_isIdentity);

class JSDOMMatrixReadOnlyPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMMatrixReadOnlyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMMatrixReadOnlyPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMMatrixReadOnlyPrototype>(vm)) JSDOMMatrixReadOnlyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMMatrixReadOnlyPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMMatrixReadOnlyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMMatrixReadOnlyPrototype, JSDOMMatrixReadOnlyPrototype::Base);

using JSDOMMatrixReadOnlyDOMConstructor = JSDOMConstructor<JSDOMMatrixReadOnly>;

/* Hash table for constructor */

static const std::array<HashTableValue, 3> JSDOMMatrixReadOnlyConstructorTableValues {
    HashTableValue { "fromMatrix"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyConstructorFunction_fromMatrix, 0 } },
    HashTableValue { "fromFloat32Array"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyConstructorFunction_fromFloat32Array, 1 } },
    HashTableValue { "fromFloat64Array"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyConstructorFunction_fromFloat64Array, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSDOMMatrixReadOnlyDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSDOMMatrixReadOnlyDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "DOMMatrixReadOnly"_s);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto initConversionResult = convert<IDLOptional<IDLUnion<IDLDOMString, IDLSequence<IDLUnrestrictedDouble>>>>(*lexicalGlobalObject, argument0.value());
    if (initConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = DOMMatrixReadOnly::create(*context, initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<DOMMatrixReadOnly>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<DOMMatrixReadOnly>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSDOMMatrixReadOnlyDOMConstructorConstruct, JSDOMMatrixReadOnlyDOMConstructor::construct);

template<> const ClassInfo JSDOMMatrixReadOnlyDOMConstructor::s_info = { "DOMMatrixReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrixReadOnlyDOMConstructor) };

template<> JSValue JSDOMMatrixReadOnlyDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMMatrixReadOnlyDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DOMMatrixReadOnly"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMMatrixReadOnly::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSDOMMatrixReadOnly::info(), JSDOMMatrixReadOnlyConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 43> JSDOMMatrixReadOnlyPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnlyConstructor, 0 } },
    HashTableValue { "a"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_a, 0 } },
    HashTableValue { "b"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_b, 0 } },
    HashTableValue { "c"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_c, 0 } },
    HashTableValue { "d"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_d, 0 } },
    HashTableValue { "e"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_e, 0 } },
    HashTableValue { "f"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_f, 0 } },
    HashTableValue { "m11"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m11, 0 } },
    HashTableValue { "m12"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m12, 0 } },
    HashTableValue { "m13"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m13, 0 } },
    HashTableValue { "m14"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m14, 0 } },
    HashTableValue { "m21"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m21, 0 } },
    HashTableValue { "m22"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m22, 0 } },
    HashTableValue { "m23"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m23, 0 } },
    HashTableValue { "m24"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m24, 0 } },
    HashTableValue { "m31"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m31, 0 } },
    HashTableValue { "m32"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m32, 0 } },
    HashTableValue { "m33"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m33, 0 } },
    HashTableValue { "m34"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m34, 0 } },
    HashTableValue { "m41"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m41, 0 } },
    HashTableValue { "m42"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m42, 0 } },
    HashTableValue { "m43"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m43, 0 } },
    HashTableValue { "m44"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_m44, 0 } },
    HashTableValue { "is2D"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_is2D, 0 } },
    HashTableValue { "isIdentity"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixReadOnly_isIdentity, 0 } },
    HashTableValue { "translate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_translate, 0 } },
    HashTableValue { "scale"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_scale, 0 } },
    HashTableValue { "scale3d"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_scale3d, 0 } },
    HashTableValue { "scaleNonUniform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_scaleNonUniform, 0 } },
    HashTableValue { "rotate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_rotate, 0 } },
    HashTableValue { "rotateFromVector"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_rotateFromVector, 0 } },
    HashTableValue { "rotateAxisAngle"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_rotateAxisAngle, 0 } },
    HashTableValue { "skewX"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_skewX, 0 } },
    HashTableValue { "skewY"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_skewY, 0 } },
    HashTableValue { "multiply"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_multiply, 0 } },
    HashTableValue { "flipX"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_flipX, 0 } },
    HashTableValue { "flipY"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_flipY, 0 } },
    HashTableValue { "inverse"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_inverse, 0 } },
    HashTableValue { "transformPoint"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_transformPoint, 0 } },
    HashTableValue { "toFloat32Array"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_toFloat32Array, 0 } },
    HashTableValue { "toFloat64Array"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_toFloat64Array, 0 } },
    HashTableValue { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_toJSON, 0 } },
    HashTableValue { "toString"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixReadOnlyPrototypeFunction_toString, 0 } },
};

const ClassInfo JSDOMMatrixReadOnlyPrototype::s_info = { "DOMMatrixReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrixReadOnlyPrototype) };

void JSDOMMatrixReadOnlyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMMatrixReadOnly::info(), JSDOMMatrixReadOnlyPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!(globalObject())->inherits<JSDOMWindowBase>()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "toString"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMMatrixReadOnly::s_info = { "DOMMatrixReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrixReadOnly) };

JSDOMMatrixReadOnly::JSDOMMatrixReadOnly(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMMatrixReadOnly>&& impl)
    : JSDOMWrapper<DOMMatrixReadOnly, SignedPtrTraits<DOMMatrixReadOnly, DOMMatrixReadOnlyPtrTag>>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DOMMatrixReadOnly>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDOMMatrixReadOnly::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMMatrixReadOnlyPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDOMMatrixReadOnlyPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMMatrixReadOnly::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMMatrixReadOnly>(vm, globalObject);
}

JSValue JSDOMMatrixReadOnly::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMatrixReadOnlyDOMConstructor, DOMConstructorID::DOMMatrixReadOnly>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMMatrixReadOnly::destroy(JSC::JSCell* cell)
{
    JSDOMMatrixReadOnly* thisObject = static_cast<JSDOMMatrixReadOnly*>(cell);
    thisObject->JSDOMMatrixReadOnly::~JSDOMMatrixReadOnly();
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnlyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMMatrixReadOnlyPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMMatrixReadOnly::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDOMMatrixReadOnly_aGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.a())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_a, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_aGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_bGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.b())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_bGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_cGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.c())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_c, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_cGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_dGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.d())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_d, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_dGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_eGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.e())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_e, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_eGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_fGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.f())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_f, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_fGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m11Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m11())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m11, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m11Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m12Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m12())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m12, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m12Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m13Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m13())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m13, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m13Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m14Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m14())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m14, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m14Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m21Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m21())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m21, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m21Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m22Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m22())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m22, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m22Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m23Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m23())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m23, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m23Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m24Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m24())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m24, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m24Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m31Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m31())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m31, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m31Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m32Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m32())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m32, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m32Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m33Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m33())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m33, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m33Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m34Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m34())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m34, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m34Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m41Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m41())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m41, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m41Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m42Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m42())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m42, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m42Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m43Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m43())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m43, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m43Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_m44Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m44())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_m44, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_m44Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_is2DGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.is2D())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_is2D, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_is2DGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMatrixReadOnly_isIdentityGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isIdentity())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixReadOnly_isIdentity, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnly_isIdentityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyConstructorFunction_fromMatrixBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto otherConversionResult = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, argument0.value());
    if (otherConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrixReadOnly>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrixReadOnly::fromMatrix(otherConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyConstructorFunction_fromMatrix, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::callStatic<jsDOMMatrixReadOnlyConstructorFunction_fromMatrixBody>(*lexicalGlobalObject, *callFrame, "fromMatrix");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyConstructorFunction_fromFloat32ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto array32ConversionResult = convert<IDLFloat32Array>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array32"_s, "DOMMatrixReadOnly"_s, "fromFloat32Array"_s, "Float32Array"_s); });
    if (array32ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrixReadOnly>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrixReadOnly::fromFloat32Array(array32ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyConstructorFunction_fromFloat32Array, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::callStatic<jsDOMMatrixReadOnlyConstructorFunction_fromFloat32ArrayBody>(*lexicalGlobalObject, *callFrame, "fromFloat32Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyConstructorFunction_fromFloat64ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto array64ConversionResult = convert<IDLFloat64Array>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array64"_s, "DOMMatrixReadOnly"_s, "fromFloat64Array"_s, "Float64Array"_s); });
    if (array64ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrixReadOnly>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrixReadOnly::fromFloat64Array(array64ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyConstructorFunction_fromFloat64Array, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::callStatic<jsDOMMatrixReadOnlyConstructorFunction_fromFloat64ArrayBody>(*lexicalGlobalObject, *callFrame, "fromFloat64Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_translateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto txConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (txConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto tyConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (tyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto tzConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (tzConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.translate(txConversionResult.releaseReturnValue(), tyConversionResult.releaseReturnValue(), tzConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_translate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_translateBody>(*lexicalGlobalObject, *callFrame, "translate");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_scaleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto scaleXConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1 }; });
    if (scaleXConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto scaleYConversionResult = convert<IDLOptional<IDLUnrestrictedDouble>>(*lexicalGlobalObject, argument1.value());
    if (scaleYConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto scaleZConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1 }; });
    if (scaleZConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto originXConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (originXConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto originYConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (originYConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto originZConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument5.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (originZConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.scale(scaleXConversionResult.releaseReturnValue(), scaleYConversionResult.releaseReturnValue(), scaleZConversionResult.releaseReturnValue(), originXConversionResult.releaseReturnValue(), originYConversionResult.releaseReturnValue(), originZConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_scale, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_scaleBody>(*lexicalGlobalObject, *callFrame, "scale");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_scale3dBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto scaleConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1 }; });
    if (scaleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto originXConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (originXConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto originYConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (originYConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto originZConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (originZConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.scale3d(scaleConversionResult.releaseReturnValue(), originXConversionResult.releaseReturnValue(), originYConversionResult.releaseReturnValue(), originZConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_scale3d, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_scale3dBody>(*lexicalGlobalObject, *callFrame, "scale3d");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_scaleNonUniformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto scaleXConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1 }; });
    if (scaleXConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto scaleYConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1 }; });
    if (scaleYConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.scaleNonUniform(scaleXConversionResult.releaseReturnValue(), scaleYConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_scaleNonUniform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_scaleNonUniformBody>(*lexicalGlobalObject, *callFrame, "scaleNonUniform");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_rotateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto rotXConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (rotXConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto rotYConversionResult = convert<IDLOptional<IDLUnrestrictedDouble>>(*lexicalGlobalObject, argument1.value());
    if (rotYConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto rotZConversionResult = convert<IDLOptional<IDLUnrestrictedDouble>>(*lexicalGlobalObject, argument2.value());
    if (rotZConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.rotate(rotXConversionResult.releaseReturnValue(), rotYConversionResult.releaseReturnValue(), rotZConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_rotate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_rotateBody>(*lexicalGlobalObject, *callFrame, "rotate");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_rotateFromVectorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.rotateFromVector(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_rotateFromVector, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_rotateFromVectorBody>(*lexicalGlobalObject, *callFrame, "rotateFromVector");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_rotateAxisAngleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto zConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (zConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto angleConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (angleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.rotateAxisAngle(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), zConversionResult.releaseReturnValue(), angleConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_rotateAxisAngle, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_rotateAxisAngleBody>(*lexicalGlobalObject, *callFrame, "rotateAxisAngle");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_skewXBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto sxConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (sxConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.skewX(sxConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_skewX, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_skewXBody>(*lexicalGlobalObject, *callFrame, "skewX");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_skewYBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto syConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (syConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.skewY(syConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_skewY, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_skewYBody>(*lexicalGlobalObject, *callFrame, "skewY");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_multiplyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto otherConversionResult = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, argument0.value());
    if (otherConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.multiply(otherConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_multiply, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_multiplyBody>(*lexicalGlobalObject, *callFrame, "multiply");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_flipXBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.flipX())));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_flipX, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_flipXBody>(*lexicalGlobalObject, *callFrame, "flipX");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_flipYBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.flipY())));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_flipY, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_flipYBody>(*lexicalGlobalObject, *callFrame, "flipY");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_inverseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.inverse())));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_inverse, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_inverseBody>(*lexicalGlobalObject, *callFrame, "inverse");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_transformPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto pointConversionResult = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, argument0.value());
    if (pointConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.transformPoint(pointConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_transformPoint, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_transformPointBody>(*lexicalGlobalObject, *callFrame, "transformPoint");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_toFloat32ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat32Array>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.toFloat32Array())));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_toFloat32Array, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_toFloat32ArrayBody>(*lexicalGlobalObject, *callFrame, "toFloat32Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_toFloat64ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat64Array>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.toFloat64Array())));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_toFloat64Array, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_toFloat64ArrayBody>(*lexicalGlobalObject, *callFrame, "toFloat64Array");
}

static inline EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSDOMMatrixReadOnly* castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto aValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.a());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "a"_s), aValue);
    auto bValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.b());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "b"_s), bValue);
    auto cValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.c());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "c"_s), cValue);
    auto dValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.d());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "d"_s), dValue);
    auto eValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.e());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "e"_s), eValue);
    auto fValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.f());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "f"_s), fValue);
    auto m11Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m11());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m11"_s), m11Value);
    auto m12Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m12());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m12"_s), m12Value);
    auto m13Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m13());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m13"_s), m13Value);
    auto m14Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m14());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m14"_s), m14Value);
    auto m21Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m21());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m21"_s), m21Value);
    auto m22Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m22());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m22"_s), m22Value);
    auto m23Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m23());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m23"_s), m23Value);
    auto m24Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m24());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m24"_s), m24Value);
    auto m31Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m31());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m31"_s), m31Value);
    auto m32Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m32());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m32"_s), m32Value);
    auto m33Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m33());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m33"_s), m33Value);
    auto m34Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m34());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m34"_s), m34Value);
    auto m41Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m41());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m41"_s), m41Value);
    auto m42Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m42());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m42"_s), m42Value);
    auto m43Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m43());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m43"_s), m43Value);
    auto m44Value = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.m44());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "m44"_s), m44Value);
    auto is2DValue = toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.is2D());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "is2D"_s), is2DValue);
    auto isIdentityValue = toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isIdentity());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "isIdentity"_s), isIdentityValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunction_toStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.toString())));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixReadOnlyPrototypeFunction_toString, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunction_toStringBody>(*lexicalGlobalObject, *callFrame, "toString");
}

JSC::GCClient::IsoSubspace* JSDOMMatrixReadOnly::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMMatrixReadOnly, UseCustomHeapCellType::No>(vm, "JSDOMMatrixReadOnly"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMMatrixReadOnly.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMMatrixReadOnly = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMMatrixReadOnly.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMMatrixReadOnly = std::forward<decltype(space)>(space); }
    );
}

void JSDOMMatrixReadOnly::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMMatrixReadOnly*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMMatrixReadOnlyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDOMMatrixReadOnlyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMMatrixReadOnly = static_cast<JSDOMMatrixReadOnly*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMMatrixReadOnly->protectedWrapped().ptr(), jsDOMMatrixReadOnly);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMMatrixReadOnly@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17DOMMatrixReadOnlyE[]; }
#endif
template<std::same_as<DOMMatrixReadOnly> T>
static inline void verifyVTable(DOMMatrixReadOnly* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DOMMatrixReadOnly@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17DOMMatrixReadOnlyE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DOMMatrixReadOnly has subclasses. If DOMMatrixReadOnly has subclasses that get passed
        // to toJS() we currently require DOMMatrixReadOnly you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMMatrixReadOnly>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DOMMatrixReadOnly>(impl.ptr());
#endif
    return createWrapper<DOMMatrixReadOnly>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMMatrixReadOnly& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMMatrixReadOnly* JSDOMMatrixReadOnly::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMMatrixReadOnly*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
