/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWakeLock.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSWakeLockSentinel.h"
#include "JSWakeLockType.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWakeLockPrototypeFunction_request);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWakeLockConstructor);

class JSWakeLockPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWakeLockPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWakeLockPrototype* ptr = new (NotNull, JSC::allocateCell<JSWakeLockPrototype>(vm)) JSWakeLockPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWakeLockPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWakeLockPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWakeLockPrototype, JSWakeLockPrototype::Base);

using JSWakeLockDOMConstructor = JSDOMConstructorNotConstructable<JSWakeLock>;

template<> const ClassInfo JSWakeLockDOMConstructor::s_info = { "WakeLock"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWakeLockDOMConstructor) };

template<> JSValue JSWakeLockDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWakeLockDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WakeLock"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWakeLock::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSWakeLockPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWakeLockConstructor, 0 } },
    HashTableValue { "request"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWakeLockPrototypeFunction_request, 0 } },
};

const ClassInfo JSWakeLockPrototype::s_info = { "WakeLock"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWakeLockPrototype) };

void JSWakeLockPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWakeLock::info(), JSWakeLockPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWakeLock::s_info = { "WakeLock"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWakeLock) };

JSWakeLock::JSWakeLock(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WakeLock>&& impl)
    : JSDOMWrapper<WakeLock>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WakeLock>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWakeLock::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWakeLockPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWakeLockPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWakeLock::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWakeLock>(vm, globalObject);
}

JSValue JSWakeLock::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWakeLockDOMConstructor, DOMConstructorID::WakeLock>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWakeLock::destroy(JSC::JSCell* cell)
{
    JSWakeLock* thisObject = static_cast<JSWakeLock*>(cell);
    thisObject->JSWakeLock::~JSWakeLock();
}

JSC_DEFINE_CUSTOM_GETTER(jsWakeLockConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWakeLockPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWakeLock::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsWakeLockPrototypeFunction_requestBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWakeLock>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto typeConversionResult = convertOptionalWithDefault<IDLEnumeration<WakeLockType>>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLEnumeration<WakeLockType>> { return Converter<IDLEnumeration<WakeLockType>>::ReturnType { WakeLockType::Screen }; }, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "type"_s, "WakeLock"_s, "request"_s, expectedEnumerationValues<WakeLockType>()); });
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<WakeLockSentinel>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.request(typeConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWakeLockPrototypeFunction_request, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWakeLock>::call<jsWakeLockPrototypeFunction_requestBody>(*lexicalGlobalObject, *callFrame, "request");
}

JSC::GCClient::IsoSubspace* JSWakeLock::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWakeLock, UseCustomHeapCellType::No>(vm, "JSWakeLock"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWakeLock.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWakeLock = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWakeLock.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWakeLock = std::forward<decltype(space)>(space); }
    );
}

void JSWakeLock::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWakeLock*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWakeLockOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWakeLockOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWakeLock = static_cast<JSWakeLock*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWakeLock->protectedWrapped().ptr(), jsWakeLock);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WakeLock@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8WakeLockE[]; }
#endif
template<std::same_as<WakeLock> T>
static inline void verifyVTable(WakeLock* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WakeLock@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore8WakeLockE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WakeLock has subclasses. If WakeLock has subclasses that get passed
        // to toJS() we currently require WakeLock you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WakeLock>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WakeLock>(impl.ptr());
#endif
    return createWrapper<WakeLock>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WakeLock& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WakeLock* JSWakeLock::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWakeLock*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
