/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioContextOptions.h"

#include "JSAudioContextLatencyCategory.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertUnion.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<AudioContextOptions>> convertDictionary<AudioContextOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    AudioContextOptions result;
    JSValue latencyHintValue;
    if (isNullOrUndefined)
        latencyHintValue = jsUndefined();
    else {
        latencyHintValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "latencyHint"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto latencyHintConversionResult = convertOptionalWithDefault<IDLUnion<IDLEnumeration<AudioContextLatencyCategory>, IDLDouble>>(lexicalGlobalObject, latencyHintValue, [&]() -> ConversionResult<IDLUnion<IDLEnumeration<AudioContextLatencyCategory>, IDLDouble>> { return Converter<IDLUnion<IDLEnumeration<AudioContextLatencyCategory>, IDLDouble>>::ReturnType { AudioContextLatencyCategory::Interactive }; });
    if (latencyHintConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.latencyHint = latencyHintConversionResult.releaseReturnValue();
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!sampleRateValue.isUndefined()) {
        auto sampleRateConversionResult = convert<IDLFloat>(lexicalGlobalObject, sampleRateValue);
        if (sampleRateConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.sampleRate = sampleRateConversionResult.releaseReturnValue();
    }
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(WEB_AUDIO)
