/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUAdapterInfo.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapterInfoConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapterInfo_vendor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapterInfo_architecture);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapterInfo_device);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapterInfo_description);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapterInfo_isFallbackAdapter);

class JSGPUAdapterInfoPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUAdapterInfoPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUAdapterInfoPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUAdapterInfoPrototype>(vm)) JSGPUAdapterInfoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUAdapterInfoPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUAdapterInfoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUAdapterInfoPrototype, JSGPUAdapterInfoPrototype::Base);

using JSGPUAdapterInfoDOMConstructor = JSDOMConstructorNotConstructable<JSGPUAdapterInfo>;

template<> const ClassInfo JSGPUAdapterInfoDOMConstructor::s_info = { "GPUAdapterInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUAdapterInfoDOMConstructor) };

template<> JSValue JSGPUAdapterInfoDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUAdapterInfoDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUAdapterInfo"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUAdapterInfo::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSGPUAdapterInfoPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapterInfoConstructor, 0 } },
    HashTableValue { "vendor"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapterInfo_vendor, 0 } },
    HashTableValue { "architecture"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapterInfo_architecture, 0 } },
    HashTableValue { "device"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapterInfo_device, 0 } },
    HashTableValue { "description"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapterInfo_description, 0 } },
    HashTableValue { "isFallbackAdapter"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapterInfo_isFallbackAdapter, 0 } },
};

const ClassInfo JSGPUAdapterInfoPrototype::s_info = { "GPUAdapterInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUAdapterInfoPrototype) };

void JSGPUAdapterInfoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUAdapterInfo::info(), JSGPUAdapterInfoPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUAdapterInfo::s_info = { "GPUAdapterInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUAdapterInfo) };

JSGPUAdapterInfo::JSGPUAdapterInfo(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUAdapterInfo>&& impl)
    : JSDOMWrapper<GPUAdapterInfo>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUAdapterInfo>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUAdapterInfo::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUAdapterInfoPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUAdapterInfoPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUAdapterInfo::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUAdapterInfo>(vm, globalObject);
}

JSValue JSGPUAdapterInfo::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUAdapterInfoDOMConstructor, DOMConstructorID::GPUAdapterInfo>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUAdapterInfo::destroy(JSC::JSCell* cell)
{
    JSGPUAdapterInfo* thisObject = static_cast<JSGPUAdapterInfo*>(cell);
    thisObject->JSGPUAdapterInfo::~JSGPUAdapterInfo();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapterInfoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUAdapterInfoPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUAdapterInfo::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPUAdapterInfo_vendorGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapterInfo& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.vendor())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapterInfo_vendor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapterInfo>::get<jsGPUAdapterInfo_vendorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUAdapterInfo_architectureGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapterInfo& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.architecture())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapterInfo_architecture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapterInfo>::get<jsGPUAdapterInfo_architectureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUAdapterInfo_deviceGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapterInfo& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.device())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapterInfo_device, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapterInfo>::get<jsGPUAdapterInfo_deviceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUAdapterInfo_descriptionGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapterInfo& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.description())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapterInfo_description, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapterInfo>::get<jsGPUAdapterInfo_descriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUAdapterInfo_isFallbackAdapterGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapterInfo& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isFallbackAdapter())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapterInfo_isFallbackAdapter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapterInfo>::get<jsGPUAdapterInfo_isFallbackAdapterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGPUAdapterInfo::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUAdapterInfo, UseCustomHeapCellType::No>(vm, "JSGPUAdapterInfo"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUAdapterInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUAdapterInfo = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUAdapterInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUAdapterInfo = std::forward<decltype(space)>(space); }
    );
}

void JSGPUAdapterInfo::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUAdapterInfo*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUAdapterInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUAdapterInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUAdapterInfo = static_cast<JSGPUAdapterInfo*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUAdapterInfo->protectedWrapped().ptr(), jsGPUAdapterInfo);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUAdapterInfo@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14GPUAdapterInfoE[]; }
#endif
template<std::same_as<GPUAdapterInfo> T>
static inline void verifyVTable(GPUAdapterInfo* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUAdapterInfo@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14GPUAdapterInfoE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUAdapterInfo has subclasses. If GPUAdapterInfo has subclasses that get passed
        // to toJS() we currently require GPUAdapterInfo you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUAdapterInfo>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUAdapterInfo>(impl.ptr());
#endif
    return createWrapper<GPUAdapterInfo>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUAdapterInfo& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUAdapterInfo* JSGPUAdapterInfo::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUAdapterInfo*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
