/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUAdapter.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUAdapterInfo.h"
#include "JSGPUDevice.h"
#include "JSGPUDeviceDescriptor.h"
#include "JSGPUSupportedFeatures.h"
#include "JSGPUSupportedLimits.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPUAdapterPrototypeFunction_requestDevice);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapterConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapter_features);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapter_limits);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapter_info);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapter_isFallbackAdapter);

class JSGPUAdapterPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUAdapterPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUAdapterPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUAdapterPrototype>(vm)) JSGPUAdapterPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUAdapterPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUAdapterPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUAdapterPrototype, JSGPUAdapterPrototype::Base);

using JSGPUAdapterDOMConstructor = JSDOMConstructorNotConstructable<JSGPUAdapter>;

template<> const ClassInfo JSGPUAdapterDOMConstructor::s_info = { "GPUAdapter"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUAdapterDOMConstructor) };

template<> JSValue JSGPUAdapterDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUAdapterDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUAdapter"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUAdapter::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSGPUAdapterPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapterConstructor, 0 } },
    HashTableValue { "features"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapter_features, 0 } },
    HashTableValue { "limits"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapter_limits, 0 } },
    HashTableValue { "info"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapter_info, 0 } },
    HashTableValue { "isFallbackAdapter"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapter_isFallbackAdapter, 0 } },
    HashTableValue { "requestDevice"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUAdapterPrototypeFunction_requestDevice, 0 } },
};

const ClassInfo JSGPUAdapterPrototype::s_info = { "GPUAdapter"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUAdapterPrototype) };

void JSGPUAdapterPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUAdapter::info(), JSGPUAdapterPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUAdapter::s_info = { "GPUAdapter"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUAdapter) };

JSGPUAdapter::JSGPUAdapter(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUAdapter>&& impl)
    : JSDOMWrapper<GPUAdapter>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUAdapter>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUAdapter::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUAdapterPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUAdapterPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUAdapter::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUAdapter>(vm, globalObject);
}

JSValue JSGPUAdapter::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUAdapterDOMConstructor, DOMConstructorID::GPUAdapter>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUAdapter::destroy(JSC::JSCell* cell)
{
    JSGPUAdapter* thisObject = static_cast<JSGPUAdapter*>(cell);
    thisObject->JSGPUAdapter::~JSGPUAdapter();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapterConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUAdapterPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUAdapter::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPUAdapter_featuresGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapter& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<GPUSupportedFeatures>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.features())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapter_features, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapter>::get<jsGPUAdapter_featuresGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUAdapter_limitsGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapter& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<GPUSupportedLimits>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.limits())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapter_limits, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapter>::get<jsGPUAdapter_limitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUAdapter_infoGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapter& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<GPUAdapterInfo>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.info())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapter_info, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapter>::get<jsGPUAdapter_infoGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUAdapter_isFallbackAdapterGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapter& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isFallbackAdapter())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapter_isFallbackAdapter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapter>::get<jsGPUAdapter_isFallbackAdapterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPUAdapterPrototypeFunction_requestDeviceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSGPUAdapter>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUDeviceDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<GPUDevice>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.requestDevice(*context, descriptorConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUAdapterPrototypeFunction_requestDevice, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSGPUAdapter>::call<jsGPUAdapterPrototypeFunction_requestDeviceBody>(*lexicalGlobalObject, *callFrame, "requestDevice");
}

JSC::GCClient::IsoSubspace* JSGPUAdapter::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUAdapter, UseCustomHeapCellType::No>(vm, "JSGPUAdapter"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUAdapter.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUAdapter = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUAdapter.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUAdapter = std::forward<decltype(space)>(space); }
    );
}

void JSGPUAdapter::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUAdapter*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUAdapterOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUAdapterOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUAdapter = static_cast<JSGPUAdapter*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUAdapter->protectedWrapped().ptr(), jsGPUAdapter);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUAdapter@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10GPUAdapterE[]; }
#endif
template<std::same_as<GPUAdapter> T>
static inline void verifyVTable(GPUAdapter* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUAdapter@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10GPUAdapterE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUAdapter has subclasses. If GPUAdapter has subclasses that get passed
        // to toJS() we currently require GPUAdapter you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUAdapter>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUAdapter>(impl.ptr());
#endif
    return createWrapper<GPUAdapter>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUAdapter& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUAdapter* JSGPUAdapter::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUAdapter*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
