/* DO NOT EDIT
 *
 * Created by rdps.py.
 *
 * ps.c
 * Definitions for generating PostScript(R) packet output.
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <stdio.h>

#include "ps.h"

static const char ps_preamble[] =
	"%!\n"
	"%!PS-Adobe-2.0\n"
	"%\n"
	"% Wireshark - Network traffic analyzer\n"
	"% By Gerald Combs <gerald@wireshark.org>\n"
	"% Copyright 1998 Gerald Combs\n"
	"%\n"
	"%%Creator: Wireshark\n"
	"%%Title: Wireshark output\n"
	"%%DocumentFonts: Helvetica Monaco\n"
	"%%EndComments\n"
	"%!\n"
	"\n"
	"%\n"
	"% Ghostscript http://ghostscript.com/ can convert postscript to pdf files.\n"
	"%\n"
	"% To convert this postscript file to pdf, type (for US letter format):\n"
	"% ps2pdf filename.ps\n"
	"%\n"
	"% or (for A4 format):\n"
	"% ps2pdf -sPAPERSIZE=a4 filename.ps\n"
	"%\n"
	"% ... and of course replace filename.ps by your current filename.\n"
	"%\n"
	"% The pdfmark's below will help converting to a pdf file, and have no\n"
	"% effect when printing the postscript directly.\n"
	"% \n"
	"\n"
	"%   This line is necessary if the file should be printable, and not just used\n"
	"%   for distilling into PDF:\n"
	"%\n"
	"/pdfmark where {pop} {userdict /pdfmark /cleartomark load put} ifelse\n"
	"%\n"
	"%   This tells PDF viewers to display bookmarks when the document is opened:\n"
	"%\n"
	"[/PageMode /UseOutlines /DOCVIEW pdfmark\n"
	"\n"
	"% Get the Imagable Area of the page\n"
	"clippath pathbbox\n"
	"\n"
	"% Set vmax to the vertical size of the page,\n"
	"% hmax to the horizontal size of the page.\n"
	"/vmax exch def\n"
	"/hmax exch def\n"
	"pop pop		% junk\n"
	"\n"
	"% 1/2-inch margins\n"
	"/lmargin 36 def					% left margin\n"
	"/tmargin vmax 56 sub def		% top margin\n"
	"/bmargin 36 def					% bottom margin\n"
	"/pagenumtab hmax 36 sub def		% right margin\n"
	"\n"
	"% Counters\n"
	"/thispagenum 1 def\n"
	"\n"
	"% Strings\n"
	"/pagenostr 7 string def\n"
	"\n"
	"\n"
	"/formfeed {\n"
	"	printpagedecorations\n"
	"	showpage\n"
	"	\n"
	"	% we need a new current point after showpage is done\n"
	"	lmargin		% X\n"
	"	vpos 		% Y\n"
	"	moveto\n"
	"	/vpos tmargin def\n"
	"} def\n"
	"\n"
	"% Prints text with possible indenting\n"
	"/putline_single {\n"
	"	exch 10 mul lmargin add		% X\n"
	"	vpos 						% Y\n"
	"	moveto\n"
	"	show\n"
	"\n"
	"	/vpos vpos 10 sub def\n"
	"\n"
	"	vpos 5 sub bmargin le 		% is vpos <= bottom margin?\n"
	"	{\n"
	"		formfeed\n"
	"	}\n"
	"	if							% then formfeed and start at top\n"
	"} def\n"
	"\n"
	"\n"
	"% Prints text with possible indenting and line wrap\n"
	"/putline {\n"
	"	/text exch def\n"
	"	/indent exch def\n"
	"	\n"
	"	% wrapat = width / sizeof font (remember: monospaced font)\n"
	"	/pagewidth pagenumtab lmargin sub def\n"
	"	/cwidth (A) stringwidth pop def\n"
	"	/wrapat pagewidth cwidth div cvi def\n"
	"		\n"
	"	text length wrapat le {\n"
	"		% print line\n"
	"		indent text 0 text length getinterval putline_single\n"
	"	}{\n"
	"		% print the lines first part\n"
	"		indent text 0 wrapat getinterval putline_single\n"
	"		% print wrapped rest\n"
	"		indent text wrapat text length wrapat sub getinterval putline\n"
	"	}\n"
	"	ifelse\n"
	"} def\n"
	"\n"
	"\n"
	"% Prints the page number at the top right\n"
	"/printpagedecorations {\n"
	"	gsave\n"
	"		% Set the font to 8 point\n"
	"		/Helvetica findfont 8 scalefont setfont\n"
	"\n"
	"		% title\n"
	"		lmargin						% X\n"
	"		vmax 36 sub					% Y\n"
	"		moveto\n"
	"		ws_pagetitle show\n"
	"\n"
	"		% this page number\n"
	"		pagenumtab (Page ) stringwidth pop sub thispagenum pagenostr cvs stringwidth pop sub 		% X\n"
	"		vmax 36 sub					% Y\n"
	"		moveto\n"
	"		(Page ) show\n"
	"		thispagenum pagenostr cvs show\n"
	"\n"
	"		% thispagenum++\n"
	"		/thispagenum thispagenum 1 add def\n"
	"		\n"
	"		% line at top of page\n"
	"		lmargin						% X\n"
	"		vmax 38 sub					% Y\n"
	"		moveto\n"
	"		\n"
	"		pagenumtab					% X\n"
	"		vmax 38 sub					% Y\n"
	"		lineto\n"
	"		stroke\n"
	"		\n"
	"		% line at bottom of page\n"
	"		lmargin						% X\n"
	"		bmargin						% Y\n"
	"		moveto\n"
	"		\n"
	"		pagenumtab					% X\n"
	"		bmargin						% Y\n"
	"		lineto\n"
	"		stroke\n"
	"		\n"
	"	grestore\n"
	"} def\n"
	"	\n"
	"% Reset the vertical position\n"
	"/vpos tmargin def\n"
	"\n"
	"% Set the font to 8 point\n"
	"/Monaco findfont 8 scalefont setfont\n"
	"\n"
;

void print_ps_preamble(FILE *fd) {
	fwrite(ps_preamble, sizeof ps_preamble - 1, 1, fd);
}


static const char ps_finale[] =
	"\n"
	"printpagedecorations\n"
	"showpage\n"
	"\n"
	"%%EOF\n"
	"\n"
;

void print_ps_finale(FILE *fd) {
	fwrite(ps_finale, sizeof ps_finale - 1, 1, fd);
}


