/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBlendFactor.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUBlendFactor enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 13> values {
        MAKE_STATIC_STRING_IMPL("zero"),
        MAKE_STATIC_STRING_IMPL("one"),
        MAKE_STATIC_STRING_IMPL("src"),
        MAKE_STATIC_STRING_IMPL("one-minus-src"),
        MAKE_STATIC_STRING_IMPL("src-alpha"),
        MAKE_STATIC_STRING_IMPL("one-minus-src-alpha"),
        MAKE_STATIC_STRING_IMPL("dst"),
        MAKE_STATIC_STRING_IMPL("one-minus-dst"),
        MAKE_STATIC_STRING_IMPL("dst-alpha"),
        MAKE_STATIC_STRING_IMPL("one-minus-dst-alpha"),
        MAKE_STATIC_STRING_IMPL("src-alpha-saturated"),
        MAKE_STATIC_STRING_IMPL("constant"),
        MAKE_STATIC_STRING_IMPL("one-minus-constant"),
    };
    static_assert(static_cast<size_t>(GPUBlendFactor::Zero) == 0, "GPUBlendFactor::Zero is not 0 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::One) == 1, "GPUBlendFactor::One is not 1 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::Src) == 2, "GPUBlendFactor::Src is not 2 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::OneMinusSrc) == 3, "GPUBlendFactor::OneMinusSrc is not 3 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::SrcAlpha) == 4, "GPUBlendFactor::SrcAlpha is not 4 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::OneMinusSrcAlpha) == 5, "GPUBlendFactor::OneMinusSrcAlpha is not 5 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::Dst) == 6, "GPUBlendFactor::Dst is not 6 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::OneMinusDst) == 7, "GPUBlendFactor::OneMinusDst is not 7 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::DstAlpha) == 8, "GPUBlendFactor::DstAlpha is not 8 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::OneMinusDstAlpha) == 9, "GPUBlendFactor::OneMinusDstAlpha is not 9 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::SrcAlphaSaturated) == 10, "GPUBlendFactor::SrcAlphaSaturated is not 10 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::Constant) == 11, "GPUBlendFactor::Constant is not 11 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::OneMinusConstant) == 12, "GPUBlendFactor::OneMinusConstant is not 12 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUBlendFactor enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUBlendFactor> parseEnumerationFromString<GPUBlendFactor>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, GPUBlendFactor>, 13> mappings {
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "constant"_s, GPUBlendFactor::Constant },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "dst"_s, GPUBlendFactor::Dst },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "dst-alpha"_s, GPUBlendFactor::DstAlpha },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "one"_s, GPUBlendFactor::One },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "one-minus-constant"_s, GPUBlendFactor::OneMinusConstant },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "one-minus-dst"_s, GPUBlendFactor::OneMinusDst },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "one-minus-dst-alpha"_s, GPUBlendFactor::OneMinusDstAlpha },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "one-minus-src"_s, GPUBlendFactor::OneMinusSrc },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "one-minus-src-alpha"_s, GPUBlendFactor::OneMinusSrcAlpha },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "src"_s, GPUBlendFactor::Src },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "src-alpha"_s, GPUBlendFactor::SrcAlpha },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "src-alpha-saturated"_s, GPUBlendFactor::SrcAlphaSaturated },
        std::pair<ComparableASCIILiteral, GPUBlendFactor> { "zero"_s, GPUBlendFactor::Zero },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUBlendFactor> parseEnumeration<GPUBlendFactor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUBlendFactor>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUBlendFactor>()
{
    return "\"zero\", \"one\", \"src\", \"one-minus-src\", \"src-alpha\", \"one-minus-src-alpha\", \"dst\", \"one-minus-dst\", \"dst-alpha\", \"one-minus-dst-alpha\", \"src-alpha-saturated\", \"constant\", \"one-minus-constant\""_s;
}

} // namespace WebCore

