/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUPipelineLayoutDescriptor.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUBindGroupLayout.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUPipelineLayoutDescriptor>> convertDictionary<GPUPipelineLayoutDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUPipelineLayoutDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (labelConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue bindGroupLayoutsValue;
    if (isNullOrUndefined)
        bindGroupLayoutsValue = jsUndefined();
    else {
        bindGroupLayoutsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bindGroupLayouts"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (bindGroupLayoutsValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "bindGroupLayouts"_s, "GPUPipelineLayoutDescriptor"_s, "sequence"_s);
        return ConversionResultException { };
    }
    auto bindGroupLayoutsConversionResult = convert<IDLSequence<IDLNullable<IDLInterface<GPUBindGroupLayout>>>>(lexicalGlobalObject, bindGroupLayoutsValue);
    if (bindGroupLayoutsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bindGroupLayouts = bindGroupLayoutsConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

