﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormationRequest.h>
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace CloudFormation {
namespace Model {

/**
 */
class DescribeResourceScanRequest : public CloudFormationRequest {
 public:
  AWS_CLOUDFORMATION_API DescribeResourceScanRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeResourceScan"; }

  AWS_CLOUDFORMATION_API Aws::String SerializePayload() const override;

 protected:
  AWS_CLOUDFORMATION_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the resource scan.</p>
   */
  inline const Aws::String& GetResourceScanId() const { return m_resourceScanId; }
  inline bool ResourceScanIdHasBeenSet() const { return m_resourceScanIdHasBeenSet; }
  template <typename ResourceScanIdT = Aws::String>
  void SetResourceScanId(ResourceScanIdT&& value) {
    m_resourceScanIdHasBeenSet = true;
    m_resourceScanId = std::forward<ResourceScanIdT>(value);
  }
  template <typename ResourceScanIdT = Aws::String>
  DescribeResourceScanRequest& WithResourceScanId(ResourceScanIdT&& value) {
    SetResourceScanId(std::forward<ResourceScanIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_resourceScanId;
  bool m_resourceScanIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFormation
}  // namespace Aws
