/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.actions;

import org.eclipse.swt.graphics.Drawable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UITextUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.actions.AbstractResultSetViewerAction;
import org.jkiss.dbeaver.ui.controls.resultset.actions.FilterByAttributeType;

public class FilterByAttributeAction
extends AbstractResultSetViewerAction {
    private final DBCLogicalOperator operator;
    private final FilterByAttributeType type;
    private final DBDAttributeBinding attribute;

    public FilterByAttributeAction(ResultSetViewer resultSetViewer, DBCLogicalOperator operator, FilterByAttributeType type, DBDAttributeBinding attribute) {
        super(resultSetViewer, attribute.getName() + " " + FilterByAttributeAction.translateFilterPattern(resultSetViewer, operator, type, attribute));
        this.operator = operator;
        this.type = type;
        this.attribute = attribute;
    }

    public void run() {
        Object value = this.type.getValue(this.getResultSetViewer(), this.attribute, this.operator, false);
        if (this.operator.getArgumentCount() != 0 && value == null) {
            return;
        }
        DBDDataFilter filter = new DBDDataFilter(this.getResultSetViewer().getModel().getDataFilter());
        DBDAttributeConstraint constraint = filter.getConstraint(this.attribute);
        if (constraint != null) {
            constraint.setOperator(this.operator);
            constraint.setValue(value);
            this.getResultSetViewer().setDataFilter(filter, true);
        }
    }

    @NotNull
    private static String translateFilterPattern(@NotNull ResultSetViewer viewer, @NotNull DBCLogicalOperator operator, @NotNull FilterByAttributeType type, @NotNull DBDAttributeBinding attribute) {
        Object value = type.getValue(viewer, attribute, operator, true);
        DBCExecutionContext executionContext = viewer.getExecutionContext();
        Object strValue = executionContext == null ? String.valueOf(value) : attribute.getValueHandler().getValueDisplayString((DBSTypedObject)attribute, value, DBDDisplayFormat.UI);
        strValue = ((String)strValue).replaceAll("\\s+", " ").replace("@", "^").trim();
        strValue = UITextUtils.getShortText((Drawable)viewer.getControl(), (String)strValue, (int)150);
        if (operator.getArgumentCount() == 0) {
            return operator.getExpression();
        }
        if (!"..".equals(strValue)) {
            strValue = "'" + (String)strValue + "'";
        }
        return operator.getExpression() + " " + (String)strValue;
    }
}

