/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Resource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class UITextUtils {
    @NotNull
    public static String getShortText(@NotNull Drawable drawable, @NotNull String text, int width) {
        GC gc = new GC(drawable);
        try {
            String string = UITextUtils.getShortText(gc, text, width);
            return string;
        }
        finally {
            UIUtils.dispose((Resource)gc);
        }
    }

    public static String getShortText(GC gc, String t, int width) {
        int pivot;
        if (CommonUtils.isEmpty((String)t)) {
            return t;
        }
        if (width >= gc.textExtent((String)t).x) {
            return t;
        }
        int w = gc.textExtent((String)"...").x;
        Object text = t;
        int l = ((String)text).length();
        if (l > 500) {
            l = 500;
        }
        int s = pivot = l / 2;
        int e = pivot + 1;
        while (s >= 0 && e < l) {
            String s1 = ((String)text).substring(0, s);
            String s2 = ((String)text).substring(e, l);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + w + l2 < width) {
                text = s1 + " ... " + s2;
                break;
            }
            --s;
            ++e;
        }
        if (s == 0 || e == l) {
            text = ((String)text).substring(0, 1) + "..." + ((String)text).substring(l - 1, l);
        }
        return text;
    }

    public static String getShortString(FontMetrics fontMetrics, String t, int width) {
        if (CommonUtils.isEmpty((String)t)) {
            return t;
        }
        if (width <= 1) {
            return "";
        }
        double avgCharWidth = fontMetrics.getAverageCharWidth();
        double length = t.length();
        if ((double)width < length * avgCharWidth) {
            length = (double)width / avgCharWidth;
            if ((length *= 2.0) < (double)t.length()) {
                t = t.substring(0, (int)length);
            }
        }
        return t;
    }
}

