%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in snmp_pdus_basic.

-module('snmp_pdus_basic').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-asn1_info([{vsn,'5.4.2'},
            {module,'snmp_pdus_basic'},
            {options,[warnings,ber,errors,
 {cwd,"/build/erlang/src/otp/lib/snmp/src/misc"},
 {outdir,"/build/erlang/src/otp/lib/snmp/src/misc"},
 noobj,
 {i,"."},
 {i,"/build/erlang/src/otp/lib/snmp/src/misc"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_Counter64/2,
enc_TimeTicks/2,
enc_Unsigned32/2,
enc_Counter32/2
]).

-export([
dec_Counter64/2,
dec_TimeTicks/2,
dec_Unsigned32/2,
dec_Counter32/2
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('Counter64', Data) -> enc_Counter64(Data);
encode_disp('TimeTicks', Data) -> enc_TimeTicks(Data);
encode_disp('Unsigned32', Data) -> enc_Unsigned32(Data);
encode_disp('Counter32', Data) -> enc_Counter32(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('Counter64', Data) -> dec_Counter64(Data);
decode_disp('TimeTicks', Data) -> dec_TimeTicks(Data);
decode_disp('Unsigned32', Data) -> dec_Unsigned32(Data);
decode_disp('Counter32', Data) -> dec_Counter32(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  Counter64
%%================================
enc_Counter64(Val) ->
    enc_Counter64(Val, [<<70>>]).

enc_Counter64(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_Counter64(Tlv) ->
   dec_Counter64(Tlv, [65542]).

dec_Counter64(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 18446744073709551615 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  TimeTicks
%%================================
enc_TimeTicks(Val) ->
    enc_TimeTicks(Val, [<<67>>]).

enc_TimeTicks(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_TimeTicks(Tlv) ->
   dec_TimeTicks(Tlv, [65539]).

dec_TimeTicks(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  Unsigned32
%%================================
enc_Unsigned32(Val) ->
    enc_Unsigned32(Val, [<<66>>]).

enc_Unsigned32(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_Unsigned32(Tlv) ->
   dec_Unsigned32(Tlv, [65538]).

dec_Unsigned32(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  Counter32
%%================================
enc_Counter32(Val) ->
    enc_Counter32(Val, [<<65>>]).

enc_Counter32(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_Counter32(Tlv) ->
   dec_Counter32(Tlv, [65537]).

dec_Counter32(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.


%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).
