/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.markedj;

import io.github.gitbucket.markedj.Lexer;
import io.github.gitbucket.markedj.Options;
import io.github.gitbucket.markedj.Renderer;
import io.github.gitbucket.markedj.Utils;
import io.github.gitbucket.markedj.rule.Rule;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class InlineLexer {
    protected Map<String, Rule> rules;
    protected Options options;
    protected Renderer renderer;
    protected boolean inLink = false;
    protected Map<String, Lexer.Link> links;

    public InlineLexer(Map<String, Rule> rules, Map<String, Lexer.Link> links, Options options, Renderer renderer) {
        this.rules = rules;
        this.links = links;
        this.options = options;
        this.renderer = renderer;
    }

    public String output(String src) {
        StringBuilder out = new StringBuilder();
        StringBuilder textBuffer = new StringBuilder();
        while (src.length() > 0) {
            String href;
            String text;
            List<String> cap = this.rules.get("escape").exec(src);
            if (!cap.isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                src = src.substring(cap.get(0).length());
                out.append(cap.get(1));
                continue;
            }
            cap = this.rules.get("autolink").exec(src);
            if (!cap.isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                src = src.substring(cap.get(0).length());
                if (cap.get(2).equals("@")) {
                    text = cap.get(1).startsWith("mailto:") ? cap.get(1).substring(7) : cap.get(1);
                    href = "mailto:" + text;
                } else {
                    href = text = Utils.escape(cap.get(1));
                }
                out.append(this.renderer.link(href, null, text));
                continue;
            }
            if (!this.inLink && !(cap = this.rules.get("url").exec(src)).isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                src = src.substring(cap.get(0).length());
                href = text = Utils.escape(cap.get(1));
                out.append(this.renderer.link(text, null, href));
                continue;
            }
            cap = this.rules.get("tag").exec(src);
            if (!cap.isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                if (!this.inLink && Pattern.compile("^<a ").matcher(cap.get(0)).find()) {
                    this.inLink = true;
                } else if (this.inLink && Pattern.compile("^</a>").matcher(cap.get(0)).find()) {
                    this.inLink = false;
                }
                src = src.substring(cap.get(0).length());
                if (this.options.isSanitize()) {
                    out.append(Utils.escape(cap.get(0)));
                    continue;
                }
                out.append(cap.get(0));
                continue;
            }
            cap = this.rules.get("link").exec(src);
            if (!cap.isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                src = src.substring(cap.get(0).length());
                this.inLink = true;
                out.append(this.outputLink(cap, new Lexer.Link(cap.get(2), cap.get(3))));
                this.inLink = false;
                continue;
            }
            cap = this.rules.get("reflink").exec(src);
            if (cap.isEmpty()) {
                cap = this.rules.get("nolink").exec(src);
            }
            if (!cap.isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                src = src.substring(cap.get(0).length());
                String key = cap.size() > 2 ? cap.get(2).replaceAll("\\s+", "") : cap.get(1).replaceAll("\\s+", "");
                Lexer.Link link = this.links.get(key.toLowerCase());
                if (link == null || Utils.isEmpty(link.getHref())) {
                    out.append(this.renderer.nolink(cap.get(0)));
                    continue;
                }
                this.inLink = true;
                out.append(this.outputLink(cap, link));
                this.inLink = false;
                continue;
            }
            cap = this.rules.get("strong").exec(src);
            if (!cap.isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                src = src.substring(cap.get(0).length());
                out.append(this.renderer.strong(this.output(Utils.or(cap.get(2), cap.get(1)))));
                continue;
            }
            cap = this.rules.get("em").exec(src);
            if (!cap.isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                src = src.substring(cap.get(0).length());
                out.append(this.renderer.em(this.output(Utils.or(cap.get(2), cap.get(1)))));
                continue;
            }
            cap = this.rules.get("code").exec(src);
            if (!cap.isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                src = src.substring(cap.get(0).length());
                out.append(this.renderer.codespan(Utils.escape(cap.get(2), true)));
                continue;
            }
            cap = this.rules.get("br").exec(src);
            if (!cap.isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                src = src.substring(cap.get(0).length());
                out.append(this.renderer.br());
                continue;
            }
            cap = this.rules.get("del").exec(src);
            if (!cap.isEmpty()) {
                if (textBuffer.length() != 0) {
                    out.append(this.renderer.text(textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                src = src.substring(cap.get(0).length());
                out.append(this.renderer.del(this.output(cap.get(1))));
                continue;
            }
            cap = this.rules.get("text").exec(src);
            if (cap.isEmpty()) continue;
            src = src.substring(cap.get(0).length());
            textBuffer.append(Utils.escape(cap.get(0)));
        }
        if (textBuffer.length() != 0) {
            out.append(this.renderer.text(textBuffer.toString()));
        }
        return out.toString();
    }

    protected String outputLink(List<String> cap, Lexer.Link link) {
        String href = Utils.escape(link.getHref());
        if (cap.get(0).charAt(0) != '!') {
            return this.renderer.link(href, link.getTitle(), this.output(cap.get(1)));
        }
        return this.renderer.image(href, link.getTitle(), Utils.escape(cap.get(1)));
    }
}

