/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain.properties;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public interface HasName {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Utils {
        private Utils() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static List<String> namesOf(HasName ... hasNames) {
            return Utils.namesOf(ImmutableList.copyOf(hasNames));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static List<String> namesOf(Iterable<? extends HasName> hasNames) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (HasName hasName : hasNames) {
                result.add(hasName.getName());
            }
            return result.build();
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<HasName, String> GET_NAME = new ChainableFunction<HasName, String>(){

            @Override
            public String apply(HasName input) {
                return input.getName();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<List<? extends HasName>, List<String>> GET_NAMES = new ChainableFunction<List<? extends HasName>, List<String>>(){

            @Override
            public List<String> apply(List<? extends HasName> input) {
                return Utils.namesOf(input);
            }
        };

        private Functions() {
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasName> name(String name) {
            return new NameEqualsPredicate(name);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasName> nameMatching(String regex) {
            return new NameMatchingPredicate(regex);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasName> nameStartingWith(String prefix) {
            return new NameStartingWithPredicate(prefix);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasName> nameContaining(String infix) {
            return new NameContainingPredicate(infix);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasName> nameEndingWith(String postfix) {
            return new NameEndingWithPredicate(postfix);
        }

        private static class NameEqualsPredicate
        extends DescribedPredicate<HasName> {
            private final String name;

            NameEqualsPredicate(String name) {
                super(String.format("name '%s'", name), new Object[0]);
                this.name = name;
            }

            @Override
            public boolean test(HasName input) {
                return input.getName().equals(this.name);
            }
        }

        private static class NameMatchingPredicate
        extends DescribedPredicate<HasName> {
            private final Pattern pattern;

            NameMatchingPredicate(String regex) {
                super(String.format("name matching '%s'", regex), new Object[0]);
                this.pattern = Pattern.compile(regex);
            }

            @Override
            public boolean test(HasName input) {
                return this.pattern.matcher(input.getName()).matches();
            }
        }

        private static class NameStartingWithPredicate
        extends DescribedPredicate<HasName> {
            private final String prefix;

            NameStartingWithPredicate(String prefix) {
                super(String.format("name starting with '%s'", prefix), new Object[0]);
                this.prefix = prefix;
            }

            @Override
            public boolean test(HasName input) {
                return input.getName().startsWith(this.prefix);
            }
        }

        private static class NameContainingPredicate
        extends DescribedPredicate<HasName> {
            private final String infix;

            NameContainingPredicate(String infix) {
                super(String.format("name containing '%s'", infix), new Object[0]);
                this.infix = infix;
            }

            @Override
            public boolean test(HasName input) {
                return input.getName().contains(this.infix);
            }
        }

        private static class NameEndingWithPredicate
        extends DescribedPredicate<HasName> {
            private final String suffix;

            NameEndingWithPredicate(String suffix) {
                super(String.format("name ending with '%s'", suffix), new Object[0]);
                this.suffix = suffix;
            }

            @Override
            public boolean test(HasName input) {
                return input.getName().endsWith(this.suffix);
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static interface AndFullName
    extends HasName {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getFullName();

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<AndFullName, String> GET_FULL_NAME = new ChainableFunction<AndFullName, String>(){

                @Override
                public String apply(AndFullName input) {
                    return input.getFullName();
                }
            };

            private Functions() {
            }
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class Predicates {
            private Predicates() {
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static DescribedPredicate<AndFullName> fullName(String fullName) {
                return new FullNameEqualsPredicate(fullName);
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static DescribedPredicate<AndFullName> fullNameMatching(String regex) {
                return new FullNameMatchingPredicate(regex);
            }

            private static class FullNameEqualsPredicate
            extends DescribedPredicate<AndFullName> {
                private final String fullName;

                FullNameEqualsPredicate(String fullName) {
                    super(String.format("full name '%s'", fullName), new Object[0]);
                    this.fullName = fullName;
                }

                @Override
                public boolean test(AndFullName input) {
                    return input.getFullName().equals(this.fullName);
                }
            }

            private static class FullNameMatchingPredicate
            extends DescribedPredicate<AndFullName> {
                private final Pattern pattern;

                FullNameMatchingPredicate(String regex) {
                    super(String.format("full name matching '%s'", regex), new Object[0]);
                    this.pattern = Pattern.compile(regex);
                }

                @Override
                public boolean test(AndFullName input) {
                    return this.pattern.matcher(input.getFullName()).matches();
                }
            }
        }
    }
}

