/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Script;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.script.ClasspathScriptCompiler;
import org.freeplane.plugin.script.MyGroovyClassLoader;
import org.freeplane.plugin.script.NodeArithmeticsCategory;
import org.freeplane.plugin.script.ScriptClassLoader;
import org.freeplane.plugin.script.ScriptResources;

class GroovyShell
extends GroovyObjectSupport {
    private static final String DEFAULT_CODE_BASE = "/groovy/shell";
    private final Binding binding;
    private int counter;
    private final CompilerConfiguration config;
    private final ClassLoader parentLoader;

    GroovyShell(ClassLoader parent, Binding binding, CompilerConfiguration config) {
        if (binding == null) {
            throw new IllegalArgumentException("Binding must not be null.");
        }
        if (config == null) {
            throw new IllegalArgumentException("Compiler configuration must not be null.");
        }
        this.parentLoader = parent != null ? parent : GroovyShell.class.getClassLoader();
        this.binding = binding;
        this.config = config;
    }

    public Object getProperty(String property) {
        Object answer = this.getVariable(property);
        if (answer == null) {
            answer = super.getProperty(property);
        }
        return answer;
    }

    public void setProperty(String property, Object newValue) {
        this.setVariable(property, newValue);
        try {
            super.setProperty(property, newValue);
        }
        catch (GroovyRuntimeException groovyRuntimeException) {
            // empty catch block
        }
    }

    private Object getVariable(String name) {
        return this.binding.getVariables().get(name);
    }

    private void setVariable(String name, Object value) {
        this.binding.setVariable(name, value);
    }

    private Class loadClass(GroovyCodeSource codeSource) throws CompilationFailedException {
        if (ClasspathScriptCompiler.compilesOnlyChangedScriptFiles()) {
            return this.parseAndCache(codeSource);
        }
        return this.parseClass(codeSource);
    }

    private Class parseClass(GroovyCodeSource codeSource) {
        GroovyClassLoader loader = this.createClassLoader();
        Class parsedClass = loader.parseClass(codeSource, false);
        return parsedClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class parseAndCache(GroovyCodeSource codeSource) {
        File sourceFile;
        String md5;
        try {
            md5 = EncodingGroovyMethods.md5((CharSequence)codeSource.getName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        File cache = new File(ScriptResources.getCompiledScriptsDir(), md5);
        File propertyFile = new File(cache, "compiled.properties");
        File classes = new File(cache, "classes");
        if (propertyFile.exists() && classes.exists()) {
            try (FileInputStream in2222 = new FileInputStream(propertyFile);){
                Properties properties = new Properties();
                properties.load(in2222);
                long compileTime = Long.parseLong(properties.getProperty("time"));
                String source = properties.getProperty("source");
                File sourceFile2 = new File(source);
                if (sourceFile2.canRead() && sourceFile2.lastModified() < compileTime) {
                    String className = properties.getProperty("class");
                    GroovyClassLoader loader = this.createClassLoader();
                    loader.addURL(ScriptClassLoader.pathToUrl(classes));
                    Class clazz = loader.loadClass(className);
                    return clazz;
                }
            }
            catch (IOException | ClassNotFoundException | NumberFormatException in2222) {
                // empty catch block
            }
        }
        if (cache.exists()) {
            try {
                FileUtils.cleanDirectory((File)cache);
            }
            catch (IOException e) {
                LogUtils.warn((Throwable)e);
            }
        }
        if ((sourceFile = codeSource.getFile()) == null) return this.parseClass(codeSource);
        classes.mkdirs();
        this.config.setTargetDirectory(classes);
        long time = System.currentTimeMillis();
        GroovyClassLoader loader = this.createClassLoader();
        Class parsedClass = loader.parseClass(codeSource, false);
        try (FileOutputStream out = new FileOutputStream(propertyFile);){
            Properties properties = new Properties();
            properties.setProperty("class", parsedClass.getName());
            properties.setProperty("time", Long.toString(time));
            properties.setProperty("source", sourceFile.getAbsolutePath());
            properties.store(out, "");
            return parsedClass;
        }
        catch (IOException e) {
            LogUtils.warn((Throwable)e);
        }
        return parsedClass;
    }

    private GroovyClassLoader createClassLoader() {
        GroovyClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

            @Override
            public GroovyClassLoader run() {
                return new MyGroovyClassLoader(GroovyShell.this.parentLoader, GroovyShell.this.config);
            }
        });
        return loader;
    }

    private Script parse(GroovyCodeSource codeSource) throws CompilationFailedException {
        return InvokerHelper.createScript((Class)this.loadClass(codeSource), (Binding)this.binding);
    }

    Script parse(File file) throws CompilationFailedException, IOException {
        return this.parse(new GroovyCodeSource(file, this.config.getSourceEncoding()));
    }

    Script parse(String scriptText) throws CompilationFailedException {
        return this.parse(scriptText, this.generateScriptName());
    }

    private Script parse(final String scriptText, final String fileName) throws CompilationFailedException {
        GroovyCodeSource gcs = AccessController.doPrivileged(new PrivilegedAction<GroovyCodeSource>(){

            @Override
            public GroovyCodeSource run() {
                return new GroovyCodeSource(scriptText, fileName, GroovyShell.DEFAULT_CODE_BASE);
            }
        });
        return this.parse(gcs);
    }

    protected synchronized String generateScriptName() {
        return "Script" + ++this.counter + ".groovy";
    }

    static {
        DefaultGroovyMethods.mixin(Number.class, NodeArithmeticsCategory.class);
    }
}

