/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.parser.AbstractCondition;
import io.sf.carte.doc.style.css.parser.AbstractSelector;
import io.sf.carte.doc.style.css.parser.CombinatorConditionImpl;
import io.sf.carte.doc.style.css.parser.MutableBoolean;
import io.sf.carte.doc.style.css.parser.NSACSelectorFactory;
import io.sf.carte.doc.style.css.parser.SelectorArgumentConditionImpl;

abstract class ConditionalSelectorImpl
extends AbstractSelector
implements ConditionalSelector {
    private static final long serialVersionUID = 1L;
    SimpleSelector selector;
    AbstractCondition condition;

    ConditionalSelectorImpl(SimpleSelector selector, AbstractCondition condition) {
        this.selector = selector;
        this.condition = condition;
    }

    @Override
    public Selector.SelectorType getSelectorType() {
        return Selector.SelectorType.CONDITIONAL;
    }

    @Override
    public SimpleSelector getSimpleSelector() {
        return this.selector;
    }

    @Override
    public AbstractCondition getCondition() {
        return this.condition;
    }

    @Override
    ConditionalSelectorImpl withCondition(NSACSelectorFactory factory, AbstractCondition cond) {
        SimpleSelector simple = this.selector == null ? NSACSelectorFactory.getUniversalSelector() : this.selector;
        CombinatorConditionImpl newCond = this.condition.appendCondition(cond);
        return factory.createConditionalSelector(simple, newCond);
    }

    @Override
    Selector replace(SelectorList base, MutableBoolean replaced) {
        AbstractCondition replCond;
        if (this.condition.getConditionType() == Condition.ConditionType.NESTING) {
            replaced.setTrueValue();
            if (base.getLength() == 1) {
                if (this.selector == null || this.selector.getSelectorType() == Selector.SelectorType.UNIVERSAL) {
                    return base.item(0);
                }
                Selector base0 = base.item(0);
                if (base0.getSelectorType() == Selector.SelectorType.CONDITIONAL && ((ConditionalSelector)base0).getSimpleSelector().getSelectorType() == Selector.SelectorType.UNIVERSAL) {
                    ConditionalSelectorImpl bclon = ((ConditionalSelectorImpl)base0).clone();
                    bclon.selector = this.selector;
                    return bclon;
                }
            }
            SelectorArgumentConditionImpl is = new SelectorArgumentConditionImpl();
            is.arguments = base;
            is.setName("is");
            replCond = is;
        } else {
            Selector base0;
            if (this.condition.getConditionType() == Condition.ConditionType.AND && base.getLength() == 1 && (this.selector == null || this.selector.getSelectorType() == Selector.SelectorType.UNIVERSAL) && ((AbstractSelector)(base0 = base.item(0))).isSimpleSelector()) {
                AbstractCondition cond1;
                SimpleSelector simple;
                CombinatorConditionImpl comb = (CombinatorConditionImpl)this.condition;
                int len = comb.getLength();
                CombinatorConditionImpl newCombCond = new CombinatorConditionImpl(len);
                if (base0.getSelectorType() == Selector.SelectorType.CONDITIONAL && ((simple = ((ConditionalSelector)base0).getSimpleSelector()) == null || simple.getSelectorType() == Selector.SelectorType.UNIVERSAL)) {
                    AbstractCondition basecond = ((ConditionalSelectorImpl)base0).getCondition();
                    for (int i = 1; i < len; ++i) {
                        AbstractCondition condItem = comb.getCondition(i);
                        if (condItem.getConditionType() == Condition.ConditionType.NESTING) {
                            newCombCond.setCondition(i, basecond);
                            replaced.setTrueValue();
                            continue;
                        }
                        condItem = condItem.replace(base, replaced);
                        newCombCond.setCondition(i, condItem);
                    }
                } else {
                    for (int i = 1; i < len; ++i) {
                        AbstractCondition condItem = comb.getCondition(i);
                        condItem = condItem.replace(base, replaced);
                        newCombCond.setCondition(i, condItem);
                    }
                }
                if ((cond1 = comb.getFirstCondition()).getConditionType() == Condition.ConditionType.NESTING) {
                    AbstractCondition newcond = newCombCond.removeFirstCondition();
                    ConditionalSelectorImpl newsel = ((AbstractSelector)base0).withCondition(this.getSelectorFactory(), newcond);
                    replaced.setTrueValue();
                    return newsel;
                }
                cond1 = cond1.replace(base, replaced);
                newCombCond.setCondition(0, cond1);
                ConditionalSelectorImpl newsel = this.getSelectorFactory().createConditionalSelector(NSACSelectorFactory.getUniversalSelector(), newCombCond);
                return newsel;
            }
            replCond = this.condition.replace(base, replaced);
        }
        ConditionalSelectorImpl clon = this.clone();
        clon.selector = (SimpleSelector)((AbstractSelector)((Object)this.selector)).replace(base, replaced);
        clon.condition = replCond;
        return clon;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionalSelectorImpl other = (ConditionalSelectorImpl)obj;
        if (this.condition == null) {
            if (other.condition != null) {
                return false;
            }
        } else if (!this.condition.equals(other.condition)) {
            if (this.selector == null || this.selector.getSelectorType() != Selector.SelectorType.CONDITIONAL) {
                return false;
            }
            if (this.selector != null && this.selector.getSelectorType() == Selector.SelectorType.CONDITIONAL || other.selector != null && other.selector.getSelectorType() == Selector.SelectorType.CONDITIONAL) {
                return this.toString().equals(other.toString());
            }
            return false;
        }
        return !(this.selector == null ? other.selector != null : !this.selector.equals(other.selector));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Selector.SelectorType simpletype = this.selector.getSelectorType();
        if (simpletype != Selector.SelectorType.UNIVERSAL || ((ElementSelector)this.selector).getNamespaceURI() != null) {
            buf.append(this.selector.toString());
        }
        buf.append(this.condition.toString());
        return buf.toString();
    }

    @Override
    public ConditionalSelectorImpl clone() {
        ConditionalSelectorImpl clon = (ConditionalSelectorImpl)super.clone();
        clon.condition = this.condition;
        clon.selector = this.selector;
        return clon;
    }
}

