/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSEnvVariableValue;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.Unit;
import java.util.Random;
import org.w3c.dom.DOMException;

class DimensionalEvaluator
extends Evaluator {
    private transient boolean hasPercentage;
    private transient Random random = null;
    private transient CSSExpression latestExpression;
    private transient CSSMathFunctionValue latestFunction;
    private transient boolean unknownFunction;

    DimensionalEvaluator() {
    }

    boolean hasUnknownFunction() {
        return this.unknownFunction;
    }

    @Override
    CSSNumberValue evaluateExpression(CSSExpression expression, Unit resultUnit) throws DOMException {
        this.latestExpression = expression;
        return super.evaluateExpression(expression, resultUnit);
    }

    short computeUnitType(CSSExpression expression) throws DOMException {
        this.hasPercentage = false;
        Unit resultUnit = new Unit();
        this.evaluateExpression(expression, resultUnit);
        int exp = resultUnit.getExponent();
        short unit = exp > 1 || exp < 0 ? (short)255 : (short)resultUnit.getUnitType();
        return unit;
    }

    CSSValueSyntax.Category dimensionalAnalysis(CSSExpression expression) throws DOMException {
        return this.getCategory(this.computeUnitType(expression));
    }

    @Override
    CSSNumberValue evaluateFunction(CSSMathFunctionValue function, Unit resultUnit) throws DOMException {
        this.latestFunction = function;
        return super.evaluateFunction(function, resultUnit);
    }

    short computeUnitType(CSSMathFunctionValue function) throws DOMException {
        this.hasPercentage = false;
        Unit resultUnit = new Unit();
        this.evaluateFunction(function, resultUnit);
        short unit = resultUnit.getUnitType();
        int exp = resultUnit.getExponent();
        if (exp > 1 || exp < 0) {
            unit = 255;
        }
        return unit;
    }

    CSSValueSyntax.Category dimensionalAnalysis(CSSMathFunctionValue function) throws DOMException {
        short unit;
        this.hasPercentage = false;
        Unit resultUnit = new Unit();
        this.evaluateFunction(function, resultUnit);
        switch (resultUnit.getExponent()) {
            case 0: {
                this.hasPercentage = false;
            }
            case 1: {
                unit = resultUnit.getUnitType();
                break;
            }
            default: {
                unit = 255;
            }
        }
        return this.getCategory(unit);
    }

    private CSSValueSyntax.Category getCategory(short unit) throws DOMException {
        CSSValueSyntax.Category cat;
        if (unit == 0) {
            cat = this.hasPercentage ? CSSValueSyntax.Category.percentage : CSSValueSyntax.Category.number;
        } else if (CSSUnit.isLengthUnitType(unit)) {
            cat = this.hasPercentage ? CSSValueSyntax.Category.lengthPercentage : CSSValueSyntax.Category.length;
        } else if (CSSUnit.isAngleUnitType(unit)) {
            cat = CSSValueSyntax.Category.angle;
        } else if (CSSUnit.isTimeUnitType(unit)) {
            cat = CSSValueSyntax.Category.time;
        } else if (CSSUnit.isResolutionUnitType(unit)) {
            cat = CSSValueSyntax.Category.resolution;
        } else if (unit == 100 || unit == 101) {
            cat = CSSValueSyntax.Category.frequency;
        } else if (unit == 2) {
            cat = CSSValueSyntax.Category.percentage;
        } else {
            throw new DOMException(17, "Unknown unit: " + unit);
        }
        return cat;
    }

    @Override
    protected float anchorSize(String ident) throws DOMException {
        return 100.0f;
    }

    @Override
    protected CSSValue absoluteProxyValue(CSSPrimitiveValue partialValue) {
        if (partialValue.getPrimitiveType() == CSSValue.Type.ENV && CSSUtil.isEnvLengthName(((CSSEnvVariableValue)partialValue).getName())) {
            return NumberValue.createCSSNumberValue((short)3, 64.0f);
        }
        return super.absoluteProxyValue(partialValue);
    }

    @Override
    protected CSSNumberValue absoluteTypedValue(CSSTypedValue partialValue) {
        int unit = partialValue.getUnitType();
        if (CSSUnit.isRelativeLengthUnitType((short)unit)) {
            this.checkRandom();
            unit = 3;
            NumberValue number = NumberValue.createCSSNumberValue((short)3, partialValue.getFloatValue(partialValue.getUnitType()) * (this.random.nextFloat() + 1.1f));
            number.setCalculatedNumber(true);
            partialValue = number;
        } else if (unit == 2) {
            this.hasPercentage = true;
        }
        return super.absoluteTypedValue(partialValue);
    }

    private void checkRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
    }

    @Override
    protected float percentage(CSSNumberValue value, short resultType) throws DOMException {
        this.hasPercentage = true;
        if (resultType != 2 && resultType != 0 && !CSSUnit.isLengthUnitType(resultType)) {
            throw new DOMException(17, "Do not know how to convert a % to " + CSSUnit.dimensionUnitString(resultType));
        }
        return value.getFloatValue((short)2);
    }

    @Override
    CSSNumberValue unknownFunction(CSSFunctionValue function, Unit resultUnit) {
        this.unknownFunction = true;
        return super.unknownFunction(function, resultUnit);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    short getPreferredUnit() {
        int unit = 2;
        if (this.latestExpression != null) {
            CSSOperandExpression operand;
            CSSPrimitiveValue value;
            CSSExpression expression;
            for (expression = this.latestExpression.getParentExpression(); expression != null && expression.getPartType() == CSSExpression.AlgebraicPart.PRODUCT; expression = expression.getParentExpression()) {
            }
            if (expression != null && (expression = this.findNonPercentOperand(expression)) != null && (value = (operand = (CSSOperandExpression)expression).getOperand()).getUnitType() != 255 && CSSUnit.isRelativeLengthUnitType((short)(unit = value.getUnitType()))) {
                unit = 3;
            }
        }
        if (this.latestFunction == null) return (short)unit;
        if (unit != 2) return (short)unit;
        CSSValueList<? extends CSSValue> args = this.latestFunction.getArguments();
        int len = args.getLength();
        int i = 0;
        while (i < len) {
            CSSValue arg = args.item(i);
            switch (arg.getPrimitiveType()) {
                case NUMERIC: {
                    short argUnit = ((TypedValue)arg).getUnitType();
                    if (argUnit == 2 || argUnit == 255 || argUnit == 1) break;
                    unit = argUnit;
                    if (!CSSUnit.isRelativeLengthUnitType((short)unit)) return (short)unit;
                    return (short)3;
                }
                case EXPRESSION: {
                    short argUnit = ((ExpressionValue)arg).computeUnitType();
                    if (argUnit == 255) break;
                    return (short)((int)argUnit);
                }
                case MATH_FUNCTION: {
                    short argUnit = ((CSSMathFunctionValue)arg).computeUnitType();
                    if (argUnit == 255) break;
                    return (short)((int)argUnit);
                }
            }
            ++i;
        }
        return (short)unit;
    }

    private CSSExpression findNonPercentOperand(CSSExpression expression) {
        block0 : switch (expression.getPartType()) {
            case SUM: {
                AlgebraicExpression sum = (AlgebraicExpression)expression;
                int len = sum.getLength();
                for (int i = 0; i < len; ++i) {
                    CSSOperandExpression operand;
                    CSSPrimitiveValue value;
                    CSSExpression expr = sum.item(i);
                    if (expr.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
                        expr = this.findNonPercentOperand(expr);
                    }
                    if (expr != null && expr.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (value = (operand = (CSSOperandExpression)expr).getOperand()).getUnitType() != 2 && value.getUnitType() != 255) {
                        expression = expr;
                        break block0;
                    }
                    expression = null;
                }
                break;
            }
            case PRODUCT: {
                AlgebraicExpression prod = (AlgebraicExpression)expression;
                int plen = prod.getLength();
                for (int i = 0; i < plen; ++i) {
                    CSSOperandExpression operand;
                    CSSPrimitiveValue value;
                    CSSExpression expr = prod.item(i);
                    if (expr.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
                        expr = this.findNonPercentOperand(expr);
                    }
                    if (expr != null && expr.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (value = (operand = (CSSOperandExpression)expr).getOperand()).getUnitType() != 2 && value.getUnitType() != 0 && value.getUnitType() != 255) {
                        expression = expr;
                        break block0;
                    }
                    expression = null;
                }
                break;
            }
        }
        return expression;
    }
}

