/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import tim.prune.data.DataPoint;
import tim.prune.data.Timestamp;

public class SegmentSummary {
    private boolean _valid = true;
    private int _pointCount = 0;
    private final int _startIndex;
    private final Timestamp _startTimestamp;
    private DataPoint _latestPoint = null;
    private double _totalRadians = 0.0;

    SegmentSummary(int n, DataPoint dataPoint) {
        this._startIndex = n;
        this._startTimestamp = dataPoint == null ? null : dataPoint.getTimestamp();
        this.addPoint(dataPoint);
    }

    public void addPoint(DataPoint dataPoint) {
        if (dataPoint == null || !dataPoint.isValid() || !dataPoint.hasTimestamp()) {
            this._valid = false;
            return;
        }
        if (this._latestPoint != null) {
            this._totalRadians += DataPoint.calculateRadiansBetween(this._latestPoint, dataPoint);
            this._valid = this._valid && !dataPoint.getTimestamp().isBefore(this._latestPoint.getTimestamp());
        }
        this._latestPoint = dataPoint;
        ++this._pointCount;
    }

    public boolean isValid() {
        return this._valid && this._pointCount > 1;
    }

    public int getPointCount() {
        return this._pointCount;
    }

    public int getStartIndex() {
        return this._startIndex;
    }

    public Timestamp getStartTimestamp() {
        return this._startTimestamp;
    }

    public long getDurationInSeconds() {
        if (this._latestPoint != null && this._latestPoint.hasTimestamp()) {
            return this._latestPoint.getTimestamp().getSecondsSince(this._startTimestamp);
        }
        return 0L;
    }

    public double getDistanceInRadians() {
        return this._totalRadians;
    }
}

