/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.distance;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;
import tim.prune.function.distance.DistanceTableModel;
import tim.prune.function.distance.FromTableModel;

public class DistanceFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JTable _pointTable = null;
    private FromTableModel _fromModel = null;
    private JTable _distancesTable = null;
    private DistanceTableModel _distModel = null;

    public DistanceFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.distances";
    }

    @Override
    public void begin() {
        ArrayList<DataPoint> arrayList;
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        if ((arrayList = DistanceFunction.getPointList(this._app.getTrackInfo())).size() < 2) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.distances.toofewpoints");
            return;
        }
        this._fromModel.init(arrayList);
        this._distModel.init(arrayList);
        int n = DistanceFunction.getPointIndex(arrayList, this._app.getTrackInfo());
        this._pointTable.getSelectionModel().setSelectionInterval(n, n);
        this._distModel.recalculate(n, this.getConfig());
        this.centerAlignBearingColumn();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.distances.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        this._fromModel = new FromTableModel();
        this._pointTable = new JTable(this._fromModel);
        this._pointTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this._distModel.recalculate(this._pointTable.getSelectedRow(), this.getConfig());
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this._pointTable);
        jScrollPane.setPreferredSize(new Dimension(100, 250));
        this._distModel = new DistanceTableModel();
        this._distancesTable = new JTable(this._distModel);
        this._distancesTable.setAutoCreateRowSorter(true);
        JScrollPane jScrollPane2 = new JScrollPane(this._distancesTable);
        jScrollPane2.setPreferredSize(new Dimension(200, 250));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setDividerLocation(0.3);
        jSplitPane.setResizeWeight(0.4);
        jPanel.add((Component)jSplitPane, "Center");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    DistanceFunction.this._dialog.dispose();
                }
            }
        };
        this._pointTable.addKeyListener(keyAdapter);
        this._distancesTable.addKeyListener(keyAdapter);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.close"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void centerAlignBearingColumn() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        this._distancesTable.getColumnModel().getColumn(2).setCellRenderer(defaultTableCellRenderer);
    }

    private static ArrayList<DataPoint> getPointList(TrackInfo trackInfo) {
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        trackInfo.getTrack().getWaypoints(arrayList);
        DataPoint dataPoint = trackInfo.getCurrentPoint();
        if (dataPoint != null && !dataPoint.isWaypoint()) {
            arrayList.add(0, dataPoint);
        }
        return arrayList;
    }

    private static int getPointIndex(ArrayList<DataPoint> arrayList, TrackInfo trackInfo) {
        DataPoint dataPoint = trackInfo.getCurrentPoint();
        if (dataPoint != null && dataPoint.isWaypoint()) {
            int n = 0;
            while (n < arrayList.size()) {
                if (arrayList.get(n) == dataPoint) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }
}

