/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.data;

import java.util.Calendar;

public class Date {
    private final int _year;
    private final int _month;
    private final int _day;

    Date(int n, int n2, int n3) {
        this._year = n;
        this._month = n2;
        this._day = n3;
    }

    static boolean isSeparator(char c) {
        return " .-:".indexOf(c) >= 0;
    }

    static Date parseString(String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.length() != 10) {
            return null;
        }
        try {
            int n = Integer.parseInt(string2.substring(0, 4));
            int n2 = Integer.parseInt(string2.substring(5, 7));
            int n3 = Integer.parseInt(string2.substring(8));
            if (n >= 1000 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= Date.getDaysInMonth(n, n2)) {
                return new Date(n, n2, n3);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    static int getDaysInMonth(int n, int n2) {
        if (n2 >= 1 && n2 <= 12) {
            if (n2 == 2) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, n);
                calendar.set(2, n2);
                calendar.set(5, 1);
                calendar.add(5, -1);
                return calendar.get(5);
            }
            int[] nArray = new int[13];
            nArray[1] = 31;
            nArray[3] = 31;
            nArray[4] = 30;
            nArray[5] = 31;
            nArray[6] = 30;
            nArray[7] = 31;
            nArray[8] = 31;
            nArray[9] = 30;
            nArray[10] = 31;
            nArray[11] = 30;
            nArray[12] = 31;
            int[] nArray2 = nArray;
            return nArray2[n2];
        }
        return 1;
    }

    public int getYear() {
        return this._year;
    }

    public int getMonth() {
        return this._month;
    }

    public int getDay() {
        return this._day;
    }

    public String toString() {
        return String.format("%d-%02d-%02d", this._year, this._month, this._day);
    }

    public boolean isAfter(Date date) {
        return date == null || this.toString().compareTo(date.toString()) > 0;
    }

    public boolean isValid() {
        return this._year >= 1000 && this._year <= 9999 && this._month >= 1 && this._month <= 12 && this._day >= 1 && this._day <= Date.getDaysInMonth(this._year, this._month);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Date date = (Date)object;
        return this._year == date._year && this._month == date._month && this._day == date._day;
    }
}

