/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.publish.internal.component.ConfigurationVariantDetailsInternal;
import org.gradle.api.specs.Spec;
import org.jspecify.annotations.Nullable;

public class JavaConfigurationVariantMapping
implements Action<ConfigurationVariantDetails> {
    public static final Set<String> UNPUBLISHABLE_VARIANT_ARTIFACTS = ImmutableSet.of((Object)"java-classes-directory", (Object)"java-resources-directory", (Object)"directory");
    private final String scope;
    private final boolean optional;
    private final Configuration resolutionConfiguration;

    public JavaConfigurationVariantMapping(String scope, boolean optional) {
        this(scope, optional, null);
    }

    public JavaConfigurationVariantMapping(String scope, boolean optional, @Nullable Configuration resolutionConfiguration) {
        this.scope = scope;
        this.optional = optional;
        this.resolutionConfiguration = resolutionConfiguration;
    }

    public void execute(ConfigurationVariantDetails details) {
        ConfigurationVariant variant = details.getConfigurationVariant();
        if (UnpublishableArtifactTypeSpec.INSTANCE.isSatisfiedBy(variant)) {
            details.skip();
        } else {
            details.mapToMavenScope(this.scope);
            if (this.optional) {
                details.mapToOptional();
            }
            if (this.resolutionConfiguration != null) {
                ((ConfigurationVariantDetailsInternal)details).dependencyMapping(dependencyMapping -> dependencyMapping.fromResolutionOf(this.resolutionConfiguration));
            }
        }
    }

    private static class UnpublishableArtifactTypeSpec
    implements Spec<ConfigurationVariant> {
        private static final UnpublishableArtifactTypeSpec INSTANCE = new UnpublishableArtifactTypeSpec();

        private UnpublishableArtifactTypeSpec() {
        }

        public boolean isSatisfiedBy(ConfigurationVariant element) {
            for (PublishArtifact artifact : element.getArtifacts()) {
                if (!UNPUBLISHABLE_VARIANT_ARTIFACTS.contains(artifact.getType())) continue;
                return true;
            }
            return false;
        }
    }
}

