#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp-test
version:              0.16.0.0
visibility:           public
id:                   lsp-test-0.16.0.0-L9ac9WdJA1uBPfPWWTNSGE
key:                  lsp-test-0.16.0.0-L9ac9WdJA1uBPfPWWTNSGE
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  c4b3d89a70933436bc277d51f1b6d064
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-20UTEUZ5CKDJdRu747ID48:Control.Applicative.Combinators,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.2.0-dUFitFTJB7FQc8xMsVNi8:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Message from lsp-types-2.0.2.0-dUFitFTJB7FQc8xMsVNi8:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.2.0-dUFitFTJB7FQc8xMsVNi8:Language.LSP.Protocol.Types,
    Language.LSP.Test

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.6.6/site-local/lsp-test-0.16.0.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/lsp-test-0.16.0.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/lsp-test-0.16.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.16.0.0-L9ac9WdJA1uBPfPWWTNSGE
depends:
    Diff-0.5-9iFzYwbbznxCTrvC5fevGO Glob-0.10.2-2ZMF3q0E9RcIvo0RuO2Ci6
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK
    aeson-pretty-0.8.10-LSDchJgtnQ46sIK4bUu3co
    ansi-terminal-1.1-6H4MdlQ9LS5JB7dL181Y6t
    async-2.2.5-BExe3HBSFHr8hii1cT1bvS base-4.18.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-1l4Xb3jVXB2Kx3NkmnOyE3
    conduit-1.3.6.1-4cc2yOSL2sy5iK6rZQd5vm
    conduit-parse-0.2.1.1-296Fq2wOjX8II0c6FIeIiC containers-0.6.7
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz directory-1.3.8.5
    exceptions-0.10.7 filepath-1.4.300.1
    lens-5.3.3-Ag3JywAjDxJ2k98xBhf4hs
    lens-aeson-1.2.3-LKwWspc3CGLABpwUtuPc2T
    lsp-2.2.0.0-1wTjR6m8XHMB9d0XTUKi2
    lsp-types-2.0.2.0-dUFitFTJB7FQc8xMsVNi8 mtl-2.3.1
    parser-combinators-1.3.0-20UTEUZ5CKDJdRu747ID48 process-1.6.19.0
    row-types-1.0.1.2-1KPI2BY2URnDbZFtTY7TBE
    some-1.0.6-FbRafNTl9PTBIoC35t78eX text-2.0.2 time-1.12.2
    transformers-0.6.1.0 unix-2.8.4.0

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

