#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 math-functions
version:              0.3.4.4
visibility:           public
id:                   math-functions-0.3.4.4-IN01xkRsacQCX7B6btQ4bI
key:                  math-functions-0.3.4.4-IN01xkRsacQCX7B6btQ4bI
license:              BSD-2-Clause
maintainer:           Alexey Khudyakov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>,
    Alexey Khudyakov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/math-functions
synopsis:             Collection of tools for numeric computations
description:
    This library contain collection of various utilities for numerical
    computing. So far there'\''re special mathematical functions,
    compensated summation algorithm, summation of series, root finding
    for real functions, polynomial summation and Chebyshev
    polynomials.

category:             Math, Numeric
abi:                  8260be6b2ac44fed127cbe10cea5446a
exposed:              True
exposed-modules:
    Numeric.MathFunctions.Comparison Numeric.MathFunctions.Constants
    Numeric.Polynomial Numeric.Polynomial.Chebyshev Numeric.RootFinding
    Numeric.Series Numeric.SpecFunctions Numeric.SpecFunctions.Extra
    Numeric.SpecFunctions.Internal Numeric.Sum

hidden-modules:       Numeric.SpecFunctions.Compat
import-dirs:          /usr/lib/ghc-9.6.6/site-local/math-functions-0.3.4.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/math-functions-0.3.4.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/math-functions-0.3.4.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-math-functions
hs-libraries:         HSmath-functions-0.3.4.4-IN01xkRsacQCX7B6btQ4bI
depends:
    base-4.18.2.1 data-default-class-0.1.2.2-CDKXYK1wrFx3d5as0Pbjkc
    deepseq-1.4.8.1 primitive-0.9.1.0-E1xWGIz4UCzCm0xql5yb2P
    vector-0.13.2.0-E3NoiTCgQOe6nzWP7aBMnB

haddock-interfaces:
    /usr/share/doc/haskell-math-functions/html/math-functions.haddock

haddock-html:         /usr/share/doc/haskell-math-functions/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

