#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.51.2
visibility:           public
id:                   hledger-web-1.51.2-9uZ2Zr8QekJIzpynYZGToI
key:                  hledger-web-1.51.2-9uZ2Zr8QekJIzpynYZGToI
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  f285c2463f5c1c1bd00dffdeb422d4bb
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.App Hledger.Web.Application
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Main Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Test
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common

hidden-modules:       Paths_hledger_web
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.51.2-9uZ2Zr8QekJIzpynYZGToI
depends:
    Decimal-0.5.2-JXrePV1lvreIVHPnZS1jqh
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK base-4.18.2.1
    base64-1.0-7qYY6Ukj5xzI8lDtv71Lh
    blaze-html-0.9.2.0-BSUXMYxgqldK7Fv9A0AXBj
    blaze-markup-0.8.3.0-F9gHjrjtMfj4BTHQBYRdEr bytestring-0.11.5.3
    case-insensitive-1.2.1.0-HFTLAepm1u61gRs0sAANH
    clientsession-0.9.3.0-EVh3Wmb7nHk6Uwrx4QacGf
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    conduit-1.3.6.1-4cc2yOSL2sy5iK6rZQd5vm
    conduit-extra-1.3.8-KyGJKsBlxeR6aLyGVSa94z containers-0.6.7
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz directory-1.3.8.5
    extra-1.7.16-6e0wBrlA2xu66mkOtGwbe0
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    githash-0.1.6.3-I67lp2I8Vnr6v6Q6s23zsl
    hjsmin-0.2.1-5cPa4A6Nqhx8Ed5O2OKasX
    hledger-1.51.2-1qSluEJK8WDI5NV4n9Jurd
    hledger-lib-1.51.2-7OdwkTnRmWM4jXtPvfzRUz
    hspec-2.11.4-1corELx5Z4KFoQMEqaY6Wo
    http-client-0.7.19-4rucZD6prn1Bn7NkqCpiFR
    http-conduit-2.3.9.1-3cMmWLkkkkTQL61v9H7Y4
    http-types-0.12.4-Hj8jLUhN6rtnIgKEy5ynr
    megaparsec-9.7.0-J7oRvDmmxLP8uuOmkK9aRM mtl-2.3.1
    network-3.1.4.0-LsWsY6caX6uCNLTGwySDR3
    safe-0.3.21-WYqCEMpsX24yfPdI1X0Hh
    shakespeare-2.1.7-CFRzD7VNGIS74GFY2KG4F1 template-haskell-2.20.0.0
    text-2.0.2 time-1.12.2 transformers-0.6.1.0
    unix-compat-0.7.4.1-DqDzbwuaouv1yXLtKQLq3q
    unordered-containers-0.2.20.1-I6eyTXb69D2BhxejMtPouo
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    wai-3.2.4-jofbQLzhHjJAjHqqQ1gcC
    wai-cors-0.2.7-8wfYGEE0I6u1rufSHnHt2z
    wai-extra-3.1.18-1DuUCp3G6ik2vwmaLqFrh
    wai-handler-launch-3.0.3.1-H94DBZcIzis4Wc9tX1NTTm
    warp-3.4.0-3Ya7eYvnJ6uGkh1jTMqqfV
    yaml-0.11.11.2-BS6mG9zOsXWGQgGFfufno4
    yesod-1.6.2.1-KKU1UzFdg1oGaNWFyjRxwH
    yesod-core-1.6.27.1-D6ElD4Y0bSo1oCdjSDIu6b
    yesod-form-1.7.9-I4fi8L52Ne3BgEspAnganO
    yesod-static-1.6.1.0-CFE86QGHBiF6X3nYZzgaHl
    yesod-test-1.6.23-B7GE6ViVCfQLsKsjr7bg2Z

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

