/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.api.Access;
import org.jruby.api.Define;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.Ifaddr;
import org.jruby.ext.socket.Option;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.RubyServerSocket;
import org.jruby.ext.socket.RubySocket;
import org.jruby.ext.socket.RubyTCPServer;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.ext.socket.RubyUDPSocket;
import org.jruby.ext.socket.RubyUNIXServer;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.load.Library;

public class SocketLibrary
implements Library {
    @Override
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        ThreadContext context = runtime2.getCurrentContext();
        RubyClass Object2 = Access.objectClass(context);
        RubyClass StandardError2 = Access.standardErrorClass(context);
        RubyClass IO = Access.ioClass(context);
        Define.defineClass(context, "SocketError", StandardError2, StandardError2.getAllocator());
        RubyClass BasicSocket = RubyBasicSocket.createBasicSocket(context, IO);
        RubyClass Socket2 = RubySocket.createSocket(context, BasicSocket);
        RubyServerSocket.createServerSocket(context, Socket2);
        if (Access.instanceConfig(context).isNativeEnabled() && !Platform.IS_WINDOWS) {
            RubyClass UNIXSocket = RubyUNIXSocket.createUNIXSocket(context, BasicSocket);
            RubyUNIXServer.createUNIXServer(context, UNIXSocket);
        }
        RubyClass IPSocket = RubyIPSocket.createIPSocket(context, BasicSocket);
        RubyClass TCPSocket = RubyTCPSocket.createTCPSocket(context, IPSocket);
        RubyTCPServer.createTCPServer(context, TCPSocket);
        RubyUDPSocket.createUDPSocket(context, IPSocket, Socket2);
        Addrinfo.createAddrinfo(context, Object2);
        Option.createOption(context, Object2, Socket2);
        Ifaddr.createIfaddr(context, Object2, Socket2);
    }
}

