/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class Heartbeat {
    public static final String SOURCE_CLUSTER_ALIAS_KEY = "sourceClusterAlias";
    public static final String TARGET_CLUSTER_ALIAS_KEY = "targetClusterAlias";
    public static final String TIMESTAMP_KEY = "timestamp";
    public static final String VERSION_KEY = "version";
    public static final short VERSION = 0;
    public static final Schema VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("timestamp", (Type)Type.INT64)});
    public static final Schema KEY_SCHEMA = new Schema(new Field[]{new Field("sourceClusterAlias", (Type)Type.STRING), new Field("targetClusterAlias", (Type)Type.STRING)});
    public static final Schema HEADER_SCHEMA = new Schema(new Field[]{new Field("version", (Type)Type.INT16)});
    private final String sourceClusterAlias;
    private final String targetClusterAlias;
    private final long timestamp;

    public Heartbeat(String sourceClusterAlias, String targetClusterAlias, long timestamp) {
        this.sourceClusterAlias = sourceClusterAlias;
        this.targetClusterAlias = targetClusterAlias;
        this.timestamp = timestamp;
    }

    public String sourceClusterAlias() {
        return this.sourceClusterAlias;
    }

    public String targetClusterAlias() {
        return this.targetClusterAlias;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.format("Heartbeat{sourceClusterAlias=%s, targetClusterAlias=%s, timestamp=%d}", this.sourceClusterAlias, this.targetClusterAlias, this.timestamp);
    }

    ByteBuffer serializeValue(short version) {
        Schema valueSchema = Heartbeat.valueSchema(version);
        Struct header = this.headerStruct(version);
        Struct value = this.valueStruct(valueSchema);
        ByteBuffer buffer = ByteBuffer.allocate(HEADER_SCHEMA.sizeOf((Object)header) + valueSchema.sizeOf((Object)value));
        HEADER_SCHEMA.write(buffer, (Object)header);
        valueSchema.write(buffer, (Object)value);
        buffer.flip();
        return buffer;
    }

    ByteBuffer serializeKey() {
        Struct struct = this.keyStruct();
        ByteBuffer buffer = ByteBuffer.allocate(KEY_SCHEMA.sizeOf((Object)struct));
        KEY_SCHEMA.write(buffer, (Object)struct);
        buffer.flip();
        return buffer;
    }

    public static Heartbeat deserializeRecord(ConsumerRecord<byte[], byte[]> record) {
        ByteBuffer value = ByteBuffer.wrap((byte[])record.value());
        Struct headerStruct = HEADER_SCHEMA.read(value);
        short version = headerStruct.getShort(VERSION_KEY);
        Struct valueStruct = Heartbeat.valueSchema(version).read(value);
        long timestamp = valueStruct.getLong(TIMESTAMP_KEY);
        Struct keyStruct = KEY_SCHEMA.read(ByteBuffer.wrap((byte[])record.key()));
        String sourceClusterAlias = keyStruct.getString(SOURCE_CLUSTER_ALIAS_KEY);
        String targetClusterAlias = keyStruct.getString(TARGET_CLUSTER_ALIAS_KEY);
        return new Heartbeat(sourceClusterAlias, targetClusterAlias, timestamp);
    }

    private Struct headerStruct(short version) {
        Struct struct = new Struct(HEADER_SCHEMA);
        struct.set(VERSION_KEY, (Object)version);
        return struct;
    }

    private Struct valueStruct(Schema schema) {
        Struct struct = new Struct(schema);
        struct.set(TIMESTAMP_KEY, (Object)this.timestamp);
        return struct;
    }

    private Struct keyStruct() {
        Struct struct = new Struct(KEY_SCHEMA);
        struct.set(SOURCE_CLUSTER_ALIAS_KEY, (Object)this.sourceClusterAlias);
        struct.set(TARGET_CLUSTER_ALIAS_KEY, (Object)this.targetClusterAlias);
        return struct;
    }

    Map<String, ?> connectPartition() {
        HashMap<String, String> partition = new HashMap<String, String>();
        partition.put(SOURCE_CLUSTER_ALIAS_KEY, this.sourceClusterAlias);
        partition.put(TARGET_CLUSTER_ALIAS_KEY, this.targetClusterAlias);
        return partition;
    }

    byte[] recordKey() {
        return this.serializeKey().array();
    }

    byte[] recordValue() {
        return this.serializeValue((short)0).array();
    }

    private static Schema valueSchema(short version) {
        assert (version == 0);
        return VALUE_SCHEMA_V0;
    }
}

