/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.math.BigInteger;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacOTP {
    public static final String HMAC_SHA1 = "HmacSHA1";
    public static final String HMAC_SHA256 = "HmacSHA256";
    public static final String HMAC_SHA512 = "HmacSHA512";
    public static final String DEFAULT_ALGORITHM = "HmacSHA1";
    public static final int DEFAULT_NUMBER_DIGITS = 6;
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};
    protected final String algorithm;
    protected final int numberDigits;
    protected final int lookAroundWindow;

    public HmacOTP(int numberDigits, String algorithm, int delayWindow) {
        this.numberDigits = numberDigits;
        this.algorithm = algorithm;
        this.lookAroundWindow = delayWindow;
    }

    public static String generateSecret(int length) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVW1234567890";
        SecureRandom r = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(r.nextInt(chars.length()));
            sb.append(c);
        }
        return sb.toString();
    }

    public String generateHOTP(byte[] key, int counter) {
        Object steps = Integer.toHexString(counter).toUpperCase();
        while (((String)steps).length() < 16) {
            steps = "0" + (String)steps;
        }
        return this.generateOTP(key, (String)steps, this.numberDigits, this.algorithm);
    }

    public String generateHOTP(String key, int counter) {
        return this.generateHOTP(key.getBytes(), counter);
    }

    public int validateHOTP(String token, byte[] key, int counter) {
        int newCounter = counter;
        for (newCounter = counter; newCounter <= counter + this.lookAroundWindow; ++newCounter) {
            String candidate = this.generateHOTP(key, newCounter);
            if (!candidate.equals(token)) continue;
            return newCounter + 1;
        }
        return -1;
    }

    public int validateHOTP(String token, String key, int counter) {
        return this.validateHOTP(token, key.getBytes(), counter);
    }

    public String generateOTP(byte[] key, String counter, int returnDigits, String crypto) {
        Object result = null;
        while (((String)counter).length() < 16) {
            counter = "0" + (String)counter;
        }
        byte[] msg = this.hexStr2Bytes((String)counter);
        byte[] hash = this.hmac_sha1(crypto, key, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[returnDigits];
        result = Integer.toString(otp);
        while (((String)result).length() < returnDigits) {
            result = "0" + (String)result;
        }
        return result;
    }

    private byte[] hmac_sha1(String crypto, byte[] keyBytes, byte[] text) {
        byte[] value;
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            value = hmac.doFinal(text);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    private byte[] hexStr2Bytes(String hex) {
        byte[] bArray = new BigInteger("10" + hex, 16).toByteArray();
        byte[] ret = new byte[bArray.length - 1];
        System.arraycopy(bArray, 1, ret, 0, ret.length);
        return ret;
    }
}

