/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.RankCalculator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.logging.Log;

@Scope(value=Scopes.NAMED_CACHE)
public class NumericVersionGenerator
implements VersionGenerator {
    final AtomicInteger versionCounter = new AtomicInteger();
    private static final NumericVersion NON_EXISTING = new NumericVersion(0L);
    @Inject
    Configuration configuration;
    @Inject
    RankCalculator rankCalculator;
    private boolean isClustered;

    @Start
    public void start() {
        this.isClustered = this.configuration.clustering().cacheMode().isClustered();
    }

    @Override
    public IncrementableEntryVersion generateNew() {
        long counter = this.versionCounter.incrementAndGet();
        return this.createNumericVersion(counter);
    }

    private IncrementableEntryVersion createNumericVersion(long counter) {
        return this.isClustered ? new NumericVersion(this.rankCalculator.getVersionPrefix() | counter) : new NumericVersion(counter);
    }

    @Override
    public IncrementableEntryVersion increment(IncrementableEntryVersion initialVersion) {
        if (initialVersion instanceof NumericVersion) {
            NumericVersion old = (NumericVersion)initialVersion;
            long counter = old.getVersion() + 1L;
            return this.createNumericVersion(counter);
        }
        throw Log.CONTAINER.unexpectedInitialVersion(initialVersion.getClass().getName());
    }

    @Override
    public IncrementableEntryVersion nonExistingVersion() {
        return NON_EXISTING;
    }

    void resetCounter() {
        this.versionCounter.set(0);
    }
}

