/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import org.hibernate.models.spi.ArrayTypeDetails;
import org.hibernate.models.spi.ClassTypeDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.PrimitiveTypeDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableReferenceDetails;
import org.hibernate.models.spi.VoidTypeDetails;
import org.hibernate.models.spi.WildcardTypeDetails;

public interface TypeDetailsSwitch<T> {
    public static <T> T switchType(TypeDetails typeDetails, TypeDetailsSwitch<T> switcher, ModelsContext modelsContext) {
        switch (typeDetails.getTypeKind()) {
            case CLASS: {
                return switcher.caseClass(typeDetails.asClassType(), modelsContext);
            }
            case PRIMITIVE: {
                return switcher.casePrimitive(typeDetails.asPrimitiveType(), modelsContext);
            }
            case VOID: {
                return switcher.caseVoid(typeDetails.asVoidType(), modelsContext);
            }
            case ARRAY: {
                return switcher.caseArrayType(typeDetails.asArrayType(), modelsContext);
            }
            case PARAMETERIZED_TYPE: {
                return switcher.caseParameterizedType(typeDetails.asParameterizedType(), modelsContext);
            }
            case WILDCARD_TYPE: {
                return switcher.caseWildcardType(typeDetails.asWildcardType(), modelsContext);
            }
            case TYPE_VARIABLE: {
                return switcher.caseTypeVariable(typeDetails.asTypeVariable(), modelsContext);
            }
            case TYPE_VARIABLE_REFERENCE: {
                return switcher.caseTypeVariableReference(typeDetails.asTypeVariableReference(), modelsContext);
            }
        }
        return switcher.defaultCase(typeDetails, modelsContext);
    }

    public T caseClass(ClassTypeDetails var1, ModelsContext var2);

    public T casePrimitive(PrimitiveTypeDetails var1, ModelsContext var2);

    public T caseVoid(VoidTypeDetails var1, ModelsContext var2);

    public T caseParameterizedType(ParameterizedTypeDetails var1, ModelsContext var2);

    public T caseWildcardType(WildcardTypeDetails var1, ModelsContext var2);

    public T caseTypeVariable(TypeVariableDetails var1, ModelsContext var2);

    public T caseTypeVariableReference(TypeVariableReferenceDetails var1, ModelsContext var2);

    public T caseArrayType(ArrayTypeDetails var1, ModelsContext var2);

    public T defaultCase(TypeDetails var1, ModelsContext var2);
}

