/*
 * Decompiled with CFR 0.152.
 */
package hughai.mapping;

import com.springrts.ai.oo.clb.Map;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.ResourceManager;
import hughai.VoiceCommandHandler;
import hughai.basictypes.ArrayIndexer;
import hughai.basictypes.Float3;
import hughai.basictypes.Int2;
import hughai.basictypes.TerrainPos;
import hughai.mapping.BuildMap;
import hughai.mapping.Maps;
import hughai.ui.MainUI;
import hughai.unitdata.UnitController;
import hughai.unitdata.UnitDefHelp;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import hughai.utils.TimeHelper;
import hughai.utils.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Metal {
    public final String MetalClassVersion = "0.1";
    public int MinMetalForSpot = 30;
    public int MaxSpots = 5000;
    public static final int granularity = 2;
    public MetalSpot[] MetalSpots;
    public ArrayList<MetalSpot> MetalSpotsUsed = new ArrayList();
    public boolean isMetalMap = false;
    public HashMap<Unit, Float3> Extractors = new HashMap();
    double ExtractorRadius;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    UnitController unitcontroller;
    UnitDefHelp unitdefhelp;
    ResourceManager resourceManager;
    TimeHelper timeHelper;
    Maps maps;
    DrawingUtils drawingUtils;
    PlayerObjects playerObjects;

    public Metal(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.unitcontroller = playerObjects.getUnitController();
        this.unitdefhelp = playerObjects.getUnitDefHelp();
        this.resourceManager = playerObjects.getResourceManager();
        this.timeHelper = playerObjects.getTimeHelper();
        this.maps = playerObjects.getMaps();
        this.drawingUtils = playerObjects.getDrawingUtils();
        this.ExtractorRadius = this.aicallback.getMap().getExtractorRadius(this.resourceManager.getMetalResource());
        this.unitcontroller.registerListener(new UnitListener());
        this.csai.RegisterVoiceCommand("searchmetalspots", new VoiceSearchMetal());
        playerObjects.getMainUI().registerButton("Show metal spots", new ShowMetalSpotsButton());
    }

    protected void finalize() {
        System.out.println(this.getClass().getSimpleName() + ".finalize()");
    }

    public void Init() {
        if (!this.LoadCache()) {
            this.csai.SendTextMsg("Metal analyzer rebuilding cachefile");
            this.SearchMetalSpots();
        }
        if (!this.isMetalMap) {
            this.ReserveMetalExtractorSpaces();
        }
    }

    void ReserveMetalExtractorSpaces() {
        for (MetalSpot metalSpot : this.MetalSpots) {
            BuildMap.BuildMapPos buildMapPos = BuildMap.BuildMapPos.fromTerrainPos(metalSpot.Pos);
            this.maps.getBuildMap().ReserveSpace(this, buildMapPos, 6, 6);
        }
    }

    public TerrainPos GetNearestMetalSpot(TerrainPos terrainPos) {
        if (!this.isMetalMap) {
            double d = 1.0E12;
            TerrainPos terrainPos2 = null;
            MetalSpot metalSpot = null;
            for (MetalSpot metalSpot2 : this.MetalSpots) {
                float f;
                if (this.MetalSpotsUsed.contains(metalSpot2)) continue;
                if (terrainPos2 == null) {
                    terrainPos2 = metalSpot2.Pos;
                }
                if (!((double)(f = terrainPos.GetSquaredDistance(metalSpot2.Pos)) < d)) continue;
                d = f;
                terrainPos2 = metalSpot2.Pos;
                metalSpot = metalSpot2;
            }
            return metalSpot.Pos;
        }
        return terrainPos;
    }

    void DrawMetalSpots() {
        if (!this.isMetalMap) {
            String string = this.playerObjects.getConfig().getMetalspotmarkerunitname();
            String string2 = this.playerObjects.getConfig().getUsedmetalspotmarkerunitname();
            for (MetalSpot metalSpot : this.MetalSpots) {
                this.logfile.WriteLine("drawing spot at " + metalSpot.Pos);
                this.drawingUtils.DrawUnit(string, metalSpot.Pos, 0.0f, 1, this.aicallback.getSkirmishAI().getTeamId(), true, true);
                this.drawingUtils.drawText(metalSpot.Pos, "" + metalSpot.Pos);
            }
            for (MetalSpot metalSpot : this.MetalSpotsUsed) {
                this.logfile.WriteLine("drawing usedspot at " + metalSpot.Pos);
                this.drawingUtils.DrawUnit(string2, metalSpot.Pos, 0.0f, 1, this.aicallback.getSkirmishAI().getTeamId(), true, true);
                this.drawingUtils.drawText(metalSpot.Pos, "" + metalSpot.Pos);
            }
        } else {
            this.csai.SendTextMsg("Metal analyzer reports this is a metal map");
        }
    }

    boolean LoadCache() {
        String string = this.aicallback.getMap().getName();
        String string2 = this.csai.getCacheDirectoryPath() + File.separator + string + "_metal.xml";
        if (!new File(string2).exists()) {
            this.logfile.WriteLine("cache file doesnt exist -> building");
            return false;
        }
        Document document = XmlHelper.OpenDom(string2);
        Element element = XmlHelper.SelectSingleElement(document.getDocumentElement(), "/root/metadata");
        String string3 = element.getAttribute("version");
        if (!string3.equals("0.1")) {
            this.logfile.WriteLine("cache file out of date ( " + string3 + " vs " + "0.1" + " ) -> rebuilding");
            return false;
        }
        this.logfile.WriteLine(document.getTextContent());
        this.isMetalMap = Boolean.parseBoolean(element.getAttribute("ismetalmap"));
        if (this.isMetalMap) {
            this.logfile.WriteLine("metal map");
            return true;
        }
        Element element2 = XmlHelper.SelectSingleElement(document.getDocumentElement(), "/root/metalspots");
        ArrayList<MetalSpot> arrayList = new ArrayList<MetalSpot>();
        for (Element element3 : XmlHelper.SelectElements(element2, "metalspot")) {
            int n = Integer.parseInt(element3.getAttribute("amount"));
            TerrainPos terrainPos = new TerrainPos();
            terrainPos.readFromXmlElement(element3);
            MetalSpot metalSpot = new MetalSpot(n, terrainPos);
            arrayList.add(metalSpot);
        }
        this.MetalSpots = arrayList.toArray(new MetalSpot[0]);
        this.logfile.WriteLine("metal spot cache file loaded");
        return true;
    }

    void SaveCache() {
        Map map = this.aicallback.getMap();
        String string = map.getName();
        String string2 = this.csai.getCacheDirectoryPath() + File.separator + string + "_metal.xml";
        Document document = XmlHelper.CreateDom();
        Element element = XmlHelper.AddChild(document.getDocumentElement(), "metadata");
        element.setAttribute("type", "MetalCache");
        element.setAttribute("map", string);
        element.setAttribute("version", "0.1");
        element.setAttribute("datecreated", this.timeHelper.GetCurrentRealTimeString());
        element.setAttribute("ismetalmap", "" + this.isMetalMap);
        element.setAttribute("extractorradius", "" + map.getExtractorRadius(this.resourceManager.getMetalResource()));
        element.setAttribute("mapheight", "" + map.getHeight());
        element.setAttribute("mapwidth", "" + map.getWidth());
        Element element2 = XmlHelper.AddChild(document.getDocumentElement(), "metalspots");
        for (MetalSpot metalSpot : this.MetalSpots) {
            Element element3 = XmlHelper.AddChild(element2, "metalspot");
            metalSpot.Pos.writeToXmlElement(element3);
            element3.setAttribute("amount", "" + metalSpot.Amount);
        }
        XmlHelper.SaveDom(document, string2);
    }

    AvailableMetalResult CalculateAvailableMetalForEachSpot(int[][] nArray, int n) {
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int n4 = n * n;
        int[][] nArray2 = new int[n2][n3];
        this.logfile.WriteLine("mapwidth: " + n2 + " mapheight: " + n3 + " ExtractorRadius: " + n + " SquareExtractorRadius: " + n4);
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n6 = 0;
                for (int k = -n; k <= n; ++k) {
                    int n7 = j + k;
                    if (n7 < 0 || n7 >= n2) continue;
                    for (int i2 = -n; i2 <= n; ++i2) {
                        int n8 = i + i2;
                        if (n8 < 0 || n8 >= n3 || k * k + i2 * i2 > n4) continue;
                        n6 += nArray[n7][n8];
                    }
                }
                nArray2[j][i] = n6;
                n5 = Math.max(n6, n5);
            }
        }
        return new AvailableMetalResult(nArray2, n5);
    }

    public void SearchMetalSpots() {
        int n;
        int n2;
        this.logfile.WriteLine("SearchMetalSpots() >>>");
        this.isMetalMap = false;
        ArrayList<MetalSpot> arrayList = new ArrayList<MetalSpot>();
        Map map = this.aicallback.getMap();
        int n3 = map.getHeight() / 2;
        int n4 = map.getWidth() / 2;
        double d = map.getMaxResource(this.resourceManager.getMetalResource());
        int n5 = n3 * n4;
        this.logfile.WriteLine("mapwidth: " + n4 + " mapheight " + n3 + " maxmetal:" + d);
        List list = map.getResourceMapRaw(this.resourceManager.getMetalResource());
        int[][] nArray = new int[n4][n3];
        int[][] nArray2 = new int[n4][n3];
        int[][] nArray3 = new int[n4][n3];
        int n6 = 0;
        ArrayIndexer arrayIndexer = new ArrayIndexer(n4, n3);
        this.logfile.WriteLine("width: " + n4 + " height: " + n3);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                nArray[j][i] = ((Short)list.get(arrayIndexer.GetIndex(j, i))).shortValue();
                n6 += nArray[j][i];
            }
        }
        this.logfile.WriteLine("*******************************************");
        double d2 = (double)n6 / (double)n5;
        int n7 = (int)((double)map.getExtractorRadius(this.resourceManager.getMetalResource()) / 16.0);
        int n8 = n7 * 2;
        int n9 = n7 * n7;
        int n10 = 4 * n9;
        double d3 = Math.PI * (double)n7 * (double)n7;
        int n11 = 0;
        this.logfile.WriteLine("Calculating available metal for each spot...");
        AvailableMetalResult availableMetalResult = this.CalculateAvailableMetalForEachSpot(nArray, n7);
        nArray2 = availableMetalResult.availableMetal;
        n11 = availableMetalResult.maxMetalAmount;
        int[][] nArray4 = new int[n4][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                nArray3[n][n2] = nArray2[n][n2] * 255 / n11;
            }
        }
        n2 = 0;
        n = 0;
        for (int i = 0; i < this.MaxSpots && n2 == 0; ++i) {
            int n12;
            int n13;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n4; ++k) {
                    if (nArray3[k][j] <= n17 && (nArray3[k][j] != n17 || nArray[k][j] <= n16)) continue;
                    n17 = nArray3[k][j];
                    n14 = k;
                    n15 = j;
                    n16 = nArray[k][j];
                }
            }
            if (n17 < this.MinMetalForSpot) {
                n2 = 1;
            }
            if (n2 != 0) continue;
            MetalPos metalPos = new MetalPos(n14, n15);
            TerrainPos terrainPos = metalPos.toTerrainPos();
            terrainPos.y = this.maps.getHeightMap().getElevationAt(terrainPos);
            MetalSpot metalSpot = new MetalSpot((int)((double)n17 * d * (double)n11 / 255.0), terrainPos);
            arrayList.add(metalSpot);
            ++n;
            for (n13 = n14 - n7; n13 < n14 + n7; ++n13) {
                if (n13 < 0 || n13 >= n4) continue;
                for (n12 = n15 - n7; n12 < n15 + n7; ++n12) {
                    if (n12 < 0 || n12 >= n3 || (n14 - n13) * (n14 - n13) + (n15 - n12) * (n15 - n12) > n9) continue;
                    nArray[n13][n12] = 0;
                    nArray3[n13][n12] = 0;
                }
            }
            for (n13 = n15 - n8; n13 < n15 + n8; ++n13) {
                if (n13 < 0 || n13 >= n3) continue;
                for (n12 = n14 - n8; n12 < n14 + n8; ++n12) {
                    if ((n14 - n12) * (n14 - n12) + (n15 - n13) * (n15 - n13) > n10 || n12 < 0 || n12 >= n4 || nArray3[n12][n13] <= 0) continue;
                    n6 = 0;
                    for (int j = n12 - n7; j < n12 + n7; ++j) {
                        if (j < 0 || j >= n4) continue;
                        for (int k = n13 - n7; k < n13 + n7; ++k) {
                            if (k < 0 || k >= n3 || (n12 - j) * (n12 - j) + (n13 - k) * (n13 - k) > n9) continue;
                            n6 += nArray[j][k];
                        }
                    }
                    nArray3[n12][n13] = n6 * 255 / n11;
                }
            }
        }
        if (n > 500) {
            this.isMetalMap = true;
            arrayList.clear();
            this.logfile.WriteLine("Map is considered to be a metal map");
        } else {
            this.isMetalMap = false;
        }
        this.MetalSpots = arrayList.toArray(new MetalSpot[0]);
        this.SaveCache();
        this.logfile.WriteLine("SearchMetalSpots() <<<");
    }

    public static class AvailableMetalResult {
        public int[][] availableMetal;
        public int maxMetalAmount;

        public AvailableMetalResult(int[][] nArray, int n) {
            this.availableMetal = nArray;
            this.maxMetalAmount = n;
        }
    }

    public class MetalSpot {
        public int Amount;
        public TerrainPos Pos = new TerrainPos();
        public boolean IsOccupied = false;

        public MetalSpot() {
        }

        public MetalSpot(int n, TerrainPos terrainPos) {
            this.Amount = n;
            this.Pos = terrainPos;
        }

        public MetalSpot(int n, TerrainPos terrainPos, boolean bl) {
            this.Amount = n;
            this.IsOccupied = bl;
            this.Pos = terrainPos;
        }

        public String toString() {
            return "MetalSpot( Pos=" + this.Pos.toString() + ", Amount=" + this.Amount + ", IsOccupied=" + this.IsOccupied;
        }
    }

    public class DrawMetalSpotsHandler
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            Metal.this.DrawMetalSpots();
        }
    }

    class UnitListener
    extends UnitController.UnitAdapter {
        UnitListener() {
        }

        @Override
        public void UnitAdded(Unit unit) {
            if (!Metal.this.isMetalMap) {
                boolean bl = Metal.this.unitdefhelp.IsMex(unit.getDef());
                if (!Metal.this.Extractors.containsKey(unit) && bl) {
                    TerrainPos terrainPos = Metal.this.unitcontroller.getPos(unit);
                    Metal.this.logfile.WriteLine("Metal.UnitAdded new extractor finished, pos " + terrainPos.toString());
                    Metal.this.Extractors.put(unit, terrainPos);
                    double d = Metal.this.ExtractorRadius * Metal.this.ExtractorRadius;
                    for (MetalSpot metalSpot : Metal.this.MetalSpots) {
                        float f = metalSpot.Pos.GetSquaredDistance(terrainPos);
                        if (!((double)f <= d)) continue;
                        Metal.this.MetalSpotsUsed.add(metalSpot);
                        Metal.this.logfile.WriteLine("Marking metal spot used: " + metalSpot.Pos.toString());
                    }
                }
            }
        }

        @Override
        public void UnitRemoved(Unit unit) {
            if (!Metal.this.isMetalMap && Metal.this.Extractors.containsKey(unit)) {
                TerrainPos terrainPos = Metal.this.unitcontroller.getPos(unit);
                Metal.this.logfile.WriteLine("Metal.UnitRemoved, pos " + terrainPos.toString());
                double d = Metal.this.ExtractorRadius * Metal.this.ExtractorRadius;
                for (MetalSpot metalSpot : Metal.this.MetalSpots) {
                    if (!((double)metalSpot.Pos.GetSquaredDistance(terrainPos) < d) || !Metal.this.MetalSpotsUsed.contains(metalSpot)) continue;
                    Metal.this.logfile.WriteLine("Marking metal spot free: " + metalSpot.Pos.toString());
                    Metal.this.MetalSpotsUsed.remove(metalSpot);
                }
                Metal.this.Extractors.remove(unit);
            }
        }
    }

    class VoiceSearchMetal
    implements VoiceCommandHandler {
        VoiceSearchMetal() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            Metal.this.csai.sendTextMessage("searching metal spots...");
            Metal.this.SearchMetalSpots();
        }
    }

    class ShowMetalSpotsButton
    implements MainUI.ButtonHandler {
        ShowMetalSpotsButton() {
        }

        @Override
        public void go() {
            Metal.this.DrawMetalSpots();
        }
    }

    public static class MetalPos
    extends Int2 {
        public MetalPos() {
        }

        public MetalPos(Int2 int2) {
            this.x = int2.x;
            this.y = int2.y;
        }

        public MetalPos(int n, int n2) {
            super(n, n2);
        }

        public TerrainPos toTerrainPos() {
            return new TerrainPos(this.x * 8 * 2, 0.0f, this.y * 8 * 2);
        }

        public static MetalPos fromTerrainPos(TerrainPos terrainPos) {
            return new MetalPos((int)terrainPos.x / 8 / 2, (int)terrainPos.z / 8 / 2);
        }
    }
}

