/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.search;

import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXReader;
import com.dickimawbooks.texparserlib.search.SearchObject;
import java.io.File;

public class SearchResult {
    private Object source;
    private File file;
    private int lineNumber = -1;
    private SearchObject foundObject;
    private String foundObjectDescription;

    public SearchResult(TeXParser teXParser, SearchObject searchObject) {
        TeXReader teXReader = teXParser.getReader();
        if (teXReader != null) {
            this.source = teXReader.getSource();
            if (this.source instanceof File) {
                this.file = (File)this.source;
            }
            this.lineNumber = teXReader.getLineNumber() + 1;
        }
        this.foundObject = searchObject;
        this.foundObjectDescription = searchObject.getDescription(teXParser);
    }

    public File getFile() {
        return this.file;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public SearchObject getObject() {
        return this.foundObject;
    }

    public String getDescription() {
        return this.foundObjectDescription;
    }

    public String toString() {
        if (this.source != null) {
            if (this.lineNumber > 0) {
                return String.format("%s:%d: %s", this.source, this.lineNumber, this.getDescription());
            }
            return String.format("%s: %s", this.source, this.getDescription());
        }
        return this.getDescription();
    }
}

