/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.CompositeExpression;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.Lexer;
import com.github.zafarkhaja.semver.expr.UnexpectedTokenException;
import com.github.zafarkhaja.semver.util.Stream;
import com.github.zafarkhaja.semver.util.UnexpectedElementException;
import java.util.EnumSet;
import java.util.Iterator;

public class ExpressionParser
implements Parser<Expression> {
    private final Lexer lexer;
    private Stream<Lexer.Token> tokens;

    ExpressionParser(Lexer lexer) {
        this.lexer = lexer;
    }

    public static Parser<Expression> newInstance() {
        return new ExpressionParser(new Lexer());
    }

    @Override
    public Expression parse(String input) {
        this.tokens = this.lexer.tokenize(input);
        CompositeExpression expr = this.parseSemVerExpression();
        this.consumeNextToken(Lexer.Token.Type.EOI);
        return expr;
    }

    private CompositeExpression parseSemVerExpression() {
        CompositeExpression expr;
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.NOT})) {
            this.tokens.consume();
            this.consumeNextToken(Lexer.Token.Type.LEFT_PAREN);
            expr = CompositeExpression.Helper.not(this.parseSemVerExpression());
            this.consumeNextToken(Lexer.Token.Type.RIGHT_PAREN);
        } else if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.LEFT_PAREN})) {
            this.consumeNextToken(Lexer.Token.Type.LEFT_PAREN);
            expr = this.parseSemVerExpression();
            this.consumeNextToken(Lexer.Token.Type.RIGHT_PAREN);
        } else {
            expr = this.parseRange();
        }
        return this.parseMoreExpressions(expr);
    }

    private CompositeExpression parseMoreExpressions(CompositeExpression expr) {
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.AND})) {
            this.tokens.consume();
            expr = expr.and(this.parseSemVerExpression());
        } else if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.OR})) {
            this.tokens.consume();
            expr = expr.or(this.parseSemVerExpression());
        }
        return expr;
    }

    private CompositeExpression parseRange() {
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.TILDE})) {
            return this.parseTildeRange();
        }
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.CARET})) {
            return this.parseCaretRange();
        }
        if (this.isWildcardRange()) {
            return this.parseWildcardRange();
        }
        if (this.isHyphenRange()) {
            return this.parseHyphenRange();
        }
        if (this.isPartialVersionRange()) {
            return this.parsePartialVersionRange();
        }
        return this.parseComparisonRange();
    }

    private CompositeExpression parseComparisonRange() {
        CompositeExpression expr;
        Lexer.Token token = this.tokens.lookahead();
        switch (token.type) {
            case EQUAL: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.eq(this.parseVersion());
                break;
            }
            case NOT_EQUAL: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.neq(this.parseVersion());
                break;
            }
            case GREATER: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.gt(this.parseVersion());
                break;
            }
            case GREATER_EQUAL: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.gte(this.parseVersion());
                break;
            }
            case LESS: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.lt(this.parseVersion());
                break;
            }
            case LESS_EQUAL: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.lte(this.parseVersion());
                break;
            }
            default: {
                expr = CompositeExpression.Helper.eq(this.parseVersion());
            }
        }
        return expr;
    }

    private CompositeExpression parseTildeRange() {
        this.consumeNextToken(Lexer.Token.Type.TILDE);
        long major = this.consumeNextNumeric();
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            Version lo = Version.of(major);
            Version hi = lo.nextMajorVersion(new String[0]);
            return CompositeExpression.Helper.gte(lo).and(CompositeExpression.Helper.lt(hi));
        }
        this.consumeNextToken(Lexer.Token.Type.DOT);
        long minor = this.consumeNextNumeric();
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            Version lo = Version.of(major, minor);
            Version hi = lo.nextMinorVersion(new String[0]);
            return CompositeExpression.Helper.gte(lo).and(CompositeExpression.Helper.lt(hi));
        }
        this.consumeNextToken(Lexer.Token.Type.DOT);
        long patch = this.consumeNextNumeric();
        Version lo = Version.of(major, minor, patch);
        Version hi = lo.nextMinorVersion(new String[0]);
        return CompositeExpression.Helper.gte(lo).and(CompositeExpression.Helper.lt(hi));
    }

    private CompositeExpression parseCaretRange() {
        this.consumeNextToken(Lexer.Token.Type.CARET);
        long major = this.consumeNextNumeric();
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            Version lo = Version.of(major);
            Version hi = lo.nextMajorVersion(new String[0]);
            return CompositeExpression.Helper.gte(lo).and(CompositeExpression.Helper.lt(hi));
        }
        this.consumeNextToken(Lexer.Token.Type.DOT);
        long minor = this.consumeNextNumeric();
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            Version lo = Version.of(major, minor);
            Version hi = major > 0L ? lo.nextMajorVersion(new String[0]) : lo.nextMinorVersion(new String[0]);
            return CompositeExpression.Helper.gte(lo).and(CompositeExpression.Helper.lt(hi));
        }
        this.consumeNextToken(Lexer.Token.Type.DOT);
        long patch = this.consumeNextNumeric();
        Version lo = Version.of(major, minor, patch);
        CompositeExpression gte = CompositeExpression.Helper.gte(lo);
        if (major > 0L) {
            return gte.and(CompositeExpression.Helper.lt(lo.nextMajorVersion(new String[0])));
        }
        if (minor > 0L) {
            return gte.and(CompositeExpression.Helper.lt(lo.nextMinorVersion(new String[0])));
        }
        if (patch > 0L) {
            return gte.and(CompositeExpression.Helper.lt(lo.nextPatchVersion(new String[0])));
        }
        return CompositeExpression.Helper.eq(lo);
    }

    private boolean isWildcardRange() {
        return this.isVersionFollowedBy(Lexer.Token.Type.WILDCARD);
    }

    private CompositeExpression parseWildcardRange() {
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.WILDCARD})) {
            this.tokens.consume();
            return CompositeExpression.Helper.gte(Version.of(0L, 0L, 0L));
        }
        long major = this.consumeNextNumeric();
        this.consumeNextToken(Lexer.Token.Type.DOT);
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.WILDCARD})) {
            this.tokens.consume();
            Version lo = Version.of(major);
            Version hi = lo.nextMajorVersion(new String[0]);
            return CompositeExpression.Helper.gte(lo).and(CompositeExpression.Helper.lt(hi));
        }
        long minor = this.consumeNextNumeric();
        this.consumeNextToken(Lexer.Token.Type.DOT);
        this.consumeNextToken(Lexer.Token.Type.WILDCARD);
        Version lo = Version.of(major, minor);
        Version hi = lo.nextMinorVersion(new String[0]);
        return CompositeExpression.Helper.gte(lo).and(CompositeExpression.Helper.lt(hi));
    }

    private boolean isHyphenRange() {
        return this.isVersionFollowedBy(Lexer.Token.Type.HYPHEN);
    }

    private CompositeExpression parseHyphenRange() {
        CompositeExpression gte = CompositeExpression.Helper.gte(this.parseVersion());
        this.consumeNextToken(Lexer.Token.Type.HYPHEN);
        return gte.and(CompositeExpression.Helper.lte(this.parseVersion()));
    }

    private boolean isPartialVersionRange() {
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC})) {
            return false;
        }
        EnumSet<Lexer.Token.Type> expected = EnumSet.complementOf(EnumSet.of(Lexer.Token.Type.NUMERIC, Lexer.Token.Type.DOT));
        return this.tokens.positiveLookaheadUntil(5, expected.toArray(new Lexer.Token.Type[0]));
    }

    private CompositeExpression parsePartialVersionRange() {
        long major = this.consumeNextNumeric();
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            Version lo = Version.of(major);
            Version hi = lo.nextMajorVersion(new String[0]);
            return CompositeExpression.Helper.gte(lo).and(CompositeExpression.Helper.lt(hi));
        }
        this.consumeNextToken(Lexer.Token.Type.DOT);
        long minor = this.consumeNextNumeric();
        Version lo = Version.of(major, minor);
        Version hi = lo.nextMinorVersion(new String[0]);
        return CompositeExpression.Helper.gte(lo).and(CompositeExpression.Helper.lt(hi));
    }

    private Version parseVersion() {
        long major = this.consumeNextNumeric();
        long minor = 0L;
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            this.tokens.consume();
            minor = this.consumeNextNumeric();
        }
        long patch = 0L;
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            this.tokens.consume();
            patch = this.consumeNextNumeric();
        }
        return Version.of(major, minor, patch);
    }

    private boolean isVersionFollowedBy(Stream.ElementType<Lexer.Token> type) {
        EnumSet<Lexer.Token.Type> expected = EnumSet.of(Lexer.Token.Type.NUMERIC, Lexer.Token.Type.DOT);
        Iterator<Lexer.Token> it = this.tokens.iterator();
        Lexer.Token lookahead = null;
        while (it.hasNext()) {
            lookahead = it.next();
            if (expected.contains(lookahead.type)) continue;
            break;
        }
        return type.isMatchedBy(lookahead);
    }

    private Lexer.Token consumeNextToken(Lexer.Token.Type ... expected) {
        try {
            return (Lexer.Token)this.tokens.consume(expected);
        }
        catch (UnexpectedElementException e) {
            throw new UnexpectedTokenException(e);
        }
    }

    private long consumeNextNumeric() {
        return Long.parseLong(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
    }
}

