/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceBT;

import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import com.zeroc.Ice.SocketException;
import com.zeroc.IceBT.EndpointI;
import com.zeroc.IceBT.Instance;
import com.zeroc.IceBT.TransceiverI;
import com.zeroc.IceInternal.Acceptor;
import com.zeroc.IceInternal.ReadyCallback;
import com.zeroc.IceInternal.Transceiver;
import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import java.util.Stack;
import java.util.UUID;

final class AcceptorI
implements Acceptor {
    private EndpointI _endpoint;
    private Instance _instance;
    private String _adapterName;
    private String _name;
    private String _uuid;
    private ReadyCallback _readyCallback;
    private BluetoothServerSocket _socket;
    private Stack<BluetoothSocket> _pending;
    private Thread _thread;
    private Exception _exception;
    private boolean _closed;

    @Override
    public ServerSocketChannel fd() {
        return null;
    }

    @Override
    public synchronized void setReadyCallback(ReadyCallback callback) {
        this._readyCallback = callback;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AcceptorI acceptorI = this;
        synchronized (acceptorI) {
            this._closed = true;
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._thread != null) {
            try {
                this._thread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public com.zeroc.IceInternal.EndpointI listen() {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(this._uuid);
        }
        catch (IllegalArgumentException ex) {
            throw new SocketException(ex);
        }
        try {
            this._socket = this._instance.bluetoothAdapter().listenUsingRfcommWithServiceRecord(this._name, uuid);
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
        this._thread = new Thread(){

            @Override
            public void run() {
                AcceptorI.this.runAccept();
            }
        };
        this._thread.start();
        return this._endpoint;
    }

    @Override
    public synchronized Transceiver accept() {
        if (this._exception != null) {
            throw new SocketException(this._exception);
        }
        assert (!this._pending.isEmpty());
        BluetoothSocket socket = this._pending.pop();
        this._readyCallback.ready(1, !this._pending.isEmpty());
        return new TransceiverI(this._instance, socket, this._uuid, this._adapterName);
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer("local address = ");
        s.append(this._instance.bluetoothAdapter().getAddress());
        return s.toString();
    }

    @Override
    public String toDetailedString() {
        StringBuffer s = new StringBuffer(this.toString());
        if (!this._name.isEmpty()) {
            s.append("\nservice name = '");
            s.append(this._name);
            s.append("'");
        }
        if (!this._uuid.isEmpty()) {
            s.append("\nservice uuid = ");
            s.append(this._uuid);
        }
        return s.toString();
    }

    AcceptorI(EndpointI endpoint, Instance instance, String adapterName, String uuid, String name) {
        this._endpoint = endpoint;
        this._instance = instance;
        this._adapterName = adapterName;
        this._name = name;
        this._uuid = uuid;
        this._pending = new Stack();
        this._closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runAccept() {
        AcceptorI acceptorI = this;
        synchronized (acceptorI) {
            while (this._readyCallback == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        while (true) {
            AcceptorI acceptorI2;
            try {
                while (true) {
                    BluetoothSocket socket = this._socket.accept();
                    acceptorI2 = this;
                    synchronized (acceptorI2) {
                        this._pending.push(socket);
                        this._readyCallback.ready(1, true);
                    }
                }
            }
            catch (Exception ex) {
                acceptorI2 = this;
                synchronized (acceptorI2) {
                    if (this._closed) {
                    } else {
                        this._exception = ex;
                        this._readyCallback.ready(1, true);
                        // MONITOREXIT @DISABLED, blocks:[17, 7, 10, 13] lbl29 : MonitorExitStatement: MONITOREXIT : var2_5
                        continue;
                    }
                }
                Iterator iterator = this._pending.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this._pending.clear();
                        return;
                    }
                    BluetoothSocket s = (BluetoothSocket)iterator.next();
                    try {
                        s.close();
                    }
                    catch (Exception exception) {
                    }
                }
            }
            break;
        }
    }
}

