/* { dg-do compile { target { ! riscv_abi_e } } } */
/* { dg-require-effective-target rv64 } */
/* We aggressively skip as we really just need to test the basic synthesis
   which shouldn't vary based on the optimization level.  -O1 seems to work
   and eliminates the usual sources of extraneous dead code that would throw
   off the counts.  */
/* { dg-skip-if "" { *-*-* } { "-O0" "-Og" "-O2" "-O3" "-Os" "-Oz" "-flto" } } */
/* { dg-options "-march=rv64gcb" } */

/* Rather than test for a specific synthesis of all these constants or
   having thousands of tests each testing one variant, we just test the
   total number of instructions.

   This isn't expected to change much and any change is worthy of a look.  */
/* { dg-final { scan-assembler-times "\\t(add|addi|bseti|li|ret|sh1add|sh2add|sh3add|slli|bclri)" 7575 } } */

unsigned long foo_0xfffff7fe7ffff7ff(void) { return 0xfffff7fe7ffff7ffUL; }
unsigned long foo_0xffffeffe7ffff7ff(void) { return 0xffffeffe7ffff7ffUL; }
unsigned long foo_0xffffdffe7ffff7ff(void) { return 0xffffdffe7ffff7ffUL; }
unsigned long foo_0xffffbffe7ffff7ff(void) { return 0xffffbffe7ffff7ffUL; }
unsigned long foo_0xffff7ffe7ffff7ff(void) { return 0xffff7ffe7ffff7ffUL; }
unsigned long foo_0xfffefffe7ffff7ff(void) { return 0xfffefffe7ffff7ffUL; }
unsigned long foo_0xfffdfffe7ffff7ff(void) { return 0xfffdfffe7ffff7ffUL; }
unsigned long foo_0xffffeffd7ffff7ff(void) { return 0xffffeffd7ffff7ffUL; }
unsigned long foo_0xffffbffd7ffff7ff(void) { return 0xffffbffd7ffff7ffUL; }
unsigned long foo_0xfffefffd7ffff7ff(void) { return 0xfffefffd7ffff7ffUL; }
unsigned long foo_0x7ffffffd7ffff7ff(void) { return 0x7ffffffd7ffff7ffUL; }
unsigned long foo_0xfffff7fb7ffff7ff(void) { return 0xfffff7fb7ffff7ffUL; }
unsigned long foo_0xffffeffb7ffff7ff(void) { return 0xffffeffb7ffff7ffUL; }
unsigned long foo_0xffffdffb7ffff7ff(void) { return 0xffffdffb7ffff7ffUL; }
unsigned long foo_0xffffbffb7ffff7ff(void) { return 0xffffbffb7ffff7ffUL; }
unsigned long foo_0xffff7ffb7ffff7ff(void) { return 0xffff7ffb7ffff7ffUL; }
unsigned long foo_0xfffefffb7ffff7ff(void) { return 0xfffefffb7ffff7ffUL; }
unsigned long foo_0xfffdfffb7ffff7ff(void) { return 0xfffdfffb7ffff7ffUL; }
unsigned long foo_0x7ffffffb7ffff7ff(void) { return 0x7ffffffb7ffff7ffUL; }
unsigned long foo_0xffffeff77ffff7ff(void) { return 0xffffeff77ffff7ffUL; }
unsigned long foo_0xffffbff77ffff7ff(void) { return 0xffffbff77ffff7ffUL; }
unsigned long foo_0xfffefff77ffff7ff(void) { return 0xfffefff77ffff7ffUL; }
unsigned long foo_0x7ffffff77ffff7ff(void) { return 0x7ffffff77ffff7ffUL; }
unsigned long foo_0xfffff7ef7ffff7ff(void) { return 0xfffff7ef7ffff7ffUL; }
unsigned long foo_0xffffefef7ffff7ff(void) { return 0xffffefef7ffff7ffUL; }
unsigned long foo_0xffffdfef7ffff7ff(void) { return 0xffffdfef7ffff7ffUL; }
unsigned long foo_0xffffbfef7ffff7ff(void) { return 0xffffbfef7ffff7ffUL; }
unsigned long foo_0xffff7fef7ffff7ff(void) { return 0xffff7fef7ffff7ffUL; }
unsigned long foo_0xfffeffef7ffff7ff(void) { return 0xfffeffef7ffff7ffUL; }
unsigned long foo_0xfffdffef7ffff7ff(void) { return 0xfffdffef7ffff7ffUL; }
unsigned long foo_0x7fffffef7ffff7ff(void) { return 0x7fffffef7ffff7ffUL; }
unsigned long foo_0xffffefdf7ffff7ff(void) { return 0xffffefdf7ffff7ffUL; }
unsigned long foo_0xffffbfdf7ffff7ff(void) { return 0xffffbfdf7ffff7ffUL; }
unsigned long foo_0xfffeffdf7ffff7ff(void) { return 0xfffeffdf7ffff7ffUL; }
unsigned long foo_0x7fffffdf7ffff7ff(void) { return 0x7fffffdf7ffff7ffUL; }
unsigned long foo_0xfffff7bf7ffff7ff(void) { return 0xfffff7bf7ffff7ffUL; }
unsigned long foo_0xffffefbf7ffff7ff(void) { return 0xffffefbf7ffff7ffUL; }
unsigned long foo_0xffffdfbf7ffff7ff(void) { return 0xffffdfbf7ffff7ffUL; }
unsigned long foo_0xffffbfbf7ffff7ff(void) { return 0xffffbfbf7ffff7ffUL; }
unsigned long foo_0xffff7fbf7ffff7ff(void) { return 0xffff7fbf7ffff7ffUL; }
unsigned long foo_0xfffeffbf7ffff7ff(void) { return 0xfffeffbf7ffff7ffUL; }
unsigned long foo_0xfffdffbf7ffff7ff(void) { return 0xfffdffbf7ffff7ffUL; }
unsigned long foo_0x7fffffbf7ffff7ff(void) { return 0x7fffffbf7ffff7ffUL; }
unsigned long foo_0xffffef7f7ffff7ff(void) { return 0xffffef7f7ffff7ffUL; }
unsigned long foo_0xffffbf7f7ffff7ff(void) { return 0xffffbf7f7ffff7ffUL; }
unsigned long foo_0xfffeff7f7ffff7ff(void) { return 0xfffeff7f7ffff7ffUL; }
unsigned long foo_0x7fffff7f7ffff7ff(void) { return 0x7fffff7f7ffff7ffUL; }
unsigned long foo_0xfffff6ff7ffff7ff(void) { return 0xfffff6ff7ffff7ffUL; }
unsigned long foo_0xffffeeff7ffff7ff(void) { return 0xffffeeff7ffff7ffUL; }
unsigned long foo_0xffffdeff7ffff7ff(void) { return 0xffffdeff7ffff7ffUL; }
unsigned long foo_0xffffbeff7ffff7ff(void) { return 0xffffbeff7ffff7ffUL; }
unsigned long foo_0xffff7eff7ffff7ff(void) { return 0xffff7eff7ffff7ffUL; }
unsigned long foo_0xfffefeff7ffff7ff(void) { return 0xfffefeff7ffff7ffUL; }
unsigned long foo_0xfffdfeff7ffff7ff(void) { return 0xfffdfeff7ffff7ffUL; }
unsigned long foo_0x7ffffeff7ffff7ff(void) { return 0x7ffffeff7ffff7ffUL; }
unsigned long foo_0xffffedff7ffff7ff(void) { return 0xffffedff7ffff7ffUL; }
unsigned long foo_0xffffbdff7ffff7ff(void) { return 0xffffbdff7ffff7ffUL; }
unsigned long foo_0xfffefdff7ffff7ff(void) { return 0xfffefdff7ffff7ffUL; }
unsigned long foo_0x7ffffdff7ffff7ff(void) { return 0x7ffffdff7ffff7ffUL; }
unsigned long foo_0xffffebff7ffff7ff(void) { return 0xffffebff7ffff7ffUL; }
unsigned long foo_0xffffdbff7ffff7ff(void) { return 0xffffdbff7ffff7ffUL; }
unsigned long foo_0xffffbbff7ffff7ff(void) { return 0xffffbbff7ffff7ffUL; }
unsigned long foo_0xffff7bff7ffff7ff(void) { return 0xffff7bff7ffff7ffUL; }
unsigned long foo_0xfffefbff7ffff7ff(void) { return 0xfffefbff7ffff7ffUL; }
unsigned long foo_0xfffdfbff7ffff7ff(void) { return 0xfffdfbff7ffff7ffUL; }
unsigned long foo_0xffffb7ff7ffff7ff(void) { return 0xffffb7ff7ffff7ffUL; }
unsigned long foo_0xfffef7ff7ffff7ff(void) { return 0xfffef7ff7ffff7ffUL; }
unsigned long foo_0xffffafff7ffff7ff(void) { return 0xffffafff7ffff7ffUL; }
unsigned long foo_0xffff6fff7ffff7ff(void) { return 0xffff6fff7ffff7ffUL; }
unsigned long foo_0xfffeefff7ffff7ff(void) { return 0xfffeefff7ffff7ffUL; }
unsigned long foo_0xfffdefff7ffff7ff(void) { return 0xfffdefff7ffff7ffUL; }
unsigned long foo_0xfffedfff7ffff7ff(void) { return 0xfffedfff7ffff7ffUL; }
unsigned long foo_0xfffebfff7ffff7ff(void) { return 0xfffebfff7ffff7ffUL; }
unsigned long foo_0xfffdbfff7ffff7ff(void) { return 0xfffdbfff7ffff7ffUL; }
unsigned long foo_0xfffff7fcfffff7ff(void) { return 0xfffff7fcfffff7ffUL; }
unsigned long foo_0xffffeffcfffff7ff(void) { return 0xffffeffcfffff7ffUL; }
unsigned long foo_0xffffdffcfffff7ff(void) { return 0xffffdffcfffff7ffUL; }
unsigned long foo_0xffffbffcfffff7ff(void) { return 0xffffbffcfffff7ffUL; }
unsigned long foo_0xffff7ffcfffff7ff(void) { return 0xffff7ffcfffff7ffUL; }
unsigned long foo_0xfffefffcfffff7ff(void) { return 0xfffefffcfffff7ffUL; }
unsigned long foo_0xfffdfffcfffff7ff(void) { return 0xfffdfffcfffff7ffUL; }
unsigned long foo_0xfffbfffcfffff7ff(void) { return 0xfffbfffcfffff7ffUL; }
unsigned long foo_0xfffff7fafffff7ff(void) { return 0xfffff7fafffff7ffUL; }
unsigned long foo_0xffffdffafffff7ff(void) { return 0xffffdffafffff7ffUL; }
unsigned long foo_0xffff7ffafffff7ff(void) { return 0xffff7ffafffff7ffUL; }
unsigned long foo_0xfffdfffafffff7ff(void) { return 0xfffdfffafffff7ffUL; }
unsigned long foo_0xfffff7f6fffff7ff(void) { return 0xfffff7f6fffff7ffUL; }
unsigned long foo_0xffffeff6fffff7ff(void) { return 0xffffeff6fffff7ffUL; }
unsigned long foo_0xffffdff6fffff7ff(void) { return 0xffffdff6fffff7ffUL; }
unsigned long foo_0xffffbff6fffff7ff(void) { return 0xffffbff6fffff7ffUL; }
unsigned long foo_0xffff7ff6fffff7ff(void) { return 0xffff7ff6fffff7ffUL; }
unsigned long foo_0xfffefff6fffff7ff(void) { return 0xfffefff6fffff7ffUL; }
unsigned long foo_0xfffdfff6fffff7ff(void) { return 0xfffdfff6fffff7ffUL; }
unsigned long foo_0xfffbfff6fffff7ff(void) { return 0xfffbfff6fffff7ffUL; }
unsigned long foo_0xfffff7eefffff7ff(void) { return 0xfffff7eefffff7ffUL; }
unsigned long foo_0xffffdfeefffff7ff(void) { return 0xffffdfeefffff7ffUL; }
unsigned long foo_0xffff7feefffff7ff(void) { return 0xffff7feefffff7ffUL; }
unsigned long foo_0xfffdffeefffff7ff(void) { return 0xfffdffeefffff7ffUL; }
unsigned long foo_0xfffff7defffff7ff(void) { return 0xfffff7defffff7ffUL; }
unsigned long foo_0xffffefdefffff7ff(void) { return 0xffffefdefffff7ffUL; }
unsigned long foo_0xffffdfdefffff7ff(void) { return 0xffffdfdefffff7ffUL; }
unsigned long foo_0xffffbfdefffff7ff(void) { return 0xffffbfdefffff7ffUL; }
unsigned long foo_0xffff7fdefffff7ff(void) { return 0xffff7fdefffff7ffUL; }
unsigned long foo_0xfffeffdefffff7ff(void) { return 0xfffeffdefffff7ffUL; }
unsigned long foo_0xfffdffdefffff7ff(void) { return 0xfffdffdefffff7ffUL; }
unsigned long foo_0xfffbffdefffff7ff(void) { return 0xfffbffdefffff7ffUL; }
unsigned long foo_0xfffff7befffff7ff(void) { return 0xfffff7befffff7ffUL; }
unsigned long foo_0xffffdfbefffff7ff(void) { return 0xffffdfbefffff7ffUL; }
unsigned long foo_0xffff7fbefffff7ff(void) { return 0xffff7fbefffff7ffUL; }
unsigned long foo_0xfffdffbefffff7ff(void) { return 0xfffdffbefffff7ffUL; }
unsigned long foo_0xfffff77efffff7ff(void) { return 0xfffff77efffff7ffUL; }
unsigned long foo_0xffffef7efffff7ff(void) { return 0xffffef7efffff7ffUL; }
unsigned long foo_0xffffdf7efffff7ff(void) { return 0xffffdf7efffff7ffUL; }
unsigned long foo_0xffffbf7efffff7ff(void) { return 0xffffbf7efffff7ffUL; }
unsigned long foo_0xffff7f7efffff7ff(void) { return 0xffff7f7efffff7ffUL; }
unsigned long foo_0xfffeff7efffff7ff(void) { return 0xfffeff7efffff7ffUL; }
unsigned long foo_0xfffdff7efffff7ff(void) { return 0xfffdff7efffff7ffUL; }
unsigned long foo_0xfffbff7efffff7ff(void) { return 0xfffbff7efffff7ffUL; }
unsigned long foo_0xfffff6fefffff7ff(void) { return 0xfffff6fefffff7ffUL; }
unsigned long foo_0xffffdefefffff7ff(void) { return 0xffffdefefffff7ffUL; }
unsigned long foo_0xffff7efefffff7ff(void) { return 0xffff7efefffff7ffUL; }
unsigned long foo_0xfffdfefefffff7ff(void) { return 0xfffdfefefffff7ffUL; }
unsigned long foo_0xffffedfefffff7ff(void) { return 0xffffedfefffff7ffUL; }
unsigned long foo_0xffffddfefffff7ff(void) { return 0xffffddfefffff7ffUL; }
unsigned long foo_0xffffbdfefffff7ff(void) { return 0xffffbdfefffff7ffUL; }
unsigned long foo_0xffff7dfefffff7ff(void) { return 0xffff7dfefffff7ffUL; }
unsigned long foo_0xfffefdfefffff7ff(void) { return 0xfffefdfefffff7ffUL; }
unsigned long foo_0xfffdfdfefffff7ff(void) { return 0xfffdfdfefffff7ffUL; }
unsigned long foo_0xfffbfdfefffff7ff(void) { return 0xfffbfdfefffff7ffUL; }
unsigned long foo_0xfffff3fefffff7ff(void) { return 0xfffff3fefffff7ffUL; }
unsigned long foo_0xffffdbfefffff7ff(void) { return 0xffffdbfefffff7ffUL; }
unsigned long foo_0xffff7bfefffff7ff(void) { return 0xffff7bfefffff7ffUL; }
unsigned long foo_0xfffdfbfefffff7ff(void) { return 0xfffdfbfefffff7ffUL; }
unsigned long foo_0xffffe7fefffff7ff(void) { return 0xffffe7fefffff7ffUL; }
unsigned long foo_0xffffb7fefffff7ff(void) { return 0xffffb7fefffff7ffUL; }
unsigned long foo_0xffff77fefffff7ff(void) { return 0xffff77fefffff7ffUL; }
unsigned long foo_0xfffef7fefffff7ff(void) { return 0xfffef7fefffff7ffUL; }
unsigned long foo_0xfffdf7fefffff7ff(void) { return 0xfffdf7fefffff7ffUL; }
unsigned long foo_0xfffbf7fefffff7ff(void) { return 0xfffbf7fefffff7ffUL; }
unsigned long foo_0xffffcffefffff7ff(void) { return 0xffffcffefffff7ffUL; }
unsigned long foo_0xffff6ffefffff7ff(void) { return 0xffff6ffefffff7ffUL; }
unsigned long foo_0xfffdeffefffff7ff(void) { return 0xfffdeffefffff7ffUL; }
unsigned long foo_0xffff9ffefffff7ff(void) { return 0xffff9ffefffff7ffUL; }
unsigned long foo_0xfffedffefffff7ff(void) { return 0xfffedffefffff7ffUL; }
unsigned long foo_0xfffddffefffff7ff(void) { return 0xfffddffefffff7ffUL; }
unsigned long foo_0xfffbdffefffff7ff(void) { return 0xfffbdffefffff7ffUL; }
unsigned long foo_0xffff3ffefffff7ff(void) { return 0xffff3ffefffff7ffUL; }
unsigned long foo_0xfffdbffefffff7ff(void) { return 0xfffdbffefffff7ffUL; }
unsigned long foo_0xfffe7ffefffff7ff(void) { return 0xfffe7ffefffff7ffUL; }
unsigned long foo_0xfffb7ffefffff7ff(void) { return 0xfffb7ffefffff7ffUL; }
unsigned long foo_0xfffcfffefffff7ff(void) { return 0xfffcfffefffff7ffUL; }
unsigned long foo_0xfff9fffefffff7ff(void) { return 0xfff9fffefffff7ffUL; }
unsigned long foo_0xffffeff9fffff7ff(void) { return 0xffffeff9fffff7ffUL; }
unsigned long foo_0xffffdff9fffff7ff(void) { return 0xffffdff9fffff7ffUL; }
unsigned long foo_0xffffbff9fffff7ff(void) { return 0xffffbff9fffff7ffUL; }
unsigned long foo_0xffff7ff9fffff7ff(void) { return 0xffff7ff9fffff7ffUL; }
unsigned long foo_0xfffefff9fffff7ff(void) { return 0xfffefff9fffff7ffUL; }
unsigned long foo_0xfffdfff9fffff7ff(void) { return 0xfffdfff9fffff7ffUL; }
unsigned long foo_0xfffbfff9fffff7ff(void) { return 0xfffbfff9fffff7ffUL; }
unsigned long foo_0xfff7fff9fffff7ff(void) { return 0xfff7fff9fffff7ffUL; }
unsigned long foo_0xffffeff5fffff7ff(void) { return 0xffffeff5fffff7ffUL; }
unsigned long foo_0xffffbff5fffff7ff(void) { return 0xffffbff5fffff7ffUL; }
unsigned long foo_0xfffefff5fffff7ff(void) { return 0xfffefff5fffff7ffUL; }
unsigned long foo_0xfffbfff5fffff7ff(void) { return 0xfffbfff5fffff7ffUL; }
unsigned long foo_0xffffefedfffff7ff(void) { return 0xffffefedfffff7ffUL; }
unsigned long foo_0xffffdfedfffff7ff(void) { return 0xffffdfedfffff7ffUL; }
unsigned long foo_0xffffbfedfffff7ff(void) { return 0xffffbfedfffff7ffUL; }
unsigned long foo_0xffff7fedfffff7ff(void) { return 0xffff7fedfffff7ffUL; }
unsigned long foo_0xfffeffedfffff7ff(void) { return 0xfffeffedfffff7ffUL; }
unsigned long foo_0xfffdffedfffff7ff(void) { return 0xfffdffedfffff7ffUL; }
unsigned long foo_0xfffbffedfffff7ff(void) { return 0xfffbffedfffff7ffUL; }
unsigned long foo_0xfff7ffedfffff7ff(void) { return 0xfff7ffedfffff7ffUL; }
unsigned long foo_0xffffefddfffff7ff(void) { return 0xffffefddfffff7ffUL; }
unsigned long foo_0xffffbfddfffff7ff(void) { return 0xffffbfddfffff7ffUL; }
unsigned long foo_0xfffeffddfffff7ff(void) { return 0xfffeffddfffff7ffUL; }
unsigned long foo_0xfffbffddfffff7ff(void) { return 0xfffbffddfffff7ffUL; }
unsigned long foo_0xffffefbdfffff7ff(void) { return 0xffffefbdfffff7ffUL; }
unsigned long foo_0xffffdfbdfffff7ff(void) { return 0xffffdfbdfffff7ffUL; }
unsigned long foo_0xffffbfbdfffff7ff(void) { return 0xffffbfbdfffff7ffUL; }
unsigned long foo_0xffff7fbdfffff7ff(void) { return 0xffff7fbdfffff7ffUL; }
unsigned long foo_0xfffeffbdfffff7ff(void) { return 0xfffeffbdfffff7ffUL; }
unsigned long foo_0xfffdffbdfffff7ff(void) { return 0xfffdffbdfffff7ffUL; }
unsigned long foo_0xfffbffbdfffff7ff(void) { return 0xfffbffbdfffff7ffUL; }
unsigned long foo_0xfff7ffbdfffff7ff(void) { return 0xfff7ffbdfffff7ffUL; }
unsigned long foo_0xffffef7dfffff7ff(void) { return 0xffffef7dfffff7ffUL; }
unsigned long foo_0xffffbf7dfffff7ff(void) { return 0xffffbf7dfffff7ffUL; }
unsigned long foo_0xfffeff7dfffff7ff(void) { return 0xfffeff7dfffff7ffUL; }
unsigned long foo_0xfffbff7dfffff7ff(void) { return 0xfffbff7dfffff7ffUL; }
unsigned long foo_0xffffeefdfffff7ff(void) { return 0xffffeefdfffff7ffUL; }
unsigned long foo_0xffffdefdfffff7ff(void) { return 0xffffdefdfffff7ffUL; }
unsigned long foo_0xffffbefdfffff7ff(void) { return 0xffffbefdfffff7ffUL; }
unsigned long foo_0xffff7efdfffff7ff(void) { return 0xffff7efdfffff7ffUL; }
unsigned long foo_0xfffefefdfffff7ff(void) { return 0xfffefefdfffff7ffUL; }
unsigned long foo_0xfffdfefdfffff7ff(void) { return 0xfffdfefdfffff7ffUL; }
unsigned long foo_0xfffbfefdfffff7ff(void) { return 0xfffbfefdfffff7ffUL; }
unsigned long foo_0xfff7fefdfffff7ff(void) { return 0xfff7fefdfffff7ffUL; }
unsigned long foo_0xffffbdfdfffff7ff(void) { return 0xffffbdfdfffff7ffUL; }
unsigned long foo_0xfffefdfdfffff7ff(void) { return 0xfffefdfdfffff7ffUL; }
unsigned long foo_0xfffbfdfdfffff7ff(void) { return 0xfffbfdfdfffff7ffUL; }
unsigned long foo_0xffffebfdfffff7ff(void) { return 0xffffebfdfffff7ffUL; }
unsigned long foo_0xffffbbfdfffff7ff(void) { return 0xffffbbfdfffff7ffUL; }
unsigned long foo_0xffff7bfdfffff7ff(void) { return 0xffff7bfdfffff7ffUL; }
unsigned long foo_0xfffefbfdfffff7ff(void) { return 0xfffefbfdfffff7ffUL; }
unsigned long foo_0xfffdfbfdfffff7ff(void) { return 0xfffdfbfdfffff7ffUL; }
unsigned long foo_0xfffbfbfdfffff7ff(void) { return 0xfffbfbfdfffff7ffUL; }
unsigned long foo_0xfff7fbfdfffff7ff(void) { return 0xfff7fbfdfffff7ffUL; }
unsigned long foo_0xffffe7fdfffff7ff(void) { return 0xffffe7fdfffff7ffUL; }
unsigned long foo_0xfffef7fdfffff7ff(void) { return 0xfffef7fdfffff7ffUL; }
unsigned long foo_0xfffbf7fdfffff7ff(void) { return 0xfffbf7fdfffff7ffUL; }
unsigned long foo_0xffffcffdfffff7ff(void) { return 0xffffcffdfffff7ffUL; }
unsigned long foo_0xffffaffdfffff7ff(void) { return 0xffffaffdfffff7ffUL; }
unsigned long foo_0xfffeeffdfffff7ff(void) { return 0xfffeeffdfffff7ffUL; }
unsigned long foo_0xfffdeffdfffff7ff(void) { return 0xfffdeffdfffff7ffUL; }
unsigned long foo_0xfffbeffdfffff7ff(void) { return 0xfffbeffdfffff7ffUL; }
unsigned long foo_0xfff7effdfffff7ff(void) { return 0xfff7effdfffff7ffUL; }
unsigned long foo_0xffff9ffdfffff7ff(void) { return 0xffff9ffdfffff7ffUL; }
unsigned long foo_0xfffbdffdfffff7ff(void) { return 0xfffbdffdfffff7ffUL; }
unsigned long foo_0xffff3ffdfffff7ff(void) { return 0xffff3ffdfffff7ffUL; }
unsigned long foo_0xfffebffdfffff7ff(void) { return 0xfffebffdfffff7ffUL; }
unsigned long foo_0xfffbbffdfffff7ff(void) { return 0xfffbbffdfffff7ffUL; }
unsigned long foo_0xfff7bffdfffff7ff(void) { return 0xfff7bffdfffff7ffUL; }
unsigned long foo_0xfffe7ffdfffff7ff(void) { return 0xfffe7ffdfffff7ffUL; }
unsigned long foo_0xfffcfffdfffff7ff(void) { return 0xfffcfffdfffff7ffUL; }
unsigned long foo_0xfffafffdfffff7ff(void) { return 0xfffafffdfffff7ffUL; }
unsigned long foo_0xfff9fffdfffff7ff(void) { return 0xfff9fffdfffff7ffUL; }
unsigned long foo_0xfff3fffdfffff7ff(void) { return 0xfff3fffdfffff7ffUL; }
unsigned long foo_0xffffdff3fffff7ff(void) { return 0xffffdff3fffff7ffUL; }
unsigned long foo_0xffffbff3fffff7ff(void) { return 0xffffbff3fffff7ffUL; }
unsigned long foo_0xffff7ff3fffff7ff(void) { return 0xffff7ff3fffff7ffUL; }
unsigned long foo_0xfffefff3fffff7ff(void) { return 0xfffefff3fffff7ffUL; }
unsigned long foo_0xfffdfff3fffff7ff(void) { return 0xfffdfff3fffff7ffUL; }
unsigned long foo_0xfffbfff3fffff7ff(void) { return 0xfffbfff3fffff7ffUL; }
unsigned long foo_0xfff7fff3fffff7ff(void) { return 0xfff7fff3fffff7ffUL; }
unsigned long foo_0xffeffff3fffff7ff(void) { return 0xffeffff3fffff7ffUL; }
unsigned long foo_0xffffdfebfffff7ff(void) { return 0xffffdfebfffff7ffUL; }
unsigned long foo_0xffff7febfffff7ff(void) { return 0xffff7febfffff7ffUL; }
unsigned long foo_0xfffdffebfffff7ff(void) { return 0xfffdffebfffff7ffUL; }
unsigned long foo_0xfff7ffebfffff7ff(void) { return 0xfff7ffebfffff7ffUL; }
unsigned long foo_0xffffdfdbfffff7ff(void) { return 0xffffdfdbfffff7ffUL; }
unsigned long foo_0xffffbfdbfffff7ff(void) { return 0xffffbfdbfffff7ffUL; }
unsigned long foo_0xffff7fdbfffff7ff(void) { return 0xffff7fdbfffff7ffUL; }
unsigned long foo_0xfffeffdbfffff7ff(void) { return 0xfffeffdbfffff7ffUL; }
unsigned long foo_0xfffdffdbfffff7ff(void) { return 0xfffdffdbfffff7ffUL; }
unsigned long foo_0xfffbffdbfffff7ff(void) { return 0xfffbffdbfffff7ffUL; }
unsigned long foo_0xfff7ffdbfffff7ff(void) { return 0xfff7ffdbfffff7ffUL; }
unsigned long foo_0xffefffdbfffff7ff(void) { return 0xffefffdbfffff7ffUL; }
unsigned long foo_0xffffdfbbfffff7ff(void) { return 0xffffdfbbfffff7ffUL; }
unsigned long foo_0xffff7fbbfffff7ff(void) { return 0xffff7fbbfffff7ffUL; }
unsigned long foo_0xfffdffbbfffff7ff(void) { return 0xfffdffbbfffff7ffUL; }
unsigned long foo_0xfff7ffbbfffff7ff(void) { return 0xfff7ffbbfffff7ffUL; }
unsigned long foo_0xffffdf7bfffff7ff(void) { return 0xffffdf7bfffff7ffUL; }
unsigned long foo_0xffffbf7bfffff7ff(void) { return 0xffffbf7bfffff7ffUL; }
unsigned long foo_0xffff7f7bfffff7ff(void) { return 0xffff7f7bfffff7ffUL; }
unsigned long foo_0xfffeff7bfffff7ff(void) { return 0xfffeff7bfffff7ffUL; }
unsigned long foo_0xfffdff7bfffff7ff(void) { return 0xfffdff7bfffff7ffUL; }
unsigned long foo_0xfffbff7bfffff7ff(void) { return 0xfffbff7bfffff7ffUL; }
unsigned long foo_0xfff7ff7bfffff7ff(void) { return 0xfff7ff7bfffff7ffUL; }
unsigned long foo_0xffefff7bfffff7ff(void) { return 0xffefff7bfffff7ffUL; }
unsigned long foo_0xffffdefbfffff7ff(void) { return 0xffffdefbfffff7ffUL; }
unsigned long foo_0xffff7efbfffff7ff(void) { return 0xffff7efbfffff7ffUL; }
unsigned long foo_0xfffdfefbfffff7ff(void) { return 0xfffdfefbfffff7ffUL; }
unsigned long foo_0xfff7fefbfffff7ff(void) { return 0xfff7fefbfffff7ffUL; }
unsigned long foo_0xffffddfbfffff7ff(void) { return 0xffffddfbfffff7ffUL; }
unsigned long foo_0xffffbdfbfffff7ff(void) { return 0xffffbdfbfffff7ffUL; }
unsigned long foo_0xffff7dfbfffff7ff(void) { return 0xffff7dfbfffff7ffUL; }
unsigned long foo_0xfffefdfbfffff7ff(void) { return 0xfffefdfbfffff7ffUL; }
unsigned long foo_0xfffdfdfbfffff7ff(void) { return 0xfffdfdfbfffff7ffUL; }
unsigned long foo_0xfffbfdfbfffff7ff(void) { return 0xfffbfdfbfffff7ffUL; }
unsigned long foo_0xfff7fdfbfffff7ff(void) { return 0xfff7fdfbfffff7ffUL; }
unsigned long foo_0xffeffdfbfffff7ff(void) { return 0xffeffdfbfffff7ffUL; }
unsigned long foo_0xffffdbfbfffff7ff(void) { return 0xffffdbfbfffff7ffUL; }
unsigned long foo_0xffff7bfbfffff7ff(void) { return 0xffff7bfbfffff7ffUL; }
unsigned long foo_0xfffdfbfbfffff7ff(void) { return 0xfffdfbfbfffff7ffUL; }
unsigned long foo_0xfff7fbfbfffff7ff(void) { return 0xfff7fbfbfffff7ffUL; }
unsigned long foo_0xffffd7fbfffff7ff(void) { return 0xffffd7fbfffff7ffUL; }
unsigned long foo_0xffffb7fbfffff7ff(void) { return 0xffffb7fbfffff7ffUL; }
unsigned long foo_0xffff77fbfffff7ff(void) { return 0xffff77fbfffff7ffUL; }
unsigned long foo_0xfffef7fbfffff7ff(void) { return 0xfffef7fbfffff7ffUL; }
unsigned long foo_0xfffdf7fbfffff7ff(void) { return 0xfffdf7fbfffff7ffUL; }
unsigned long foo_0xfffbf7fbfffff7ff(void) { return 0xfffbf7fbfffff7ffUL; }
unsigned long foo_0xfff7f7fbfffff7ff(void) { return 0xfff7f7fbfffff7ffUL; }
unsigned long foo_0xffeff7fbfffff7ff(void) { return 0xffeff7fbfffff7ffUL; }
unsigned long foo_0xffffcffbfffff7ff(void) { return 0xffffcffbfffff7ffUL; }
unsigned long foo_0xffff6ffbfffff7ff(void) { return 0xffff6ffbfffff7ffUL; }
unsigned long foo_0xfffdeffbfffff7ff(void) { return 0xfffdeffbfffff7ffUL; }
unsigned long foo_0xfff7effbfffff7ff(void) { return 0xfff7effbfffff7ffUL; }
unsigned long foo_0xffff9ffbfffff7ff(void) { return 0xffff9ffbfffff7ffUL; }
unsigned long foo_0xffff5ffbfffff7ff(void) { return 0xffff5ffbfffff7ffUL; }
unsigned long foo_0xfffedffbfffff7ff(void) { return 0xfffedffbfffff7ffUL; }
unsigned long foo_0xfffddffbfffff7ff(void) { return 0xfffddffbfffff7ffUL; }
unsigned long foo_0xfffbdffbfffff7ff(void) { return 0xfffbdffbfffff7ffUL; }
unsigned long foo_0xfff7dffbfffff7ff(void) { return 0xfff7dffbfffff7ffUL; }
unsigned long foo_0xffefdffbfffff7ff(void) { return 0xffefdffbfffff7ffUL; }
unsigned long foo_0xffff3ffbfffff7ff(void) { return 0xffff3ffbfffff7ffUL; }
unsigned long foo_0xfffdbffbfffff7ff(void) { return 0xfffdbffbfffff7ffUL; }
unsigned long foo_0xfff7bffbfffff7ff(void) { return 0xfff7bffbfffff7ffUL; }
unsigned long foo_0xfffe7ffbfffff7ff(void) { return 0xfffe7ffbfffff7ffUL; }
unsigned long foo_0xfffd7ffbfffff7ff(void) { return 0xfffd7ffbfffff7ffUL; }
unsigned long foo_0xfffb7ffbfffff7ff(void) { return 0xfffb7ffbfffff7ffUL; }
unsigned long foo_0xfff77ffbfffff7ff(void) { return 0xfff77ffbfffff7ffUL; }
unsigned long foo_0xffef7ffbfffff7ff(void) { return 0xffef7ffbfffff7ffUL; }
unsigned long foo_0xfffcfffbfffff7ff(void) { return 0xfffcfffbfffff7ffUL; }
unsigned long foo_0xfff6fffbfffff7ff(void) { return 0xfff6fffbfffff7ffUL; }
unsigned long foo_0xfff9fffbfffff7ff(void) { return 0xfff9fffbfffff7ffUL; }
unsigned long foo_0xfff5fffbfffff7ff(void) { return 0xfff5fffbfffff7ffUL; }
unsigned long foo_0xffedfffbfffff7ff(void) { return 0xffedfffbfffff7ffUL; }
unsigned long foo_0xfff3fffbfffff7ff(void) { return 0xfff3fffbfffff7ffUL; }
unsigned long foo_0xffe7fffbfffff7ff(void) { return 0xffe7fffbfffff7ffUL; }
unsigned long foo_0xffffbfe7fffff7ff(void) { return 0xffffbfe7fffff7ffUL; }
unsigned long foo_0xffff7fe7fffff7ff(void) { return 0xffff7fe7fffff7ffUL; }
unsigned long foo_0xfffeffe7fffff7ff(void) { return 0xfffeffe7fffff7ffUL; }
unsigned long foo_0xfffdffe7fffff7ff(void) { return 0xfffdffe7fffff7ffUL; }
unsigned long foo_0xfffbffe7fffff7ff(void) { return 0xfffbffe7fffff7ffUL; }
unsigned long foo_0xfff7ffe7fffff7ff(void) { return 0xfff7ffe7fffff7ffUL; }
unsigned long foo_0xffefffe7fffff7ff(void) { return 0xffefffe7fffff7ffUL; }
unsigned long foo_0xffdfffe7fffff7ff(void) { return 0xffdfffe7fffff7ffUL; }
unsigned long foo_0xffffbfd7fffff7ff(void) { return 0xffffbfd7fffff7ffUL; }
unsigned long foo_0xfffeffd7fffff7ff(void) { return 0xfffeffd7fffff7ffUL; }
unsigned long foo_0xfffbffd7fffff7ff(void) { return 0xfffbffd7fffff7ffUL; }
unsigned long foo_0xffefffd7fffff7ff(void) { return 0xffefffd7fffff7ffUL; }
unsigned long foo_0xffffbfb7fffff7ff(void) { return 0xffffbfb7fffff7ffUL; }
unsigned long foo_0xffff7fb7fffff7ff(void) { return 0xffff7fb7fffff7ffUL; }
unsigned long foo_0xfffeffb7fffff7ff(void) { return 0xfffeffb7fffff7ffUL; }
unsigned long foo_0xfffdffb7fffff7ff(void) { return 0xfffdffb7fffff7ffUL; }
unsigned long foo_0xfffbffb7fffff7ff(void) { return 0xfffbffb7fffff7ffUL; }
unsigned long foo_0xfff7ffb7fffff7ff(void) { return 0xfff7ffb7fffff7ffUL; }
unsigned long foo_0xffefffb7fffff7ff(void) { return 0xffefffb7fffff7ffUL; }
unsigned long foo_0xffdfffb7fffff7ff(void) { return 0xffdfffb7fffff7ffUL; }
unsigned long foo_0xffffbf77fffff7ff(void) { return 0xffffbf77fffff7ffUL; }
unsigned long foo_0xfffeff77fffff7ff(void) { return 0xfffeff77fffff7ffUL; }
unsigned long foo_0xfffbff77fffff7ff(void) { return 0xfffbff77fffff7ffUL; }
unsigned long foo_0xffefff77fffff7ff(void) { return 0xffefff77fffff7ffUL; }
unsigned long foo_0xffffbef7fffff7ff(void) { return 0xffffbef7fffff7ffUL; }
unsigned long foo_0xffff7ef7fffff7ff(void) { return 0xffff7ef7fffff7ffUL; }
unsigned long foo_0xfffefef7fffff7ff(void) { return 0xfffefef7fffff7ffUL; }
unsigned long foo_0xfffdfef7fffff7ff(void) { return 0xfffdfef7fffff7ffUL; }
unsigned long foo_0xfffbfef7fffff7ff(void) { return 0xfffbfef7fffff7ffUL; }
unsigned long foo_0xfff7fef7fffff7ff(void) { return 0xfff7fef7fffff7ffUL; }
unsigned long foo_0xffeffef7fffff7ff(void) { return 0xffeffef7fffff7ffUL; }
unsigned long foo_0xffdffef7fffff7ff(void) { return 0xffdffef7fffff7ffUL; }
unsigned long foo_0xffffbdf7fffff7ff(void) { return 0xffffbdf7fffff7ffUL; }
unsigned long foo_0xfffefdf7fffff7ff(void) { return 0xfffefdf7fffff7ffUL; }
unsigned long foo_0xfffbfdf7fffff7ff(void) { return 0xfffbfdf7fffff7ffUL; }
unsigned long foo_0xffeffdf7fffff7ff(void) { return 0xffeffdf7fffff7ffUL; }
unsigned long foo_0xffffbbf7fffff7ff(void) { return 0xffffbbf7fffff7ffUL; }
unsigned long foo_0xffff7bf7fffff7ff(void) { return 0xffff7bf7fffff7ffUL; }
unsigned long foo_0xfffefbf7fffff7ff(void) { return 0xfffefbf7fffff7ffUL; }
unsigned long foo_0xfffdfbf7fffff7ff(void) { return 0xfffdfbf7fffff7ffUL; }
unsigned long foo_0xfffbfbf7fffff7ff(void) { return 0xfffbfbf7fffff7ffUL; }
unsigned long foo_0xfff7fbf7fffff7ff(void) { return 0xfff7fbf7fffff7ffUL; }
unsigned long foo_0xffeffbf7fffff7ff(void) { return 0xffeffbf7fffff7ffUL; }
unsigned long foo_0xffdffbf7fffff7ff(void) { return 0xffdffbf7fffff7ffUL; }
unsigned long foo_0xffffb7f7fffff7ff(void) { return 0xffffb7f7fffff7ffUL; }
unsigned long foo_0xfffef7f7fffff7ff(void) { return 0xfffef7f7fffff7ffUL; }
unsigned long foo_0xfffbf7f7fffff7ff(void) { return 0xfffbf7f7fffff7ffUL; }
unsigned long foo_0xffeff7f7fffff7ff(void) { return 0xffeff7f7fffff7ffUL; }
unsigned long foo_0xffffaff7fffff7ff(void) { return 0xffffaff7fffff7ffUL; }
unsigned long foo_0xffff6ff7fffff7ff(void) { return 0xffff6ff7fffff7ffUL; }
unsigned long foo_0xfffeeff7fffff7ff(void) { return 0xfffeeff7fffff7ffUL; }
unsigned long foo_0xfffdeff7fffff7ff(void) { return 0xfffdeff7fffff7ffUL; }
unsigned long foo_0xfffbeff7fffff7ff(void) { return 0xfffbeff7fffff7ffUL; }
unsigned long foo_0xfff7eff7fffff7ff(void) { return 0xfff7eff7fffff7ffUL; }
unsigned long foo_0xffefeff7fffff7ff(void) { return 0xffefeff7fffff7ffUL; }
unsigned long foo_0xffdfeff7fffff7ff(void) { return 0xffdfeff7fffff7ffUL; }
unsigned long foo_0xffff9ff7fffff7ff(void) { return 0xffff9ff7fffff7ffUL; }
unsigned long foo_0xfffedff7fffff7ff(void) { return 0xfffedff7fffff7ffUL; }
unsigned long foo_0xfffbdff7fffff7ff(void) { return 0xfffbdff7fffff7ffUL; }
unsigned long foo_0xffefdff7fffff7ff(void) { return 0xffefdff7fffff7ffUL; }
unsigned long foo_0xffff3ff7fffff7ff(void) { return 0xffff3ff7fffff7ffUL; }
unsigned long foo_0xfffebff7fffff7ff(void) { return 0xfffebff7fffff7ffUL; }
unsigned long foo_0xfffdbff7fffff7ff(void) { return 0xfffdbff7fffff7ffUL; }
unsigned long foo_0xfffbbff7fffff7ff(void) { return 0xfffbbff7fffff7ffUL; }
unsigned long foo_0xfff7bff7fffff7ff(void) { return 0xfff7bff7fffff7ffUL; }
unsigned long foo_0xffefbff7fffff7ff(void) { return 0xffefbff7fffff7ffUL; }
unsigned long foo_0xffdfbff7fffff7ff(void) { return 0xffdfbff7fffff7ffUL; }
unsigned long foo_0xfffe7ff7fffff7ff(void) { return 0xfffe7ff7fffff7ffUL; }
unsigned long foo_0xfffb7ff7fffff7ff(void) { return 0xfffb7ff7fffff7ffUL; }
unsigned long foo_0xffef7ff7fffff7ff(void) { return 0xffef7ff7fffff7ffUL; }
unsigned long foo_0xfffcfff7fffff7ff(void) { return 0xfffcfff7fffff7ffUL; }
unsigned long foo_0xfffafff7fffff7ff(void) { return 0xfffafff7fffff7ffUL; }
unsigned long foo_0xfff6fff7fffff7ff(void) { return 0xfff6fff7fffff7ffUL; }
unsigned long foo_0xffeefff7fffff7ff(void) { return 0xffeefff7fffff7ffUL; }
unsigned long foo_0xffdefff7fffff7ff(void) { return 0xffdefff7fffff7ffUL; }
unsigned long foo_0xfff9fff7fffff7ff(void) { return 0xfff9fff7fffff7ffUL; }
unsigned long foo_0xffedfff7fffff7ff(void) { return 0xffedfff7fffff7ffUL; }
unsigned long foo_0xfff3fff7fffff7ff(void) { return 0xfff3fff7fffff7ffUL; }
unsigned long foo_0xffebfff7fffff7ff(void) { return 0xffebfff7fffff7ffUL; }
unsigned long foo_0xffdbfff7fffff7ff(void) { return 0xffdbfff7fffff7ffUL; }
unsigned long foo_0xffe7fff7fffff7ff(void) { return 0xffe7fff7fffff7ffUL; }
unsigned long foo_0xffcffff7fffff7ff(void) { return 0xffcffff7fffff7ffUL; }
unsigned long foo_0xffff7fcffffff7ff(void) { return 0xffff7fcffffff7ffUL; }
unsigned long foo_0xfffeffcffffff7ff(void) { return 0xfffeffcffffff7ffUL; }
unsigned long foo_0xfffdffcffffff7ff(void) { return 0xfffdffcffffff7ffUL; }
unsigned long foo_0xfffbffcffffff7ff(void) { return 0xfffbffcffffff7ffUL; }
unsigned long foo_0xfff7ffcffffff7ff(void) { return 0xfff7ffcffffff7ffUL; }
unsigned long foo_0xffefffcffffff7ff(void) { return 0xffefffcffffff7ffUL; }
unsigned long foo_0xffdfffcffffff7ff(void) { return 0xffdfffcffffff7ffUL; }
unsigned long foo_0xffbfffcffffff7ff(void) { return 0xffbfffcffffff7ffUL; }
unsigned long foo_0xffff7faffffff7ff(void) { return 0xffff7faffffff7ffUL; }
unsigned long foo_0xfffdffaffffff7ff(void) { return 0xfffdffaffffff7ffUL; }
unsigned long foo_0xfff7ffaffffff7ff(void) { return 0xfff7ffaffffff7ffUL; }
unsigned long foo_0xffdfffaffffff7ff(void) { return 0xffdfffaffffff7ffUL; }
unsigned long foo_0xffff7f6ffffff7ff(void) { return 0xffff7f6ffffff7ffUL; }
unsigned long foo_0xfffeff6ffffff7ff(void) { return 0xfffeff6ffffff7ffUL; }
unsigned long foo_0xfffdff6ffffff7ff(void) { return 0xfffdff6ffffff7ffUL; }
unsigned long foo_0xfffbff6ffffff7ff(void) { return 0xfffbff6ffffff7ffUL; }
unsigned long foo_0xfff7ff6ffffff7ff(void) { return 0xfff7ff6ffffff7ffUL; }
unsigned long foo_0xffefff6ffffff7ff(void) { return 0xffefff6ffffff7ffUL; }
unsigned long foo_0xffdfff6ffffff7ff(void) { return 0xffdfff6ffffff7ffUL; }
unsigned long foo_0xffbfff6ffffff7ff(void) { return 0xffbfff6ffffff7ffUL; }
unsigned long foo_0xffff7eeffffff7ff(void) { return 0xffff7eeffffff7ffUL; }
unsigned long foo_0xfffdfeeffffff7ff(void) { return 0xfffdfeeffffff7ffUL; }
unsigned long foo_0xfff7feeffffff7ff(void) { return 0xfff7feeffffff7ffUL; }
unsigned long foo_0xffdffeeffffff7ff(void) { return 0xffdffeeffffff7ffUL; }
unsigned long foo_0xffff7deffffff7ff(void) { return 0xffff7deffffff7ffUL; }
unsigned long foo_0xfffefdeffffff7ff(void) { return 0xfffefdeffffff7ffUL; }
unsigned long foo_0xfffdfdeffffff7ff(void) { return 0xfffdfdeffffff7ffUL; }
unsigned long foo_0xfffbfdeffffff7ff(void) { return 0xfffbfdeffffff7ffUL; }
unsigned long foo_0xfff7fdeffffff7ff(void) { return 0xfff7fdeffffff7ffUL; }
unsigned long foo_0xffeffdeffffff7ff(void) { return 0xffeffdeffffff7ffUL; }
unsigned long foo_0xffdffdeffffff7ff(void) { return 0xffdffdeffffff7ffUL; }
unsigned long foo_0xffbffdeffffff7ff(void) { return 0xffbffdeffffff7ffUL; }
unsigned long foo_0xffff7beffffff7ff(void) { return 0xffff7beffffff7ffUL; }
unsigned long foo_0xfffdfbeffffff7ff(void) { return 0xfffdfbeffffff7ffUL; }
unsigned long foo_0xfff7fbeffffff7ff(void) { return 0xfff7fbeffffff7ffUL; }
unsigned long foo_0xffdffbeffffff7ff(void) { return 0xffdffbeffffff7ffUL; }
unsigned long foo_0xffff77effffff7ff(void) { return 0xffff77effffff7ffUL; }
unsigned long foo_0xfffef7effffff7ff(void) { return 0xfffef7effffff7ffUL; }
unsigned long foo_0xfffdf7effffff7ff(void) { return 0xfffdf7effffff7ffUL; }
unsigned long foo_0xfffbf7effffff7ff(void) { return 0xfffbf7effffff7ffUL; }
unsigned long foo_0xfff7f7effffff7ff(void) { return 0xfff7f7effffff7ffUL; }
unsigned long foo_0xffeff7effffff7ff(void) { return 0xffeff7effffff7ffUL; }
unsigned long foo_0xffdff7effffff7ff(void) { return 0xffdff7effffff7ffUL; }
unsigned long foo_0xffbff7effffff7ff(void) { return 0xffbff7effffff7ffUL; }
unsigned long foo_0xffff6feffffff7ff(void) { return 0xffff6feffffff7ffUL; }
unsigned long foo_0xfffdefeffffff7ff(void) { return 0xfffdefeffffff7ffUL; }
unsigned long foo_0xfff7efeffffff7ff(void) { return 0xfff7efeffffff7ffUL; }
unsigned long foo_0xffdfefeffffff7ff(void) { return 0xffdfefeffffff7ffUL; }
unsigned long foo_0xffff5feffffff7ff(void) { return 0xffff5feffffff7ffUL; }
unsigned long foo_0xfffedfeffffff7ff(void) { return 0xfffedfeffffff7ffUL; }
unsigned long foo_0xfffddfeffffff7ff(void) { return 0xfffddfeffffff7ffUL; }
unsigned long foo_0xfffbdfeffffff7ff(void) { return 0xfffbdfeffffff7ffUL; }
unsigned long foo_0xfff7dfeffffff7ff(void) { return 0xfff7dfeffffff7ffUL; }
unsigned long foo_0xffefdfeffffff7ff(void) { return 0xffefdfeffffff7ffUL; }
unsigned long foo_0xffdfdfeffffff7ff(void) { return 0xffdfdfeffffff7ffUL; }
unsigned long foo_0xffbfdfeffffff7ff(void) { return 0xffbfdfeffffff7ffUL; }
unsigned long foo_0xffff3feffffff7ff(void) { return 0xffff3feffffff7ffUL; }
unsigned long foo_0xfffdbfeffffff7ff(void) { return 0xfffdbfeffffff7ffUL; }
unsigned long foo_0xfff7bfeffffff7ff(void) { return 0xfff7bfeffffff7ffUL; }
unsigned long foo_0xffdfbfeffffff7ff(void) { return 0xffdfbfeffffff7ffUL; }
unsigned long foo_0xfffe7feffffff7ff(void) { return 0xfffe7feffffff7ffUL; }
unsigned long foo_0xfffd7feffffff7ff(void) { return 0xfffd7feffffff7ffUL; }
unsigned long foo_0xfffb7feffffff7ff(void) { return 0xfffb7feffffff7ffUL; }
unsigned long foo_0xfff77feffffff7ff(void) { return 0xfff77feffffff7ffUL; }
unsigned long foo_0xffef7feffffff7ff(void) { return 0xffef7feffffff7ffUL; }
unsigned long foo_0xffdf7feffffff7ff(void) { return 0xffdf7feffffff7ffUL; }
unsigned long foo_0xffbf7feffffff7ff(void) { return 0xffbf7feffffff7ffUL; }
unsigned long foo_0xfffcffeffffff7ff(void) { return 0xfffcffeffffff7ffUL; }
unsigned long foo_0xfff6ffeffffff7ff(void) { return 0xfff6ffeffffff7ffUL; }
unsigned long foo_0xffdeffeffffff7ff(void) { return 0xffdeffeffffff7ffUL; }
unsigned long foo_0xfff9ffeffffff7ff(void) { return 0xfff9ffeffffff7ffUL; }
unsigned long foo_0xfff5ffeffffff7ff(void) { return 0xfff5ffeffffff7ffUL; }
unsigned long foo_0xffedffeffffff7ff(void) { return 0xffedffeffffff7ffUL; }
unsigned long foo_0xffddffeffffff7ff(void) { return 0xffddffeffffff7ffUL; }
unsigned long foo_0xffbdffeffffff7ff(void) { return 0xffbdffeffffff7ffUL; }
unsigned long foo_0xfff3ffeffffff7ff(void) { return 0xfff3ffeffffff7ffUL; }
unsigned long foo_0xffdbffeffffff7ff(void) { return 0xffdbffeffffff7ffUL; }
unsigned long foo_0xffe7ffeffffff7ff(void) { return 0xffe7ffeffffff7ffUL; }
unsigned long foo_0xffd7ffeffffff7ff(void) { return 0xffd7ffeffffff7ffUL; }
unsigned long foo_0xffb7ffeffffff7ff(void) { return 0xffb7ffeffffff7ffUL; }
unsigned long foo_0xffcfffeffffff7ff(void) { return 0xffcfffeffffff7ffUL; }
unsigned long foo_0xff9fffeffffff7ff(void) { return 0xff9fffeffffff7ffUL; }
unsigned long foo_0xfffeff9ffffff7ff(void) { return 0xfffeff9ffffff7ffUL; }
unsigned long foo_0xfffdff9ffffff7ff(void) { return 0xfffdff9ffffff7ffUL; }
unsigned long foo_0xfffbff9ffffff7ff(void) { return 0xfffbff9ffffff7ffUL; }
unsigned long foo_0xfff7ff9ffffff7ff(void) { return 0xfff7ff9ffffff7ffUL; }
unsigned long foo_0xffefff9ffffff7ff(void) { return 0xffefff9ffffff7ffUL; }
unsigned long foo_0xffdfff9ffffff7ff(void) { return 0xffdfff9ffffff7ffUL; }
unsigned long foo_0xffbfff9ffffff7ff(void) { return 0xffbfff9ffffff7ffUL; }
unsigned long foo_0xff7fff9ffffff7ff(void) { return 0xff7fff9ffffff7ffUL; }
unsigned long foo_0xfffeff5ffffff7ff(void) { return 0xfffeff5ffffff7ffUL; }
unsigned long foo_0xfffbff5ffffff7ff(void) { return 0xfffbff5ffffff7ffUL; }
unsigned long foo_0xffefff5ffffff7ff(void) { return 0xffefff5ffffff7ffUL; }
unsigned long foo_0xffbfff5ffffff7ff(void) { return 0xffbfff5ffffff7ffUL; }
unsigned long foo_0xfffefedffffff7ff(void) { return 0xfffefedffffff7ffUL; }
unsigned long foo_0xfffdfedffffff7ff(void) { return 0xfffdfedffffff7ffUL; }
unsigned long foo_0xfffbfedffffff7ff(void) { return 0xfffbfedffffff7ffUL; }
unsigned long foo_0xfff7fedffffff7ff(void) { return 0xfff7fedffffff7ffUL; }
unsigned long foo_0xffeffedffffff7ff(void) { return 0xffeffedffffff7ffUL; }
unsigned long foo_0xffdffedffffff7ff(void) { return 0xffdffedffffff7ffUL; }
unsigned long foo_0xffbffedffffff7ff(void) { return 0xffbffedffffff7ffUL; }
unsigned long foo_0xff7ffedffffff7ff(void) { return 0xff7ffedffffff7ffUL; }
unsigned long foo_0xfffefddffffff7ff(void) { return 0xfffefddffffff7ffUL; }
unsigned long foo_0xfffbfddffffff7ff(void) { return 0xfffbfddffffff7ffUL; }
unsigned long foo_0xffeffddffffff7ff(void) { return 0xffeffddffffff7ffUL; }
unsigned long foo_0xffbffddffffff7ff(void) { return 0xffbffddffffff7ffUL; }
unsigned long foo_0xfffefbdffffff7ff(void) { return 0xfffefbdffffff7ffUL; }
unsigned long foo_0xfffdfbdffffff7ff(void) { return 0xfffdfbdffffff7ffUL; }
unsigned long foo_0xfffbfbdffffff7ff(void) { return 0xfffbfbdffffff7ffUL; }
unsigned long foo_0xfff7fbdffffff7ff(void) { return 0xfff7fbdffffff7ffUL; }
unsigned long foo_0xffeffbdffffff7ff(void) { return 0xffeffbdffffff7ffUL; }
unsigned long foo_0xffdffbdffffff7ff(void) { return 0xffdffbdffffff7ffUL; }
unsigned long foo_0xffbffbdffffff7ff(void) { return 0xffbffbdffffff7ffUL; }
unsigned long foo_0xff7ffbdffffff7ff(void) { return 0xff7ffbdffffff7ffUL; }
unsigned long foo_0xfffef7dffffff7ff(void) { return 0xfffef7dffffff7ffUL; }
unsigned long foo_0xfffbf7dffffff7ff(void) { return 0xfffbf7dffffff7ffUL; }
unsigned long foo_0xffeff7dffffff7ff(void) { return 0xffeff7dffffff7ffUL; }
unsigned long foo_0xffbff7dffffff7ff(void) { return 0xffbff7dffffff7ffUL; }
unsigned long foo_0xfffeefdffffff7ff(void) { return 0xfffeefdffffff7ffUL; }
unsigned long foo_0xfffdefdffffff7ff(void) { return 0xfffdefdffffff7ffUL; }
unsigned long foo_0xfffbefdffffff7ff(void) { return 0xfffbefdffffff7ffUL; }
unsigned long foo_0xfff7efdffffff7ff(void) { return 0xfff7efdffffff7ffUL; }
unsigned long foo_0xffefefdffffff7ff(void) { return 0xffefefdffffff7ffUL; }
unsigned long foo_0xffdfefdffffff7ff(void) { return 0xffdfefdffffff7ffUL; }
unsigned long foo_0xffbfefdffffff7ff(void) { return 0xffbfefdffffff7ffUL; }
unsigned long foo_0xff7fefdffffff7ff(void) { return 0xff7fefdffffff7ffUL; }
unsigned long foo_0xfffedfdffffff7ff(void) { return 0xfffedfdffffff7ffUL; }
unsigned long foo_0xfffbdfdffffff7ff(void) { return 0xfffbdfdffffff7ffUL; }
unsigned long foo_0xffefdfdffffff7ff(void) { return 0xffefdfdffffff7ffUL; }
unsigned long foo_0xffbfdfdffffff7ff(void) { return 0xffbfdfdffffff7ffUL; }
unsigned long foo_0xfffebfdffffff7ff(void) { return 0xfffebfdffffff7ffUL; }
unsigned long foo_0xfffdbfdffffff7ff(void) { return 0xfffdbfdffffff7ffUL; }
unsigned long foo_0xfffbbfdffffff7ff(void) { return 0xfffbbfdffffff7ffUL; }
unsigned long foo_0xfff7bfdffffff7ff(void) { return 0xfff7bfdffffff7ffUL; }
unsigned long foo_0xffefbfdffffff7ff(void) { return 0xffefbfdffffff7ffUL; }
unsigned long foo_0xffdfbfdffffff7ff(void) { return 0xffdfbfdffffff7ffUL; }
unsigned long foo_0xffbfbfdffffff7ff(void) { return 0xffbfbfdffffff7ffUL; }
unsigned long foo_0xff7fbfdffffff7ff(void) { return 0xff7fbfdffffff7ffUL; }
unsigned long foo_0xfffe7fdffffff7ff(void) { return 0xfffe7fdffffff7ffUL; }
unsigned long foo_0xfffb7fdffffff7ff(void) { return 0xfffb7fdffffff7ffUL; }
unsigned long foo_0xffef7fdffffff7ff(void) { return 0xffef7fdffffff7ffUL; }
unsigned long foo_0xffbf7fdffffff7ff(void) { return 0xffbf7fdffffff7ffUL; }
unsigned long foo_0xfffcffdffffff7ff(void) { return 0xfffcffdffffff7ffUL; }
unsigned long foo_0xfffaffdffffff7ff(void) { return 0xfffaffdffffff7ffUL; }
unsigned long foo_0xfff6ffdffffff7ff(void) { return 0xfff6ffdffffff7ffUL; }
unsigned long foo_0xffeeffdffffff7ff(void) { return 0xffeeffdffffff7ffUL; }
unsigned long foo_0xffdeffdffffff7ff(void) { return 0xffdeffdffffff7ffUL; }
unsigned long foo_0xffbeffdffffff7ff(void) { return 0xffbeffdffffff7ffUL; }
unsigned long foo_0xff7effdffffff7ff(void) { return 0xff7effdffffff7ffUL; }
unsigned long foo_0xfff9ffdffffff7ff(void) { return 0xfff9ffdffffff7ffUL; }
unsigned long foo_0xffedffdffffff7ff(void) { return 0xffedffdffffff7ffUL; }
unsigned long foo_0xffbdffdffffff7ff(void) { return 0xffbdffdffffff7ffUL; }
unsigned long foo_0xfff3ffdffffff7ff(void) { return 0xfff3ffdffffff7ffUL; }
unsigned long foo_0xffebffdffffff7ff(void) { return 0xffebffdffffff7ffUL; }
unsigned long foo_0xffdbffdffffff7ff(void) { return 0xffdbffdffffff7ffUL; }
unsigned long foo_0xffbbffdffffff7ff(void) { return 0xffbbffdffffff7ffUL; }
unsigned long foo_0xff7bffdffffff7ff(void) { return 0xff7bffdffffff7ffUL; }
unsigned long foo_0xffe7ffdffffff7ff(void) { return 0xffe7ffdffffff7ffUL; }
unsigned long foo_0xffb7ffdffffff7ff(void) { return 0xffb7ffdffffff7ffUL; }
unsigned long foo_0xffcfffdffffff7ff(void) { return 0xffcfffdffffff7ffUL; }
unsigned long foo_0xffafffdffffff7ff(void) { return 0xffafffdffffff7ffUL; }
unsigned long foo_0xff6fffdffffff7ff(void) { return 0xff6fffdffffff7ffUL; }
unsigned long foo_0xff9fffdffffff7ff(void) { return 0xff9fffdffffff7ffUL; }
unsigned long foo_0xff3fffdffffff7ff(void) { return 0xff3fffdffffff7ffUL; }
unsigned long foo_0xfffdff3ffffff7ff(void) { return 0xfffdff3ffffff7ffUL; }
unsigned long foo_0xfffbff3ffffff7ff(void) { return 0xfffbff3ffffff7ffUL; }
unsigned long foo_0xfff7ff3ffffff7ff(void) { return 0xfff7ff3ffffff7ffUL; }
unsigned long foo_0xffefff3ffffff7ff(void) { return 0xffefff3ffffff7ffUL; }
unsigned long foo_0xffdfff3ffffff7ff(void) { return 0xffdfff3ffffff7ffUL; }
unsigned long foo_0xffbfff3ffffff7ff(void) { return 0xffbfff3ffffff7ffUL; }
unsigned long foo_0xff7fff3ffffff7ff(void) { return 0xff7fff3ffffff7ffUL; }
unsigned long foo_0xfeffff3ffffff7ff(void) { return 0xfeffff3ffffff7ffUL; }
unsigned long foo_0xfffdfebffffff7ff(void) { return 0xfffdfebffffff7ffUL; }
unsigned long foo_0xfff7febffffff7ff(void) { return 0xfff7febffffff7ffUL; }
unsigned long foo_0xffdffebffffff7ff(void) { return 0xffdffebffffff7ffUL; }
unsigned long foo_0xff7ffebffffff7ff(void) { return 0xff7ffebffffff7ffUL; }
unsigned long foo_0xfffdfdbffffff7ff(void) { return 0xfffdfdbffffff7ffUL; }
unsigned long foo_0xfffbfdbffffff7ff(void) { return 0xfffbfdbffffff7ffUL; }
unsigned long foo_0xfff7fdbffffff7ff(void) { return 0xfff7fdbffffff7ffUL; }
unsigned long foo_0xffeffdbffffff7ff(void) { return 0xffeffdbffffff7ffUL; }
unsigned long foo_0xffdffdbffffff7ff(void) { return 0xffdffdbffffff7ffUL; }
unsigned long foo_0xffbffdbffffff7ff(void) { return 0xffbffdbffffff7ffUL; }
unsigned long foo_0xff7ffdbffffff7ff(void) { return 0xff7ffdbffffff7ffUL; }
unsigned long foo_0xfefffdbffffff7ff(void) { return 0xfefffdbffffff7ffUL; }
unsigned long foo_0xfffdfbbffffff7ff(void) { return 0xfffdfbbffffff7ffUL; }
unsigned long foo_0xfff7fbbffffff7ff(void) { return 0xfff7fbbffffff7ffUL; }
unsigned long foo_0xffdffbbffffff7ff(void) { return 0xffdffbbffffff7ffUL; }
unsigned long foo_0xff7ffbbffffff7ff(void) { return 0xff7ffbbffffff7ffUL; }
unsigned long foo_0xfffdf7bffffff7ff(void) { return 0xfffdf7bffffff7ffUL; }
unsigned long foo_0xfffbf7bffffff7ff(void) { return 0xfffbf7bffffff7ffUL; }
unsigned long foo_0xfff7f7bffffff7ff(void) { return 0xfff7f7bffffff7ffUL; }
unsigned long foo_0xffeff7bffffff7ff(void) { return 0xffeff7bffffff7ffUL; }
unsigned long foo_0xffdff7bffffff7ff(void) { return 0xffdff7bffffff7ffUL; }
unsigned long foo_0xffbff7bffffff7ff(void) { return 0xffbff7bffffff7ffUL; }
unsigned long foo_0xff7ff7bffffff7ff(void) { return 0xff7ff7bffffff7ffUL; }
unsigned long foo_0xfefff7bffffff7ff(void) { return 0xfefff7bffffff7ffUL; }
unsigned long foo_0xfffdefbffffff7ff(void) { return 0xfffdefbffffff7ffUL; }
unsigned long foo_0xfff7efbffffff7ff(void) { return 0xfff7efbffffff7ffUL; }
unsigned long foo_0xffdfefbffffff7ff(void) { return 0xffdfefbffffff7ffUL; }
unsigned long foo_0xff7fefbffffff7ff(void) { return 0xff7fefbffffff7ffUL; }
unsigned long foo_0xfffddfbffffff7ff(void) { return 0xfffddfbffffff7ffUL; }
unsigned long foo_0xfffbdfbffffff7ff(void) { return 0xfffbdfbffffff7ffUL; }
unsigned long foo_0xfff7dfbffffff7ff(void) { return 0xfff7dfbffffff7ffUL; }
unsigned long foo_0xffefdfbffffff7ff(void) { return 0xffefdfbffffff7ffUL; }
unsigned long foo_0xffdfdfbffffff7ff(void) { return 0xffdfdfbffffff7ffUL; }
unsigned long foo_0xffbfdfbffffff7ff(void) { return 0xffbfdfbffffff7ffUL; }
unsigned long foo_0xff7fdfbffffff7ff(void) { return 0xff7fdfbffffff7ffUL; }
unsigned long foo_0xfeffdfbffffff7ff(void) { return 0xfeffdfbffffff7ffUL; }
unsigned long foo_0xfffdbfbffffff7ff(void) { return 0xfffdbfbffffff7ffUL; }
unsigned long foo_0xfff7bfbffffff7ff(void) { return 0xfff7bfbffffff7ffUL; }
unsigned long foo_0xffdfbfbffffff7ff(void) { return 0xffdfbfbffffff7ffUL; }
unsigned long foo_0xff7fbfbffffff7ff(void) { return 0xff7fbfbffffff7ffUL; }
unsigned long foo_0xfffd7fbffffff7ff(void) { return 0xfffd7fbffffff7ffUL; }
unsigned long foo_0xfffb7fbffffff7ff(void) { return 0xfffb7fbffffff7ffUL; }
unsigned long foo_0xfff77fbffffff7ff(void) { return 0xfff77fbffffff7ffUL; }
unsigned long foo_0xffef7fbffffff7ff(void) { return 0xffef7fbffffff7ffUL; }
unsigned long foo_0xffdf7fbffffff7ff(void) { return 0xffdf7fbffffff7ffUL; }
unsigned long foo_0xffbf7fbffffff7ff(void) { return 0xffbf7fbffffff7ffUL; }
unsigned long foo_0xff7f7fbffffff7ff(void) { return 0xff7f7fbffffff7ffUL; }
unsigned long foo_0xfeff7fbffffff7ff(void) { return 0xfeff7fbffffff7ffUL; }
unsigned long foo_0xfffcffbffffff7ff(void) { return 0xfffcffbffffff7ffUL; }
unsigned long foo_0xfff6ffbffffff7ff(void) { return 0xfff6ffbffffff7ffUL; }
unsigned long foo_0xffdeffbffffff7ff(void) { return 0xffdeffbffffff7ffUL; }
unsigned long foo_0xff7effbffffff7ff(void) { return 0xff7effbffffff7ffUL; }
unsigned long foo_0xfff9ffbffffff7ff(void) { return 0xfff9ffbffffff7ffUL; }
unsigned long foo_0xfff5ffbffffff7ff(void) { return 0xfff5ffbffffff7ffUL; }
unsigned long foo_0xffedffbffffff7ff(void) { return 0xffedffbffffff7ffUL; }
unsigned long foo_0xffddffbffffff7ff(void) { return 0xffddffbffffff7ffUL; }
unsigned long foo_0xffbdffbffffff7ff(void) { return 0xffbdffbffffff7ffUL; }
unsigned long foo_0xff7dffbffffff7ff(void) { return 0xff7dffbffffff7ffUL; }
unsigned long foo_0xfefdffbffffff7ff(void) { return 0xfefdffbffffff7ffUL; }
unsigned long foo_0xfff3ffbffffff7ff(void) { return 0xfff3ffbffffff7ffUL; }
unsigned long foo_0xffdbffbffffff7ff(void) { return 0xffdbffbffffff7ffUL; }
unsigned long foo_0xff7bffbffffff7ff(void) { return 0xff7bffbffffff7ffUL; }
unsigned long foo_0xffe7ffbffffff7ff(void) { return 0xffe7ffbffffff7ffUL; }
unsigned long foo_0xffd7ffbffffff7ff(void) { return 0xffd7ffbffffff7ffUL; }
unsigned long foo_0xffb7ffbffffff7ff(void) { return 0xffb7ffbffffff7ffUL; }
unsigned long foo_0xff77ffbffffff7ff(void) { return 0xff77ffbffffff7ffUL; }
unsigned long foo_0xfef7ffbffffff7ff(void) { return 0xfef7ffbffffff7ffUL; }
unsigned long foo_0xffcfffbffffff7ff(void) { return 0xffcfffbffffff7ffUL; }
unsigned long foo_0xff6fffbffffff7ff(void) { return 0xff6fffbffffff7ffUL; }
unsigned long foo_0xff9fffbffffff7ff(void) { return 0xff9fffbffffff7ffUL; }
unsigned long foo_0xff5fffbffffff7ff(void) { return 0xff5fffbffffff7ffUL; }
unsigned long foo_0xfedfffbffffff7ff(void) { return 0xfedfffbffffff7ffUL; }
unsigned long foo_0xff3fffbffffff7ff(void) { return 0xff3fffbffffff7ffUL; }
unsigned long foo_0xfe7fffbffffff7ff(void) { return 0xfe7fffbffffff7ffUL; }
unsigned long foo_0xfffbfe7ffffff7ff(void) { return 0xfffbfe7ffffff7ffUL; }
unsigned long foo_0xfff7fe7ffffff7ff(void) { return 0xfff7fe7ffffff7ffUL; }
unsigned long foo_0xffeffe7ffffff7ff(void) { return 0xffeffe7ffffff7ffUL; }
unsigned long foo_0xffdffe7ffffff7ff(void) { return 0xffdffe7ffffff7ffUL; }
unsigned long foo_0xffbffe7ffffff7ff(void) { return 0xffbffe7ffffff7ffUL; }
unsigned long foo_0xff7ffe7ffffff7ff(void) { return 0xff7ffe7ffffff7ffUL; }
unsigned long foo_0xfefffe7ffffff7ff(void) { return 0xfefffe7ffffff7ffUL; }
unsigned long foo_0xfdfffe7ffffff7ff(void) { return 0xfdfffe7ffffff7ffUL; }
unsigned long foo_0xfffbfd7ffffff7ff(void) { return 0xfffbfd7ffffff7ffUL; }
unsigned long foo_0xffeffd7ffffff7ff(void) { return 0xffeffd7ffffff7ffUL; }
unsigned long foo_0xffbffd7ffffff7ff(void) { return 0xffbffd7ffffff7ffUL; }
unsigned long foo_0xfefffd7ffffff7ff(void) { return 0xfefffd7ffffff7ffUL; }
unsigned long foo_0xfffbfb7ffffff7ff(void) { return 0xfffbfb7ffffff7ffUL; }
unsigned long foo_0xfff7fb7ffffff7ff(void) { return 0xfff7fb7ffffff7ffUL; }
unsigned long foo_0xffeffb7ffffff7ff(void) { return 0xffeffb7ffffff7ffUL; }
unsigned long foo_0xffdffb7ffffff7ff(void) { return 0xffdffb7ffffff7ffUL; }
unsigned long foo_0xffbffb7ffffff7ff(void) { return 0xffbffb7ffffff7ffUL; }
unsigned long foo_0xff7ffb7ffffff7ff(void) { return 0xff7ffb7ffffff7ffUL; }
unsigned long foo_0xfefffb7ffffff7ff(void) { return 0xfefffb7ffffff7ffUL; }
unsigned long foo_0xfdfffb7ffffff7ff(void) { return 0xfdfffb7ffffff7ffUL; }
unsigned long foo_0xfffbf77ffffff7ff(void) { return 0xfffbf77ffffff7ffUL; }
unsigned long foo_0xffeff77ffffff7ff(void) { return 0xffeff77ffffff7ffUL; }
unsigned long foo_0xffbff77ffffff7ff(void) { return 0xffbff77ffffff7ffUL; }
unsigned long foo_0xfefff77ffffff7ff(void) { return 0xfefff77ffffff7ffUL; }
unsigned long foo_0xfffbef7ffffff7ff(void) { return 0xfffbef7ffffff7ffUL; }
unsigned long foo_0xfff7ef7ffffff7ff(void) { return 0xfff7ef7ffffff7ffUL; }
unsigned long foo_0xffefef7ffffff7ff(void) { return 0xffefef7ffffff7ffUL; }
unsigned long foo_0xffdfef7ffffff7ff(void) { return 0xffdfef7ffffff7ffUL; }
unsigned long foo_0xffbfef7ffffff7ff(void) { return 0xffbfef7ffffff7ffUL; }
unsigned long foo_0xff7fef7ffffff7ff(void) { return 0xff7fef7ffffff7ffUL; }
unsigned long foo_0xfeffef7ffffff7ff(void) { return 0xfeffef7ffffff7ffUL; }
unsigned long foo_0xfdffef7ffffff7ff(void) { return 0xfdffef7ffffff7ffUL; }
unsigned long foo_0xfffbdf7ffffff7ff(void) { return 0xfffbdf7ffffff7ffUL; }
unsigned long foo_0xffefdf7ffffff7ff(void) { return 0xffefdf7ffffff7ffUL; }
unsigned long foo_0xffbfdf7ffffff7ff(void) { return 0xffbfdf7ffffff7ffUL; }
unsigned long foo_0xfeffdf7ffffff7ff(void) { return 0xfeffdf7ffffff7ffUL; }
unsigned long foo_0xfffbbf7ffffff7ff(void) { return 0xfffbbf7ffffff7ffUL; }
unsigned long foo_0xfff7bf7ffffff7ff(void) { return 0xfff7bf7ffffff7ffUL; }
unsigned long foo_0xffefbf7ffffff7ff(void) { return 0xffefbf7ffffff7ffUL; }
unsigned long foo_0xffdfbf7ffffff7ff(void) { return 0xffdfbf7ffffff7ffUL; }
unsigned long foo_0xffbfbf7ffffff7ff(void) { return 0xffbfbf7ffffff7ffUL; }
unsigned long foo_0xff7fbf7ffffff7ff(void) { return 0xff7fbf7ffffff7ffUL; }
unsigned long foo_0xfeffbf7ffffff7ff(void) { return 0xfeffbf7ffffff7ffUL; }
unsigned long foo_0xfdffbf7ffffff7ff(void) { return 0xfdffbf7ffffff7ffUL; }
unsigned long foo_0xfffb7f7ffffff7ff(void) { return 0xfffb7f7ffffff7ffUL; }
unsigned long foo_0xffef7f7ffffff7ff(void) { return 0xffef7f7ffffff7ffUL; }
unsigned long foo_0xffbf7f7ffffff7ff(void) { return 0xffbf7f7ffffff7ffUL; }
unsigned long foo_0xfeff7f7ffffff7ff(void) { return 0xfeff7f7ffffff7ffUL; }
unsigned long foo_0xfffaff7ffffff7ff(void) { return 0xfffaff7ffffff7ffUL; }
unsigned long foo_0xfff6ff7ffffff7ff(void) { return 0xfff6ff7ffffff7ffUL; }
unsigned long foo_0xffeeff7ffffff7ff(void) { return 0xffeeff7ffffff7ffUL; }
unsigned long foo_0xffdeff7ffffff7ff(void) { return 0xffdeff7ffffff7ffUL; }
unsigned long foo_0xffbeff7ffffff7ff(void) { return 0xffbeff7ffffff7ffUL; }
unsigned long foo_0xff7eff7ffffff7ff(void) { return 0xff7eff7ffffff7ffUL; }
unsigned long foo_0xfefeff7ffffff7ff(void) { return 0xfefeff7ffffff7ffUL; }
unsigned long foo_0xfdfeff7ffffff7ff(void) { return 0xfdfeff7ffffff7ffUL; }
unsigned long foo_0xfff9ff7ffffff7ff(void) { return 0xfff9ff7ffffff7ffUL; }
unsigned long foo_0xffedff7ffffff7ff(void) { return 0xffedff7ffffff7ffUL; }
unsigned long foo_0xffbdff7ffffff7ff(void) { return 0xffbdff7ffffff7ffUL; }
unsigned long foo_0xfefdff7ffffff7ff(void) { return 0xfefdff7ffffff7ffUL; }
unsigned long foo_0xfff3ff7ffffff7ff(void) { return 0xfff3ff7ffffff7ffUL; }
unsigned long foo_0xffebff7ffffff7ff(void) { return 0xffebff7ffffff7ffUL; }
unsigned long foo_0xffdbff7ffffff7ff(void) { return 0xffdbff7ffffff7ffUL; }
unsigned long foo_0xffbbff7ffffff7ff(void) { return 0xffbbff7ffffff7ffUL; }
unsigned long foo_0xff7bff7ffffff7ff(void) { return 0xff7bff7ffffff7ffUL; }
unsigned long foo_0xfefbff7ffffff7ff(void) { return 0xfefbff7ffffff7ffUL; }
unsigned long foo_0xfdfbff7ffffff7ff(void) { return 0xfdfbff7ffffff7ffUL; }
unsigned long foo_0xffe7ff7ffffff7ff(void) { return 0xffe7ff7ffffff7ffUL; }
unsigned long foo_0xffb7ff7ffffff7ff(void) { return 0xffb7ff7ffffff7ffUL; }
unsigned long foo_0xfef7ff7ffffff7ff(void) { return 0xfef7ff7ffffff7ffUL; }
unsigned long foo_0xffcfff7ffffff7ff(void) { return 0xffcfff7ffffff7ffUL; }
unsigned long foo_0xffafff7ffffff7ff(void) { return 0xffafff7ffffff7ffUL; }
unsigned long foo_0xff6fff7ffffff7ff(void) { return 0xff6fff7ffffff7ffUL; }
unsigned long foo_0xfeefff7ffffff7ff(void) { return 0xfeefff7ffffff7ffUL; }
unsigned long foo_0xfdefff7ffffff7ff(void) { return 0xfdefff7ffffff7ffUL; }
unsigned long foo_0xff9fff7ffffff7ff(void) { return 0xff9fff7ffffff7ffUL; }
unsigned long foo_0xfedfff7ffffff7ff(void) { return 0xfedfff7ffffff7ffUL; }
unsigned long foo_0xff3fff7ffffff7ff(void) { return 0xff3fff7ffffff7ffUL; }
unsigned long foo_0xfebfff7ffffff7ff(void) { return 0xfebfff7ffffff7ffUL; }
unsigned long foo_0xfdbfff7ffffff7ff(void) { return 0xfdbfff7ffffff7ffUL; }
unsigned long foo_0xfe7fff7ffffff7ff(void) { return 0xfe7fff7ffffff7ffUL; }
unsigned long foo_0xfcffff7ffffff7ff(void) { return 0xfcffff7ffffff7ffUL; }
unsigned long foo_0xfff7fcfffffff7ff(void) { return 0xfff7fcfffffff7ffUL; }
unsigned long foo_0xffeffcfffffff7ff(void) { return 0xffeffcfffffff7ffUL; }
unsigned long foo_0xffdffcfffffff7ff(void) { return 0xffdffcfffffff7ffUL; }
unsigned long foo_0xffbffcfffffff7ff(void) { return 0xffbffcfffffff7ffUL; }
unsigned long foo_0xff7ffcfffffff7ff(void) { return 0xff7ffcfffffff7ffUL; }
unsigned long foo_0xfefffcfffffff7ff(void) { return 0xfefffcfffffff7ffUL; }
unsigned long foo_0xfdfffcfffffff7ff(void) { return 0xfdfffcfffffff7ffUL; }
unsigned long foo_0xfbfffcfffffff7ff(void) { return 0xfbfffcfffffff7ffUL; }
unsigned long foo_0xfff7fafffffff7ff(void) { return 0xfff7fafffffff7ffUL; }
unsigned long foo_0xffdffafffffff7ff(void) { return 0xffdffafffffff7ffUL; }
unsigned long foo_0xff7ffafffffff7ff(void) { return 0xff7ffafffffff7ffUL; }
unsigned long foo_0xfdfffafffffff7ff(void) { return 0xfdfffafffffff7ffUL; }
unsigned long foo_0xfff7f6fffffff7ff(void) { return 0xfff7f6fffffff7ffUL; }
unsigned long foo_0xffeff6fffffff7ff(void) { return 0xffeff6fffffff7ffUL; }
unsigned long foo_0xffdff6fffffff7ff(void) { return 0xffdff6fffffff7ffUL; }
unsigned long foo_0xffbff6fffffff7ff(void) { return 0xffbff6fffffff7ffUL; }
unsigned long foo_0xff7ff6fffffff7ff(void) { return 0xff7ff6fffffff7ffUL; }
unsigned long foo_0xfefff6fffffff7ff(void) { return 0xfefff6fffffff7ffUL; }
unsigned long foo_0xfdfff6fffffff7ff(void) { return 0xfdfff6fffffff7ffUL; }
unsigned long foo_0xfbfff6fffffff7ff(void) { return 0xfbfff6fffffff7ffUL; }
unsigned long foo_0xfff7eefffffff7ff(void) { return 0xfff7eefffffff7ffUL; }
unsigned long foo_0xffdfeefffffff7ff(void) { return 0xffdfeefffffff7ffUL; }
unsigned long foo_0xff7feefffffff7ff(void) { return 0xff7feefffffff7ffUL; }
unsigned long foo_0xfdffeefffffff7ff(void) { return 0xfdffeefffffff7ffUL; }
unsigned long foo_0xfff7defffffff7ff(void) { return 0xfff7defffffff7ffUL; }
unsigned long foo_0xffefdefffffff7ff(void) { return 0xffefdefffffff7ffUL; }
unsigned long foo_0xffdfdefffffff7ff(void) { return 0xffdfdefffffff7ffUL; }
unsigned long foo_0xffbfdefffffff7ff(void) { return 0xffbfdefffffff7ffUL; }
unsigned long foo_0xff7fdefffffff7ff(void) { return 0xff7fdefffffff7ffUL; }
unsigned long foo_0xfeffdefffffff7ff(void) { return 0xfeffdefffffff7ffUL; }
unsigned long foo_0xfdffdefffffff7ff(void) { return 0xfdffdefffffff7ffUL; }
unsigned long foo_0xfbffdefffffff7ff(void) { return 0xfbffdefffffff7ffUL; }
unsigned long foo_0xfff7befffffff7ff(void) { return 0xfff7befffffff7ffUL; }
unsigned long foo_0xffdfbefffffff7ff(void) { return 0xffdfbefffffff7ffUL; }
unsigned long foo_0xff7fbefffffff7ff(void) { return 0xff7fbefffffff7ffUL; }
unsigned long foo_0xfdffbefffffff7ff(void) { return 0xfdffbefffffff7ffUL; }
unsigned long foo_0xfff77efffffff7ff(void) { return 0xfff77efffffff7ffUL; }
unsigned long foo_0xffef7efffffff7ff(void) { return 0xffef7efffffff7ffUL; }
unsigned long foo_0xffdf7efffffff7ff(void) { return 0xffdf7efffffff7ffUL; }
unsigned long foo_0xffbf7efffffff7ff(void) { return 0xffbf7efffffff7ffUL; }
unsigned long foo_0xff7f7efffffff7ff(void) { return 0xff7f7efffffff7ffUL; }
unsigned long foo_0xfeff7efffffff7ff(void) { return 0xfeff7efffffff7ffUL; }
unsigned long foo_0xfdff7efffffff7ff(void) { return 0xfdff7efffffff7ffUL; }
unsigned long foo_0xfbff7efffffff7ff(void) { return 0xfbff7efffffff7ffUL; }
unsigned long foo_0xfff6fefffffff7ff(void) { return 0xfff6fefffffff7ffUL; }
unsigned long foo_0xffdefefffffff7ff(void) { return 0xffdefefffffff7ffUL; }
unsigned long foo_0xff7efefffffff7ff(void) { return 0xff7efefffffff7ffUL; }
unsigned long foo_0xfdfefefffffff7ff(void) { return 0xfdfefefffffff7ffUL; }
unsigned long foo_0xfff5fefffffff7ff(void) { return 0xfff5fefffffff7ffUL; }
unsigned long foo_0xffedfefffffff7ff(void) { return 0xffedfefffffff7ffUL; }
unsigned long foo_0xffddfefffffff7ff(void) { return 0xffddfefffffff7ffUL; }
unsigned long foo_0xffbdfefffffff7ff(void) { return 0xffbdfefffffff7ffUL; }
unsigned long foo_0xff7dfefffffff7ff(void) { return 0xff7dfefffffff7ffUL; }
unsigned long foo_0xfefdfefffffff7ff(void) { return 0xfefdfefffffff7ffUL; }
unsigned long foo_0xfdfdfefffffff7ff(void) { return 0xfdfdfefffffff7ffUL; }
unsigned long foo_0xfbfdfefffffff7ff(void) { return 0xfbfdfefffffff7ffUL; }
unsigned long foo_0xfff3fefffffff7ff(void) { return 0xfff3fefffffff7ffUL; }
unsigned long foo_0xffdbfefffffff7ff(void) { return 0xffdbfefffffff7ffUL; }
unsigned long foo_0xff7bfefffffff7ff(void) { return 0xff7bfefffffff7ffUL; }
unsigned long foo_0xfdfbfefffffff7ff(void) { return 0xfdfbfefffffff7ffUL; }
unsigned long foo_0xffe7fefffffff7ff(void) { return 0xffe7fefffffff7ffUL; }
unsigned long foo_0xffd7fefffffff7ff(void) { return 0xffd7fefffffff7ffUL; }
unsigned long foo_0xffb7fefffffff7ff(void) { return 0xffb7fefffffff7ffUL; }
unsigned long foo_0xff77fefffffff7ff(void) { return 0xff77fefffffff7ffUL; }
unsigned long foo_0xfef7fefffffff7ff(void) { return 0xfef7fefffffff7ffUL; }
unsigned long foo_0xfdf7fefffffff7ff(void) { return 0xfdf7fefffffff7ffUL; }
unsigned long foo_0xfbf7fefffffff7ff(void) { return 0xfbf7fefffffff7ffUL; }
unsigned long foo_0xffcffefffffff7ff(void) { return 0xffcffefffffff7ffUL; }
unsigned long foo_0xff6ffefffffff7ff(void) { return 0xff6ffefffffff7ffUL; }
unsigned long foo_0xfdeffefffffff7ff(void) { return 0xfdeffefffffff7ffUL; }
unsigned long foo_0xff9ffefffffff7ff(void) { return 0xff9ffefffffff7ffUL; }
unsigned long foo_0xff5ffefffffff7ff(void) { return 0xff5ffefffffff7ffUL; }
unsigned long foo_0xfedffefffffff7ff(void) { return 0xfedffefffffff7ffUL; }
unsigned long foo_0xfddffefffffff7ff(void) { return 0xfddffefffffff7ffUL; }
unsigned long foo_0xfbdffefffffff7ff(void) { return 0xfbdffefffffff7ffUL; }
unsigned long foo_0xff3ffefffffff7ff(void) { return 0xff3ffefffffff7ffUL; }
unsigned long foo_0xfdbffefffffff7ff(void) { return 0xfdbffefffffff7ffUL; }
unsigned long foo_0xfe7ffefffffff7ff(void) { return 0xfe7ffefffffff7ffUL; }
unsigned long foo_0xfd7ffefffffff7ff(void) { return 0xfd7ffefffffff7ffUL; }
unsigned long foo_0xfb7ffefffffff7ff(void) { return 0xfb7ffefffffff7ffUL; }
unsigned long foo_0xfcfffefffffff7ff(void) { return 0xfcfffefffffff7ffUL; }
unsigned long foo_0xf9fffefffffff7ff(void) { return 0xf9fffefffffff7ffUL; }
unsigned long foo_0xffeff9fffffff7ff(void) { return 0xffeff9fffffff7ffUL; }
unsigned long foo_0xffdff9fffffff7ff(void) { return 0xffdff9fffffff7ffUL; }
unsigned long foo_0xffbff9fffffff7ff(void) { return 0xffbff9fffffff7ffUL; }
unsigned long foo_0xff7ff9fffffff7ff(void) { return 0xff7ff9fffffff7ffUL; }
unsigned long foo_0xfefff9fffffff7ff(void) { return 0xfefff9fffffff7ffUL; }
unsigned long foo_0xfdfff9fffffff7ff(void) { return 0xfdfff9fffffff7ffUL; }
unsigned long foo_0xfbfff9fffffff7ff(void) { return 0xfbfff9fffffff7ffUL; }
unsigned long foo_0xf7fff9fffffff7ff(void) { return 0xf7fff9fffffff7ffUL; }
unsigned long foo_0xffeff5fffffff7ff(void) { return 0xffeff5fffffff7ffUL; }
unsigned long foo_0xffbff5fffffff7ff(void) { return 0xffbff5fffffff7ffUL; }
unsigned long foo_0xfefff5fffffff7ff(void) { return 0xfefff5fffffff7ffUL; }
unsigned long foo_0xfbfff5fffffff7ff(void) { return 0xfbfff5fffffff7ffUL; }
unsigned long foo_0xffefedfffffff7ff(void) { return 0xffefedfffffff7ffUL; }
unsigned long foo_0xffdfedfffffff7ff(void) { return 0xffdfedfffffff7ffUL; }
unsigned long foo_0xffbfedfffffff7ff(void) { return 0xffbfedfffffff7ffUL; }
unsigned long foo_0xff7fedfffffff7ff(void) { return 0xff7fedfffffff7ffUL; }
unsigned long foo_0xfeffedfffffff7ff(void) { return 0xfeffedfffffff7ffUL; }
unsigned long foo_0xfdffedfffffff7ff(void) { return 0xfdffedfffffff7ffUL; }
unsigned long foo_0xfbffedfffffff7ff(void) { return 0xfbffedfffffff7ffUL; }
unsigned long foo_0xf7ffedfffffff7ff(void) { return 0xf7ffedfffffff7ffUL; }
unsigned long foo_0xffefddfffffff7ff(void) { return 0xffefddfffffff7ffUL; }
unsigned long foo_0xffbfddfffffff7ff(void) { return 0xffbfddfffffff7ffUL; }
unsigned long foo_0xfeffddfffffff7ff(void) { return 0xfeffddfffffff7ffUL; }
unsigned long foo_0xfbffddfffffff7ff(void) { return 0xfbffddfffffff7ffUL; }
unsigned long foo_0xffefbdfffffff7ff(void) { return 0xffefbdfffffff7ffUL; }
unsigned long foo_0xffdfbdfffffff7ff(void) { return 0xffdfbdfffffff7ffUL; }
unsigned long foo_0xffbfbdfffffff7ff(void) { return 0xffbfbdfffffff7ffUL; }
unsigned long foo_0xff7fbdfffffff7ff(void) { return 0xff7fbdfffffff7ffUL; }
unsigned long foo_0xfeffbdfffffff7ff(void) { return 0xfeffbdfffffff7ffUL; }
unsigned long foo_0xfdffbdfffffff7ff(void) { return 0xfdffbdfffffff7ffUL; }
unsigned long foo_0xfbffbdfffffff7ff(void) { return 0xfbffbdfffffff7ffUL; }
unsigned long foo_0xf7ffbdfffffff7ff(void) { return 0xf7ffbdfffffff7ffUL; }
unsigned long foo_0xffef7dfffffff7ff(void) { return 0xffef7dfffffff7ffUL; }
unsigned long foo_0xffbf7dfffffff7ff(void) { return 0xffbf7dfffffff7ffUL; }
unsigned long foo_0xfeff7dfffffff7ff(void) { return 0xfeff7dfffffff7ffUL; }
unsigned long foo_0xfbff7dfffffff7ff(void) { return 0xfbff7dfffffff7ffUL; }
unsigned long foo_0xffeefdfffffff7ff(void) { return 0xffeefdfffffff7ffUL; }
unsigned long foo_0xffdefdfffffff7ff(void) { return 0xffdefdfffffff7ffUL; }
unsigned long foo_0xffbefdfffffff7ff(void) { return 0xffbefdfffffff7ffUL; }
unsigned long foo_0xff7efdfffffff7ff(void) { return 0xff7efdfffffff7ffUL; }
unsigned long foo_0xfefefdfffffff7ff(void) { return 0xfefefdfffffff7ffUL; }
unsigned long foo_0xfdfefdfffffff7ff(void) { return 0xfdfefdfffffff7ffUL; }
unsigned long foo_0xfbfefdfffffff7ff(void) { return 0xfbfefdfffffff7ffUL; }
unsigned long foo_0xf7fefdfffffff7ff(void) { return 0xf7fefdfffffff7ffUL; }
unsigned long foo_0xffedfdfffffff7ff(void) { return 0xffedfdfffffff7ffUL; }
unsigned long foo_0xffbdfdfffffff7ff(void) { return 0xffbdfdfffffff7ffUL; }
unsigned long foo_0xfefdfdfffffff7ff(void) { return 0xfefdfdfffffff7ffUL; }
unsigned long foo_0xfbfdfdfffffff7ff(void) { return 0xfbfdfdfffffff7ffUL; }
unsigned long foo_0xffebfdfffffff7ff(void) { return 0xffebfdfffffff7ffUL; }
unsigned long foo_0xffdbfdfffffff7ff(void) { return 0xffdbfdfffffff7ffUL; }
unsigned long foo_0xffbbfdfffffff7ff(void) { return 0xffbbfdfffffff7ffUL; }
unsigned long foo_0xff7bfdfffffff7ff(void) { return 0xff7bfdfffffff7ffUL; }
unsigned long foo_0xfefbfdfffffff7ff(void) { return 0xfefbfdfffffff7ffUL; }
unsigned long foo_0xfdfbfdfffffff7ff(void) { return 0xfdfbfdfffffff7ffUL; }
unsigned long foo_0xfbfbfdfffffff7ff(void) { return 0xfbfbfdfffffff7ffUL; }
unsigned long foo_0xf7fbfdfffffff7ff(void) { return 0xf7fbfdfffffff7ffUL; }
unsigned long foo_0xffe7fdfffffff7ff(void) { return 0xffe7fdfffffff7ffUL; }
unsigned long foo_0xffb7fdfffffff7ff(void) { return 0xffb7fdfffffff7ffUL; }
unsigned long foo_0xfef7fdfffffff7ff(void) { return 0xfef7fdfffffff7ffUL; }
unsigned long foo_0xfbf7fdfffffff7ff(void) { return 0xfbf7fdfffffff7ffUL; }
unsigned long foo_0xffcffdfffffff7ff(void) { return 0xffcffdfffffff7ffUL; }
unsigned long foo_0xffaffdfffffff7ff(void) { return 0xffaffdfffffff7ffUL; }
unsigned long foo_0xff6ffdfffffff7ff(void) { return 0xff6ffdfffffff7ffUL; }
unsigned long foo_0xfeeffdfffffff7ff(void) { return 0xfeeffdfffffff7ffUL; }
unsigned long foo_0xfdeffdfffffff7ff(void) { return 0xfdeffdfffffff7ffUL; }
unsigned long foo_0xfbeffdfffffff7ff(void) { return 0xfbeffdfffffff7ffUL; }
unsigned long foo_0xf7effdfffffff7ff(void) { return 0xf7effdfffffff7ffUL; }
unsigned long foo_0xff9ffdfffffff7ff(void) { return 0xff9ffdfffffff7ffUL; }
unsigned long foo_0xfedffdfffffff7ff(void) { return 0xfedffdfffffff7ffUL; }
unsigned long foo_0xfbdffdfffffff7ff(void) { return 0xfbdffdfffffff7ffUL; }
unsigned long foo_0xff3ffdfffffff7ff(void) { return 0xff3ffdfffffff7ffUL; }
unsigned long foo_0xfebffdfffffff7ff(void) { return 0xfebffdfffffff7ffUL; }
unsigned long foo_0xfdbffdfffffff7ff(void) { return 0xfdbffdfffffff7ffUL; }
unsigned long foo_0xfbbffdfffffff7ff(void) { return 0xfbbffdfffffff7ffUL; }
unsigned long foo_0xf7bffdfffffff7ff(void) { return 0xf7bffdfffffff7ffUL; }
unsigned long foo_0xfe7ffdfffffff7ff(void) { return 0xfe7ffdfffffff7ffUL; }
unsigned long foo_0xfb7ffdfffffff7ff(void) { return 0xfb7ffdfffffff7ffUL; }
unsigned long foo_0xfcfffdfffffff7ff(void) { return 0xfcfffdfffffff7ffUL; }
unsigned long foo_0xfafffdfffffff7ff(void) { return 0xfafffdfffffff7ffUL; }
unsigned long foo_0xf6fffdfffffff7ff(void) { return 0xf6fffdfffffff7ffUL; }
unsigned long foo_0xf9fffdfffffff7ff(void) { return 0xf9fffdfffffff7ffUL; }
unsigned long foo_0xf3fffdfffffff7ff(void) { return 0xf3fffdfffffff7ffUL; }
unsigned long foo_0xffdff3fffffff7ff(void) { return 0xffdff3fffffff7ffUL; }
unsigned long foo_0xffbff3fffffff7ff(void) { return 0xffbff3fffffff7ffUL; }
unsigned long foo_0xff7ff3fffffff7ff(void) { return 0xff7ff3fffffff7ffUL; }
unsigned long foo_0xfefff3fffffff7ff(void) { return 0xfefff3fffffff7ffUL; }
unsigned long foo_0xfdfff3fffffff7ff(void) { return 0xfdfff3fffffff7ffUL; }
unsigned long foo_0xfbfff3fffffff7ff(void) { return 0xfbfff3fffffff7ffUL; }
unsigned long foo_0xf7fff3fffffff7ff(void) { return 0xf7fff3fffffff7ffUL; }
unsigned long foo_0xeffff3fffffff7ff(void) { return 0xeffff3fffffff7ffUL; }
unsigned long foo_0xffdfebfffffff7ff(void) { return 0xffdfebfffffff7ffUL; }
unsigned long foo_0xff7febfffffff7ff(void) { return 0xff7febfffffff7ffUL; }
unsigned long foo_0xfdffebfffffff7ff(void) { return 0xfdffebfffffff7ffUL; }
unsigned long foo_0xf7ffebfffffff7ff(void) { return 0xf7ffebfffffff7ffUL; }
unsigned long foo_0xffdfdbfffffff7ff(void) { return 0xffdfdbfffffff7ffUL; }
unsigned long foo_0xffbfdbfffffff7ff(void) { return 0xffbfdbfffffff7ffUL; }
unsigned long foo_0xff7fdbfffffff7ff(void) { return 0xff7fdbfffffff7ffUL; }
unsigned long foo_0xfeffdbfffffff7ff(void) { return 0xfeffdbfffffff7ffUL; }
unsigned long foo_0xfdffdbfffffff7ff(void) { return 0xfdffdbfffffff7ffUL; }
unsigned long foo_0xfbffdbfffffff7ff(void) { return 0xfbffdbfffffff7ffUL; }
unsigned long foo_0xf7ffdbfffffff7ff(void) { return 0xf7ffdbfffffff7ffUL; }
unsigned long foo_0xefffdbfffffff7ff(void) { return 0xefffdbfffffff7ffUL; }
unsigned long foo_0xffdfbbfffffff7ff(void) { return 0xffdfbbfffffff7ffUL; }
unsigned long foo_0xff7fbbfffffff7ff(void) { return 0xff7fbbfffffff7ffUL; }
unsigned long foo_0xfdffbbfffffff7ff(void) { return 0xfdffbbfffffff7ffUL; }
unsigned long foo_0xf7ffbbfffffff7ff(void) { return 0xf7ffbbfffffff7ffUL; }
unsigned long foo_0xffdf7bfffffff7ff(void) { return 0xffdf7bfffffff7ffUL; }
unsigned long foo_0xffbf7bfffffff7ff(void) { return 0xffbf7bfffffff7ffUL; }
unsigned long foo_0xff7f7bfffffff7ff(void) { return 0xff7f7bfffffff7ffUL; }
unsigned long foo_0xfeff7bfffffff7ff(void) { return 0xfeff7bfffffff7ffUL; }
unsigned long foo_0xfdff7bfffffff7ff(void) { return 0xfdff7bfffffff7ffUL; }
unsigned long foo_0xfbff7bfffffff7ff(void) { return 0xfbff7bfffffff7ffUL; }
unsigned long foo_0xf7ff7bfffffff7ff(void) { return 0xf7ff7bfffffff7ffUL; }
unsigned long foo_0xefff7bfffffff7ff(void) { return 0xefff7bfffffff7ffUL; }
unsigned long foo_0xffdefbfffffff7ff(void) { return 0xffdefbfffffff7ffUL; }
unsigned long foo_0xff7efbfffffff7ff(void) { return 0xff7efbfffffff7ffUL; }
unsigned long foo_0xfdfefbfffffff7ff(void) { return 0xfdfefbfffffff7ffUL; }
unsigned long foo_0xf7fefbfffffff7ff(void) { return 0xf7fefbfffffff7ffUL; }
unsigned long foo_0xffddfbfffffff7ff(void) { return 0xffddfbfffffff7ffUL; }
unsigned long foo_0xffbdfbfffffff7ff(void) { return 0xffbdfbfffffff7ffUL; }
unsigned long foo_0xff7dfbfffffff7ff(void) { return 0xff7dfbfffffff7ffUL; }
unsigned long foo_0xfefdfbfffffff7ff(void) { return 0xfefdfbfffffff7ffUL; }
unsigned long foo_0xfdfdfbfffffff7ff(void) { return 0xfdfdfbfffffff7ffUL; }
unsigned long foo_0xfbfdfbfffffff7ff(void) { return 0xfbfdfbfffffff7ffUL; }
unsigned long foo_0xf7fdfbfffffff7ff(void) { return 0xf7fdfbfffffff7ffUL; }
unsigned long foo_0xeffdfbfffffff7ff(void) { return 0xeffdfbfffffff7ffUL; }
unsigned long foo_0xffdbfbfffffff7ff(void) { return 0xffdbfbfffffff7ffUL; }
unsigned long foo_0xff7bfbfffffff7ff(void) { return 0xff7bfbfffffff7ffUL; }
unsigned long foo_0xfdfbfbfffffff7ff(void) { return 0xfdfbfbfffffff7ffUL; }
unsigned long foo_0xf7fbfbfffffff7ff(void) { return 0xf7fbfbfffffff7ffUL; }
unsigned long foo_0xffd7fbfffffff7ff(void) { return 0xffd7fbfffffff7ffUL; }
unsigned long foo_0xffb7fbfffffff7ff(void) { return 0xffb7fbfffffff7ffUL; }
unsigned long foo_0xff77fbfffffff7ff(void) { return 0xff77fbfffffff7ffUL; }
unsigned long foo_0xfef7fbfffffff7ff(void) { return 0xfef7fbfffffff7ffUL; }
unsigned long foo_0xfdf7fbfffffff7ff(void) { return 0xfdf7fbfffffff7ffUL; }
unsigned long foo_0xfbf7fbfffffff7ff(void) { return 0xfbf7fbfffffff7ffUL; }
unsigned long foo_0xf7f7fbfffffff7ff(void) { return 0xf7f7fbfffffff7ffUL; }
unsigned long foo_0xeff7fbfffffff7ff(void) { return 0xeff7fbfffffff7ffUL; }
unsigned long foo_0xffcffbfffffff7ff(void) { return 0xffcffbfffffff7ffUL; }
unsigned long foo_0xff6ffbfffffff7ff(void) { return 0xff6ffbfffffff7ffUL; }
unsigned long foo_0xfdeffbfffffff7ff(void) { return 0xfdeffbfffffff7ffUL; }
unsigned long foo_0xf7effbfffffff7ff(void) { return 0xf7effbfffffff7ffUL; }
unsigned long foo_0xff9ffbfffffff7ff(void) { return 0xff9ffbfffffff7ffUL; }
unsigned long foo_0xff5ffbfffffff7ff(void) { return 0xff5ffbfffffff7ffUL; }
unsigned long foo_0xfedffbfffffff7ff(void) { return 0xfedffbfffffff7ffUL; }
unsigned long foo_0xfddffbfffffff7ff(void) { return 0xfddffbfffffff7ffUL; }
unsigned long foo_0xfbdffbfffffff7ff(void) { return 0xfbdffbfffffff7ffUL; }
unsigned long foo_0xf7dffbfffffff7ff(void) { return 0xf7dffbfffffff7ffUL; }
unsigned long foo_0xefdffbfffffff7ff(void) { return 0xefdffbfffffff7ffUL; }
unsigned long foo_0xff3ffbfffffff7ff(void) { return 0xff3ffbfffffff7ffUL; }
unsigned long foo_0xfdbffbfffffff7ff(void) { return 0xfdbffbfffffff7ffUL; }
unsigned long foo_0xf7bffbfffffff7ff(void) { return 0xf7bffbfffffff7ffUL; }
unsigned long foo_0xfe7ffbfffffff7ff(void) { return 0xfe7ffbfffffff7ffUL; }
unsigned long foo_0xfd7ffbfffffff7ff(void) { return 0xfd7ffbfffffff7ffUL; }
unsigned long foo_0xfb7ffbfffffff7ff(void) { return 0xfb7ffbfffffff7ffUL; }
unsigned long foo_0xf77ffbfffffff7ff(void) { return 0xf77ffbfffffff7ffUL; }
unsigned long foo_0xef7ffbfffffff7ff(void) { return 0xef7ffbfffffff7ffUL; }
unsigned long foo_0xfcfffbfffffff7ff(void) { return 0xfcfffbfffffff7ffUL; }
unsigned long foo_0xf6fffbfffffff7ff(void) { return 0xf6fffbfffffff7ffUL; }
unsigned long foo_0xf9fffbfffffff7ff(void) { return 0xf9fffbfffffff7ffUL; }
unsigned long foo_0xf5fffbfffffff7ff(void) { return 0xf5fffbfffffff7ffUL; }
unsigned long foo_0xedfffbfffffff7ff(void) { return 0xedfffbfffffff7ffUL; }
unsigned long foo_0xf3fffbfffffff7ff(void) { return 0xf3fffbfffffff7ffUL; }
unsigned long foo_0xe7fffbfffffff7ff(void) { return 0xe7fffbfffffff7ffUL; }
unsigned long foo_0xffbfe7fffffff7ff(void) { return 0xffbfe7fffffff7ffUL; }
unsigned long foo_0xff7fe7fffffff7ff(void) { return 0xff7fe7fffffff7ffUL; }
unsigned long foo_0xfeffe7fffffff7ff(void) { return 0xfeffe7fffffff7ffUL; }
unsigned long foo_0xfdffe7fffffff7ff(void) { return 0xfdffe7fffffff7ffUL; }
unsigned long foo_0xfbffe7fffffff7ff(void) { return 0xfbffe7fffffff7ffUL; }
unsigned long foo_0xf7ffe7fffffff7ff(void) { return 0xf7ffe7fffffff7ffUL; }
unsigned long foo_0xefffe7fffffff7ff(void) { return 0xefffe7fffffff7ffUL; }
unsigned long foo_0xdfffe7fffffff7ff(void) { return 0xdfffe7fffffff7ffUL; }
unsigned long foo_0xffbfd7fffffff7ff(void) { return 0xffbfd7fffffff7ffUL; }
unsigned long foo_0xfeffd7fffffff7ff(void) { return 0xfeffd7fffffff7ffUL; }
unsigned long foo_0xfbffd7fffffff7ff(void) { return 0xfbffd7fffffff7ffUL; }
unsigned long foo_0xefffd7fffffff7ff(void) { return 0xefffd7fffffff7ffUL; }
unsigned long foo_0x7fffd7fffffff7ff(void) { return 0x7fffd7fffffff7ffUL; }
unsigned long foo_0xffbfb7fffffff7ff(void) { return 0xffbfb7fffffff7ffUL; }
unsigned long foo_0xff7fb7fffffff7ff(void) { return 0xff7fb7fffffff7ffUL; }
unsigned long foo_0xfeffb7fffffff7ff(void) { return 0xfeffb7fffffff7ffUL; }
unsigned long foo_0xfdffb7fffffff7ff(void) { return 0xfdffb7fffffff7ffUL; }
unsigned long foo_0xfbffb7fffffff7ff(void) { return 0xfbffb7fffffff7ffUL; }
unsigned long foo_0xf7ffb7fffffff7ff(void) { return 0xf7ffb7fffffff7ffUL; }
unsigned long foo_0xefffb7fffffff7ff(void) { return 0xefffb7fffffff7ffUL; }
unsigned long foo_0xdfffb7fffffff7ff(void) { return 0xdfffb7fffffff7ffUL; }
unsigned long foo_0x7fffb7fffffff7ff(void) { return 0x7fffb7fffffff7ffUL; }
unsigned long foo_0xffbf77fffffff7ff(void) { return 0xffbf77fffffff7ffUL; }
unsigned long foo_0xfeff77fffffff7ff(void) { return 0xfeff77fffffff7ffUL; }
unsigned long foo_0xfbff77fffffff7ff(void) { return 0xfbff77fffffff7ffUL; }
unsigned long foo_0xefff77fffffff7ff(void) { return 0xefff77fffffff7ffUL; }
unsigned long foo_0x7fff77fffffff7ff(void) { return 0x7fff77fffffff7ffUL; }
unsigned long foo_0xffbef7fffffff7ff(void) { return 0xffbef7fffffff7ffUL; }
unsigned long foo_0xff7ef7fffffff7ff(void) { return 0xff7ef7fffffff7ffUL; }
unsigned long foo_0xfefef7fffffff7ff(void) { return 0xfefef7fffffff7ffUL; }
unsigned long foo_0xfdfef7fffffff7ff(void) { return 0xfdfef7fffffff7ffUL; }
unsigned long foo_0xfbfef7fffffff7ff(void) { return 0xfbfef7fffffff7ffUL; }
unsigned long foo_0xf7fef7fffffff7ff(void) { return 0xf7fef7fffffff7ffUL; }
unsigned long foo_0xeffef7fffffff7ff(void) { return 0xeffef7fffffff7ffUL; }
unsigned long foo_0xdffef7fffffff7ff(void) { return 0xdffef7fffffff7ffUL; }
unsigned long foo_0x7ffef7fffffff7ff(void) { return 0x7ffef7fffffff7ffUL; }
unsigned long foo_0xffbdf7fffffff7ff(void) { return 0xffbdf7fffffff7ffUL; }
unsigned long foo_0xfefdf7fffffff7ff(void) { return 0xfefdf7fffffff7ffUL; }
unsigned long foo_0xfbfdf7fffffff7ff(void) { return 0xfbfdf7fffffff7ffUL; }
unsigned long foo_0xeffdf7fffffff7ff(void) { return 0xeffdf7fffffff7ffUL; }
unsigned long foo_0x7ffdf7fffffff7ff(void) { return 0x7ffdf7fffffff7ffUL; }
unsigned long foo_0xffbbf7fffffff7ff(void) { return 0xffbbf7fffffff7ffUL; }
unsigned long foo_0xff7bf7fffffff7ff(void) { return 0xff7bf7fffffff7ffUL; }
unsigned long foo_0xfefbf7fffffff7ff(void) { return 0xfefbf7fffffff7ffUL; }
unsigned long foo_0xfdfbf7fffffff7ff(void) { return 0xfdfbf7fffffff7ffUL; }
unsigned long foo_0xfbfbf7fffffff7ff(void) { return 0xfbfbf7fffffff7ffUL; }
unsigned long foo_0xf7fbf7fffffff7ff(void) { return 0xf7fbf7fffffff7ffUL; }
unsigned long foo_0xeffbf7fffffff7ff(void) { return 0xeffbf7fffffff7ffUL; }
unsigned long foo_0xdffbf7fffffff7ff(void) { return 0xdffbf7fffffff7ffUL; }
unsigned long foo_0x7ffbf7fffffff7ff(void) { return 0x7ffbf7fffffff7ffUL; }
unsigned long foo_0xffb7f7fffffff7ff(void) { return 0xffb7f7fffffff7ffUL; }
unsigned long foo_0xfef7f7fffffff7ff(void) { return 0xfef7f7fffffff7ffUL; }
unsigned long foo_0xfbf7f7fffffff7ff(void) { return 0xfbf7f7fffffff7ffUL; }
unsigned long foo_0xeff7f7fffffff7ff(void) { return 0xeff7f7fffffff7ffUL; }
unsigned long foo_0x7ff7f7fffffff7ff(void) { return 0x7ff7f7fffffff7ffUL; }
unsigned long foo_0xffaff7fffffff7ff(void) { return 0xffaff7fffffff7ffUL; }
unsigned long foo_0xff6ff7fffffff7ff(void) { return 0xff6ff7fffffff7ffUL; }
unsigned long foo_0xfeeff7fffffff7ff(void) { return 0xfeeff7fffffff7ffUL; }
unsigned long foo_0xfdeff7fffffff7ff(void) { return 0xfdeff7fffffff7ffUL; }
unsigned long foo_0xfbeff7fffffff7ff(void) { return 0xfbeff7fffffff7ffUL; }
unsigned long foo_0xf7eff7fffffff7ff(void) { return 0xf7eff7fffffff7ffUL; }
unsigned long foo_0xefeff7fffffff7ff(void) { return 0xefeff7fffffff7ffUL; }
unsigned long foo_0xdfeff7fffffff7ff(void) { return 0xdfeff7fffffff7ffUL; }
unsigned long foo_0x7feff7fffffff7ff(void) { return 0x7feff7fffffff7ffUL; }
unsigned long foo_0xff9ff7fffffff7ff(void) { return 0xff9ff7fffffff7ffUL; }
unsigned long foo_0xfedff7fffffff7ff(void) { return 0xfedff7fffffff7ffUL; }
unsigned long foo_0xfbdff7fffffff7ff(void) { return 0xfbdff7fffffff7ffUL; }
unsigned long foo_0xefdff7fffffff7ff(void) { return 0xefdff7fffffff7ffUL; }
unsigned long foo_0x7fdff7fffffff7ff(void) { return 0x7fdff7fffffff7ffUL; }
unsigned long foo_0xff3ff7fffffff7ff(void) { return 0xff3ff7fffffff7ffUL; }
unsigned long foo_0xfebff7fffffff7ff(void) { return 0xfebff7fffffff7ffUL; }
unsigned long foo_0xfdbff7fffffff7ff(void) { return 0xfdbff7fffffff7ffUL; }
unsigned long foo_0xfbbff7fffffff7ff(void) { return 0xfbbff7fffffff7ffUL; }
unsigned long foo_0xf7bff7fffffff7ff(void) { return 0xf7bff7fffffff7ffUL; }
unsigned long foo_0xefbff7fffffff7ff(void) { return 0xefbff7fffffff7ffUL; }
unsigned long foo_0xdfbff7fffffff7ff(void) { return 0xdfbff7fffffff7ffUL; }
unsigned long foo_0x7fbff7fffffff7ff(void) { return 0x7fbff7fffffff7ffUL; }
unsigned long foo_0xfe7ff7fffffff7ff(void) { return 0xfe7ff7fffffff7ffUL; }
unsigned long foo_0xfb7ff7fffffff7ff(void) { return 0xfb7ff7fffffff7ffUL; }
unsigned long foo_0xef7ff7fffffff7ff(void) { return 0xef7ff7fffffff7ffUL; }
unsigned long foo_0x7f7ff7fffffff7ff(void) { return 0x7f7ff7fffffff7ffUL; }
unsigned long foo_0xfcfff7fffffff7ff(void) { return 0xfcfff7fffffff7ffUL; }
unsigned long foo_0xfafff7fffffff7ff(void) { return 0xfafff7fffffff7ffUL; }
unsigned long foo_0xf6fff7fffffff7ff(void) { return 0xf6fff7fffffff7ffUL; }
unsigned long foo_0xeefff7fffffff7ff(void) { return 0xeefff7fffffff7ffUL; }
unsigned long foo_0xdefff7fffffff7ff(void) { return 0xdefff7fffffff7ffUL; }
unsigned long foo_0x7efff7fffffff7ff(void) { return 0x7efff7fffffff7ffUL; }
unsigned long foo_0xf9fff7fffffff7ff(void) { return 0xf9fff7fffffff7ffUL; }
unsigned long foo_0xedfff7fffffff7ff(void) { return 0xedfff7fffffff7ffUL; }
unsigned long foo_0x7dfff7fffffff7ff(void) { return 0x7dfff7fffffff7ffUL; }
unsigned long foo_0xf3fff7fffffff7ff(void) { return 0xf3fff7fffffff7ffUL; }
unsigned long foo_0xebfff7fffffff7ff(void) { return 0xebfff7fffffff7ffUL; }
unsigned long foo_0xdbfff7fffffff7ff(void) { return 0xdbfff7fffffff7ffUL; }
unsigned long foo_0x7bfff7fffffff7ff(void) { return 0x7bfff7fffffff7ffUL; }
unsigned long foo_0xe7fff7fffffff7ff(void) { return 0xe7fff7fffffff7ffUL; }
unsigned long foo_0x77fff7fffffff7ff(void) { return 0x77fff7fffffff7ffUL; }
unsigned long foo_0xcffff7fffffff7ff(void) { return 0xcffff7fffffff7ffUL; }
unsigned long foo_0x6ffff7fffffff7ff(void) { return 0x6ffff7fffffff7ffUL; }
unsigned long foo_0x5ffff7fffffff7ff(void) { return 0x5ffff7fffffff7ffUL; }
unsigned long foo_0xff7fcffffffff7ff(void) { return 0xff7fcffffffff7ffUL; }
unsigned long foo_0xfeffcffffffff7ff(void) { return 0xfeffcffffffff7ffUL; }
unsigned long foo_0xfdffcffffffff7ff(void) { return 0xfdffcffffffff7ffUL; }
unsigned long foo_0xfbffcffffffff7ff(void) { return 0xfbffcffffffff7ffUL; }
unsigned long foo_0xf7ffcffffffff7ff(void) { return 0xf7ffcffffffff7ffUL; }
unsigned long foo_0xefffcffffffff7ff(void) { return 0xefffcffffffff7ffUL; }
unsigned long foo_0xdfffcffffffff7ff(void) { return 0xdfffcffffffff7ffUL; }
unsigned long foo_0xbfffcffffffff7ff(void) { return 0xbfffcffffffff7ffUL; }
unsigned long foo_0xff7faffffffff7ff(void) { return 0xff7faffffffff7ffUL; }
unsigned long foo_0xfdffaffffffff7ff(void) { return 0xfdffaffffffff7ffUL; }
unsigned long foo_0xf7ffaffffffff7ff(void) { return 0xf7ffaffffffff7ffUL; }
unsigned long foo_0xdfffaffffffff7ff(void) { return 0xdfffaffffffff7ffUL; }
unsigned long foo_0xff7f6ffffffff7ff(void) { return 0xff7f6ffffffff7ffUL; }
unsigned long foo_0xfeff6ffffffff7ff(void) { return 0xfeff6ffffffff7ffUL; }
unsigned long foo_0xfdff6ffffffff7ff(void) { return 0xfdff6ffffffff7ffUL; }
unsigned long foo_0xfbff6ffffffff7ff(void) { return 0xfbff6ffffffff7ffUL; }
unsigned long foo_0xf7ff6ffffffff7ff(void) { return 0xf7ff6ffffffff7ffUL; }
unsigned long foo_0xefff6ffffffff7ff(void) { return 0xefff6ffffffff7ffUL; }
unsigned long foo_0xdfff6ffffffff7ff(void) { return 0xdfff6ffffffff7ffUL; }
unsigned long foo_0xbfff6ffffffff7ff(void) { return 0xbfff6ffffffff7ffUL; }
unsigned long foo_0x7fff6ffffffff7ff(void) { return 0x7fff6ffffffff7ffUL; }
unsigned long foo_0xff7eeffffffff7ff(void) { return 0xff7eeffffffff7ffUL; }
unsigned long foo_0xfdfeeffffffff7ff(void) { return 0xfdfeeffffffff7ffUL; }
unsigned long foo_0xf7feeffffffff7ff(void) { return 0xf7feeffffffff7ffUL; }
unsigned long foo_0xdffeeffffffff7ff(void) { return 0xdffeeffffffff7ffUL; }
unsigned long foo_0xff7deffffffff7ff(void) { return 0xff7deffffffff7ffUL; }
unsigned long foo_0xfefdeffffffff7ff(void) { return 0xfefdeffffffff7ffUL; }
unsigned long foo_0xfdfdeffffffff7ff(void) { return 0xfdfdeffffffff7ffUL; }
unsigned long foo_0xfbfdeffffffff7ff(void) { return 0xfbfdeffffffff7ffUL; }
unsigned long foo_0xf7fdeffffffff7ff(void) { return 0xf7fdeffffffff7ffUL; }
unsigned long foo_0xeffdeffffffff7ff(void) { return 0xeffdeffffffff7ffUL; }
unsigned long foo_0xdffdeffffffff7ff(void) { return 0xdffdeffffffff7ffUL; }
unsigned long foo_0xbffdeffffffff7ff(void) { return 0xbffdeffffffff7ffUL; }
unsigned long foo_0x7ffdeffffffff7ff(void) { return 0x7ffdeffffffff7ffUL; }
unsigned long foo_0xff7beffffffff7ff(void) { return 0xff7beffffffff7ffUL; }
unsigned long foo_0xfdfbeffffffff7ff(void) { return 0xfdfbeffffffff7ffUL; }
unsigned long foo_0xf7fbeffffffff7ff(void) { return 0xf7fbeffffffff7ffUL; }
unsigned long foo_0xdffbeffffffff7ff(void) { return 0xdffbeffffffff7ffUL; }
unsigned long foo_0xff77effffffff7ff(void) { return 0xff77effffffff7ffUL; }
unsigned long foo_0xfef7effffffff7ff(void) { return 0xfef7effffffff7ffUL; }
unsigned long foo_0xfdf7effffffff7ff(void) { return 0xfdf7effffffff7ffUL; }
unsigned long foo_0xfbf7effffffff7ff(void) { return 0xfbf7effffffff7ffUL; }
unsigned long foo_0xf7f7effffffff7ff(void) { return 0xf7f7effffffff7ffUL; }
unsigned long foo_0xeff7effffffff7ff(void) { return 0xeff7effffffff7ffUL; }
unsigned long foo_0xdff7effffffff7ff(void) { return 0xdff7effffffff7ffUL; }
unsigned long foo_0xbff7effffffff7ff(void) { return 0xbff7effffffff7ffUL; }
unsigned long foo_0x7ff7effffffff7ff(void) { return 0x7ff7effffffff7ffUL; }
unsigned long foo_0xff6feffffffff7ff(void) { return 0xff6feffffffff7ffUL; }
unsigned long foo_0xfdefeffffffff7ff(void) { return 0xfdefeffffffff7ffUL; }
unsigned long foo_0xf7efeffffffff7ff(void) { return 0xf7efeffffffff7ffUL; }
unsigned long foo_0xdfefeffffffff7ff(void) { return 0xdfefeffffffff7ffUL; }
unsigned long foo_0xff5feffffffff7ff(void) { return 0xff5feffffffff7ffUL; }
unsigned long foo_0xfedfeffffffff7ff(void) { return 0xfedfeffffffff7ffUL; }
unsigned long foo_0xfddfeffffffff7ff(void) { return 0xfddfeffffffff7ffUL; }
unsigned long foo_0xfbdfeffffffff7ff(void) { return 0xfbdfeffffffff7ffUL; }
unsigned long foo_0xf7dfeffffffff7ff(void) { return 0xf7dfeffffffff7ffUL; }
unsigned long foo_0xefdfeffffffff7ff(void) { return 0xefdfeffffffff7ffUL; }
unsigned long foo_0xdfdfeffffffff7ff(void) { return 0xdfdfeffffffff7ffUL; }
unsigned long foo_0xbfdfeffffffff7ff(void) { return 0xbfdfeffffffff7ffUL; }
unsigned long foo_0x7fdfeffffffff7ff(void) { return 0x7fdfeffffffff7ffUL; }
unsigned long foo_0xff3feffffffff7ff(void) { return 0xff3feffffffff7ffUL; }
unsigned long foo_0xfdbfeffffffff7ff(void) { return 0xfdbfeffffffff7ffUL; }
unsigned long foo_0xf7bfeffffffff7ff(void) { return 0xf7bfeffffffff7ffUL; }
unsigned long foo_0xdfbfeffffffff7ff(void) { return 0xdfbfeffffffff7ffUL; }
unsigned long foo_0xfe7feffffffff7ff(void) { return 0xfe7feffffffff7ffUL; }
unsigned long foo_0xfd7feffffffff7ff(void) { return 0xfd7feffffffff7ffUL; }
unsigned long foo_0xfb7feffffffff7ff(void) { return 0xfb7feffffffff7ffUL; }
unsigned long foo_0xf77feffffffff7ff(void) { return 0xf77feffffffff7ffUL; }
unsigned long foo_0xef7feffffffff7ff(void) { return 0xef7feffffffff7ffUL; }
unsigned long foo_0xdf7feffffffff7ff(void) { return 0xdf7feffffffff7ffUL; }
unsigned long foo_0xbf7feffffffff7ff(void) { return 0xbf7feffffffff7ffUL; }
unsigned long foo_0x7f7feffffffff7ff(void) { return 0x7f7feffffffff7ffUL; }
unsigned long foo_0xfcffeffffffff7ff(void) { return 0xfcffeffffffff7ffUL; }
unsigned long foo_0xf6ffeffffffff7ff(void) { return 0xf6ffeffffffff7ffUL; }
unsigned long foo_0xdeffeffffffff7ff(void) { return 0xdeffeffffffff7ffUL; }
unsigned long foo_0xf9ffeffffffff7ff(void) { return 0xf9ffeffffffff7ffUL; }
unsigned long foo_0xf5ffeffffffff7ff(void) { return 0xf5ffeffffffff7ffUL; }
unsigned long foo_0xedffeffffffff7ff(void) { return 0xedffeffffffff7ffUL; }
unsigned long foo_0xddffeffffffff7ff(void) { return 0xddffeffffffff7ffUL; }
unsigned long foo_0xbdffeffffffff7ff(void) { return 0xbdffeffffffff7ffUL; }
unsigned long foo_0x7dffeffffffff7ff(void) { return 0x7dffeffffffff7ffUL; }
unsigned long foo_0xf3ffeffffffff7ff(void) { return 0xf3ffeffffffff7ffUL; }
unsigned long foo_0xdbffeffffffff7ff(void) { return 0xdbffeffffffff7ffUL; }
unsigned long foo_0xe7ffeffffffff7ff(void) { return 0xe7ffeffffffff7ffUL; }
unsigned long foo_0xd7ffeffffffff7ff(void) { return 0xd7ffeffffffff7ffUL; }
unsigned long foo_0xb7ffeffffffff7ff(void) { return 0xb7ffeffffffff7ffUL; }
unsigned long foo_0x77ffeffffffff7ff(void) { return 0x77ffeffffffff7ffUL; }
unsigned long foo_0xcfffeffffffff7ff(void) { return 0xcfffeffffffff7ffUL; }
unsigned long foo_0x9fffeffffffff7ff(void) { return 0x9fffeffffffff7ffUL; }
unsigned long foo_0x5fffeffffffff7ff(void) { return 0x5fffeffffffff7ffUL; }
unsigned long foo_0xfeff9ffffffff7ff(void) { return 0xfeff9ffffffff7ffUL; }
unsigned long foo_0xfdff9ffffffff7ff(void) { return 0xfdff9ffffffff7ffUL; }
unsigned long foo_0xfbff9ffffffff7ff(void) { return 0xfbff9ffffffff7ffUL; }
unsigned long foo_0xf7ff9ffffffff7ff(void) { return 0xf7ff9ffffffff7ffUL; }
unsigned long foo_0xefff9ffffffff7ff(void) { return 0xefff9ffffffff7ffUL; }
unsigned long foo_0xdfff9ffffffff7ff(void) { return 0xdfff9ffffffff7ffUL; }
unsigned long foo_0xbfff9ffffffff7ff(void) { return 0xbfff9ffffffff7ffUL; }
unsigned long foo_0xfeff5ffffffff7ff(void) { return 0xfeff5ffffffff7ffUL; }
unsigned long foo_0xfbff5ffffffff7ff(void) { return 0xfbff5ffffffff7ffUL; }
unsigned long foo_0xefff5ffffffff7ff(void) { return 0xefff5ffffffff7ffUL; }
unsigned long foo_0xbfff5ffffffff7ff(void) { return 0xbfff5ffffffff7ffUL; }
unsigned long foo_0x7fff5ffffffff7ff(void) { return 0x7fff5ffffffff7ffUL; }
unsigned long foo_0xfefedffffffff7ff(void) { return 0xfefedffffffff7ffUL; }
unsigned long foo_0xfdfedffffffff7ff(void) { return 0xfdfedffffffff7ffUL; }
unsigned long foo_0xfbfedffffffff7ff(void) { return 0xfbfedffffffff7ffUL; }
unsigned long foo_0xf7fedffffffff7ff(void) { return 0xf7fedffffffff7ffUL; }
unsigned long foo_0xeffedffffffff7ff(void) { return 0xeffedffffffff7ffUL; }
unsigned long foo_0xdffedffffffff7ff(void) { return 0xdffedffffffff7ffUL; }
unsigned long foo_0xbffedffffffff7ff(void) { return 0xbffedffffffff7ffUL; }
unsigned long foo_0x7ffedffffffff7ff(void) { return 0x7ffedffffffff7ffUL; }
unsigned long foo_0xfefddffffffff7ff(void) { return 0xfefddffffffff7ffUL; }
unsigned long foo_0xfbfddffffffff7ff(void) { return 0xfbfddffffffff7ffUL; }
unsigned long foo_0xeffddffffffff7ff(void) { return 0xeffddffffffff7ffUL; }
unsigned long foo_0xbffddffffffff7ff(void) { return 0xbffddffffffff7ffUL; }
unsigned long foo_0x7ffddffffffff7ff(void) { return 0x7ffddffffffff7ffUL; }
unsigned long foo_0xfefbdffffffff7ff(void) { return 0xfefbdffffffff7ffUL; }
unsigned long foo_0xfdfbdffffffff7ff(void) { return 0xfdfbdffffffff7ffUL; }
unsigned long foo_0xfbfbdffffffff7ff(void) { return 0xfbfbdffffffff7ffUL; }
unsigned long foo_0xf7fbdffffffff7ff(void) { return 0xf7fbdffffffff7ffUL; }
unsigned long foo_0xeffbdffffffff7ff(void) { return 0xeffbdffffffff7ffUL; }
unsigned long foo_0xdffbdffffffff7ff(void) { return 0xdffbdffffffff7ffUL; }
unsigned long foo_0xbffbdffffffff7ff(void) { return 0xbffbdffffffff7ffUL; }
unsigned long foo_0x7ffbdffffffff7ff(void) { return 0x7ffbdffffffff7ffUL; }
unsigned long foo_0xfef7dffffffff7ff(void) { return 0xfef7dffffffff7ffUL; }
unsigned long foo_0xfbf7dffffffff7ff(void) { return 0xfbf7dffffffff7ffUL; }
unsigned long foo_0xeff7dffffffff7ff(void) { return 0xeff7dffffffff7ffUL; }
unsigned long foo_0xbff7dffffffff7ff(void) { return 0xbff7dffffffff7ffUL; }
unsigned long foo_0x7ff7dffffffff7ff(void) { return 0x7ff7dffffffff7ffUL; }
unsigned long foo_0xfeefdffffffff7ff(void) { return 0xfeefdffffffff7ffUL; }
unsigned long foo_0xfdefdffffffff7ff(void) { return 0xfdefdffffffff7ffUL; }
unsigned long foo_0xfbefdffffffff7ff(void) { return 0xfbefdffffffff7ffUL; }
unsigned long foo_0xf7efdffffffff7ff(void) { return 0xf7efdffffffff7ffUL; }
unsigned long foo_0xefefdffffffff7ff(void) { return 0xefefdffffffff7ffUL; }
unsigned long foo_0xdfefdffffffff7ff(void) { return 0xdfefdffffffff7ffUL; }
unsigned long foo_0xbfefdffffffff7ff(void) { return 0xbfefdffffffff7ffUL; }
unsigned long foo_0x7fefdffffffff7ff(void) { return 0x7fefdffffffff7ffUL; }
unsigned long foo_0xfedfdffffffff7ff(void) { return 0xfedfdffffffff7ffUL; }
unsigned long foo_0xfbdfdffffffff7ff(void) { return 0xfbdfdffffffff7ffUL; }
unsigned long foo_0xefdfdffffffff7ff(void) { return 0xefdfdffffffff7ffUL; }
unsigned long foo_0xbfdfdffffffff7ff(void) { return 0xbfdfdffffffff7ffUL; }
unsigned long foo_0x7fdfdffffffff7ff(void) { return 0x7fdfdffffffff7ffUL; }
unsigned long foo_0xfebfdffffffff7ff(void) { return 0xfebfdffffffff7ffUL; }
unsigned long foo_0xfdbfdffffffff7ff(void) { return 0xfdbfdffffffff7ffUL; }
unsigned long foo_0xfbbfdffffffff7ff(void) { return 0xfbbfdffffffff7ffUL; }
unsigned long foo_0xf7bfdffffffff7ff(void) { return 0xf7bfdffffffff7ffUL; }
unsigned long foo_0xefbfdffffffff7ff(void) { return 0xefbfdffffffff7ffUL; }
unsigned long foo_0xdfbfdffffffff7ff(void) { return 0xdfbfdffffffff7ffUL; }
unsigned long foo_0xbfbfdffffffff7ff(void) { return 0xbfbfdffffffff7ffUL; }
unsigned long foo_0x7fbfdffffffff7ff(void) { return 0x7fbfdffffffff7ffUL; }
unsigned long foo_0xfe7fdffffffff7ff(void) { return 0xfe7fdffffffff7ffUL; }
unsigned long foo_0xfb7fdffffffff7ff(void) { return 0xfb7fdffffffff7ffUL; }
unsigned long foo_0xef7fdffffffff7ff(void) { return 0xef7fdffffffff7ffUL; }
unsigned long foo_0xbf7fdffffffff7ff(void) { return 0xbf7fdffffffff7ffUL; }
unsigned long foo_0x7f7fdffffffff7ff(void) { return 0x7f7fdffffffff7ffUL; }
unsigned long foo_0xfcffdffffffff7ff(void) { return 0xfcffdffffffff7ffUL; }
unsigned long foo_0xfaffdffffffff7ff(void) { return 0xfaffdffffffff7ffUL; }
unsigned long foo_0xf6ffdffffffff7ff(void) { return 0xf6ffdffffffff7ffUL; }
unsigned long foo_0xeeffdffffffff7ff(void) { return 0xeeffdffffffff7ffUL; }
unsigned long foo_0xdeffdffffffff7ff(void) { return 0xdeffdffffffff7ffUL; }
unsigned long foo_0xbeffdffffffff7ff(void) { return 0xbeffdffffffff7ffUL; }
unsigned long foo_0x7effdffffffff7ff(void) { return 0x7effdffffffff7ffUL; }
unsigned long foo_0xf9ffdffffffff7ff(void) { return 0xf9ffdffffffff7ffUL; }
unsigned long foo_0xedffdffffffff7ff(void) { return 0xedffdffffffff7ffUL; }
unsigned long foo_0xbdffdffffffff7ff(void) { return 0xbdffdffffffff7ffUL; }
unsigned long foo_0x7dffdffffffff7ff(void) { return 0x7dffdffffffff7ffUL; }
unsigned long foo_0xf3ffdffffffff7ff(void) { return 0xf3ffdffffffff7ffUL; }
unsigned long foo_0xebffdffffffff7ff(void) { return 0xebffdffffffff7ffUL; }
unsigned long foo_0xdbffdffffffff7ff(void) { return 0xdbffdffffffff7ffUL; }
unsigned long foo_0xbbffdffffffff7ff(void) { return 0xbbffdffffffff7ffUL; }
unsigned long foo_0x7bffdffffffff7ff(void) { return 0x7bffdffffffff7ffUL; }
unsigned long foo_0xe7ffdffffffff7ff(void) { return 0xe7ffdffffffff7ffUL; }
unsigned long foo_0xb7ffdffffffff7ff(void) { return 0xb7ffdffffffff7ffUL; }
unsigned long foo_0x77ffdffffffff7ff(void) { return 0x77ffdffffffff7ffUL; }
unsigned long foo_0xcfffdffffffff7ff(void) { return 0xcfffdffffffff7ffUL; }
unsigned long foo_0xafffdffffffff7ff(void) { return 0xafffdffffffff7ffUL; }
unsigned long foo_0x6fffdffffffff7ff(void) { return 0x6fffdffffffff7ffUL; }
unsigned long foo_0x9fffdffffffff7ff(void) { return 0x9fffdffffffff7ffUL; }
unsigned long foo_0x5fffdffffffff7ff(void) { return 0x5fffdffffffff7ffUL; }
unsigned long foo_0xfdff3ffffffff7ff(void) { return 0xfdff3ffffffff7ffUL; }
unsigned long foo_0xfbff3ffffffff7ff(void) { return 0xfbff3ffffffff7ffUL; }
unsigned long foo_0xf7ff3ffffffff7ff(void) { return 0xf7ff3ffffffff7ffUL; }
unsigned long foo_0xefff3ffffffff7ff(void) { return 0xefff3ffffffff7ffUL; }
unsigned long foo_0xdfff3ffffffff7ff(void) { return 0xdfff3ffffffff7ffUL; }
unsigned long foo_0xbfff3ffffffff7ff(void) { return 0xbfff3ffffffff7ffUL; }
unsigned long foo_0xfdfebffffffff7ff(void) { return 0xfdfebffffffff7ffUL; }
unsigned long foo_0xf7febffffffff7ff(void) { return 0xf7febffffffff7ffUL; }
unsigned long foo_0xdffebffffffff7ff(void) { return 0xdffebffffffff7ffUL; }
unsigned long foo_0xfdfdbffffffff7ff(void) { return 0xfdfdbffffffff7ffUL; }
unsigned long foo_0xfbfdbffffffff7ff(void) { return 0xfbfdbffffffff7ffUL; }
unsigned long foo_0xf7fdbffffffff7ff(void) { return 0xf7fdbffffffff7ffUL; }
unsigned long foo_0xeffdbffffffff7ff(void) { return 0xeffdbffffffff7ffUL; }
unsigned long foo_0xdffdbffffffff7ff(void) { return 0xdffdbffffffff7ffUL; }
unsigned long foo_0xbffdbffffffff7ff(void) { return 0xbffdbffffffff7ffUL; }
unsigned long foo_0x7ffdbffffffff7ff(void) { return 0x7ffdbffffffff7ffUL; }
unsigned long foo_0xfdfbbffffffff7ff(void) { return 0xfdfbbffffffff7ffUL; }
unsigned long foo_0xf7fbbffffffff7ff(void) { return 0xf7fbbffffffff7ffUL; }
unsigned long foo_0xdffbbffffffff7ff(void) { return 0xdffbbffffffff7ffUL; }
unsigned long foo_0xfdf7bffffffff7ff(void) { return 0xfdf7bffffffff7ffUL; }
unsigned long foo_0xfbf7bffffffff7ff(void) { return 0xfbf7bffffffff7ffUL; }
unsigned long foo_0xf7f7bffffffff7ff(void) { return 0xf7f7bffffffff7ffUL; }
unsigned long foo_0xeff7bffffffff7ff(void) { return 0xeff7bffffffff7ffUL; }
unsigned long foo_0xdff7bffffffff7ff(void) { return 0xdff7bffffffff7ffUL; }
unsigned long foo_0xbff7bffffffff7ff(void) { return 0xbff7bffffffff7ffUL; }
unsigned long foo_0x7ff7bffffffff7ff(void) { return 0x7ff7bffffffff7ffUL; }
unsigned long foo_0xfdefbffffffff7ff(void) { return 0xfdefbffffffff7ffUL; }
unsigned long foo_0xf7efbffffffff7ff(void) { return 0xf7efbffffffff7ffUL; }
unsigned long foo_0xdfefbffffffff7ff(void) { return 0xdfefbffffffff7ffUL; }
unsigned long foo_0xfddfbffffffff7ff(void) { return 0xfddfbffffffff7ffUL; }
unsigned long foo_0xfbdfbffffffff7ff(void) { return 0xfbdfbffffffff7ffUL; }
unsigned long foo_0xf7dfbffffffff7ff(void) { return 0xf7dfbffffffff7ffUL; }
unsigned long foo_0xefdfbffffffff7ff(void) { return 0xefdfbffffffff7ffUL; }
unsigned long foo_0xdfdfbffffffff7ff(void) { return 0xdfdfbffffffff7ffUL; }
unsigned long foo_0xbfdfbffffffff7ff(void) { return 0xbfdfbffffffff7ffUL; }
unsigned long foo_0x7fdfbffffffff7ff(void) { return 0x7fdfbffffffff7ffUL; }
unsigned long foo_0xfdbfbffffffff7ff(void) { return 0xfdbfbffffffff7ffUL; }
unsigned long foo_0xf7bfbffffffff7ff(void) { return 0xf7bfbffffffff7ffUL; }
unsigned long foo_0xdfbfbffffffff7ff(void) { return 0xdfbfbffffffff7ffUL; }
unsigned long foo_0xfd7fbffffffff7ff(void) { return 0xfd7fbffffffff7ffUL; }
unsigned long foo_0xfb7fbffffffff7ff(void) { return 0xfb7fbffffffff7ffUL; }
unsigned long foo_0xf77fbffffffff7ff(void) { return 0xf77fbffffffff7ffUL; }
unsigned long foo_0xef7fbffffffff7ff(void) { return 0xef7fbffffffff7ffUL; }
unsigned long foo_0xdf7fbffffffff7ff(void) { return 0xdf7fbffffffff7ffUL; }
unsigned long foo_0xbf7fbffffffff7ff(void) { return 0xbf7fbffffffff7ffUL; }
unsigned long foo_0x7f7fbffffffff7ff(void) { return 0x7f7fbffffffff7ffUL; }
unsigned long foo_0xfcffbffffffff7ff(void) { return 0xfcffbffffffff7ffUL; }
unsigned long foo_0xf6ffbffffffff7ff(void) { return 0xf6ffbffffffff7ffUL; }
unsigned long foo_0xdeffbffffffff7ff(void) { return 0xdeffbffffffff7ffUL; }
unsigned long foo_0xf9ffbffffffff7ff(void) { return 0xf9ffbffffffff7ffUL; }
unsigned long foo_0xf5ffbffffffff7ff(void) { return 0xf5ffbffffffff7ffUL; }
unsigned long foo_0xedffbffffffff7ff(void) { return 0xedffbffffffff7ffUL; }
unsigned long foo_0xddffbffffffff7ff(void) { return 0xddffbffffffff7ffUL; }
unsigned long foo_0xbdffbffffffff7ff(void) { return 0xbdffbffffffff7ffUL; }
unsigned long foo_0x7dffbffffffff7ff(void) { return 0x7dffbffffffff7ffUL; }
unsigned long foo_0xf3ffbffffffff7ff(void) { return 0xf3ffbffffffff7ffUL; }
unsigned long foo_0xdbffbffffffff7ff(void) { return 0xdbffbffffffff7ffUL; }
unsigned long foo_0xe7ffbffffffff7ff(void) { return 0xe7ffbffffffff7ffUL; }
unsigned long foo_0xd7ffbffffffff7ff(void) { return 0xd7ffbffffffff7ffUL; }
unsigned long foo_0xb7ffbffffffff7ff(void) { return 0xb7ffbffffffff7ffUL; }
unsigned long foo_0x77ffbffffffff7ff(void) { return 0x77ffbffffffff7ffUL; }
unsigned long foo_0xcfffbffffffff7ff(void) { return 0xcfffbffffffff7ffUL; }
unsigned long foo_0x9fffbffffffff7ff(void) { return 0x9fffbffffffff7ffUL; }
unsigned long foo_0x5fffbffffffff7ff(void) { return 0x5fffbffffffff7ffUL; }
unsigned long foo_0xfbfe7ffffffff7ff(void) { return 0xfbfe7ffffffff7ffUL; }
unsigned long foo_0xf7fe7ffffffff7ff(void) { return 0xf7fe7ffffffff7ffUL; }
unsigned long foo_0xeffe7ffffffff7ff(void) { return 0xeffe7ffffffff7ffUL; }
unsigned long foo_0xdffe7ffffffff7ff(void) { return 0xdffe7ffffffff7ffUL; }
unsigned long foo_0xbffe7ffffffff7ff(void) { return 0xbffe7ffffffff7ffUL; }
unsigned long foo_0xfbfd7ffffffff7ff(void) { return 0xfbfd7ffffffff7ffUL; }
unsigned long foo_0xeffd7ffffffff7ff(void) { return 0xeffd7ffffffff7ffUL; }
unsigned long foo_0xbffd7ffffffff7ff(void) { return 0xbffd7ffffffff7ffUL; }
unsigned long foo_0x7ffd7ffffffff7ff(void) { return 0x7ffd7ffffffff7ffUL; }
unsigned long foo_0xfbfb7ffffffff7ff(void) { return 0xfbfb7ffffffff7ffUL; }
unsigned long foo_0xf7fb7ffffffff7ff(void) { return 0xf7fb7ffffffff7ffUL; }
unsigned long foo_0xeffb7ffffffff7ff(void) { return 0xeffb7ffffffff7ffUL; }
unsigned long foo_0xdffb7ffffffff7ff(void) { return 0xdffb7ffffffff7ffUL; }
unsigned long foo_0xbffb7ffffffff7ff(void) { return 0xbffb7ffffffff7ffUL; }
unsigned long foo_0x7ffb7ffffffff7ff(void) { return 0x7ffb7ffffffff7ffUL; }
unsigned long foo_0xfbf77ffffffff7ff(void) { return 0xfbf77ffffffff7ffUL; }
unsigned long foo_0xeff77ffffffff7ff(void) { return 0xeff77ffffffff7ffUL; }
unsigned long foo_0xbff77ffffffff7ff(void) { return 0xbff77ffffffff7ffUL; }
unsigned long foo_0x7ff77ffffffff7ff(void) { return 0x7ff77ffffffff7ffUL; }
unsigned long foo_0xfbef7ffffffff7ff(void) { return 0xfbef7ffffffff7ffUL; }
unsigned long foo_0xf7ef7ffffffff7ff(void) { return 0xf7ef7ffffffff7ffUL; }
unsigned long foo_0xefef7ffffffff7ff(void) { return 0xefef7ffffffff7ffUL; }
unsigned long foo_0xdfef7ffffffff7ff(void) { return 0xdfef7ffffffff7ffUL; }
unsigned long foo_0xbfef7ffffffff7ff(void) { return 0xbfef7ffffffff7ffUL; }
unsigned long foo_0x7fef7ffffffff7ff(void) { return 0x7fef7ffffffff7ffUL; }
unsigned long foo_0xfbdf7ffffffff7ff(void) { return 0xfbdf7ffffffff7ffUL; }
unsigned long foo_0xefdf7ffffffff7ff(void) { return 0xefdf7ffffffff7ffUL; }
unsigned long foo_0xbfdf7ffffffff7ff(void) { return 0xbfdf7ffffffff7ffUL; }
unsigned long foo_0x7fdf7ffffffff7ff(void) { return 0x7fdf7ffffffff7ffUL; }
unsigned long foo_0xfbbf7ffffffff7ff(void) { return 0xfbbf7ffffffff7ffUL; }
unsigned long foo_0xf7bf7ffffffff7ff(void) { return 0xf7bf7ffffffff7ffUL; }
unsigned long foo_0xefbf7ffffffff7ff(void) { return 0xefbf7ffffffff7ffUL; }
unsigned long foo_0xdfbf7ffffffff7ff(void) { return 0xdfbf7ffffffff7ffUL; }
unsigned long foo_0xbfbf7ffffffff7ff(void) { return 0xbfbf7ffffffff7ffUL; }
unsigned long foo_0x7fbf7ffffffff7ff(void) { return 0x7fbf7ffffffff7ffUL; }
unsigned long foo_0xfb7f7ffffffff7ff(void) { return 0xfb7f7ffffffff7ffUL; }
unsigned long foo_0xef7f7ffffffff7ff(void) { return 0xef7f7ffffffff7ffUL; }
unsigned long foo_0xbf7f7ffffffff7ff(void) { return 0xbf7f7ffffffff7ffUL; }
unsigned long foo_0x7f7f7ffffffff7ff(void) { return 0x7f7f7ffffffff7ffUL; }
unsigned long foo_0xfaff7ffffffff7ff(void) { return 0xfaff7ffffffff7ffUL; }
unsigned long foo_0xf6ff7ffffffff7ff(void) { return 0xf6ff7ffffffff7ffUL; }
unsigned long foo_0xeeff7ffffffff7ff(void) { return 0xeeff7ffffffff7ffUL; }
unsigned long foo_0xdeff7ffffffff7ff(void) { return 0xdeff7ffffffff7ffUL; }
unsigned long foo_0xbeff7ffffffff7ff(void) { return 0xbeff7ffffffff7ffUL; }
unsigned long foo_0x7eff7ffffffff7ff(void) { return 0x7eff7ffffffff7ffUL; }
unsigned long foo_0xf9ff7ffffffff7ff(void) { return 0xf9ff7ffffffff7ffUL; }
unsigned long foo_0xedff7ffffffff7ff(void) { return 0xedff7ffffffff7ffUL; }
unsigned long foo_0xbdff7ffffffff7ff(void) { return 0xbdff7ffffffff7ffUL; }
unsigned long foo_0x7dff7ffffffff7ff(void) { return 0x7dff7ffffffff7ffUL; }
unsigned long foo_0xf3ff7ffffffff7ff(void) { return 0xf3ff7ffffffff7ffUL; }
unsigned long foo_0xebff7ffffffff7ff(void) { return 0xebff7ffffffff7ffUL; }
unsigned long foo_0xdbff7ffffffff7ff(void) { return 0xdbff7ffffffff7ffUL; }
unsigned long foo_0xbbff7ffffffff7ff(void) { return 0xbbff7ffffffff7ffUL; }
unsigned long foo_0x7bff7ffffffff7ff(void) { return 0x7bff7ffffffff7ffUL; }
unsigned long foo_0xe7ff7ffffffff7ff(void) { return 0xe7ff7ffffffff7ffUL; }
unsigned long foo_0xb7ff7ffffffff7ff(void) { return 0xb7ff7ffffffff7ffUL; }
unsigned long foo_0x77ff7ffffffff7ff(void) { return 0x77ff7ffffffff7ffUL; }
unsigned long foo_0xcfff7ffffffff7ff(void) { return 0xcfff7ffffffff7ffUL; }
unsigned long foo_0xafff7ffffffff7ff(void) { return 0xafff7ffffffff7ffUL; }
unsigned long foo_0x6fff7ffffffff7ff(void) { return 0x6fff7ffffffff7ffUL; }
unsigned long foo_0x9fff7ffffffff7ff(void) { return 0x9fff7ffffffff7ffUL; }
unsigned long foo_0x5fff7ffffffff7ff(void) { return 0x5fff7ffffffff7ffUL; }
unsigned long foo_0xf7fcfffffffff7ff(void) { return 0xf7fcfffffffff7ffUL; }
unsigned long foo_0xeffcfffffffff7ff(void) { return 0xeffcfffffffff7ffUL; }
unsigned long foo_0xdffcfffffffff7ff(void) { return 0xdffcfffffffff7ffUL; }
unsigned long foo_0xbffcfffffffff7ff(void) { return 0xbffcfffffffff7ffUL; }
unsigned long foo_0xf7fafffffffff7ff(void) { return 0xf7fafffffffff7ffUL; }
unsigned long foo_0xdffafffffffff7ff(void) { return 0xdffafffffffff7ffUL; }
unsigned long foo_0xf7f6fffffffff7ff(void) { return 0xf7f6fffffffff7ffUL; }
unsigned long foo_0xeff6fffffffff7ff(void) { return 0xeff6fffffffff7ffUL; }
unsigned long foo_0xdff6fffffffff7ff(void) { return 0xdff6fffffffff7ffUL; }
unsigned long foo_0xbff6fffffffff7ff(void) { return 0xbff6fffffffff7ffUL; }
unsigned long foo_0x7ff6fffffffff7ff(void) { return 0x7ff6fffffffff7ffUL; }
unsigned long foo_0xf7eefffffffff7ff(void) { return 0xf7eefffffffff7ffUL; }
unsigned long foo_0xdfeefffffffff7ff(void) { return 0xdfeefffffffff7ffUL; }
unsigned long foo_0xf7defffffffff7ff(void) { return 0xf7defffffffff7ffUL; }
unsigned long foo_0xefdefffffffff7ff(void) { return 0xefdefffffffff7ffUL; }
unsigned long foo_0xdfdefffffffff7ff(void) { return 0xdfdefffffffff7ffUL; }
unsigned long foo_0xbfdefffffffff7ff(void) { return 0xbfdefffffffff7ffUL; }
unsigned long foo_0x7fdefffffffff7ff(void) { return 0x7fdefffffffff7ffUL; }
unsigned long foo_0xf7befffffffff7ff(void) { return 0xf7befffffffff7ffUL; }
unsigned long foo_0xdfbefffffffff7ff(void) { return 0xdfbefffffffff7ffUL; }
unsigned long foo_0xf77efffffffff7ff(void) { return 0xf77efffffffff7ffUL; }
unsigned long foo_0xef7efffffffff7ff(void) { return 0xef7efffffffff7ffUL; }
unsigned long foo_0xdf7efffffffff7ff(void) { return 0xdf7efffffffff7ffUL; }
unsigned long foo_0xbf7efffffffff7ff(void) { return 0xbf7efffffffff7ffUL; }
unsigned long foo_0x7f7efffffffff7ff(void) { return 0x7f7efffffffff7ffUL; }
unsigned long foo_0xf6fefffffffff7ff(void) { return 0xf6fefffffffff7ffUL; }
unsigned long foo_0xdefefffffffff7ff(void) { return 0xdefefffffffff7ffUL; }
unsigned long foo_0xf5fefffffffff7ff(void) { return 0xf5fefffffffff7ffUL; }
unsigned long foo_0xedfefffffffff7ff(void) { return 0xedfefffffffff7ffUL; }
unsigned long foo_0xddfefffffffff7ff(void) { return 0xddfefffffffff7ffUL; }
unsigned long foo_0xbdfefffffffff7ff(void) { return 0xbdfefffffffff7ffUL; }
unsigned long foo_0x7dfefffffffff7ff(void) { return 0x7dfefffffffff7ffUL; }
unsigned long foo_0xf3fefffffffff7ff(void) { return 0xf3fefffffffff7ffUL; }
unsigned long foo_0xdbfefffffffff7ff(void) { return 0xdbfefffffffff7ffUL; }
unsigned long foo_0xe7fefffffffff7ff(void) { return 0xe7fefffffffff7ffUL; }
unsigned long foo_0xd7fefffffffff7ff(void) { return 0xd7fefffffffff7ffUL; }
unsigned long foo_0xb7fefffffffff7ff(void) { return 0xb7fefffffffff7ffUL; }
unsigned long foo_0x77fefffffffff7ff(void) { return 0x77fefffffffff7ffUL; }
unsigned long foo_0xcffefffffffff7ff(void) { return 0xcffefffffffff7ffUL; }
unsigned long foo_0x9ffefffffffff7ff(void) { return 0x9ffefffffffff7ffUL; }
unsigned long foo_0x5ffefffffffff7ff(void) { return 0x5ffefffffffff7ffUL; }
unsigned long foo_0xeff9fffffffff7ff(void) { return 0xeff9fffffffff7ffUL; }
unsigned long foo_0xdff9fffffffff7ff(void) { return 0xdff9fffffffff7ffUL; }
unsigned long foo_0xbff9fffffffff7ff(void) { return 0xbff9fffffffff7ffUL; }
unsigned long foo_0xeff5fffffffff7ff(void) { return 0xeff5fffffffff7ffUL; }
unsigned long foo_0xbff5fffffffff7ff(void) { return 0xbff5fffffffff7ffUL; }
unsigned long foo_0x7ff5fffffffff7ff(void) { return 0x7ff5fffffffff7ffUL; }
unsigned long foo_0xefedfffffffff7ff(void) { return 0xefedfffffffff7ffUL; }
unsigned long foo_0xdfedfffffffff7ff(void) { return 0xdfedfffffffff7ffUL; }
unsigned long foo_0xbfedfffffffff7ff(void) { return 0xbfedfffffffff7ffUL; }
unsigned long foo_0x7fedfffffffff7ff(void) { return 0x7fedfffffffff7ffUL; }
unsigned long foo_0xefddfffffffff7ff(void) { return 0xefddfffffffff7ffUL; }
unsigned long foo_0xbfddfffffffff7ff(void) { return 0xbfddfffffffff7ffUL; }
unsigned long foo_0x7fddfffffffff7ff(void) { return 0x7fddfffffffff7ffUL; }
unsigned long foo_0xefbdfffffffff7ff(void) { return 0xefbdfffffffff7ffUL; }
unsigned long foo_0xdfbdfffffffff7ff(void) { return 0xdfbdfffffffff7ffUL; }
unsigned long foo_0xbfbdfffffffff7ff(void) { return 0xbfbdfffffffff7ffUL; }
unsigned long foo_0x7fbdfffffffff7ff(void) { return 0x7fbdfffffffff7ffUL; }
unsigned long foo_0xef7dfffffffff7ff(void) { return 0xef7dfffffffff7ffUL; }
unsigned long foo_0xbf7dfffffffff7ff(void) { return 0xbf7dfffffffff7ffUL; }
unsigned long foo_0x7f7dfffffffff7ff(void) { return 0x7f7dfffffffff7ffUL; }
unsigned long foo_0xeefdfffffffff7ff(void) { return 0xeefdfffffffff7ffUL; }
unsigned long foo_0xdefdfffffffff7ff(void) { return 0xdefdfffffffff7ffUL; }
unsigned long foo_0xbefdfffffffff7ff(void) { return 0xbefdfffffffff7ffUL; }
unsigned long foo_0x7efdfffffffff7ff(void) { return 0x7efdfffffffff7ffUL; }
unsigned long foo_0xedfdfffffffff7ff(void) { return 0xedfdfffffffff7ffUL; }
unsigned long foo_0xbdfdfffffffff7ff(void) { return 0xbdfdfffffffff7ffUL; }
unsigned long foo_0x7dfdfffffffff7ff(void) { return 0x7dfdfffffffff7ffUL; }
unsigned long foo_0xebfdfffffffff7ff(void) { return 0xebfdfffffffff7ffUL; }
unsigned long foo_0xdbfdfffffffff7ff(void) { return 0xdbfdfffffffff7ffUL; }
unsigned long foo_0xbbfdfffffffff7ff(void) { return 0xbbfdfffffffff7ffUL; }
unsigned long foo_0x7bfdfffffffff7ff(void) { return 0x7bfdfffffffff7ffUL; }
unsigned long foo_0xe7fdfffffffff7ff(void) { return 0xe7fdfffffffff7ffUL; }
unsigned long foo_0xb7fdfffffffff7ff(void) { return 0xb7fdfffffffff7ffUL; }
unsigned long foo_0x77fdfffffffff7ff(void) { return 0x77fdfffffffff7ffUL; }
unsigned long foo_0xcffdfffffffff7ff(void) { return 0xcffdfffffffff7ffUL; }
unsigned long foo_0xaffdfffffffff7ff(void) { return 0xaffdfffffffff7ffUL; }
unsigned long foo_0x6ffdfffffffff7ff(void) { return 0x6ffdfffffffff7ffUL; }
unsigned long foo_0x9ffdfffffffff7ff(void) { return 0x9ffdfffffffff7ffUL; }
unsigned long foo_0x5ffdfffffffff7ff(void) { return 0x5ffdfffffffff7ffUL; }
unsigned long foo_0xdff3fffffffff7ff(void) { return 0xdff3fffffffff7ffUL; }
unsigned long foo_0xbff3fffffffff7ff(void) { return 0xbff3fffffffff7ffUL; }
unsigned long foo_0xdfebfffffffff7ff(void) { return 0xdfebfffffffff7ffUL; }
unsigned long foo_0xdfdbfffffffff7ff(void) { return 0xdfdbfffffffff7ffUL; }
unsigned long foo_0xbfdbfffffffff7ff(void) { return 0xbfdbfffffffff7ffUL; }
unsigned long foo_0x7fdbfffffffff7ff(void) { return 0x7fdbfffffffff7ffUL; }
unsigned long foo_0xdfbbfffffffff7ff(void) { return 0xdfbbfffffffff7ffUL; }
unsigned long foo_0xdf7bfffffffff7ff(void) { return 0xdf7bfffffffff7ffUL; }
unsigned long foo_0xbf7bfffffffff7ff(void) { return 0xbf7bfffffffff7ffUL; }
unsigned long foo_0x7f7bfffffffff7ff(void) { return 0x7f7bfffffffff7ffUL; }
unsigned long foo_0xdefbfffffffff7ff(void) { return 0xdefbfffffffff7ffUL; }
unsigned long foo_0xddfbfffffffff7ff(void) { return 0xddfbfffffffff7ffUL; }
unsigned long foo_0xbdfbfffffffff7ff(void) { return 0xbdfbfffffffff7ffUL; }
unsigned long foo_0x7dfbfffffffff7ff(void) { return 0x7dfbfffffffff7ffUL; }
unsigned long foo_0xdbfbfffffffff7ff(void) { return 0xdbfbfffffffff7ffUL; }
unsigned long foo_0xd7fbfffffffff7ff(void) { return 0xd7fbfffffffff7ffUL; }
unsigned long foo_0xb7fbfffffffff7ff(void) { return 0xb7fbfffffffff7ffUL; }
unsigned long foo_0x77fbfffffffff7ff(void) { return 0x77fbfffffffff7ffUL; }
unsigned long foo_0xcffbfffffffff7ff(void) { return 0xcffbfffffffff7ffUL; }
unsigned long foo_0x9ffbfffffffff7ff(void) { return 0x9ffbfffffffff7ffUL; }
unsigned long foo_0x5ffbfffffffff7ff(void) { return 0x5ffbfffffffff7ffUL; }
unsigned long foo_0xbfe7fffffffff7ff(void) { return 0xbfe7fffffffff7ffUL; }
unsigned long foo_0xbfd7fffffffff7ff(void) { return 0xbfd7fffffffff7ffUL; }
unsigned long foo_0x7fd7fffffffff7ff(void) { return 0x7fd7fffffffff7ffUL; }
unsigned long foo_0xbfb7fffffffff7ff(void) { return 0xbfb7fffffffff7ffUL; }
unsigned long foo_0x7fb7fffffffff7ff(void) { return 0x7fb7fffffffff7ffUL; }
unsigned long foo_0xbf77fffffffff7ff(void) { return 0xbf77fffffffff7ffUL; }
unsigned long foo_0x7f77fffffffff7ff(void) { return 0x7f77fffffffff7ffUL; }
unsigned long foo_0xbef7fffffffff7ff(void) { return 0xbef7fffffffff7ffUL; }
unsigned long foo_0x7ef7fffffffff7ff(void) { return 0x7ef7fffffffff7ffUL; }
unsigned long foo_0xbdf7fffffffff7ff(void) { return 0xbdf7fffffffff7ffUL; }
unsigned long foo_0x7df7fffffffff7ff(void) { return 0x7df7fffffffff7ffUL; }
unsigned long foo_0xbbf7fffffffff7ff(void) { return 0xbbf7fffffffff7ffUL; }
unsigned long foo_0x7bf7fffffffff7ff(void) { return 0x7bf7fffffffff7ffUL; }
unsigned long foo_0xb7f7fffffffff7ff(void) { return 0xb7f7fffffffff7ffUL; }
unsigned long foo_0x77f7fffffffff7ff(void) { return 0x77f7fffffffff7ffUL; }
unsigned long foo_0xaff7fffffffff7ff(void) { return 0xaff7fffffffff7ffUL; }
unsigned long foo_0x6ff7fffffffff7ff(void) { return 0x6ff7fffffffff7ffUL; }
unsigned long foo_0x9ff7fffffffff7ff(void) { return 0x9ff7fffffffff7ffUL; }
unsigned long foo_0x5ff7fffffffff7ff(void) { return 0x5ff7fffffffff7ffUL; }
unsigned long foo_0x7f6ffffffffff7ff(void) { return 0x7f6ffffffffff7ffUL; }
unsigned long foo_0x7deffffffffff7ff(void) { return 0x7deffffffffff7ffUL; }
unsigned long foo_0x77effffffffff7ff(void) { return 0x77effffffffff7ffUL; }
unsigned long foo_0x5feffffffffff7ff(void) { return 0x5feffffffffff7ffUL; }
unsigned long foo_0x7f5ffffffffff7ff(void) { return 0x7f5ffffffffff7ffUL; }
unsigned long foo_0x7edffffffffff7ff(void) { return 0x7edffffffffff7ffUL; }
unsigned long foo_0x7ddffffffffff7ff(void) { return 0x7ddffffffffff7ffUL; }
unsigned long foo_0x7bdffffffffff7ff(void) { return 0x7bdffffffffff7ffUL; }
unsigned long foo_0x77dffffffffff7ff(void) { return 0x77dffffffffff7ffUL; }
unsigned long foo_0x6fdffffffffff7ff(void) { return 0x6fdffffffffff7ffUL; }
unsigned long foo_0x5fdffffffffff7ff(void) { return 0x5fdffffffffff7ffUL; }
unsigned long foo_0x7dbffffffffff7ff(void) { return 0x7dbffffffffff7ffUL; }
unsigned long foo_0x77bffffffffff7ff(void) { return 0x77bffffffffff7ffUL; }
unsigned long foo_0x5fbffffffffff7ff(void) { return 0x5fbffffffffff7ffUL; }
unsigned long foo_0x7d7ffffffffff7ff(void) { return 0x7d7ffffffffff7ffUL; }
unsigned long foo_0x7b7ffffffffff7ff(void) { return 0x7b7ffffffffff7ffUL; }
unsigned long foo_0x777ffffffffff7ff(void) { return 0x777ffffffffff7ffUL; }
unsigned long foo_0x6f7ffffffffff7ff(void) { return 0x6f7ffffffffff7ffUL; }
unsigned long foo_0x5f7ffffffffff7ff(void) { return 0x5f7ffffffffff7ffUL; }
unsigned long foo_0x76fffffffffff7ff(void) { return 0x76fffffffffff7ffUL; }
unsigned long foo_0x5efffffffffff7ff(void) { return 0x5efffffffffff7ffUL; }
unsigned long foo_0x75fffffffffff7ff(void) { return 0x75fffffffffff7ffUL; }
unsigned long foo_0x6dfffffffffff7ff(void) { return 0x6dfffffffffff7ffUL; }
unsigned long foo_0x5dfffffffffff7ff(void) { return 0x5dfffffffffff7ffUL; }
unsigned long foo_0x5bfffffffffff7ff(void) { return 0x5bfffffffffff7ffUL; }
unsigned long foo_0x57fffffffffff7ff(void) { return 0x57fffffffffff7ffUL; }
unsigned long foo_0xffffdffe7fffefff(void) { return 0xffffdffe7fffefffUL; }
unsigned long foo_0xffffbffe7fffdfff(void) { return 0xffffbffe7fffdfffUL; }
