/*
 * Fonteditfs - A full-screen console font editor.
 * Copyright (C) 2002, 2003 Uri Shaked <uri@keves.org>.
 * Portions of the code were donated by amir shalem <amir@boom.org.il>.
 * Homepage: http://fonteditfs.sourceforge.net/
 *
 * Licensed under the BSD license:
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ITS AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * $Id: stack.c,v 1.1 2003/09/20 15:17:34 uri Exp $
 * Stack routines.
 */

#include <stdlib.h>
#include "stack.h"

Stack* stack_init() {
    Stack *st = (Stack*)malloc(sizeof(Stack));
    if (st) {
	st->head = (StackElement*)0;
	st->count = 0;
    }
    return st;
}

void stack_push(Stack *st, void *data) {
    StackElement *newhead = (StackElement*)malloc(sizeof(StackElement));
    if (!newhead)
	return;
    newhead->next = st->head;
    newhead->data = data;
    st->head = newhead;
    st->count++;
}

void *stack_pop(Stack *st) {
    StackElement *head = st->head;
    void *result;
    if (head)
	st->head = head->next;
    if (head) {
	result = head->data;
	free(head);
        st->count--;
	return result;
    }
    return (void*)0;
}

int stack_size(Stack *st) {
    return st->count;
}
