#!/bin/sh
#
#  This script generates the source file dynamic_big_crypt.c
#

rm -f dynamic_big_crypt.c
perl ./dynamic_big_crypt_chopper.pl TEST || exit 1

# first timestamp the file generation.
echo "/*" > xxx
echo " * The source for this file AUTO-GENERATED on:" >> xxx
echo " * `date`" >> xxx
echo " *" >> xxx

# now add a STRONG warning
cat <<_EOF >>xxx
 * NOTE.  This file IS 100% auto-generated code.
 *
 * **DO NOT** edit any portion of this .c file. ANY change
 * made to this file WILL BE LOST, the next time the
 * 'make distclean' is run, or whenever the 'base' files
 * which generate this file are modified.
 *
 * If bugs are found, then they must be fixed in the file(s)
 * of dynamic_big_crypt_header.cin, which is the 'common'
 * functions, data and includes used by all hashes, OR
 * the bug must be fixed (carefully) in the file
 * dynamic_big_crypt_hash.cin   This second file is
 * a 100% common file.  Each of the hashes we have, MUST
 * be able to be run from this file, after it is run
 * through the dynamic_big_crypt_chopper.pl filter program
 * which was built specifically for this task. The
 * existing command line arguments which run
 * dynamic_big_crypt_chopper.pl are in the shell script
 * dynamic_big_crypt_generator.sh which is the script
 * what actually generated THIS file.
 */

_EOF

# append the header (which starts with a #ifndef DYNAMIC_DISABLED
cat dynamic_big_crypt_header.cin >> xxx

##############################################################################
# NOTE, when a new hash type is added, be SURE to search the dynamic .c files
# for the string:
#   LARGE_HASH_EDIT_POINT
# and update the code to properly integrate the new large hash.
##############################################################################

# now generate a section for each hash
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=MD5        PARAHASH=MD5        BIN_SZ=16 BIN_REAL_SZ=16 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=MD5_CTX                HASH_Init=MD5_Init            HASH_Update=MD5_Update       HASH_Final=MD5_Final            SSEBody=SIMDmd5body    SSE_LIMBS=4 SSE_ONLY_LIMBS='2BUF_' SSEFLAGS=' '                    UNDEFINED=TRUNC_TO16                                < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=MD4        PARAHASH=MD4        BIN_SZ=16 BIN_REAL_SZ=16 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=MD4_CTX                HASH_Init=MD4_Init            HASH_Update=MD4_Update       HASH_Final=MD4_Final            SSEBody=SIMDmd4body    SSE_LIMBS=4 SSE_ONLY_LIMBS='2BUF_' SSEFLAGS=' '                    UNDEFINED=TRUNC_TO16                                < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=SHA1       PARAHASH=SHA1       BIN_SZ=20 BIN_REAL_SZ=20 BE_HASH=1 JSWAPH='JOHNSWAP('   JSWAPT=');'  HASH_CTX=SHA_CTX                HASH_Init=SHA1_Init           HASH_Update=SHA1_Update      HASH_Final=SHA1_Final           SSEBody=SIMDSHA1body   SSE_LIMBS=4 SSE_ONLY_LIMBS='2BUF_' SSEFLAGS=' '                      DEFINED=TRUNC_TO16                                < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=SHA224     PARAHASH=SHA256     BIN_SZ=32 BIN_REAL_SZ=28 BE_HASH=1 JSWAPH='JOHNSWAP('   JSWAPT=');'  HASH_CTX=SHA256_CTX             HASH_Init=SHA224_Init         HASH_Update=SHA256_Update    HASH_Final=SHA256_Final         SSEBody=SIMDSHA256body SSE_LIMBS=4 SSE_ONLY_LIMBS='2BUF_' SSEFLAGS='|SSEi_CRYPT_SHA224'     DEFINED=TRUNC_TO16                                < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=SHA256     PARAHASH=SHA256     BIN_SZ=32 BIN_REAL_SZ=32 BE_HASH=1 JSWAPH='JOHNSWAP('   JSWAPT=');'  HASH_CTX=SHA256_CTX             HASH_Init=SHA256_Init         HASH_Update=SHA256_Update    HASH_Final=SHA256_Final         SSEBody=SIMDSHA256body SSE_LIMBS=4 SSE_ONLY_LIMBS='2BUF_' SSEFLAGS=' '                      DEFINED=TRUNC_TO16                                < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=64 HASH=SHA384     PARAHASH=SHA512     BIN_SZ=64 BIN_REAL_SZ=48 BE_HASH=1 JSWAPH='JOHNSWAP64(' JSWAPT=');'  HASH_CTX=SHA512_CTX             HASH_Init=SHA384_Init         HASH_Update=SHA512_Update    HASH_Final=SHA512_Final         SSEBody=SIMDSHA512body SSE_LIMBS=2 SSE_ONLY_LIMBS=''      SSEFLAGS='|SSEi_CRYPT_SHA384'     DEFINED=TRUNC_TO16                                < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=64 HASH=SHA512     PARAHASH=SHA512     BIN_SZ=64 BIN_REAL_SZ=64 BE_HASH=1 JSWAPH='JOHNSWAP64(' JSWAPT=');'  HASH_CTX=SHA512_CTX             HASH_Init=SHA512_Init         HASH_Update=SHA512_Update    HASH_Final=SHA512_Final         SSEBody=SIMDSHA512body SSE_LIMBS=2 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16                                < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=64 HASH=SHA3_224   PARAHASH=SHA3_224   BIN_SZ=64 BIN_REAL_SZ=28 BE_HASH=1 JSWAPH='JOHNSWAP64(' JSWAPT=');'  HASH_CTX=KECCAK_CTX             HASH_Init=SHA3_224_Init       HASH_Update=KECCAK_Update    HASH_Final=KECCAK_Final         SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_SHA3_224   < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=64 HASH=SHA3_256   PARAHASH=SHA3_256   BIN_SZ=64 BIN_REAL_SZ=32 BE_HASH=1 JSWAPH='JOHNSWAP64(' JSWAPT=');'  HASH_CTX=KECCAK_CTX             HASH_Init=SHA3_256_Init       HASH_Update=KECCAK_Update    HASH_Final=KECCAK_Final         SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_SHA3_256   < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=64 HASH=SHA3_384   PARAHASH=SHA3_384   BIN_SZ=64 BIN_REAL_SZ=48 BE_HASH=1 JSWAPH='JOHNSWAP64(' JSWAPT=');'  HASH_CTX=KECCAK_CTX             HASH_Init=SHA3_384_Init       HASH_Update=KECCAK_Update    HASH_Final=KECCAK_Final         SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_SHA3_384   < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=64 HASH=SHA3_512   PARAHASH=SHA3_512   BIN_SZ=64 BIN_REAL_SZ=64 BE_HASH=1 JSWAPH='JOHNSWAP64(' JSWAPT=');'  HASH_CTX=KECCAK_CTX             HASH_Init=SHA3_512_Init       HASH_Update=KECCAK_Update    HASH_Final=KECCAK_Final         SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_SHA3_512   < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=64 HASH=KECCAK_256 PARAHASH=KECCAK_256 BIN_SZ=64 BIN_REAL_SZ=32 BE_HASH=1 JSWAPH='JOHNSWAP64(' JSWAPT=');'  HASH_CTX=KECCAK_CTX             HASH_Init=KECCAK_256_Init     HASH_Update=KECCAK_Update    HASH_Final=KECCAK_Final         SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_KECCAK_256 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=64 HASH=KECCAK_512 PARAHASH=KECCAK_512 BIN_SZ=64 BIN_REAL_SZ=64 BE_HASH=1 JSWAPH='JOHNSWAP64(' JSWAPT=');'  HASH_CTX=KECCAK_CTX             HASH_Init=KECCAK_512_Init     HASH_Update=KECCAK_Update    HASH_Final=KECCAK_Final         SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_KECCAK_512 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=GOST       PARAHASH=GOST       BIN_SZ=32 BIN_REAL_SZ=32 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=gost_ctx               HASH_Init=john_gost_init      HASH_Update=john_gost_update HASH_Final=john_gost_final      SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_GOST       < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=64 HASH=WHIRLPOOL  PARAHASH=WHIRLPOOL  BIN_SZ=64 BIN_REAL_SZ=64 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=WHIRLPOOL_CTX          HASH_Init=WHIRLPOOL_Init      HASH_Update=WHIRLPOOL_Update HASH_Final=WHIRLPOOL_Final      SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_WHIRLPOOL  < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=Tiger      PARAHASH=Tiger      BIN_SZ=24 BIN_REAL_SZ=24 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_tiger_context      HASH_Init=sph_tiger_init      HASH_Update=sph_tiger        HASH_Final=sph_tiger_close      SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_Tiger      < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=RIPEMD128  PARAHASH=RIPEMD128  BIN_SZ=16 BIN_REAL_SZ=16 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_ripemd128_context  HASH_Init=sph_ripemd128_init  HASH_Update=sph_ripemd128    HASH_Final=sph_ripemd128_close  SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                    UNDEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_RIPEMD128  < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=RIPEMD160  PARAHASH=RIPEMD160  BIN_SZ=20 BIN_REAL_SZ=20 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_ripemd160_context  HASH_Init=sph_ripemd160_init  HASH_Update=sph_ripemd160    HASH_Final=sph_ripemd160_close  SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_RIPEMD160  < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=RIPEMD256  PARAHASH=RIPEMD256  BIN_SZ=32 BIN_REAL_SZ=32 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_ripemd256_context  HASH_Init=sph_ripemd256_init  HASH_Update=sph_ripemd256    HASH_Final=sph_ripemd256_close  SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_RIPEMD256  < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=RIPEMD320  PARAHASH=RIPEMD320  BIN_SZ=40 BIN_REAL_SZ=40 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_ripemd320_context  HASH_Init=sph_ripemd320_init  HASH_Update=sph_ripemd320    HASH_Final=sph_ripemd320_close  SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_RIPEMD320  < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL128_3 PARAHASH=HAVAL128_3 BIN_SZ=16 BIN_REAL_SZ=16 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval128_3_context HASH_Init=sph_haval128_3_init HASH_Update=sph_haval128_3   HASH_Final=sph_haval128_3_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL128_3 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL128_4 PARAHASH=HAVAL128_4 BIN_SZ=16 BIN_REAL_SZ=16 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval128_4_context HASH_Init=sph_haval128_4_init HASH_Update=sph_haval128_4   HASH_Final=sph_haval128_4_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL128_4 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL128_5 PARAHASH=HAVAL128_5 BIN_SZ=16 BIN_REAL_SZ=16 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval128_5_context HASH_Init=sph_haval128_5_init HASH_Update=sph_haval128_5   HASH_Final=sph_haval128_5_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL128_5 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL160_3 PARAHASH=HAVAL160_3 BIN_SZ=20 BIN_REAL_SZ=20 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval160_3_context HASH_Init=sph_haval160_3_init HASH_Update=sph_haval160_3   HASH_Final=sph_haval160_3_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL160_3 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL160_4 PARAHASH=HAVAL160_4 BIN_SZ=20 BIN_REAL_SZ=20 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval160_4_context HASH_Init=sph_haval160_4_init HASH_Update=sph_haval160_4   HASH_Final=sph_haval160_4_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL160_4 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL160_5 PARAHASH=HAVAL160_5 BIN_SZ=20 BIN_REAL_SZ=20 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval160_5_context HASH_Init=sph_haval160_5_init HASH_Update=sph_haval160_5   HASH_Final=sph_haval160_5_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL160_5 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL192_3 PARAHASH=HAVAL192_3 BIN_SZ=24 BIN_REAL_SZ=24 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval192_3_context HASH_Init=sph_haval192_3_init HASH_Update=sph_haval192_3   HASH_Final=sph_haval192_3_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL192_3 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL192_4 PARAHASH=HAVAL192_4 BIN_SZ=24 BIN_REAL_SZ=24 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval192_4_context HASH_Init=sph_haval192_4_init HASH_Update=sph_haval192_4   HASH_Final=sph_haval192_4_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL192_4 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL192_5 PARAHASH=HAVAL192_5 BIN_SZ=24 BIN_REAL_SZ=24 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval192_5_context HASH_Init=sph_haval192_5_init HASH_Update=sph_haval192_5   HASH_Final=sph_haval192_5_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL192_5 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL224_3 PARAHASH=HAVAL224_3 BIN_SZ=28 BIN_REAL_SZ=28 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval224_3_context HASH_Init=sph_haval224_3_init HASH_Update=sph_haval224_3   HASH_Final=sph_haval224_3_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL224_3 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL224_4 PARAHASH=HAVAL224_4 BIN_SZ=28 BIN_REAL_SZ=28 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval224_4_context HASH_Init=sph_haval224_4_init HASH_Update=sph_haval224_4   HASH_Final=sph_haval224_4_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL224_4 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL224_5 PARAHASH=HAVAL224_5 BIN_SZ=28 BIN_REAL_SZ=28 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval224_5_context HASH_Init=sph_haval224_5_init HASH_Update=sph_haval224_5   HASH_Final=sph_haval224_5_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL224_5 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL256_3 PARAHASH=HAVAL256_3 BIN_SZ=32 BIN_REAL_SZ=32 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval256_3_context HASH_Init=sph_haval256_3_init HASH_Update=sph_haval256_3   HASH_Final=sph_haval256_3_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL256_3 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL256_4 PARAHASH=HAVAL256_4 BIN_SZ=32 BIN_REAL_SZ=32 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval256_4_context HASH_Init=sph_haval256_4_init HASH_Update=sph_haval256_4   HASH_Final=sph_haval256_4_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL256_4 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=HAVAL256_5 PARAHASH=HAVAL256_5 BIN_SZ=32 BIN_REAL_SZ=32 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_haval256_5_context HASH_Init=sph_haval256_5_init HASH_Update=sph_haval256_5   HASH_Final=sph_haval256_5_close SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_HAVAL256_5 < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=PANAMA     PARAHASH=PANAMA     BIN_SZ=32 BIN_REAL_SZ=32 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_panama_context     HASH_Init=sph_panama_init     HASH_Update=sph_panama       HASH_Final=sph_panama_close     SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_PANAMA     < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=MD2        PARAHASH=MD2        BIN_SZ=16 BIN_REAL_SZ=16 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_md2_context        HASH_Init=sph_md2_init        HASH_Update=sph_md2          HASH_Final=sph_md2_close        SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_MD2        < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=SKEIN224   PARAHASH=SKEIN224   BIN_SZ=64 BIN_REAL_SZ=28 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_skein224_context   HASH_Init=sph_skein224_init   HASH_Update=sph_skein224     HASH_Final=sph_skein224_close   SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_SKEIN224   < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=SKEIN256   PARAHASH=SKEIN256   BIN_SZ=64 BIN_REAL_SZ=32 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_skein256_context   HASH_Init=sph_skein256_init   HASH_Update=sph_skein256     HASH_Final=sph_skein256_close   SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_SKEIN256   < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=SKEIN384   PARAHASH=SKEIN384   BIN_SZ=64 BIN_REAL_SZ=48 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_skein384_context   HASH_Init=sph_skein384_init   HASH_Update=sph_skein384     HASH_Final=sph_skein384_close   SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_SKEIN384   < dynamic_big_crypt_hash.cin  >> xxx
perl ./dynamic_big_crypt_chopper.pl BITS=32 HASH=SKEIN512   PARAHASH=SKEIN512   BIN_SZ=64 BIN_REAL_SZ=64 BE_HASH=0 JSWAPH=' '           JSWAPT=';'   HASH_CTX=sph_skein512_context   HASH_Init=sph_skein512_init   HASH_Update=sph_skein512     HASH_Final=sph_skein512_close   SSEBody=''             SSE_LIMBS=0 SSE_ONLY_LIMBS=''      SSEFLAGS=' '                      DEFINED=TRUNC_TO16 UNDEFINED=SIMD_PARA_SKEIN512   < dynamic_big_crypt_hash.cin  >> xxx
# LARGE_HASH_EDIT_POINT

# now we close out the #define DYNAMIC_DISABLED started at the very top
# of dynamic_big_crypt_header.cin
echo "" >> xxx
echo '#endif // DYNAMIC_DISABLED' >> xxx
mv xxx dynamic_big_crypt.c

exit 0
