shlinters
=========


## Description

 `shlinters` is a set of bash linters and utilities for linters. They are
 posix, except `u_codespell` that, _for now_, uses a GNU extension
 (`grep -H`) and `smd` that requires GNU sed.


## 1  Linters

 So far, only three trivial linters are proposed. Feel free to request
 others.

 Two links to non-trivial ones are also proposed.

 ### 1.1  `end-of-file-fixer.sh`, `trailing-whitespace.sh`, `line-endings.sh`

 As the name suggests, these are equivalents of the pre-commit linters of
 the same name, but faster.

 ### 1.2  `expand-tabs.sh`

 As the name suggest. See `expand-tabs.sh -h`.

 ### 1.3  `get_u_codespell.sh`

 This allows to download `u_codespell` to a subdir.
 [u\_codespell](https://codeberg.org/johann1764/u_codespell/) is an
 alternative bash front-end for
 [codespell](https://github.com/codespell-project/codespell/).

 ### 1.4  `get_smd.sh`

 This allows to download `smd` to a subdir.
 [smd](https://codeberg.org/johann1764/smd/) is a high quality markdown
 reader for the terminal and linter.


## 2  Meta-scripts

 ### 2.1  parallel.sh

 This allows to use a linter with a decent parallelism management. By
 default, uses 1 thread per CPU core and split the input file list
 accordingly in order to have it processed in parallel by n instances of
 the specified linter. The outputs are concatenated and the return codes
 are or-ed.

 Allows to use k cores per process (useful for fixed-parallelism linters,
 such as bash linters), and also allows a limited (so far) form of total
 size balancing amongst the processes with -b. This is useful for slow
 linters, such as any pre-commit builtin linter, and
 `u_codespell`/`codespell`. The later benefits from having 2 cores per
 thread (as most bash scripts do).

 In terms of speed, any pre-commit hook would benefit from using
 `require_serial=true` and wrapping the call into the relevant
 `parallel.sh` call (try with and without -b, with different values 1, 2,
 and more for cores/thread). This is a simple workaround for pre-commit
 limited parallelism management.

 Try `parallel.sh -h` for more details.

 ### 2.2  update.sh

 It updates the whole dir with the latest version of scripts downloaded
 from codeberg. If `u_codespell` was downloaded, it is also updated.


## 3  Bugs, Features and Suggestions

 Bug reports, feature requests, suggestions and any questions are welcomed
 [here](https://codeberg.org/johann1764/shlinters/issues).


## 4  License

 All scripts are under [GPL3](GPL3.txt)
