/* { dg-options "-mlasx -w -fno-strict-aliasing" } */
#include "../simd_correctness_check.h"
#include <lasxintrin.h>

int
main ()
{
  __m256i __m256i_op0, __m256i_op1, __m256i_op2, __m256i_out, __m256i_result;
  __m256 __m256_op0, __m256_op1, __m256_op2, __m256_out, __m256_result;
  __m256d __m256d_op0, __m256d_op1, __m256d_op2, __m256d_out, __m256d_result;

  int int_op0, int_op1, int_op2, int_out, int_result, i = 1, fail;
  long int long_op0, long_op1, long_op2, lont_out, lont_result;
  long int long_int_out, long_int_result;
  unsigned int unsigned_int_out, unsigned_int_result;
  unsigned long int unsigned_long_int_out, unsigned_long_int_result;

  *((unsigned long *)&__m256i_op0[3]) = 0x042f0500cfea969a;
  *((unsigned long *)&__m256i_op0[2]) = 0x58569d7be9179100;
  *((unsigned long *)&__m256i_op0[1]) = 0xa98d4f7a77c308ee;
  *((unsigned long *)&__m256i_op0[0]) = 0x0ad152a5ad72feeb;
  *((unsigned long *)&__m256i_op1[3]) = 0x34ec5670cd4b5ec0;
  *((unsigned long *)&__m256i_op1[2]) = 0x4f111e4b8e0d7291;
  *((unsigned long *)&__m256i_op1[1]) = 0xeaa81f47dc3bdd09;
  *((unsigned long *)&__m256i_op1[0]) = 0x0e0d5fde5df99830;
  *((unsigned long *)&__m256i_op2[3]) = 0x80c72fcd40fb3bc0;
  *((unsigned long *)&__m256i_op2[2]) = 0x84bd087966d4ace0;
  *((unsigned long *)&__m256i_op2[1]) = 0x26aa68b274dc1322;
  *((unsigned long *)&__m256i_op2[0]) = 0xe072db2bb9d4cd40;
  *((unsigned long *)&__m256i_result[3]) = 0x044819410d87e69a;
  *((unsigned long *)&__m256i_result[2]) = 0x21d3905ae3e93be0;
  *((unsigned long *)&__m256i_result[1]) = 0x5125883a30da0f20;
  *((unsigned long *)&__m256i_result[0]) = 0x6d7b2d3ac2777aeb;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffffffffffffeff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xfffffffffffffeff;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000000ffff001f;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000ffff001f;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x000000000000ffe0;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000001e18;
  *((unsigned long *)&__m256i_op2[1]) = 0x000000000000ffe0;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000001e18;
  *((unsigned long *)&__m256i_result[3]) = 0xffffffffffffff1f;
  *((unsigned long *)&__m256i_result[2]) = 0xfffffffffffffeff;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffffffff1f;
  *((unsigned long *)&__m256i_result[0]) = 0xfffffffffffffeff;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000ffff00010000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000ffff00010000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000fffe00010001;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000fffe00010001;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x00000000ffffffff;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x1717171717171717;
  *((unsigned long *)&__m256i_op0[2]) = 0x000607f700000001;
  *((unsigned long *)&__m256i_op0[1]) = 0x1717171717171717;
  *((unsigned long *)&__m256i_op0[0]) = 0x000607f700000001;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000002e0000002e;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000002e0000ffff;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000002e0000002e;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000002e0000fffe;
  *((unsigned long *)&__m256i_result[3]) = 0x1717171717171717;
  *((unsigned long *)&__m256i_result[2]) = 0x000607f700000001;
  *((unsigned long *)&__m256i_result[1]) = 0x1717171717171717;
  *((unsigned long *)&__m256i_result[0]) = 0x000607f700000001;
  __m256i_out = __lasx_xvmadd_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffff00000000;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffff00000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000003f00000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000003f00000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000003f00000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000003f00000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000003f00000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000003f00000000;
  __m256i_out = __lasx_xvmadd_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x370036db92c4007e;
  *((unsigned long *)&__m256i_op0[2]) = 0x371462137c1e0049;
  *((unsigned long *)&__m256i_op0[1]) = 0x800000fe7e02fffe;
  *((unsigned long *)&__m256i_op0[0]) = 0x371c413b999d04b5;
  *((unsigned long *)&__m256i_op1[3]) = 0x0002ff80ffb70000;
  *((unsigned long *)&__m256i_op1[2]) = 0xffb7ff80ffd0ffd8;
  *((unsigned long *)&__m256i_op1[1]) = 0x00010000002fff9e;
  *((unsigned long *)&__m256i_op1[0]) = 0xffb5ff80ffd0ffd8;
  *((unsigned long *)&__m256i_op2[3]) = 0xffff00ff00ffff00;
  *((unsigned long *)&__m256i_op2[2]) = 0xff000000ff00ff00;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffff00ffff;
  *((unsigned long *)&__m256i_op2[0]) = 0xff00000000ff00ff;
  *((unsigned long *)&__m256i_result[3]) = 0x37fe365b920d007e;
  *((unsigned long *)&__m256i_result[2]) = 0x381462137d1e0149;
  *((unsigned long *)&__m256i_result[1]) = 0x80ff00fe7e020060;
  *((unsigned long *)&__m256i_result[0]) = 0x381c413b99cd04dd;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xb70036db12c4007e;
  *((unsigned long *)&__m256i_op1[2]) = 0xb7146213fc1e0049;
  *((unsigned long *)&__m256i_op1[1]) = 0x000000fefe02fffe;
  *((unsigned long *)&__m256i_op1[0]) = 0xb71c413b199d04b5;
  *((unsigned long *)&__m256i_op2[3]) = 0xb70036db12c4007e;
  *((unsigned long *)&__m256i_op2[2]) = 0xb7146213fc1e0049;
  *((unsigned long *)&__m256i_op2[1]) = 0x000000fefe02fffe;
  *((unsigned long *)&__m256i_op2[0]) = 0xb71c413b199d04b5;
  *((unsigned long *)&__m256i_result[3]) = 0xd100645944100004;
  *((unsigned long *)&__m256i_result[2]) = 0xd1908469108400d1;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000404040104;
  *((unsigned long *)&__m256i_result[0]) = 0xd1108199714910f9;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x7fff000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x7fff000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x7fff7fff00000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x7fff7fff00000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x1f0fdf7f3e3b31d4;
  *((unsigned long *)&__m256i_op2[2]) = 0x7ff8000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x1f0fdf7f3e3b31d4;
  *((unsigned long *)&__m256i_op2[0]) = 0x7ff8000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x61f1000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0108000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x61f1a18100000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0108000000000000;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000055555555;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000100000004;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000055555555;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000100000004;
  *((unsigned long *)&__m256i_op2[3]) = 0x000000007fffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x000000007fffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x2aaaaaaa2aaaaaab;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x2aaaaaaa2aaaaaab;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x7c007c007c007c00;
  *((unsigned long *)&__m256i_op0[2]) = 0x7c007c007c007c00;
  *((unsigned long *)&__m256i_op0[1]) = 0x7c007c007c007c00;
  *((unsigned long *)&__m256i_op0[0]) = 0x7c007c007c007c00;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x7c007c007c007c00;
  *((unsigned long *)&__m256i_result[2]) = 0x7c007c007c007c00;
  *((unsigned long *)&__m256i_result[1]) = 0x7c007c007c007c00;
  *((unsigned long *)&__m256i_result[0]) = 0x7c007c007c007c00;
  __m256i_out = __lasx_xvmadd_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000ff00ff;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000fd00ffff02fe;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000001fffeff;
  *((unsigned long *)&__m256i_op1[0]) = 0xff00fe00feff02ff;
  *((unsigned long *)&__m256i_op2[3]) = 0x00007f7f00007f00;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x00007f7f00007fff;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000ffff0100;
  *((unsigned long *)&__m256i_result[0]) = 0x00000000ffffffff;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000ffee0000ff4c;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000ff050000ff3c;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000fff90000ff78;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000ffa80000ff31;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffffffff;
  __m256i_out = __lasx_xvmadd_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0101010127272525;
  *((unsigned long *)&__m256i_op2[2]) = 0x23a2a121179e951d;
  *((unsigned long *)&__m256i_op2[1]) = 0x0101010127272525;
  *((unsigned long *)&__m256i_op2[0]) = 0x23a2a121179e951d;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000100000001;
  __m256i_out = __lasx_xvmadd_h (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op1[2]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op1[1]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op1[0]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op2[3]) = 0x7ff0000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x7ff0000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x7ff0000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x7ff0000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x7fefffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0x7fefffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x7fefffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0x7fefffffffffffff;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_result[3]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_result[2]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_result[1]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_result[0]) = 0x000000ff000000ff;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x008e8e8e8e8e8e8e;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x008e8e8e8e8e8e8e;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000700000007;
  *((unsigned long *)&__m256i_op1[2]) = 0x0007ffff0007ffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000700000007;
  *((unsigned long *)&__m256i_op1[0]) = 0x0007ffff0007ffff;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x008e8e8e8e8e8e8e;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x008e8e8e8e8e8e8e;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x007000008e700000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x007000008e700000;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000008050501;
  *((unsigned long *)&__m256i_op0[2]) = 0x0100000100000001;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000008050501;
  *((unsigned long *)&__m256i_op0[0]) = 0x0100000100000001;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x9090909090909090;
  *((unsigned long *)&__m256i_op2[2]) = 0x9090909090909090;
  *((unsigned long *)&__m256i_op2[1]) = 0x9090909090909090;
  *((unsigned long *)&__m256i_op2[0]) = 0x9090909090909090;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000008050501;
  *((unsigned long *)&__m256i_result[2]) = 0x0100000100000001;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000008050501;
  *((unsigned long *)&__m256i_result[0]) = 0x0100000100000001;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmadd_h (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x00000000ff88ffc0;
  *((unsigned long *)&__m256i_op2[2]) = 0x00000000ff78ffc0;
  *((unsigned long *)&__m256i_op2[1]) = 0x00000000ff88ffc0;
  *((unsigned long *)&__m256i_op2[0]) = 0x00000000ff78ffc0;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000040;
  __m256i_out = __lasx_xvmadd_h (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000080040;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000080040;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000080040;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000080040;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000000007f0000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000007f0000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000080040;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000080040;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000080040;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000080040;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x00009fff00002001;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x00009fff00002001;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_result[2]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_result[1]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_result[0]) = 0x8000000080000000;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op2[3]) = 0x0001497c98ea4fca;
  *((unsigned long *)&__m256i_op2[2]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0x0001497c98ea4fca;
  *((unsigned long *)&__m256i_op2[0]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x000000006715b036;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[1]) = 0x000000006715b036;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000001;
  __m256i_out = __lasx_xvmadd_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000002;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000080;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000002;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000080;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x00000000000000ff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000007f80;
  __m256i_out = __lasx_xvmadd_h (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000000d6d6d;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000000d6d6d;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000000d6d6d;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000000d6d6d;
  *((unsigned long *)&__m256i_op1[3]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000000d6d6d;
  *((unsigned long *)&__m256i_result[2]) = 0x00000000000d6d6d;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000000d6d6d;
  *((unsigned long *)&__m256i_result[0]) = 0x00000000000d6d6d;
  __m256i_out = __lasx_xvmadd_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x7f80ffffff808000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x7f80ffffff808000;
  *((unsigned long *)&__m256i_op1[3]) = 0x001f001fffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffe0ffe000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x001f001fffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffe0ffe000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0xffe0ffe000000001;
  *((unsigned long *)&__m256i_result[2]) = 0x7fa0001fff808000;
  *((unsigned long *)&__m256i_result[1]) = 0xffe0ffe000000001;
  *((unsigned long *)&__m256i_result[0]) = 0x7fa0001fff808000;
  __m256i_out = __lasx_xvmadd_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  return 0;
}
