#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2021 Anna Lea
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Gomo
# send your bug reports to contact@dotslashplay.it
###

script_version=20240823.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='gomo'
GAME_NAME='Gomo'

ARCHIVE_BASE_1_NAME='setup_gomo_1.0_(20774).exe'
ARCHIVE_BASE_1_MD5='7679c55aaafe8308518aa4940929fbb0'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='290000'
ARCHIVE_BASE_1_VERSION='1.0-gog20774'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/gomo'

ARCHIVE_BASE_0_NAME='setup_gomo_2.1.0.4.exe'
ARCHIVE_BASE_0_MD5='5ee422dff6f00976e170296103dd29e6'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='560000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.1.0.4'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_BIN_FILES='
adobe air
gomo.exe'
CONTENT_GAME_DATA_FILES='
meta-inf
movies
music
world
gomo.swf'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Gomo'

APP_MAIN_EXE='gomo.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
