;;; EMAIL-HOST
;;; ---------

;;(email-host-init env) -> env
;; initializes environment
(defund email-host-init (env)
  (begin
   (cw "  [email-host-init]~%")
  (set-var 'hostname '()
  (set-var 'users '(postmaster) env))))


;;(email-host-command string list[args] env) -> 
;;
(defund email-host-command (cmd args env)
  (begin 
   (cw "  [email-host-command: ~x0 (~x1)]~%" (lookup 'hostname) cmd)
  (cond ((equal cmd 'SET_HOSTNAME)
         (let ((hn (car args)))
           (set-var 'hostname hn env)))
        ((equal cmd 'INIT_USER)
         (let ((uname (car args)))
	    (set-var 'users (los-adjoin uname (lookup 'users)) env)))
        ((equal cmd 'DELETE_USER)
         (let ((uname (car args)))
           (set-var 'users (remove-equal uname (lookup 'users)) env)))
        (t env))))

;;(email-host-outgoing message env) ->
;;
(defund email-host-outgoing (msg env)
  (begin 
   (cw "  [email-host-outgoing: ~x0]~%" (lookup 'hostname))
   (let ((recip (recipient msg))) ; 
     (begin 
      (cw ".....~x0~%" (stringify recip))
      (if (equal (lookup 'hostname)
		 (email-host recip))
	  (begin  (cw "delivering...")
		  (let ((r-user (email-user recip)))
		    (if (member-equal r-user (lookup 'users))
			(begin (cw "..to ~x0~%" r-user)
			       (if (message-p msg)
				   (act deliver msg)
				 (begin (cw "Message not msgp ~x0~%" msg)
					(act deliver msg))))
		      (begin
		       (cw "no user~%")
		       (let ((pm-addr (mk-email 'Postmaster (lookup 'hostname))))
			 (act mail
			      (mk-message pm-addr
					  (list (message-sender msg))
					  nil
					  (list
					   "Unknown user: " 
					   (stringify recip)
					   "Following message undeliverable:"
					   (stringify (message-headers msg))
					   "e"
					   (stringify (message-body msg))))))))))
	(act mail msg))))))

;;(email-host-incoming message env) ->
(defund email-host-incoming (msg env)
  (begin
   (cw "  [email-host-incoming: ~x0]~%" (lookup 'hostname))
   (act comment "[Incoming events not handled]")))
