/*╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌
 * widgets/InfoButton.h is part of Brewtarget, and is copyright the following authors 2023:
 *   • Matt Young <mfsy@yahoo.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Brewtarget is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌*/
#ifndef WIDGETS_INFOBUTTON_H
#define WIDGETS_INFOBUTTON_H
#pragma once

#include <QLabel>
#include <QPushButton>

class InfoText;

/**
 * \class InfoButton
 *
 * \brief A button that looks like 'ⓘ' that you can click to show more info about the field it is placed next to.
 */
class InfoButton : public QPushButton {
   Q_OBJECT
public:
   explicit InfoButton(QWidget * parent = nullptr);
   virtual ~InfoButton();

   /**
    * \brief This is called by our \c InfoText to link it to us.
    */
   void linkWith(InfoText * infoText);

public slots:
   /**
    * \brief When the button is clicked, this is the function that ends up getting called.
    */
   void doClick();

protected:
   virtual void paintEvent(QPaintEvent * event) override;
   virtual void resizeEvent(QResizeEvent * event)override;

private:
   int getCircleDiameter() const;

   InfoText * m_infoText;
};

#endif
