// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file appendableTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "appendableTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "appendable.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableShortStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableShortStruct)
{

    ReturnCode_t return_code_AppendableShortStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableShortStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableShortStruct", type_ids_AppendableShortStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableShortStruct)
    {
        StructTypeFlag struct_flags_AppendableShortStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableShortStruct = "AppendableShortStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableShortStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableShortStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableShortStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableShortStruct;
        if (!tmp_ann_custom_AppendableShortStruct.empty())
        {
            ann_custom_AppendableShortStruct = tmp_ann_custom_AppendableShortStruct;
        }

        CompleteTypeDetail detail_AppendableShortStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableShortStruct, ann_custom_AppendableShortStruct, type_name_AppendableShortStruct.to_string());
        CompleteStructHeader header_AppendableShortStruct;
        header_AppendableShortStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableShortStruct);
        CompleteStructMemberSeq member_seq_AppendableShortStruct;
        {
            TypeIdentifierPair type_ids_var_short;
            ReturnCode_t return_code_var_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_var_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_short = 0x00000000;
            bool common_var_short_ec {false};
            CommonStructMember common_var_short {TypeObjectUtils::build_common_struct_member(member_id_var_short, member_flags_var_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_short, common_var_short_ec))};
            if (!common_var_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_short = "var_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_short;
            ann_custom_AppendableShortStruct.reset();
            CompleteMemberDetail detail_var_short = TypeObjectUtils::build_complete_member_detail(name_var_short, member_ann_builtin_var_short, ann_custom_AppendableShortStruct);
            CompleteStructMember member_var_short = TypeObjectUtils::build_complete_struct_member(common_var_short, detail_var_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableShortStruct, member_var_short);
        }
        CompleteStructType struct_type_AppendableShortStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableShortStruct, header_AppendableShortStruct, member_seq_AppendableShortStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableShortStruct, type_name_AppendableShortStruct.to_string(), type_ids_AppendableShortStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableShortStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableUShortStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableUShortStruct)
{

    ReturnCode_t return_code_AppendableUShortStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableUShortStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableUShortStruct", type_ids_AppendableUShortStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableUShortStruct)
    {
        StructTypeFlag struct_flags_AppendableUShortStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableUShortStruct = "AppendableUShortStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableUShortStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableUShortStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableUShortStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableUShortStruct;
        if (!tmp_ann_custom_AppendableUShortStruct.empty())
        {
            ann_custom_AppendableUShortStruct = tmp_ann_custom_AppendableUShortStruct;
        }

        CompleteTypeDetail detail_AppendableUShortStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableUShortStruct, ann_custom_AppendableUShortStruct, type_name_AppendableUShortStruct.to_string());
        CompleteStructHeader header_AppendableUShortStruct;
        header_AppendableUShortStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableUShortStruct);
        CompleteStructMemberSeq member_seq_AppendableUShortStruct;
        {
            TypeIdentifierPair type_ids_var_ushort;
            ReturnCode_t return_code_var_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_var_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ushort)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ushort Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ushort = 0x00000000;
            bool common_var_ushort_ec {false};
            CommonStructMember common_var_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_ushort, member_flags_var_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ushort, common_var_ushort_ec))};
            if (!common_var_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ushort = "var_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ushort;
            ann_custom_AppendableUShortStruct.reset();
            CompleteMemberDetail detail_var_ushort = TypeObjectUtils::build_complete_member_detail(name_var_ushort, member_ann_builtin_var_ushort, ann_custom_AppendableUShortStruct);
            CompleteStructMember member_var_ushort = TypeObjectUtils::build_complete_struct_member(common_var_ushort, detail_var_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableUShortStruct, member_var_ushort);
        }
        CompleteStructType struct_type_AppendableUShortStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableUShortStruct, header_AppendableUShortStruct, member_seq_AppendableUShortStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableUShortStruct, type_name_AppendableUShortStruct.to_string(), type_ids_AppendableUShortStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableUShortStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableLongStruct)
{

    ReturnCode_t return_code_AppendableLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableLongStruct", type_ids_AppendableLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableLongStruct)
    {
        StructTypeFlag struct_flags_AppendableLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableLongStruct = "AppendableLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableLongStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableLongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableLongStruct;
        if (!tmp_ann_custom_AppendableLongStruct.empty())
        {
            ann_custom_AppendableLongStruct = tmp_ann_custom_AppendableLongStruct;
        }

        CompleteTypeDetail detail_AppendableLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableLongStruct, ann_custom_AppendableLongStruct, type_name_AppendableLongStruct.to_string());
        CompleteStructHeader header_AppendableLongStruct;
        header_AppendableLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableLongStruct);
        CompleteStructMemberSeq member_seq_AppendableLongStruct;
        {
            TypeIdentifierPair type_ids_var_long;
            ReturnCode_t return_code_var_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_long = 0x00000000;
            bool common_var_long_ec {false};
            CommonStructMember common_var_long {TypeObjectUtils::build_common_struct_member(member_id_var_long, member_flags_var_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_long, common_var_long_ec))};
            if (!common_var_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_long;
            ann_custom_AppendableLongStruct.reset();
            CompleteMemberDetail detail_var_long = TypeObjectUtils::build_complete_member_detail(name_var_long, member_ann_builtin_var_long, ann_custom_AppendableLongStruct);
            CompleteStructMember member_var_long = TypeObjectUtils::build_complete_struct_member(common_var_long, detail_var_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableLongStruct, member_var_long);
        }
        CompleteStructType struct_type_AppendableLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableLongStruct, header_AppendableLongStruct, member_seq_AppendableLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableLongStruct, type_name_AppendableLongStruct.to_string(), type_ids_AppendableLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableULongStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableULongStruct)
{

    ReturnCode_t return_code_AppendableULongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableULongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableULongStruct", type_ids_AppendableULongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableULongStruct)
    {
        StructTypeFlag struct_flags_AppendableULongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableULongStruct = "AppendableULongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableULongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableULongStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableULongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableULongStruct;
        if (!tmp_ann_custom_AppendableULongStruct.empty())
        {
            ann_custom_AppendableULongStruct = tmp_ann_custom_AppendableULongStruct;
        }

        CompleteTypeDetail detail_AppendableULongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableULongStruct, ann_custom_AppendableULongStruct, type_name_AppendableULongStruct.to_string());
        CompleteStructHeader header_AppendableULongStruct;
        header_AppendableULongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableULongStruct);
        CompleteStructMemberSeq member_seq_AppendableULongStruct;
        {
            TypeIdentifierPair type_ids_var_ulong;
            ReturnCode_t return_code_var_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_var_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulong = 0x00000000;
            bool common_var_ulong_ec {false};
            CommonStructMember common_var_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_ulong, member_flags_var_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulong, common_var_ulong_ec))};
            if (!common_var_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulong = "var_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulong;
            ann_custom_AppendableULongStruct.reset();
            CompleteMemberDetail detail_var_ulong = TypeObjectUtils::build_complete_member_detail(name_var_ulong, member_ann_builtin_var_ulong, ann_custom_AppendableULongStruct);
            CompleteStructMember member_var_ulong = TypeObjectUtils::build_complete_struct_member(common_var_ulong, detail_var_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableULongStruct, member_var_ulong);
        }
        CompleteStructType struct_type_AppendableULongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableULongStruct, header_AppendableULongStruct, member_seq_AppendableULongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableULongStruct, type_name_AppendableULongStruct.to_string(), type_ids_AppendableULongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableULongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableLongLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableLongLongStruct)
{

    ReturnCode_t return_code_AppendableLongLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableLongLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableLongLongStruct", type_ids_AppendableLongLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableLongLongStruct)
    {
        StructTypeFlag struct_flags_AppendableLongLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableLongLongStruct = "AppendableLongLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableLongLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableLongLongStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableLongLongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableLongLongStruct;
        if (!tmp_ann_custom_AppendableLongLongStruct.empty())
        {
            ann_custom_AppendableLongLongStruct = tmp_ann_custom_AppendableLongLongStruct;
        }

        CompleteTypeDetail detail_AppendableLongLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableLongLongStruct, ann_custom_AppendableLongLongStruct, type_name_AppendableLongLongStruct.to_string());
        CompleteStructHeader header_AppendableLongLongStruct;
        header_AppendableLongLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableLongLongStruct);
        CompleteStructMemberSeq member_seq_AppendableLongLongStruct;
        {
            TypeIdentifierPair type_ids_var_longlong;
            ReturnCode_t return_code_var_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longlong = 0x00000000;
            bool common_var_longlong_ec {false};
            CommonStructMember common_var_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_longlong, member_flags_var_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longlong, common_var_longlong_ec))};
            if (!common_var_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longlong = "var_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longlong;
            ann_custom_AppendableLongLongStruct.reset();
            CompleteMemberDetail detail_var_longlong = TypeObjectUtils::build_complete_member_detail(name_var_longlong, member_ann_builtin_var_longlong, ann_custom_AppendableLongLongStruct);
            CompleteStructMember member_var_longlong = TypeObjectUtils::build_complete_struct_member(common_var_longlong, detail_var_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableLongLongStruct, member_var_longlong);
        }
        CompleteStructType struct_type_AppendableLongLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableLongLongStruct, header_AppendableLongLongStruct, member_seq_AppendableLongLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableLongLongStruct, type_name_AppendableLongLongStruct.to_string(), type_ids_AppendableLongLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableLongLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableULongLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableULongLongStruct)
{

    ReturnCode_t return_code_AppendableULongLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableULongLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableULongLongStruct", type_ids_AppendableULongLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableULongLongStruct)
    {
        StructTypeFlag struct_flags_AppendableULongLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableULongLongStruct = "AppendableULongLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableULongLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableULongLongStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableULongLongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableULongLongStruct;
        if (!tmp_ann_custom_AppendableULongLongStruct.empty())
        {
            ann_custom_AppendableULongLongStruct = tmp_ann_custom_AppendableULongLongStruct;
        }

        CompleteTypeDetail detail_AppendableULongLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableULongLongStruct, ann_custom_AppendableULongLongStruct, type_name_AppendableULongLongStruct.to_string());
        CompleteStructHeader header_AppendableULongLongStruct;
        header_AppendableULongLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableULongLongStruct);
        CompleteStructMemberSeq member_seq_AppendableULongLongStruct;
        {
            TypeIdentifierPair type_ids_var_ulonglong;
            ReturnCode_t return_code_var_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulonglong = 0x00000000;
            bool common_var_ulonglong_ec {false};
            CommonStructMember common_var_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_ulonglong, member_flags_var_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulonglong, common_var_ulonglong_ec))};
            if (!common_var_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulonglong = "var_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulonglong;
            ann_custom_AppendableULongLongStruct.reset();
            CompleteMemberDetail detail_var_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_ulonglong, member_ann_builtin_var_ulonglong, ann_custom_AppendableULongLongStruct);
            CompleteStructMember member_var_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_ulonglong, detail_var_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableULongLongStruct, member_var_ulonglong);
        }
        CompleteStructType struct_type_AppendableULongLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableULongLongStruct, header_AppendableULongLongStruct, member_seq_AppendableULongLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableULongLongStruct, type_name_AppendableULongLongStruct.to_string(), type_ids_AppendableULongLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableULongLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableFloatStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableFloatStruct)
{

    ReturnCode_t return_code_AppendableFloatStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableFloatStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableFloatStruct", type_ids_AppendableFloatStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableFloatStruct)
    {
        StructTypeFlag struct_flags_AppendableFloatStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableFloatStruct = "AppendableFloatStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableFloatStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableFloatStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableFloatStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableFloatStruct;
        if (!tmp_ann_custom_AppendableFloatStruct.empty())
        {
            ann_custom_AppendableFloatStruct = tmp_ann_custom_AppendableFloatStruct;
        }

        CompleteTypeDetail detail_AppendableFloatStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableFloatStruct, ann_custom_AppendableFloatStruct, type_name_AppendableFloatStruct.to_string());
        CompleteStructHeader header_AppendableFloatStruct;
        header_AppendableFloatStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableFloatStruct);
        CompleteStructMemberSeq member_seq_AppendableFloatStruct;
        {
            TypeIdentifierPair type_ids_var_float;
            ReturnCode_t return_code_var_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_var_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_float)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_float Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_float = 0x00000000;
            bool common_var_float_ec {false};
            CommonStructMember common_var_float {TypeObjectUtils::build_common_struct_member(member_id_var_float, member_flags_var_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_float, common_var_float_ec))};
            if (!common_var_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_float = "var_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_float;
            ann_custom_AppendableFloatStruct.reset();
            CompleteMemberDetail detail_var_float = TypeObjectUtils::build_complete_member_detail(name_var_float, member_ann_builtin_var_float, ann_custom_AppendableFloatStruct);
            CompleteStructMember member_var_float = TypeObjectUtils::build_complete_struct_member(common_var_float, detail_var_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableFloatStruct, member_var_float);
        }
        CompleteStructType struct_type_AppendableFloatStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableFloatStruct, header_AppendableFloatStruct, member_seq_AppendableFloatStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableFloatStruct, type_name_AppendableFloatStruct.to_string(), type_ids_AppendableFloatStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableFloatStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableDoubleStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableDoubleStruct)
{

    ReturnCode_t return_code_AppendableDoubleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableDoubleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableDoubleStruct", type_ids_AppendableDoubleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableDoubleStruct)
    {
        StructTypeFlag struct_flags_AppendableDoubleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableDoubleStruct = "AppendableDoubleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableDoubleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableDoubleStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableDoubleStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableDoubleStruct;
        if (!tmp_ann_custom_AppendableDoubleStruct.empty())
        {
            ann_custom_AppendableDoubleStruct = tmp_ann_custom_AppendableDoubleStruct;
        }

        CompleteTypeDetail detail_AppendableDoubleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableDoubleStruct, ann_custom_AppendableDoubleStruct, type_name_AppendableDoubleStruct.to_string());
        CompleteStructHeader header_AppendableDoubleStruct;
        header_AppendableDoubleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableDoubleStruct);
        CompleteStructMemberSeq member_seq_AppendableDoubleStruct;
        {
            TypeIdentifierPair type_ids_var_double;
            ReturnCode_t return_code_var_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_var_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_double)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_double Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_double = 0x00000000;
            bool common_var_double_ec {false};
            CommonStructMember common_var_double {TypeObjectUtils::build_common_struct_member(member_id_var_double, member_flags_var_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_double, common_var_double_ec))};
            if (!common_var_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_double = "var_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_double;
            ann_custom_AppendableDoubleStruct.reset();
            CompleteMemberDetail detail_var_double = TypeObjectUtils::build_complete_member_detail(name_var_double, member_ann_builtin_var_double, ann_custom_AppendableDoubleStruct);
            CompleteStructMember member_var_double = TypeObjectUtils::build_complete_struct_member(common_var_double, detail_var_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableDoubleStruct, member_var_double);
        }
        CompleteStructType struct_type_AppendableDoubleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableDoubleStruct, header_AppendableDoubleStruct, member_seq_AppendableDoubleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableDoubleStruct, type_name_AppendableDoubleStruct.to_string(), type_ids_AppendableDoubleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableDoubleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableLongDoubleStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableLongDoubleStruct)
{

    ReturnCode_t return_code_AppendableLongDoubleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableLongDoubleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableLongDoubleStruct", type_ids_AppendableLongDoubleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableLongDoubleStruct)
    {
        StructTypeFlag struct_flags_AppendableLongDoubleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableLongDoubleStruct = "AppendableLongDoubleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableLongDoubleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableLongDoubleStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableLongDoubleStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableLongDoubleStruct;
        if (!tmp_ann_custom_AppendableLongDoubleStruct.empty())
        {
            ann_custom_AppendableLongDoubleStruct = tmp_ann_custom_AppendableLongDoubleStruct;
        }

        CompleteTypeDetail detail_AppendableLongDoubleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableLongDoubleStruct, ann_custom_AppendableLongDoubleStruct, type_name_AppendableLongDoubleStruct.to_string());
        CompleteStructHeader header_AppendableLongDoubleStruct;
        header_AppendableLongDoubleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableLongDoubleStruct);
        CompleteStructMemberSeq member_seq_AppendableLongDoubleStruct;
        {
            TypeIdentifierPair type_ids_var_longdouble;
            ReturnCode_t return_code_var_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_var_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longdouble)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longdouble Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longdouble = 0x00000000;
            bool common_var_longdouble_ec {false};
            CommonStructMember common_var_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_longdouble, member_flags_var_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longdouble, common_var_longdouble_ec))};
            if (!common_var_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longdouble = "var_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longdouble;
            ann_custom_AppendableLongDoubleStruct.reset();
            CompleteMemberDetail detail_var_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_longdouble, member_ann_builtin_var_longdouble, ann_custom_AppendableLongDoubleStruct);
            CompleteStructMember member_var_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_longdouble, detail_var_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableLongDoubleStruct, member_var_longdouble);
        }
        CompleteStructType struct_type_AppendableLongDoubleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableLongDoubleStruct, header_AppendableLongDoubleStruct, member_seq_AppendableLongDoubleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableLongDoubleStruct, type_name_AppendableLongDoubleStruct.to_string(), type_ids_AppendableLongDoubleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableLongDoubleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableBooleanStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableBooleanStruct)
{

    ReturnCode_t return_code_AppendableBooleanStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableBooleanStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableBooleanStruct", type_ids_AppendableBooleanStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableBooleanStruct)
    {
        StructTypeFlag struct_flags_AppendableBooleanStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableBooleanStruct = "AppendableBooleanStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableBooleanStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableBooleanStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableBooleanStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableBooleanStruct;
        if (!tmp_ann_custom_AppendableBooleanStruct.empty())
        {
            ann_custom_AppendableBooleanStruct = tmp_ann_custom_AppendableBooleanStruct;
        }

        CompleteTypeDetail detail_AppendableBooleanStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableBooleanStruct, ann_custom_AppendableBooleanStruct, type_name_AppendableBooleanStruct.to_string());
        CompleteStructHeader header_AppendableBooleanStruct;
        header_AppendableBooleanStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableBooleanStruct);
        CompleteStructMemberSeq member_seq_AppendableBooleanStruct;
        {
            TypeIdentifierPair type_ids_var_boolean;
            ReturnCode_t return_code_var_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_var_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_boolean Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_boolean = 0x00000000;
            bool common_var_boolean_ec {false};
            CommonStructMember common_var_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_boolean, member_flags_var_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_boolean, common_var_boolean_ec))};
            if (!common_var_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_boolean = "var_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_boolean;
            ann_custom_AppendableBooleanStruct.reset();
            CompleteMemberDetail detail_var_boolean = TypeObjectUtils::build_complete_member_detail(name_var_boolean, member_ann_builtin_var_boolean, ann_custom_AppendableBooleanStruct);
            CompleteStructMember member_var_boolean = TypeObjectUtils::build_complete_struct_member(common_var_boolean, detail_var_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableBooleanStruct, member_var_boolean);
        }
        CompleteStructType struct_type_AppendableBooleanStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableBooleanStruct, header_AppendableBooleanStruct, member_seq_AppendableBooleanStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableBooleanStruct, type_name_AppendableBooleanStruct.to_string(), type_ids_AppendableBooleanStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableBooleanStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableOctetStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableOctetStruct)
{

    ReturnCode_t return_code_AppendableOctetStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableOctetStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableOctetStruct", type_ids_AppendableOctetStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableOctetStruct)
    {
        StructTypeFlag struct_flags_AppendableOctetStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableOctetStruct = "AppendableOctetStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableOctetStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableOctetStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableOctetStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableOctetStruct;
        if (!tmp_ann_custom_AppendableOctetStruct.empty())
        {
            ann_custom_AppendableOctetStruct = tmp_ann_custom_AppendableOctetStruct;
        }

        CompleteTypeDetail detail_AppendableOctetStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableOctetStruct, ann_custom_AppendableOctetStruct, type_name_AppendableOctetStruct.to_string());
        CompleteStructHeader header_AppendableOctetStruct;
        header_AppendableOctetStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableOctetStruct);
        CompleteStructMemberSeq member_seq_AppendableOctetStruct;
        {
            TypeIdentifierPair type_ids_var_octet;
            ReturnCode_t return_code_var_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_var_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_octet Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_octet = 0x00000000;
            bool common_var_octet_ec {false};
            CommonStructMember common_var_octet {TypeObjectUtils::build_common_struct_member(member_id_var_octet, member_flags_var_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_octet, common_var_octet_ec))};
            if (!common_var_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_octet = "var_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_octet;
            ann_custom_AppendableOctetStruct.reset();
            CompleteMemberDetail detail_var_octet = TypeObjectUtils::build_complete_member_detail(name_var_octet, member_ann_builtin_var_octet, ann_custom_AppendableOctetStruct);
            CompleteStructMember member_var_octet = TypeObjectUtils::build_complete_struct_member(common_var_octet, detail_var_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableOctetStruct, member_var_octet);
        }
        CompleteStructType struct_type_AppendableOctetStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableOctetStruct, header_AppendableOctetStruct, member_seq_AppendableOctetStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableOctetStruct, type_name_AppendableOctetStruct.to_string(), type_ids_AppendableOctetStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableOctetStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableCharStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableCharStruct)
{

    ReturnCode_t return_code_AppendableCharStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableCharStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableCharStruct", type_ids_AppendableCharStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableCharStruct)
    {
        StructTypeFlag struct_flags_AppendableCharStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableCharStruct = "AppendableCharStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableCharStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableCharStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableCharStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableCharStruct;
        if (!tmp_ann_custom_AppendableCharStruct.empty())
        {
            ann_custom_AppendableCharStruct = tmp_ann_custom_AppendableCharStruct;
        }

        CompleteTypeDetail detail_AppendableCharStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableCharStruct, ann_custom_AppendableCharStruct, type_name_AppendableCharStruct.to_string());
        CompleteStructHeader header_AppendableCharStruct;
        header_AppendableCharStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableCharStruct);
        CompleteStructMemberSeq member_seq_AppendableCharStruct;
        {
            TypeIdentifierPair type_ids_var_char8;
            ReturnCode_t return_code_var_char8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_var_char8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char8 = 0x00000000;
            bool common_var_char8_ec {false};
            CommonStructMember common_var_char8 {TypeObjectUtils::build_common_struct_member(member_id_var_char8, member_flags_var_char8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char8, common_var_char8_ec))};
            if (!common_var_char8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char8 = "var_char8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char8;
            ann_custom_AppendableCharStruct.reset();
            CompleteMemberDetail detail_var_char8 = TypeObjectUtils::build_complete_member_detail(name_var_char8, member_ann_builtin_var_char8, ann_custom_AppendableCharStruct);
            CompleteStructMember member_var_char8 = TypeObjectUtils::build_complete_struct_member(common_var_char8, detail_var_char8);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableCharStruct, member_var_char8);
        }
        CompleteStructType struct_type_AppendableCharStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableCharStruct, header_AppendableCharStruct, member_seq_AppendableCharStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableCharStruct, type_name_AppendableCharStruct.to_string(), type_ids_AppendableCharStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableCharStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableWCharStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableWCharStruct)
{

    ReturnCode_t return_code_AppendableWCharStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableWCharStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableWCharStruct", type_ids_AppendableWCharStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableWCharStruct)
    {
        StructTypeFlag struct_flags_AppendableWCharStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableWCharStruct = "AppendableWCharStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableWCharStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableWCharStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableWCharStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableWCharStruct;
        if (!tmp_ann_custom_AppendableWCharStruct.empty())
        {
            ann_custom_AppendableWCharStruct = tmp_ann_custom_AppendableWCharStruct;
        }

        CompleteTypeDetail detail_AppendableWCharStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableWCharStruct, ann_custom_AppendableWCharStruct, type_name_AppendableWCharStruct.to_string());
        CompleteStructHeader header_AppendableWCharStruct;
        header_AppendableWCharStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableWCharStruct);
        CompleteStructMemberSeq member_seq_AppendableWCharStruct;
        {
            TypeIdentifierPair type_ids_var_char16;
            ReturnCode_t return_code_var_char16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_var_char16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char16)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char16 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char16 = 0x00000000;
            bool common_var_char16_ec {false};
            CommonStructMember common_var_char16 {TypeObjectUtils::build_common_struct_member(member_id_var_char16, member_flags_var_char16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char16, common_var_char16_ec))};
            if (!common_var_char16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char16 = "var_char16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char16;
            ann_custom_AppendableWCharStruct.reset();
            CompleteMemberDetail detail_var_char16 = TypeObjectUtils::build_complete_member_detail(name_var_char16, member_ann_builtin_var_char16, ann_custom_AppendableWCharStruct);
            CompleteStructMember member_var_char16 = TypeObjectUtils::build_complete_struct_member(common_var_char16, detail_var_char16);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableWCharStruct, member_var_char16);
        }
        CompleteStructType struct_type_AppendableWCharStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableWCharStruct, header_AppendableWCharStruct, member_seq_AppendableWCharStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableWCharStruct, type_name_AppendableWCharStruct.to_string(), type_ids_AppendableWCharStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableWCharStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableUnionStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableUnionStruct)
{

    ReturnCode_t return_code_AppendableUnionStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableUnionStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableUnionStruct", type_ids_AppendableUnionStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableUnionStruct)
    {
        StructTypeFlag struct_flags_AppendableUnionStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableUnionStruct = "AppendableUnionStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableUnionStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableUnionStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableUnionStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableUnionStruct;
        if (!tmp_ann_custom_AppendableUnionStruct.empty())
        {
            ann_custom_AppendableUnionStruct = tmp_ann_custom_AppendableUnionStruct;
        }

        CompleteTypeDetail detail_AppendableUnionStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableUnionStruct, ann_custom_AppendableUnionStruct, type_name_AppendableUnionStruct.to_string());
        CompleteStructHeader header_AppendableUnionStruct;
        header_AppendableUnionStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableUnionStruct);
        CompleteStructMemberSeq member_seq_AppendableUnionStruct;
        {
            TypeIdentifierPair type_ids_var_union;
            ReturnCode_t return_code_var_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerUnionHelper", type_ids_var_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union)
            {
            ::register_InnerUnionHelper_type_identifier(type_ids_var_union);
            }
            StructMemberFlag member_flags_var_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union = 0x00000000;
            bool common_var_union_ec {false};
            CommonStructMember common_var_union {TypeObjectUtils::build_common_struct_member(member_id_var_union, member_flags_var_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union, common_var_union_ec))};
            if (!common_var_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union = "var_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union;
            ann_custom_AppendableUnionStruct.reset();
            CompleteMemberDetail detail_var_union = TypeObjectUtils::build_complete_member_detail(name_var_union, member_ann_builtin_var_union, ann_custom_AppendableUnionStruct);
            CompleteStructMember member_var_union = TypeObjectUtils::build_complete_struct_member(common_var_union, detail_var_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableUnionStruct, member_var_union);
        }
        CompleteStructType struct_type_AppendableUnionStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableUnionStruct, header_AppendableUnionStruct, member_seq_AppendableUnionStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableUnionStruct, type_name_AppendableUnionStruct.to_string(), type_ids_AppendableUnionStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableUnionStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableEmptyStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableEmptyStruct)
{

    ReturnCode_t return_code_AppendableEmptyStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableEmptyStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableEmptyStruct", type_ids_AppendableEmptyStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableEmptyStruct)
    {
        StructTypeFlag struct_flags_AppendableEmptyStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableEmptyStruct = "AppendableEmptyStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableEmptyStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableEmptyStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableEmptyStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableEmptyStruct;
        if (!tmp_ann_custom_AppendableEmptyStruct.empty())
        {
            ann_custom_AppendableEmptyStruct = tmp_ann_custom_AppendableEmptyStruct;
        }

        CompleteTypeDetail detail_AppendableEmptyStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableEmptyStruct, ann_custom_AppendableEmptyStruct, type_name_AppendableEmptyStruct.to_string());
        CompleteStructHeader header_AppendableEmptyStruct;
        header_AppendableEmptyStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableEmptyStruct);
        CompleteStructMemberSeq member_seq_AppendableEmptyStruct;
        CompleteStructType struct_type_AppendableEmptyStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableEmptyStruct, header_AppendableEmptyStruct, member_seq_AppendableEmptyStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableEmptyStruct, type_name_AppendableEmptyStruct.to_string(), type_ids_AppendableEmptyStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableEmptyStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableEmptyInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableEmptyInheritanceStruct)
{

    ReturnCode_t return_code_AppendableEmptyInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableEmptyInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableEmptyInheritanceStruct", type_ids_AppendableEmptyInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableEmptyInheritanceStruct)
    {
        StructTypeFlag struct_flags_AppendableEmptyInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_AppendableEmptyInheritanceStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "AppendableEmptyStruct", type_ids_AppendableEmptyInheritanceStruct);

        if (return_code_AppendableEmptyInheritanceStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_AppendableEmptyStruct_type_identifier(type_ids_AppendableEmptyInheritanceStruct);
        }
        QualifiedTypeName type_name_AppendableEmptyInheritanceStruct = "AppendableEmptyInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableEmptyInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableEmptyInheritanceStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableEmptyInheritanceStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableEmptyInheritanceStruct;
        if (!tmp_ann_custom_AppendableEmptyInheritanceStruct.empty())
        {
            ann_custom_AppendableEmptyInheritanceStruct = tmp_ann_custom_AppendableEmptyInheritanceStruct;
        }

        CompleteTypeDetail detail_AppendableEmptyInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableEmptyInheritanceStruct, ann_custom_AppendableEmptyInheritanceStruct, type_name_AppendableEmptyInheritanceStruct.to_string());
        CompleteStructHeader header_AppendableEmptyInheritanceStruct;
        if (EK_COMPLETE == type_ids_AppendableEmptyInheritanceStruct.type_identifier1()._d())
        {
            header_AppendableEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_AppendableEmptyInheritanceStruct.type_identifier1(), detail_AppendableEmptyInheritanceStruct);
        }
        else if (EK_COMPLETE == type_ids_AppendableEmptyInheritanceStruct.type_identifier2()._d())
        {
            header_AppendableEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_AppendableEmptyInheritanceStruct.type_identifier2(), detail_AppendableEmptyInheritanceStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableEmptyInheritanceStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_AppendableEmptyInheritanceStruct;
        {
            TypeIdentifierPair type_ids_var_str;
            ReturnCode_t return_code_var_str {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_str =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_str);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_str)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_str))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_str = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_str = 0x00000000;
            bool common_var_str_ec {false};
            CommonStructMember common_var_str {TypeObjectUtils::build_common_struct_member(member_id_var_str, member_flags_var_str, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_str, common_var_str_ec))};
            if (!common_var_str_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_str member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_str = "var_str";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_str;
            ann_custom_AppendableEmptyInheritanceStruct.reset();
            CompleteMemberDetail detail_var_str = TypeObjectUtils::build_complete_member_detail(name_var_str, member_ann_builtin_var_str, ann_custom_AppendableEmptyInheritanceStruct);
            CompleteStructMember member_var_str = TypeObjectUtils::build_complete_struct_member(common_var_str, detail_var_str);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableEmptyInheritanceStruct, member_var_str);
        }
        CompleteStructType struct_type_AppendableEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableEmptyInheritanceStruct, header_AppendableEmptyInheritanceStruct, member_seq_AppendableEmptyInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableEmptyInheritanceStruct, type_name_AppendableEmptyInheritanceStruct.to_string(), type_ids_AppendableEmptyInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableEmptyInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableInheritanceStruct)
{

    ReturnCode_t return_code_AppendableInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableInheritanceStruct", type_ids_AppendableInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableInheritanceStruct)
    {
        StructTypeFlag struct_flags_AppendableInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_AppendableInheritanceStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "AppendableShortStruct", type_ids_AppendableInheritanceStruct);

        if (return_code_AppendableInheritanceStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_AppendableShortStruct_type_identifier(type_ids_AppendableInheritanceStruct);
        }
        QualifiedTypeName type_name_AppendableInheritanceStruct = "AppendableInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableInheritanceStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableInheritanceStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableInheritanceStruct;
        if (!tmp_ann_custom_AppendableInheritanceStruct.empty())
        {
            ann_custom_AppendableInheritanceStruct = tmp_ann_custom_AppendableInheritanceStruct;
        }

        CompleteTypeDetail detail_AppendableInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableInheritanceStruct, ann_custom_AppendableInheritanceStruct, type_name_AppendableInheritanceStruct.to_string());
        CompleteStructHeader header_AppendableInheritanceStruct;
        if (EK_COMPLETE == type_ids_AppendableInheritanceStruct.type_identifier1()._d())
        {
            header_AppendableInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_AppendableInheritanceStruct.type_identifier1(), detail_AppendableInheritanceStruct);
        }
        else if (EK_COMPLETE == type_ids_AppendableInheritanceStruct.type_identifier2()._d())
        {
            header_AppendableInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_AppendableInheritanceStruct.type_identifier2(), detail_AppendableInheritanceStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableInheritanceStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_AppendableInheritanceStruct;
        {
            TypeIdentifierPair type_ids_var_str;
            ReturnCode_t return_code_var_str {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_str =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_str);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_str)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_str))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_str = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_str = 0x00000001;
            bool common_var_str_ec {false};
            CommonStructMember common_var_str {TypeObjectUtils::build_common_struct_member(member_id_var_str, member_flags_var_str, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_str, common_var_str_ec))};
            if (!common_var_str_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_str member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_str = "var_str";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_str;
            ann_custom_AppendableInheritanceStruct.reset();
            CompleteMemberDetail detail_var_str = TypeObjectUtils::build_complete_member_detail(name_var_str, member_ann_builtin_var_str, ann_custom_AppendableInheritanceStruct);
            CompleteStructMember member_var_str = TypeObjectUtils::build_complete_struct_member(common_var_str, detail_var_str);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableInheritanceStruct, member_var_str);
        }
        CompleteStructType struct_type_AppendableInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableInheritanceStruct, header_AppendableInheritanceStruct, member_seq_AppendableInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableInheritanceStruct, type_name_AppendableInheritanceStruct.to_string(), type_ids_AppendableInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableInheritanceEmptyStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableInheritanceEmptyStruct)
{

    ReturnCode_t return_code_AppendableInheritanceEmptyStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableInheritanceEmptyStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableInheritanceEmptyStruct", type_ids_AppendableInheritanceEmptyStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableInheritanceEmptyStruct)
    {
        StructTypeFlag struct_flags_AppendableInheritanceEmptyStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_AppendableInheritanceEmptyStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "AppendableShortStruct", type_ids_AppendableInheritanceEmptyStruct);

        if (return_code_AppendableInheritanceEmptyStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_AppendableShortStruct_type_identifier(type_ids_AppendableInheritanceEmptyStruct);
        }
        QualifiedTypeName type_name_AppendableInheritanceEmptyStruct = "AppendableInheritanceEmptyStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableInheritanceEmptyStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableInheritanceEmptyStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableInheritanceEmptyStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableInheritanceEmptyStruct;
        if (!tmp_ann_custom_AppendableInheritanceEmptyStruct.empty())
        {
            ann_custom_AppendableInheritanceEmptyStruct = tmp_ann_custom_AppendableInheritanceEmptyStruct;
        }

        CompleteTypeDetail detail_AppendableInheritanceEmptyStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableInheritanceEmptyStruct, ann_custom_AppendableInheritanceEmptyStruct, type_name_AppendableInheritanceEmptyStruct.to_string());
        CompleteStructHeader header_AppendableInheritanceEmptyStruct;
        if (EK_COMPLETE == type_ids_AppendableInheritanceEmptyStruct.type_identifier1()._d())
        {
            header_AppendableInheritanceEmptyStruct = TypeObjectUtils::build_complete_struct_header(type_ids_AppendableInheritanceEmptyStruct.type_identifier1(), detail_AppendableInheritanceEmptyStruct);
        }
        else if (EK_COMPLETE == type_ids_AppendableInheritanceEmptyStruct.type_identifier2()._d())
        {
            header_AppendableInheritanceEmptyStruct = TypeObjectUtils::build_complete_struct_header(type_ids_AppendableInheritanceEmptyStruct.type_identifier2(), detail_AppendableInheritanceEmptyStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableInheritanceEmptyStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_AppendableInheritanceEmptyStruct;
        CompleteStructType struct_type_AppendableInheritanceEmptyStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableInheritanceEmptyStruct, header_AppendableInheritanceEmptyStruct, member_seq_AppendableInheritanceEmptyStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableInheritanceEmptyStruct, type_name_AppendableInheritanceEmptyStruct.to_string(), type_ids_AppendableInheritanceEmptyStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableInheritanceEmptyStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableExtensibilityInheritance_type_identifier(
        TypeIdentifierPair& type_ids_AppendableExtensibilityInheritance)
{

    ReturnCode_t return_code_AppendableExtensibilityInheritance {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableExtensibilityInheritance =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableExtensibilityInheritance", type_ids_AppendableExtensibilityInheritance);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableExtensibilityInheritance)
    {
        StructTypeFlag struct_flags_AppendableExtensibilityInheritance = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_AppendableExtensibilityInheritance =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "AppendableShortStruct", type_ids_AppendableExtensibilityInheritance);

        if (return_code_AppendableExtensibilityInheritance != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_AppendableShortStruct_type_identifier(type_ids_AppendableExtensibilityInheritance);
        }
        QualifiedTypeName type_name_AppendableExtensibilityInheritance = "AppendableExtensibilityInheritance";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableExtensibilityInheritance;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableExtensibilityInheritance;
        CompleteTypeDetail detail_AppendableExtensibilityInheritance = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableExtensibilityInheritance, ann_custom_AppendableExtensibilityInheritance, type_name_AppendableExtensibilityInheritance.to_string());
        CompleteStructHeader header_AppendableExtensibilityInheritance;
        if (EK_COMPLETE == type_ids_AppendableExtensibilityInheritance.type_identifier1()._d())
        {
            header_AppendableExtensibilityInheritance = TypeObjectUtils::build_complete_struct_header(type_ids_AppendableExtensibilityInheritance.type_identifier1(), detail_AppendableExtensibilityInheritance);
        }
        else if (EK_COMPLETE == type_ids_AppendableExtensibilityInheritance.type_identifier2()._d())
        {
            header_AppendableExtensibilityInheritance = TypeObjectUtils::build_complete_struct_header(type_ids_AppendableExtensibilityInheritance.type_identifier2(), detail_AppendableExtensibilityInheritance);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableExtensibilityInheritance Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_AppendableExtensibilityInheritance;
        {
            TypeIdentifierPair type_ids_var_long;
            ReturnCode_t return_code_var_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_long = 0x00000001;
            bool common_var_long_ec {false};
            CommonStructMember common_var_long {TypeObjectUtils::build_common_struct_member(member_id_var_long, member_flags_var_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_long, common_var_long_ec))};
            if (!common_var_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_long;
            ann_custom_AppendableExtensibilityInheritance.reset();
            CompleteMemberDetail detail_var_long = TypeObjectUtils::build_complete_member_detail(name_var_long, member_ann_builtin_var_long, ann_custom_AppendableExtensibilityInheritance);
            CompleteStructMember member_var_long = TypeObjectUtils::build_complete_struct_member(common_var_long, detail_var_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableExtensibilityInheritance, member_var_long);
        }
        CompleteStructType struct_type_AppendableExtensibilityInheritance = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableExtensibilityInheritance, header_AppendableExtensibilityInheritance, member_seq_AppendableExtensibilityInheritance);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableExtensibilityInheritance, type_name_AppendableExtensibilityInheritance.to_string(), type_ids_AppendableExtensibilityInheritance))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableExtensibilityInheritance already registered in TypeObjectRegistry for a different type.");
        }
    }
}

