//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdelegatednetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/delegatednetwork/armdelegatednetwork"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/getDelegatedSubnet.json
func ExampleDelegatedSubnetServiceClient_GetDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDelegatedSubnetServiceClient().GetDetails(ctx, "TestRG", "delegated1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DelegatedSubnet = armdelegatednetwork.DelegatedSubnet{
	// 	Name: to.Ptr("delegated1"),
	// 	Type: to.Ptr("Microsoft.DelegatedNetwork/delegatedSubnets"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/delegatedSubnets/delegated1"),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armdelegatednetwork.DelegatedSubnetProperties{
	// 		ControllerDetails: &armdelegatednetwork.ControllerDetails{
	// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller"),
	// 		},
	// 		ProvisioningState: to.Ptr(armdelegatednetwork.DelegatedSubnetStateSucceeded),
	// 		ResourceGUID: to.Ptr("5a82cbcf-e8ea-4175-ac2b-ad36a73f9801"),
	// 		SubnetDetails: &armdelegatednetwork.SubnetDetails{
	// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/putDelegatedSubnet.json
func ExampleDelegatedSubnetServiceClient_BeginPutDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDelegatedSubnetServiceClient().BeginPutDetails(ctx, "TestRG", "delegated1", armdelegatednetwork.DelegatedSubnet{
		Location: to.Ptr("West US"),
		Properties: &armdelegatednetwork.DelegatedSubnetProperties{
			ControllerDetails: &armdelegatednetwork.ControllerDetails{
				ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller"),
			},
			SubnetDetails: &armdelegatednetwork.SubnetDetails{
				ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DelegatedSubnet = armdelegatednetwork.DelegatedSubnet{
	// 	Name: to.Ptr("delegated1"),
	// 	Type: to.Ptr("Microsoft.DelegatedNetwork/delegatedSubnets"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/delegatedSubnets/delegated1"),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armdelegatednetwork.DelegatedSubnetProperties{
	// 		ControllerDetails: &armdelegatednetwork.ControllerDetails{
	// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller"),
	// 		},
	// 		ProvisioningState: to.Ptr(armdelegatednetwork.DelegatedSubnetStateSucceeded),
	// 		ResourceGUID: to.Ptr("5a82cbcf-e8ea-4175-ac2b-ad36a73f9801"),
	// 		SubnetDetails: &armdelegatednetwork.SubnetDetails{
	// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/patchDelegatedSubnet.json
func ExampleDelegatedSubnetServiceClient_BeginPatchDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDelegatedSubnetServiceClient().BeginPatchDetails(ctx, "TestRG", "delegated1", armdelegatednetwork.ResourceUpdateParameters{
		Tags: map[string]*string{
			"key": to.Ptr("value"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DelegatedSubnet = armdelegatednetwork.DelegatedSubnet{
	// 	Name: to.Ptr("delegated1"),
	// 	Type: to.Ptr("Microsoft.DelegatedNetwork/delegatedSubnets"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/delegatedSubnets/delegated1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key": to.Ptr("value"),
	// 	},
	// 	Properties: &armdelegatednetwork.DelegatedSubnetProperties{
	// 		ControllerDetails: &armdelegatednetwork.ControllerDetails{
	// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller"),
	// 		},
	// 		ProvisioningState: to.Ptr(armdelegatednetwork.DelegatedSubnetStateSucceeded),
	// 		ResourceGUID: to.Ptr("5a82cbcf-e8ea-4175-ac2b-ad36a73f9801"),
	// 		SubnetDetails: &armdelegatednetwork.SubnetDetails{
	// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/deleteDelegatedSubnet.json
func ExampleDelegatedSubnetServiceClient_BeginDeleteDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDelegatedSubnetServiceClient().BeginDeleteDetails(ctx, "TestRG", "delegated1", &armdelegatednetwork.DelegatedSubnetServiceClientBeginDeleteDetailsOptions{ForceDelete: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/delegatedSubnetListBySub.json
func ExampleDelegatedSubnetServiceClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDelegatedSubnetServiceClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DelegatedSubnets = armdelegatednetwork.DelegatedSubnets{
		// 	Value: []*armdelegatednetwork.DelegatedSubnet{
		// 		{
		// 			Name: to.Ptr("delegated1"),
		// 			Type: to.Ptr("Microsoft.DelegatedNetwork/delegatedSubnets"),
		// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet/providers/Microsoft.DelegatedNetwork/delegatedSubnets/delegated1"),
		// 			Location: to.Ptr("West US"),
		// 			Properties: &armdelegatednetwork.DelegatedSubnetProperties{
		// 				ControllerDetails: &armdelegatednetwork.ControllerDetails{
		// 					ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller"),
		// 				},
		// 				ProvisioningState: to.Ptr(armdelegatednetwork.DelegatedSubnetStateSucceeded),
		// 				ResourceGUID: to.Ptr("5a82cbcf-e8ea-4175-ac2b-ad36a73f9801"),
		// 				SubnetDetails: &armdelegatednetwork.SubnetDetails{
		// 					ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/delegatedSubnetListByRG.json
func ExampleDelegatedSubnetServiceClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDelegatedSubnetServiceClient().NewListByResourceGroupPager("testRG", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DelegatedSubnets = armdelegatednetwork.DelegatedSubnets{
		// 	Value: []*armdelegatednetwork.DelegatedSubnet{
		// 		{
		// 			Name: to.Ptr("delegated1"),
		// 			Type: to.Ptr("Microsoft.DelegatedNetwork/delegatedSubnets"),
		// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/delegatedSubnets/delegated1"),
		// 			Location: to.Ptr("West US"),
		// 			Properties: &armdelegatednetwork.DelegatedSubnetProperties{
		// 				ControllerDetails: &armdelegatednetwork.ControllerDetails{
		// 					ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller"),
		// 				},
		// 				ProvisioningState: to.Ptr(armdelegatednetwork.DelegatedSubnetStateSucceeded),
		// 				ResourceGUID: to.Ptr("5a82cbcf-e8ea-4175-ac2b-ad36a73f9801"),
		// 				SubnetDetails: &armdelegatednetwork.SubnetDetails{
		// 					ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}
