//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdeploymentscripts_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armdeploymentscripts/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Create.json
func ExampleClient_BeginCreate_deploymentScriptsCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreate(ctx, "script-rg", "MyDeploymentScript", &armdeploymentscripts.AzurePowerShellScript{
		Identity: &armdeploymentscripts.ManagedServiceIdentity{
			Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": {},
			},
		},
		Kind:     to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
		Location: to.Ptr("westus"),
		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
			Arguments:         to.Ptr("-Location 'westus' -Name \"*rg2\""),
			RetentionInterval: to.Ptr("PT7D"),
			ScriptContent:     to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
			SupportingScriptUris: []*string{
				to.Ptr("https://uri1.to.supporting.script"),
				to.Ptr("https://uri2.to.supporting.script")},
			Timeout:             to.Ptr("PT1H"),
			AzPowerShellVersion: to.Ptr("1.7.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdeploymentscripts.ClientCreateResponse{
	// 	                            DeploymentScriptClassification: &armdeploymentscripts.AzurePowerShellScript{
	// 		Identity: &armdeploymentscripts.ManagedServiceIdentity{
	// 			Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
	// 			UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
	// 				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": &armdeploymentscripts.UserAssignedIdentity{
	// 				},
	// 			},
	// 		},
	// 		Kind: to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
	// 		Location: to.Ptr("westus"),
	// 		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
	// 			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
	// 			Outputs: map[string]any{
	// 				"output1": "value1",
	// 			},
	// 			ProvisioningState: to.Ptr(armdeploymentscripts.ScriptProvisioningStateSucceeded),
	// 			Status: &armdeploymentscripts.ScriptStatus{
	// 				ContainerInstanceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ContainerInstance/containerGroups/scriptContainer"),
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StorageAccountID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.Storage/storageAccounts/scriptStorage"),
	// 			},
	// 			Arguments: to.Ptr("-Location 'westus' -Name \"*rg2\""),
	// 			RetentionInterval: to.Ptr("P7D"),
	// 			ScriptContent: to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
	// 			SupportingScriptUris: []*string{
	// 				to.Ptr("https://uri1.to.supporting.script"),
	// 				to.Ptr("https://uri2.to.supporting.script")},
	// 				Timeout: to.Ptr("PT1H"),
	// 				AzPowerShellVersion: to.Ptr("1.7.0"),
	// 			},
	// 		},
	// 		                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Create_No_UserManagedIdentity.json
func ExampleClient_BeginCreate_deploymentScriptsCreateNoUserManagedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreate(ctx, "script-rg", "MyDeploymentScript", &armdeploymentscripts.AzurePowerShellScript{
		Kind:     to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
		Location: to.Ptr("westus"),
		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
			Arguments:         to.Ptr("-Location 'westus' -Name \"*rg2\""),
			RetentionInterval: to.Ptr("PT7D"),
			ScriptContent:     to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
			SupportingScriptUris: []*string{
				to.Ptr("https://uri1.to.supporting.script"),
				to.Ptr("https://uri2.to.supporting.script")},
			Timeout:             to.Ptr("PT1H"),
			AzPowerShellVersion: to.Ptr("1.7.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdeploymentscripts.ClientCreateResponse{
	// 	                            DeploymentScriptClassification: &armdeploymentscripts.AzurePowerShellScript{
	// 		Kind: to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
	// 		Location: to.Ptr("westus"),
	// 		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
	// 			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
	// 			Outputs: map[string]any{
	// 				"output1": "value1",
	// 			},
	// 			ProvisioningState: to.Ptr(armdeploymentscripts.ScriptProvisioningStateSucceeded),
	// 			Status: &armdeploymentscripts.ScriptStatus{
	// 				ContainerInstanceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ContainerInstance/containerGroups/scriptContainer"),
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StorageAccountID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.Storage/storageAccounts/scriptStorage"),
	// 			},
	// 			Arguments: to.Ptr("-Location 'westus' -Name \"*rg2\""),
	// 			RetentionInterval: to.Ptr("P7D"),
	// 			ScriptContent: to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
	// 			SupportingScriptUris: []*string{
	// 				to.Ptr("https://uri1.to.supporting.script"),
	// 				to.Ptr("https://uri2.to.supporting.script")},
	// 				Timeout: to.Ptr("PT1H"),
	// 				AzPowerShellVersion: to.Ptr("1.7.0"),
	// 			},
	// 		},
	// 		                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Min_Create.json
func ExampleClient_BeginCreate_deploymentScriptsCreateMinCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreate(ctx, "script-rg", "MyDeploymentScript", &armdeploymentscripts.AzurePowerShellScript{
		Identity: &armdeploymentscripts.ManagedServiceIdentity{
			Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": {},
			},
		},
		Kind:     to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
		Location: to.Ptr("westus"),
		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
			Arguments:           to.Ptr("-Location 'westus' -Name \"*rg2\""),
			RetentionInterval:   to.Ptr("P7D"),
			ScriptContent:       to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
			AzPowerShellVersion: to.Ptr("1.7.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdeploymentscripts.ClientCreateResponse{
	// 	                            DeploymentScriptClassification: &armdeploymentscripts.AzurePowerShellScript{
	// 		Identity: &armdeploymentscripts.ManagedServiceIdentity{
	// 			Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
	// 			UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
	// 				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": &armdeploymentscripts.UserAssignedIdentity{
	// 				},
	// 			},
	// 		},
	// 		Kind: to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
	// 		Location: to.Ptr("westus"),
	// 		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
	// 			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
	// 			Outputs: map[string]any{
	// 				"output1": "value1",
	// 			},
	// 			ProvisioningState: to.Ptr(armdeploymentscripts.ScriptProvisioningStateSucceeded),
	// 			Status: &armdeploymentscripts.ScriptStatus{
	// 				ContainerInstanceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ContainerInstance/containerGroups/scriptContainer"),
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StorageAccountID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.Storage/storageAccounts/scriptStorage"),
	// 			},
	// 			Arguments: to.Ptr("-Location 'westus' -Name \"*rg2\""),
	// 			RetentionInterval: to.Ptr("P7D"),
	// 			ScriptContent: to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
	// 			Timeout: to.Ptr("PT1H"),
	// 			AzPowerShellVersion: to.Ptr("1.7.0"),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Create_Using_Custom_Aci_Name.json
func ExampleClient_BeginCreate_deploymentScriptsCreateUsingCustomAciName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreate(ctx, "script-rg", "MyDeploymentScript", &armdeploymentscripts.AzurePowerShellScript{
		Identity: &armdeploymentscripts.ManagedServiceIdentity{
			Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": {},
			},
		},
		Kind:     to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
		Location: to.Ptr("westus"),
		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
			ContainerSettings: &armdeploymentscripts.ContainerConfiguration{
				ContainerGroupName: to.Ptr("contoso-aci"),
			},
			Arguments:         to.Ptr("-Location 'westus' -Name \"*rg2\""),
			RetentionInterval: to.Ptr("PT7D"),
			ScriptContent:     to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
			SupportingScriptUris: []*string{
				to.Ptr("https://uri1.to.supporting.script"),
				to.Ptr("https://uri2.to.supporting.script")},
			Timeout:             to.Ptr("PT1H"),
			AzPowerShellVersion: to.Ptr("1.7.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdeploymentscripts.ClientCreateResponse{
	// 	                            DeploymentScriptClassification: &armdeploymentscripts.AzurePowerShellScript{
	// 		Identity: &armdeploymentscripts.ManagedServiceIdentity{
	// 			Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
	// 			UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
	// 				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": &armdeploymentscripts.UserAssignedIdentity{
	// 				},
	// 			},
	// 		},
	// 		Kind: to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
	// 		Location: to.Ptr("westus"),
	// 		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
	// 			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
	// 			ContainerSettings: &armdeploymentscripts.ContainerConfiguration{
	// 				ContainerGroupName: to.Ptr("contoso-aci"),
	// 			},
	// 			Outputs: map[string]any{
	// 				"output1": "value1",
	// 			},
	// 			ProvisioningState: to.Ptr(armdeploymentscripts.ScriptProvisioningStateSucceeded),
	// 			Status: &armdeploymentscripts.ScriptStatus{
	// 				ContainerInstanceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ContainerInstance/containerGroups/scriptContainer"),
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StorageAccountID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.Storage/storageAccounts/scriptStorage"),
	// 			},
	// 			Arguments: to.Ptr("-Location 'westus' -Name \"*rg2\""),
	// 			RetentionInterval: to.Ptr("P7D"),
	// 			ScriptContent: to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
	// 			SupportingScriptUris: []*string{
	// 				to.Ptr("https://uri1.to.supporting.script"),
	// 				to.Ptr("https://uri2.to.supporting.script")},
	// 				Timeout: to.Ptr("PT1H"),
	// 				AzPowerShellVersion: to.Ptr("1.7.0"),
	// 			},
	// 		},
	// 		                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Create_Using_Existing_StorageAccount.json
func ExampleClient_BeginCreate_deploymentScriptsCreateUsingExistingStorageAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreate(ctx, "script-rg", "MyDeploymentScript", &armdeploymentscripts.AzurePowerShellScript{
		Identity: &armdeploymentscripts.ManagedServiceIdentity{
			Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": {},
			},
		},
		Kind:     to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
		Location: to.Ptr("westus"),
		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
			StorageAccountSettings: &armdeploymentscripts.StorageAccountConfiguration{
				StorageAccountKey:  to.Ptr("contosostoragekey"),
				StorageAccountName: to.Ptr("contosostorage"),
			},
			Arguments:         to.Ptr("-Location 'westus' -Name \"*rg2\""),
			RetentionInterval: to.Ptr("PT7D"),
			ScriptContent:     to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
			SupportingScriptUris: []*string{
				to.Ptr("https://uri1.to.supporting.script"),
				to.Ptr("https://uri2.to.supporting.script")},
			Timeout:             to.Ptr("PT1H"),
			AzPowerShellVersion: to.Ptr("1.7.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdeploymentscripts.ClientCreateResponse{
	// 	                            DeploymentScriptClassification: &armdeploymentscripts.AzurePowerShellScript{
	// 		Identity: &armdeploymentscripts.ManagedServiceIdentity{
	// 			Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
	// 			UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
	// 				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": &armdeploymentscripts.UserAssignedIdentity{
	// 				},
	// 			},
	// 		},
	// 		Kind: to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
	// 		Location: to.Ptr("westus"),
	// 		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
	// 			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
	// 			Outputs: map[string]any{
	// 				"output1": "value1",
	// 			},
	// 			ProvisioningState: to.Ptr(armdeploymentscripts.ScriptProvisioningStateSucceeded),
	// 			Status: &armdeploymentscripts.ScriptStatus{
	// 				ContainerInstanceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ContainerInstance/containerGroups/scriptContainer"),
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StorageAccountID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.Storage/storageAccounts/scriptStorage"),
	// 			},
	// 			StorageAccountSettings: &armdeploymentscripts.StorageAccountConfiguration{
	// 				StorageAccountName: to.Ptr("contosostorage"),
	// 			},
	// 			Arguments: to.Ptr("-Location 'westus' -Name \"*rg2\""),
	// 			RetentionInterval: to.Ptr("P7D"),
	// 			ScriptContent: to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
	// 			SupportingScriptUris: []*string{
	// 				to.Ptr("https://uri1.to.supporting.script"),
	// 				to.Ptr("https://uri2.to.supporting.script")},
	// 				Timeout: to.Ptr("PT1H"),
	// 				AzPowerShellVersion: to.Ptr("1.7.0"),
	// 			},
	// 		},
	// 		                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Update.json
func ExampleClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Update(ctx, "script-rg", "MyDeploymentScript", &armdeploymentscripts.ClientUpdateOptions{DeploymentScript: &armdeploymentscripts.DeploymentScriptUpdateParameter{
		Tags: map[string]*string{},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdeploymentscripts.ClientUpdateResponse{
	// 	                            DeploymentScriptClassification: &armdeploymentscripts.AzurePowerShellScript{
	// 		Identity: &armdeploymentscripts.ManagedServiceIdentity{
	// 			Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
	// 			UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
	// 				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": &armdeploymentscripts.UserAssignedIdentity{
	// 				},
	// 			},
	// 		},
	// 		Kind: to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
	// 		Location: to.Ptr("westus"),
	// 		SystemData: &armdeploymentscripts.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armdeploymentscripts.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armdeploymentscripts.CreatedByTypeApplication),
	// 		},
	// 		Tags: map[string]*string{
	// 		},
	// 		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
	// 			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
	// 			Outputs: map[string]any{
	// 				"output1": "value1",
	// 			},
	// 			ProvisioningState: to.Ptr(armdeploymentscripts.ScriptProvisioningStateSucceeded),
	// 			Status: &armdeploymentscripts.ScriptStatus{
	// 				ContainerInstanceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ContainerInstance/containerGroups/scriptContainer"),
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StorageAccountID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.Storage/storageAccounts/scriptStorage"),
	// 			},
	// 			Arguments: to.Ptr("-Location 'westus' -Name \"*rg2\""),
	// 			RetentionInterval: to.Ptr("P7D"),
	// 			ScriptContent: to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
	// 			SupportingScriptUris: []*string{
	// 				to.Ptr("https://uri1.to.supporting.script"),
	// 				to.Ptr("https://uri2.to.supporting.script")},
	// 				Timeout: to.Ptr("PT1H"),
	// 				AzPowerShellVersion: to.Ptr("1.7.0"),
	// 			},
	// 		},
	// 		                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Get.json
func ExampleClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Get(ctx, "script-rg", "MyDeploymentScript", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdeploymentscripts.ClientGetResponse{
	// 	                            DeploymentScriptClassification: &armdeploymentscripts.AzurePowerShellScript{
	// 		Identity: &armdeploymentscripts.ManagedServiceIdentity{
	// 			Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
	// 			UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
	// 				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": &armdeploymentscripts.UserAssignedIdentity{
	// 				},
	// 			},
	// 		},
	// 		Kind: to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
	// 		Location: to.Ptr("westus"),
	// 		SystemData: &armdeploymentscripts.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armdeploymentscripts.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armdeploymentscripts.CreatedByTypeApplication),
	// 		},
	// 		Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
	// 			CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
	// 			Outputs: map[string]any{
	// 				"output1": "value1",
	// 			},
	// 			ProvisioningState: to.Ptr(armdeploymentscripts.ScriptProvisioningStateSucceeded),
	// 			Status: &armdeploymentscripts.ScriptStatus{
	// 				ContainerInstanceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ContainerInstance/containerGroups/scriptContainer"),
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
	// 				StorageAccountID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.Storage/storageAccounts/scriptStorage"),
	// 			},
	// 			Arguments: to.Ptr("-Location 'westus' -Name \"*rg2\""),
	// 			RetentionInterval: to.Ptr("PT7D"),
	// 			ScriptContent: to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
	// 			Timeout: to.Ptr("PT1H"),
	// 			AzPowerShellVersion: to.Ptr("1.7.0"),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_Delete.json
func ExampleClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewClient().Delete(ctx, "script-rg", "MyDeploymentScript", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_ListBySubscription.json
func ExampleClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeploymentScriptListResult = armdeploymentscripts.DeploymentScriptListResult{
		// 	Value: []armdeploymentscripts.DeploymentScriptClassification{
		// 		&armdeploymentscripts.AzurePowerShellScript{
		// 			Identity: &armdeploymentscripts.ManagedServiceIdentity{
		// 				Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": &armdeploymentscripts.UserAssignedIdentity{
		// 					},
		// 				},
		// 			},
		// 			Kind: to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
		// 			Location: to.Ptr("westus"),
		// 			SystemData: &armdeploymentscripts.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armdeploymentscripts.CreatedByTypeApplication),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armdeploymentscripts.CreatedByTypeApplication),
		// 			},
		// 			Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
		// 				CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
		// 				Outputs: map[string]any{
		// 					"output1": "value1",
		// 				},
		// 				ProvisioningState: to.Ptr(armdeploymentscripts.ScriptProvisioningStateSucceeded),
		// 				Status: &armdeploymentscripts.ScriptStatus{
		// 					ContainerInstanceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ContainerInstance/containerGroups/scriptContainer"),
		// 					EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
		// 					StorageAccountID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.Storage/storageAccounts/scriptStorage"),
		// 				},
		// 				Arguments: to.Ptr("-Location 'westus' -Name \"*rg2\""),
		// 				RetentionInterval: to.Ptr("PT7D"),
		// 				ScriptContent: to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
		// 				Timeout: to.Ptr("PT1H"),
		// 				AzPowerShellVersion: to.Ptr("1.7.0"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_GetLogs.json
func ExampleClient_GetLogs() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().GetLogs(ctx, "script-rg", "MyDeploymentScript", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScriptLogsList = armdeploymentscripts.ScriptLogsList{
	// 	Value: []*armdeploymentscripts.ScriptLog{
	// 		{
	// 			Properties: &armdeploymentscripts.LogProperties{
	// 				Log: to.Ptr("script execution stdout/stderr logs"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_GetLogsDefault.json
func ExampleClient_GetLogsDefault_deploymentScriptsGetLogs() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().GetLogsDefault(ctx, "script-rg", "MyDeploymentScript", &armdeploymentscripts.ClientGetLogsDefaultOptions{Tail: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScriptLog = armdeploymentscripts.ScriptLog{
	// 	Properties: &armdeploymentscripts.LogProperties{
	// 		Log: to.Ptr("script execution stdout/stderr logs"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_GetLogsDefaultWithTail.json
func ExampleClient_GetLogsDefault_deploymentScriptsGetLogsWithTail() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().GetLogsDefault(ctx, "script-rg", "MyDeploymentScript", &armdeploymentscripts.ClientGetLogsDefaultOptions{Tail: to.Ptr[int32](5)})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScriptLog = armdeploymentscripts.ScriptLog{
	// 	Properties: &armdeploymentscripts.LogProperties{
	// 		Log: to.Ptr("script execution stdout/stderr logs"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resources/resource-manager/Microsoft.Resources/stable/2020-10-01/examples/DeploymentScripts_ListByResourceGroup.json
func ExampleClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentscripts.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListByResourceGroupPager("script-rg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeploymentScriptListResult = armdeploymentscripts.DeploymentScriptListResult{
		// 	Value: []armdeploymentscripts.DeploymentScriptClassification{
		// 		&armdeploymentscripts.AzurePowerShellScript{
		// 			Identity: &armdeploymentscripts.ManagedServiceIdentity{
		// 				Type: to.Ptr(armdeploymentscripts.ManagedServiceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armdeploymentscripts.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai": &armdeploymentscripts.UserAssignedIdentity{
		// 					},
		// 				},
		// 			},
		// 			Kind: to.Ptr(armdeploymentscripts.ScriptTypeAzurePowerShell),
		// 			Location: to.Ptr("westus"),
		// 			SystemData: &armdeploymentscripts.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armdeploymentscripts.CreatedByTypeApplication),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armdeploymentscripts.CreatedByTypeApplication),
		// 			},
		// 			Properties: &armdeploymentscripts.AzurePowerShellScriptProperties{
		// 				CleanupPreference: to.Ptr(armdeploymentscripts.CleanupOptionsAlways),
		// 				Outputs: map[string]any{
		// 					"output1": "value1",
		// 				},
		// 				ProvisioningState: to.Ptr(armdeploymentscripts.ScriptProvisioningStateSucceeded),
		// 				Status: &armdeploymentscripts.ScriptStatus{
		// 					ContainerInstanceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.ContainerInstance/containerGroups/scriptContainer"),
		// 					EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-13T23:19:45.000Z"); return t}()),
		// 					StorageAccountID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scriptRG/providers/Microsoft.Storage/storageAccounts/scriptStorage"),
		// 				},
		// 				Arguments: to.Ptr("-Location 'westus' -Name \"*rg2\""),
		// 				RetentionInterval: to.Ptr("P7D"),
		// 				ScriptContent: to.Ptr("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
		// 				SupportingScriptUris: []*string{
		// 					to.Ptr("https://uri1.to.supporting.script"),
		// 					to.Ptr("https://uri2.to.supporting.script")},
		// 					Timeout: to.Ptr("PT1H"),
		// 					AzPowerShellVersion: to.Ptr("1.7.0"),
		// 				},
		// 		}},
		// 	}
	}
}
