//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VulnerabilityAssessmentExecuteScanClient contains the methods for the SQLVulnerabilityAssessmentExecuteScan group.
// Don't use this type directly, use NewVulnerabilityAssessmentExecuteScanClient() instead.
type VulnerabilityAssessmentExecuteScanClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewVulnerabilityAssessmentExecuteScanClient creates a new instance of VulnerabilityAssessmentExecuteScanClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVulnerabilityAssessmentExecuteScanClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VulnerabilityAssessmentExecuteScanClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VulnerabilityAssessmentExecuteScanClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginExecute - Executes a Vulnerability Assessment database scan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - VulnerabilityAssessmentExecuteScanClientBeginExecuteOptions contains the optional parameters for the VulnerabilityAssessmentExecuteScanClient.BeginExecute
//     method.
func (client *VulnerabilityAssessmentExecuteScanClient) BeginExecute(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *VulnerabilityAssessmentExecuteScanClientBeginExecuteOptions) (*runtime.Poller[VulnerabilityAssessmentExecuteScanClientExecuteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.execute(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[VulnerabilityAssessmentExecuteScanClientExecuteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[VulnerabilityAssessmentExecuteScanClientExecuteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Execute - Executes a Vulnerability Assessment database scan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
func (client *VulnerabilityAssessmentExecuteScanClient) execute(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *VulnerabilityAssessmentExecuteScanClientBeginExecuteOptions) (*http.Response, error) {
	var err error
	const operationName = "VulnerabilityAssessmentExecuteScanClient.BeginExecute"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.executeCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// executeCreateRequest creates the Execute request.
func (client *VulnerabilityAssessmentExecuteScanClient) executeCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *VulnerabilityAssessmentExecuteScanClientBeginExecuteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/initiateScan"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("systemDatabaseName", "master")
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}
