/* Automatically generated nanopb header */
/* Generated by nanopb-0.4.8-dev */

#ifndef PB_OPENTELEMETRY_PROTO_METRICS_V1_OPENTELEMETRY_PROTO_METRICS_V1_METRICS_PB_H_INCLUDED
#define PB_OPENTELEMETRY_PROTO_METRICS_V1_OPENTELEMETRY_PROTO_METRICS_V1_METRICS_PB_H_INCLUDED
#include <nanopb/pb.h>
#include "opentelemetry/common.pb.h"
#include "opentelemetry/resource.pb.h"

#if PB_PROTO_HEADER_VERSION != 40
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Enum definitions */
/* AggregationTemporality defines how a metric aggregator reports aggregated
 values. It describes how those values relate to the time interval over
 which they are aggregated. */
typedef enum _opentelemetry_proto_metrics_v1_AggregationTemporality {
    /* UNSPECIFIED is the default AggregationTemporality, it MUST not be used. */
    opentelemetry_proto_metrics_v1_AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED = 0,
    /* DELTA is an AggregationTemporality for a metric aggregator which reports
 changes since last report time. Successive metrics contain aggregation of
 values from continuous and non-overlapping intervals.

 The values for a DELTA metric are based only on the time interval
 associated with one measurement cycle. There is no dependency on
 previous measurements like is the case for CUMULATIVE metrics.

 For example, consider a system measuring the number of requests that
 it receives and reports the sum of these requests every second as a
 DELTA metric:

   1. The system starts receiving at time=t_0.
   2. A request is received, the system measures 1 request.
   3. A request is received, the system measures 1 request.
   4. A request is received, the system measures 1 request.
   5. The 1 second collection cycle ends. A metric is exported for the
      number of requests received over the interval of time t_0 to
      t_0+1 with a value of 3.
   6. A request is received, the system measures 1 request.
   7. A request is received, the system measures 1 request.
   8. The 1 second collection cycle ends. A metric is exported for the
      number of requests received over the interval of time t_0+1 to
      t_0+2 with a value of 2. */
    opentelemetry_proto_metrics_v1_AggregationTemporality_AGGREGATION_TEMPORALITY_DELTA = 1,
    /* CUMULATIVE is an AggregationTemporality for a metric aggregator which
 reports changes since a fixed start time. This means that current values
 of a CUMULATIVE metric depend on all previous measurements since the
 start time. Because of this, the sender is required to retain this state
 in some form. If this state is lost or invalidated, the CUMULATIVE metric
 values MUST be reset and a new fixed start time following the last
 reported measurement time sent MUST be used.

 For example, consider a system measuring the number of requests that
 it receives and reports the sum of these requests every second as a
 CUMULATIVE metric:

   1. The system starts receiving at time=t_0.
   2. A request is received, the system measures 1 request.
   3. A request is received, the system measures 1 request.
   4. A request is received, the system measures 1 request.
   5. The 1 second collection cycle ends. A metric is exported for the
      number of requests received over the interval of time t_0 to
      t_0+1 with a value of 3.
   6. A request is received, the system measures 1 request.
   7. A request is received, the system measures 1 request.
   8. The 1 second collection cycle ends. A metric is exported for the
      number of requests received over the interval of time t_0 to
      t_0+2 with a value of 5.
   9. The system experiences a fault and loses state.
   10. The system recovers and resumes receiving at time=t_1.
   11. A request is received, the system measures 1 request.
   12. The 1 second collection cycle ends. A metric is exported for the
      number of requests received over the interval of time t_1 to
      t_0+1 with a value of 1.

 Note: Even though, when reporting changes since last report time, using
 CUMULATIVE is valid, it is not recommended. This may cause problems for
 systems that do not use start_time to determine when the aggregation
 value was reset (e.g. Prometheus). */
    opentelemetry_proto_metrics_v1_AggregationTemporality_AGGREGATION_TEMPORALITY_CUMULATIVE = 2
} opentelemetry_proto_metrics_v1_AggregationTemporality;

/* DataPointFlags is defined as a protobuf 'uint32' type and is to be used as a
 bit-field representing 32 distinct boolean flags.  Each flag defined in this
 enum is a bit-mask.  To test the presence of a single flag in the flags of
 a data point, for example, use an expression like:

   (point.flags & DATA_POINT_FLAGS_NO_RECORDED_VALUE_MASK) == DATA_POINT_FLAGS_NO_RECORDED_VALUE_MASK */
typedef enum _opentelemetry_proto_metrics_v1_DataPointFlags {
    /* The zero value for the enum. Should not be used for comparisons.
 Instead use bitwise "and" with the appropriate mask as shown above. */
    opentelemetry_proto_metrics_v1_DataPointFlags_DATA_POINT_FLAGS_DO_NOT_USE = 0,
    /* This DataPoint is valid but has no recorded value.  This value
 SHOULD be used to reflect explicitly missing data in a series, as
 for an equivalent to the Prometheus "staleness marker". */
    opentelemetry_proto_metrics_v1_DataPointFlags_DATA_POINT_FLAGS_NO_RECORDED_VALUE_MASK = 1
} opentelemetry_proto_metrics_v1_DataPointFlags;

/* Struct definitions */
/* MetricsData represents the metrics data that can be stored in a persistent
 storage, OR can be embedded by other protocols that transfer OTLP metrics
 data but do not implement the OTLP protocol.

 The main difference between this message and collector protocol is that
 in this message there will not be any "control" or "metadata" specific to
 OTLP protocol.

 When new fields are added into this message, the OTLP request MUST be updated
 as well. */
typedef struct _opentelemetry_proto_metrics_v1_MetricsData {
    /* An array of ResourceMetrics.
 For data coming from a single resource this array will typically contain
 one element. Intermediary nodes that receive data from multiple origins
 typically batch the data before forwarding further and in that case this
 array will contain multiple elements. */
    pb_callback_t resource_metrics;
} opentelemetry_proto_metrics_v1_MetricsData;

/* A collection of ScopeMetrics from a Resource. */
typedef struct _opentelemetry_proto_metrics_v1_ResourceMetrics {
    /* The resource for the metrics in this message.
 If this field is not set then no resource info is known. */
    bool has_resource;
    opentelemetry_proto_resource_v1_Resource resource;
    /* A list of metrics that originate from a resource. */
    pb_callback_t scope_metrics;
    /* This schema_url applies to the data in the "resource" field. It does not apply
 to the data in the "scope_metrics" field which have their own schema_url field. */
    pb_callback_t schema_url;
} opentelemetry_proto_metrics_v1_ResourceMetrics;

/* A collection of Metrics produced by an Scope. */
typedef struct _opentelemetry_proto_metrics_v1_ScopeMetrics {
    /* The instrumentation scope information for the metrics in this message.
 Semantically when InstrumentationScope isn't set, it is equivalent with
 an empty instrumentation scope name (unknown). */
    bool has_scope;
    opentelemetry_proto_common_v1_InstrumentationScope scope;
    /* A list of metrics that originate from an instrumentation library. */
    pb_callback_t metrics;
    /* This schema_url applies to all metrics in the "metrics" field. */
    pb_callback_t schema_url;
} opentelemetry_proto_metrics_v1_ScopeMetrics;

/* Gauge represents the type of a scalar metric that always exports the
 "current value" for every data point. It should be used for an "unknown"
 aggregation.

 A Gauge does not support different aggregation temporalities. Given the
 aggregation is unknown, points cannot be combined using the same
 aggregation, regardless of aggregation temporalities. Therefore,
 AggregationTemporality is not included. Consequently, this also means
 "StartTimeUnixNano" is ignored for all data points. */
typedef struct _opentelemetry_proto_metrics_v1_Gauge {
    pb_callback_t data_points;
} opentelemetry_proto_metrics_v1_Gauge;

/* Sum represents the type of a scalar metric that is calculated as a sum of all
 reported measurements over a time interval. */
typedef struct _opentelemetry_proto_metrics_v1_Sum {
    pb_callback_t data_points;
    /* aggregation_temporality describes if the aggregator reports delta changes
 since last report time, or cumulative changes since a fixed start time. */
    opentelemetry_proto_metrics_v1_AggregationTemporality aggregation_temporality;
    /* If "true" means that the sum is monotonic. */
    bool is_monotonic;
} opentelemetry_proto_metrics_v1_Sum;

/* Histogram represents the type of a metric that is calculated by aggregating
 as a Histogram of all reported measurements over a time interval. */
typedef struct _opentelemetry_proto_metrics_v1_Histogram {
    pb_callback_t data_points;
    /* aggregation_temporality describes if the aggregator reports delta changes
 since last report time, or cumulative changes since a fixed start time. */
    opentelemetry_proto_metrics_v1_AggregationTemporality aggregation_temporality;
} opentelemetry_proto_metrics_v1_Histogram;

/* ExponentialHistogram represents the type of a metric that is calculated by aggregating
 as a ExponentialHistogram of all reported double measurements over a time interval. */
typedef struct _opentelemetry_proto_metrics_v1_ExponentialHistogram {
    pb_callback_t data_points;
    /* aggregation_temporality describes if the aggregator reports delta changes
 since last report time, or cumulative changes since a fixed start time. */
    opentelemetry_proto_metrics_v1_AggregationTemporality aggregation_temporality;
} opentelemetry_proto_metrics_v1_ExponentialHistogram;

/* Summary metric data are used to convey quantile summaries,
 a Prometheus (see: https://prometheus.io/docs/concepts/metric_types/#summary)
 and OpenMetrics (see: https://github.com/OpenObservability/OpenMetrics/blob/4dbf6075567ab43296eed941037c12951faafb92/protos/prometheus.proto#L45)
 data type. These data points cannot always be merged in a meaningful way.
 While they can be useful in some applications, histogram data points are
 recommended for new applications. */
typedef struct _opentelemetry_proto_metrics_v1_Summary {
    pb_callback_t data_points;
} opentelemetry_proto_metrics_v1_Summary;

/* Defines a Metric which has one or more timeseries.  The following is a
 brief summary of the Metric data model.  For more details, see:

   https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/data-model.md


 The data model and relation between entities is shown in the
 diagram below. Here, "DataPoint" is the term used to refer to any
 one of the specific data point value types, and "points" is the term used
 to refer to any one of the lists of points contained in the Metric.

 - Metric is composed of a metadata and data.
 - Metadata part contains a name, description, unit.
 - Data is one of the possible types (Sum, Gauge, Histogram, Summary).
 - DataPoint contains timestamps, attributes, and one of the possible value type
   fields.

     Metric
  +------------+
  |name        |
  |description |
  |unit        |     +------------------------------------+
  |data        |---> |Gauge, Sum, Histogram, Summary, ... |
  +------------+     +------------------------------------+

    Data [One of Gauge, Sum, Histogram, Summary, ...]
  +-----------+
  |...        |  // Metadata about the Data.
  |points     |--+
  +-----------+  |
                 |      +---------------------------+
                 |      |DataPoint 1                |
                 v      |+------+------+   +------+ |
              +-----+   ||label |label |...|label | |
              |  1  |-->||value1|value2|...|valueN| |
              +-----+   |+------+------+   +------+ |
              |  .  |   |+-----+                    |
              |  .  |   ||value|                    |
              |  .  |   |+-----+                    |
              |  .  |   +---------------------------+
              |  .  |                   .
              |  .  |                   .
              |  .  |                   .
              |  .  |   +---------------------------+
              |  .  |   |DataPoint M                |
              +-----+   |+------+------+   +------+ |
              |  M  |-->||label |label |...|label | |
              +-----+   ||value1|value2|...|valueN| |
                        |+------+------+   +------+ |
                        |+-----+                    |
                        ||value|                    |
                        |+-----+                    |
                        +---------------------------+

 Each distinct type of DataPoint represents the output of a specific
 aggregation function, the result of applying the DataPoint's
 associated function of to one or more measurements.

 All DataPoint types have three common fields:
 - Attributes includes key-value pairs associated with the data point
 - TimeUnixNano is required, set to the end time of the aggregation
 - StartTimeUnixNano is optional, but strongly encouraged for DataPoints
   having an AggregationTemporality field, as discussed below.

 Both TimeUnixNano and StartTimeUnixNano values are expressed as
 UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.

 # TimeUnixNano

 This field is required, having consistent interpretation across
 DataPoint types.  TimeUnixNano is the moment corresponding to when
 the data point's aggregate value was captured.

 Data points with the 0 value for TimeUnixNano SHOULD be rejected
 by consumers.

 # StartTimeUnixNano

 StartTimeUnixNano in general allows detecting when a sequence of
 observations is unbroken.  This field indicates to consumers the
 start time for points with cumulative and delta
 AggregationTemporality, and it should be included whenever possible
 to support correct rate calculation.  Although it may be omitted
 when the start time is truly unknown, setting StartTimeUnixNano is
 strongly encouraged. */
typedef struct _opentelemetry_proto_metrics_v1_Metric {
    /* name of the metric, including its DNS name prefix. It must be unique. */
    pb_callback_t name;
    /* description of the metric, which can be used in documentation. */
    pb_callback_t description;
    /* unit in which the metric value is reported. Follows the format
 described by http://unitsofmeasure.org/ucum.html. */
    pb_callback_t unit;
    pb_callback_t cb_data;
    pb_size_t which_data;
    union {
        opentelemetry_proto_metrics_v1_Gauge gauge;
        opentelemetry_proto_metrics_v1_Sum sum;
        opentelemetry_proto_metrics_v1_Histogram histogram;
        opentelemetry_proto_metrics_v1_ExponentialHistogram exponential_histogram;
        opentelemetry_proto_metrics_v1_Summary summary;
    } data;
} opentelemetry_proto_metrics_v1_Metric;

/* NumberDataPoint is a single data point in a timeseries that describes the
 time-varying scalar value of a metric. */
typedef struct _opentelemetry_proto_metrics_v1_NumberDataPoint {
    /* StartTimeUnixNano is optional but strongly encouraged, see the
 the detailed comments above Metric.

 Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
 1970. */
    uint64_t start_time_unix_nano;
    /* TimeUnixNano is required, see the detailed comments above Metric.

 Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
 1970. */
    uint64_t time_unix_nano;
    pb_size_t which_value;
    union {
        double as_double;
        int64_t as_int;
    } value;
    /* (Optional) List of exemplars collected from
 measurements that were used to form the data point */
    pb_callback_t exemplars;
    /* The set of key/value pairs that uniquely identify the timeseries from
 where this point belongs. The list may be empty (may contain 0 elements).
 Attribute keys MUST be unique (it is not allowed to have more than one
 attribute with the same key). */
    pb_callback_t attributes;
    /* Flags that apply to this specific data point.  See DataPointFlags
 for the available flags and their meaning. */
    uint32_t flags;
} opentelemetry_proto_metrics_v1_NumberDataPoint;

/* HistogramDataPoint is a single data point in a timeseries that describes the
 time-varying values of a Histogram. A Histogram contains summary statistics
 for a population of values, it may optionally contain the distribution of
 those values across a set of buckets.

 If the histogram contains the distribution of values, then both
 "explicit_bounds" and "bucket counts" fields must be defined.
 If the histogram does not contain the distribution of values, then both
 "explicit_bounds" and "bucket_counts" must be omitted and only "count" and
 "sum" are known. */
typedef struct _opentelemetry_proto_metrics_v1_HistogramDataPoint {
    /* StartTimeUnixNano is optional but strongly encouraged, see the
 the detailed comments above Metric.

 Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
 1970. */
    uint64_t start_time_unix_nano;
    /* TimeUnixNano is required, see the detailed comments above Metric.

 Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
 1970. */
    uint64_t time_unix_nano;
    /* count is the number of values in the population. Must be non-negative. This
 value must be equal to the sum of the "count" fields in buckets if a
 histogram is provided. */
    uint64_t count;
    /* sum of the values in the population. If count is zero then this field
 must be zero.

 Note: Sum should only be filled out when measuring non-negative discrete
 events, and is assumed to be monotonic over the values of these events.
 Negative events *can* be recorded, but sum should not be filled out when
 doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
 see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram */
    bool has_sum;
    double sum;
    /* bucket_counts is an optional field contains the count values of histogram
 for each bucket.

 The sum of the bucket_counts must equal the value in the count field.

 The number of elements in bucket_counts array must be by one greater than
 the number of elements in explicit_bounds array. */
    pb_callback_t bucket_counts;
    /* explicit_bounds specifies buckets with explicitly defined bounds for values.

 The boundaries for bucket at index i are:

 (-infinity, explicit_bounds[i]] for i == 0
 (explicit_bounds[i-1], explicit_bounds[i]] for 0 < i < size(explicit_bounds)
 (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)

 The values in the explicit_bounds array must be strictly increasing.

 Histogram buckets are inclusive of their upper boundary, except the last
 bucket where the boundary is at infinity. This format is intentionally
 compatible with the OpenMetrics histogram definition. */
    pb_callback_t explicit_bounds;
    /* (Optional) List of exemplars collected from
 measurements that were used to form the data point */
    pb_callback_t exemplars;
    /* The set of key/value pairs that uniquely identify the timeseries from
 where this point belongs. The list may be empty (may contain 0 elements).
 Attribute keys MUST be unique (it is not allowed to have more than one
 attribute with the same key). */
    pb_callback_t attributes;
    /* Flags that apply to this specific data point.  See DataPointFlags
 for the available flags and their meaning. */
    uint32_t flags;
    /* min is the minimum value over (start_time, end_time]. */
    bool has_min;
    double min;
    /* max is the maximum value over (start_time, end_time]. */
    bool has_max;
    double max;
} opentelemetry_proto_metrics_v1_HistogramDataPoint;

/* Buckets are a set of bucket counts, encoded in a contiguous array
 of counts. */
typedef struct _opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets {
    /* Offset is the bucket index of the first entry in the bucket_counts array.
 
 Note: This uses a varint encoding as a simple form of compression. */
    int32_t offset;
    /* bucket_counts is an array of count values, where bucket_counts[i] carries
 the count of the bucket at index (offset+i). bucket_counts[i] is the count
 of values greater than base^(offset+i) and less than or equal to
 base^(offset+i+1).

 Note: By contrast, the explicit HistogramDataPoint uses
 fixed64.  This field is expected to have many buckets,
 especially zeros, so uint64 has been selected to ensure
 varint encoding. */
    pb_callback_t bucket_counts;
} opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets;

/* ExponentialHistogramDataPoint is a single data point in a timeseries that describes the
 time-varying values of a ExponentialHistogram of double values. A ExponentialHistogram contains
 summary statistics for a population of values, it may optionally contain the
 distribution of those values across a set of buckets. */
typedef struct _opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint {
    /* The set of key/value pairs that uniquely identify the timeseries from
 where this point belongs. The list may be empty (may contain 0 elements).
 Attribute keys MUST be unique (it is not allowed to have more than one
 attribute with the same key). */
    pb_callback_t attributes;
    /* StartTimeUnixNano is optional but strongly encouraged, see the
 the detailed comments above Metric.

 Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
 1970. */
    uint64_t start_time_unix_nano;
    /* TimeUnixNano is required, see the detailed comments above Metric.

 Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
 1970. */
    uint64_t time_unix_nano;
    /* count is the number of values in the population. Must be
 non-negative. This value must be equal to the sum of the "bucket_counts"
 values in the positive and negative Buckets plus the "zero_count" field. */
    uint64_t count;
    /* sum of the values in the population. If count is zero then this field
 must be zero.

 Note: Sum should only be filled out when measuring non-negative discrete
 events, and is assumed to be monotonic over the values of these events.
 Negative events *can* be recorded, but sum should not be filled out when
 doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
 see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram */
    bool has_sum;
    double sum;
    /* scale describes the resolution of the histogram.  Boundaries are
 located at powers of the base, where:

   base = (2^(2^-scale))

 The histogram bucket identified by `index`, a signed integer,
 contains values that are greater than (base^index) and
 less than or equal to (base^(index+1)).

 The positive and negative ranges of the histogram are expressed
 separately.  Negative values are mapped by their absolute value
 into the negative range using the same scale as the positive range.

 scale is not restricted by the protocol, as the permissible
 values depend on the range of the data. */
    int32_t scale;
    /* zero_count is the count of values that are either exactly zero or
 within the region considered zero by the instrumentation at the
 tolerated degree of precision.  This bucket stores values that
 cannot be expressed using the standard exponential formula as
 well as values that have been rounded to zero.

 Implementations MAY consider the zero bucket to have probability
 mass equal to (zero_count / count). */
    uint64_t zero_count;
    /* positive carries the positive range of exponential bucket counts. */
    bool has_positive;
    opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets positive;
    /* negative carries the negative range of exponential bucket counts. */
    bool has_negative;
    opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets negative;
    /* Flags that apply to this specific data point.  See DataPointFlags
 for the available flags and their meaning. */
    uint32_t flags;
    /* (Optional) List of exemplars collected from
 measurements that were used to form the data point */
    pb_callback_t exemplars;
    /* min is the minimum value over (start_time, end_time]. */
    bool has_min;
    double min;
    /* max is the maximum value over (start_time, end_time]. */
    bool has_max;
    double max;
    /* ZeroThreshold may be optionally set to convey the width of the zero
 region. Where the zero region is defined as the closed interval
 [-ZeroThreshold, ZeroThreshold].
 When ZeroThreshold is 0, zero count bucket stores values that cannot be
 expressed using the standard exponential formula as well as values that
 have been rounded to zero. */
    double zero_threshold;
} opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint;

/* SummaryDataPoint is a single data point in a timeseries that describes the
 time-varying values of a Summary metric. */
typedef struct _opentelemetry_proto_metrics_v1_SummaryDataPoint {
    /* StartTimeUnixNano is optional but strongly encouraged, see the
 the detailed comments above Metric.

 Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
 1970. */
    uint64_t start_time_unix_nano;
    /* TimeUnixNano is required, see the detailed comments above Metric.

 Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
 1970. */
    uint64_t time_unix_nano;
    /* count is the number of values in the population. Must be non-negative. */
    uint64_t count;
    /* sum of the values in the population. If count is zero then this field
 must be zero.

 Note: Sum should only be filled out when measuring non-negative discrete
 events, and is assumed to be monotonic over the values of these events.
 Negative events *can* be recorded, but sum should not be filled out when
 doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
 see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#summary */
    double sum;
    /* (Optional) list of values at different quantiles of the distribution calculated
 from the current snapshot. The quantiles must be strictly increasing. */
    pb_callback_t quantile_values;
    /* The set of key/value pairs that uniquely identify the timeseries from
 where this point belongs. The list may be empty (may contain 0 elements).
 Attribute keys MUST be unique (it is not allowed to have more than one
 attribute with the same key). */
    pb_callback_t attributes;
    /* Flags that apply to this specific data point.  See DataPointFlags
 for the available flags and their meaning. */
    uint32_t flags;
} opentelemetry_proto_metrics_v1_SummaryDataPoint;

/* Represents the value at a given quantile of a distribution.

 To record Min and Max values following conventions are used:
 - The 1.0 quantile is equivalent to the maximum value observed.
 - The 0.0 quantile is equivalent to the minimum value observed.

 See the following issue for more context:
 https://github.com/open-telemetry/opentelemetry-proto/issues/125 */
typedef struct _opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile {
    /* The quantile of a distribution. Must be in the interval
 [0.0, 1.0]. */
    double quantile;
    /* The value at the given quantile of a distribution.

 Quantile values must NOT be negative. */
    double value;
} opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile;

/* A representation of an exemplar, which is a sample input measurement.
 Exemplars also hold information about the environment when the measurement
 was recorded, for example the span and trace ID of the active span when the
 exemplar was recorded. */
typedef struct _opentelemetry_proto_metrics_v1_Exemplar {
    /* time_unix_nano is the exact time when this exemplar was recorded

 Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
 1970. */
    uint64_t time_unix_nano;
    pb_size_t which_value;
    union {
        double as_double;
        int64_t as_int;
    } value;
    /* (Optional) Span ID of the exemplar trace.
 span_id may be missing if the measurement is not recorded inside a trace
 or if the trace is not sampled. */
    pb_callback_t span_id;
    /* (Optional) Trace ID of the exemplar trace.
 trace_id may be missing if the measurement is not recorded inside a trace
 or if the trace is not sampled. */
    pb_callback_t trace_id;
    /* The set of key/value pairs that were filtered out by the aggregator, but
 recorded alongside the original measurement. Only key/value pairs that were
 filtered out by the aggregator should be included */
    pb_callback_t filtered_attributes;
} opentelemetry_proto_metrics_v1_Exemplar;


#ifdef __cplusplus
extern "C" {
#endif

/* Helper constants for enums */
#define _opentelemetry_proto_metrics_v1_AggregationTemporality_MIN opentelemetry_proto_metrics_v1_AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
#define _opentelemetry_proto_metrics_v1_AggregationTemporality_MAX opentelemetry_proto_metrics_v1_AggregationTemporality_AGGREGATION_TEMPORALITY_CUMULATIVE
#define _opentelemetry_proto_metrics_v1_AggregationTemporality_ARRAYSIZE ((opentelemetry_proto_metrics_v1_AggregationTemporality)(opentelemetry_proto_metrics_v1_AggregationTemporality_AGGREGATION_TEMPORALITY_CUMULATIVE+1))

#define _opentelemetry_proto_metrics_v1_DataPointFlags_MIN opentelemetry_proto_metrics_v1_DataPointFlags_DATA_POINT_FLAGS_DO_NOT_USE
#define _opentelemetry_proto_metrics_v1_DataPointFlags_MAX opentelemetry_proto_metrics_v1_DataPointFlags_DATA_POINT_FLAGS_NO_RECORDED_VALUE_MASK
#define _opentelemetry_proto_metrics_v1_DataPointFlags_ARRAYSIZE ((opentelemetry_proto_metrics_v1_DataPointFlags)(opentelemetry_proto_metrics_v1_DataPointFlags_DATA_POINT_FLAGS_NO_RECORDED_VALUE_MASK+1))






#define opentelemetry_proto_metrics_v1_Sum_aggregation_temporality_ENUMTYPE opentelemetry_proto_metrics_v1_AggregationTemporality

#define opentelemetry_proto_metrics_v1_Histogram_aggregation_temporality_ENUMTYPE opentelemetry_proto_metrics_v1_AggregationTemporality

#define opentelemetry_proto_metrics_v1_ExponentialHistogram_aggregation_temporality_ENUMTYPE opentelemetry_proto_metrics_v1_AggregationTemporality










/* Initializer values for message structs */
#define opentelemetry_proto_metrics_v1_MetricsData_init_default {{{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_ResourceMetrics_init_default {false, opentelemetry_proto_resource_v1_Resource_init_default, {{NULL}, NULL}, {{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_ScopeMetrics_init_default {false, opentelemetry_proto_common_v1_InstrumentationScope_init_default, {{NULL}, NULL}, {{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_Metric_init_default {{{NULL}, NULL}, {{NULL}, NULL}, {{NULL}, NULL}, {{NULL}, NULL}, 0, {opentelemetry_proto_metrics_v1_Gauge_init_default}}
#define opentelemetry_proto_metrics_v1_Gauge_init_default {{{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_Sum_init_default {{{NULL}, NULL}, _opentelemetry_proto_metrics_v1_AggregationTemporality_MIN, 0}
#define opentelemetry_proto_metrics_v1_Histogram_init_default {{{NULL}, NULL}, _opentelemetry_proto_metrics_v1_AggregationTemporality_MIN}
#define opentelemetry_proto_metrics_v1_ExponentialHistogram_init_default {{{NULL}, NULL}, _opentelemetry_proto_metrics_v1_AggregationTemporality_MIN}
#define opentelemetry_proto_metrics_v1_Summary_init_default {{{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_NumberDataPoint_init_default {0, 0, 0, {0}, {{NULL}, NULL}, {{NULL}, NULL}, 0}
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_init_default {0, 0, 0, false, 0, {{NULL}, NULL}, {{NULL}, NULL}, {{NULL}, NULL}, {{NULL}, NULL}, 0, false, 0, false, 0}
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_init_default {{{NULL}, NULL}, 0, 0, 0, false, 0, 0, 0, false, opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_init_default, false, opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_init_default, 0, {{NULL}, NULL}, false, 0, false, 0, 0}
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_init_default {0, {{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_init_default {0, 0, 0, 0, {{NULL}, NULL}, {{NULL}, NULL}, 0}
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_init_default {0, 0}
#define opentelemetry_proto_metrics_v1_Exemplar_init_default {0, 0, {0}, {{NULL}, NULL}, {{NULL}, NULL}, {{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_MetricsData_init_zero {{{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_ResourceMetrics_init_zero {false, opentelemetry_proto_resource_v1_Resource_init_zero, {{NULL}, NULL}, {{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_ScopeMetrics_init_zero {false, opentelemetry_proto_common_v1_InstrumentationScope_init_zero, {{NULL}, NULL}, {{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_Metric_init_zero {{{NULL}, NULL}, {{NULL}, NULL}, {{NULL}, NULL}, {{NULL}, NULL}, 0, {opentelemetry_proto_metrics_v1_Gauge_init_zero}}
#define opentelemetry_proto_metrics_v1_Gauge_init_zero {{{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_Sum_init_zero {{{NULL}, NULL}, _opentelemetry_proto_metrics_v1_AggregationTemporality_MIN, 0}
#define opentelemetry_proto_metrics_v1_Histogram_init_zero {{{NULL}, NULL}, _opentelemetry_proto_metrics_v1_AggregationTemporality_MIN}
#define opentelemetry_proto_metrics_v1_ExponentialHistogram_init_zero {{{NULL}, NULL}, _opentelemetry_proto_metrics_v1_AggregationTemporality_MIN}
#define opentelemetry_proto_metrics_v1_Summary_init_zero {{{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_NumberDataPoint_init_zero {0, 0, 0, {0}, {{NULL}, NULL}, {{NULL}, NULL}, 0}
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_init_zero {0, 0, 0, false, 0, {{NULL}, NULL}, {{NULL}, NULL}, {{NULL}, NULL}, {{NULL}, NULL}, 0, false, 0, false, 0}
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_init_zero {{{NULL}, NULL}, 0, 0, 0, false, 0, 0, 0, false, opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_init_zero, false, opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_init_zero, 0, {{NULL}, NULL}, false, 0, false, 0, 0}
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_init_zero {0, {{NULL}, NULL}}
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_init_zero {0, 0, 0, 0, {{NULL}, NULL}, {{NULL}, NULL}, 0}
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_init_zero {0, 0}
#define opentelemetry_proto_metrics_v1_Exemplar_init_zero {0, 0, {0}, {{NULL}, NULL}, {{NULL}, NULL}, {{NULL}, NULL}}

/* Field tags (for use in manual encoding/decoding) */
#define opentelemetry_proto_metrics_v1_MetricsData_resource_metrics_tag 1
#define opentelemetry_proto_metrics_v1_ResourceMetrics_resource_tag 1
#define opentelemetry_proto_metrics_v1_ResourceMetrics_scope_metrics_tag 2
#define opentelemetry_proto_metrics_v1_ResourceMetrics_schema_url_tag 3
#define opentelemetry_proto_metrics_v1_ScopeMetrics_scope_tag 1
#define opentelemetry_proto_metrics_v1_ScopeMetrics_metrics_tag 2
#define opentelemetry_proto_metrics_v1_ScopeMetrics_schema_url_tag 3
#define opentelemetry_proto_metrics_v1_Gauge_data_points_tag 1
#define opentelemetry_proto_metrics_v1_Sum_data_points_tag 1
#define opentelemetry_proto_metrics_v1_Sum_aggregation_temporality_tag 2
#define opentelemetry_proto_metrics_v1_Sum_is_monotonic_tag 3
#define opentelemetry_proto_metrics_v1_Histogram_data_points_tag 1
#define opentelemetry_proto_metrics_v1_Histogram_aggregation_temporality_tag 2
#define opentelemetry_proto_metrics_v1_ExponentialHistogram_data_points_tag 1
#define opentelemetry_proto_metrics_v1_ExponentialHistogram_aggregation_temporality_tag 2
#define opentelemetry_proto_metrics_v1_Summary_data_points_tag 1
#define opentelemetry_proto_metrics_v1_Metric_name_tag 1
#define opentelemetry_proto_metrics_v1_Metric_description_tag 2
#define opentelemetry_proto_metrics_v1_Metric_unit_tag 3
#define opentelemetry_proto_metrics_v1_Metric_gauge_tag 5
#define opentelemetry_proto_metrics_v1_Metric_sum_tag 7
#define opentelemetry_proto_metrics_v1_Metric_histogram_tag 9
#define opentelemetry_proto_metrics_v1_Metric_exponential_histogram_tag 10
#define opentelemetry_proto_metrics_v1_Metric_summary_tag 11
#define opentelemetry_proto_metrics_v1_NumberDataPoint_start_time_unix_nano_tag 2
#define opentelemetry_proto_metrics_v1_NumberDataPoint_time_unix_nano_tag 3
#define opentelemetry_proto_metrics_v1_NumberDataPoint_as_double_tag 4
#define opentelemetry_proto_metrics_v1_NumberDataPoint_as_int_tag 6
#define opentelemetry_proto_metrics_v1_NumberDataPoint_exemplars_tag 5
#define opentelemetry_proto_metrics_v1_NumberDataPoint_attributes_tag 7
#define opentelemetry_proto_metrics_v1_NumberDataPoint_flags_tag 8
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_start_time_unix_nano_tag 2
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_time_unix_nano_tag 3
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_count_tag 4
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_sum_tag 5
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_bucket_counts_tag 6
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_explicit_bounds_tag 7
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_exemplars_tag 8
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_attributes_tag 9
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_flags_tag 10
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_min_tag 11
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_max_tag 12
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_offset_tag 1
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_bucket_counts_tag 2
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_attributes_tag 1
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_start_time_unix_nano_tag 2
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_time_unix_nano_tag 3
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_count_tag 4
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_sum_tag 5
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_scale_tag 6
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_zero_count_tag 7
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_positive_tag 8
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_negative_tag 9
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_flags_tag 10
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_exemplars_tag 11
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_min_tag 12
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_max_tag 13
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_zero_threshold_tag 14
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_start_time_unix_nano_tag 2
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_time_unix_nano_tag 3
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_count_tag 4
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_sum_tag 5
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_quantile_values_tag 6
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_attributes_tag 7
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_flags_tag 8
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_quantile_tag 1
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_value_tag 2
#define opentelemetry_proto_metrics_v1_Exemplar_time_unix_nano_tag 2
#define opentelemetry_proto_metrics_v1_Exemplar_as_double_tag 3
#define opentelemetry_proto_metrics_v1_Exemplar_as_int_tag 6
#define opentelemetry_proto_metrics_v1_Exemplar_span_id_tag 4
#define opentelemetry_proto_metrics_v1_Exemplar_trace_id_tag 5
#define opentelemetry_proto_metrics_v1_Exemplar_filtered_attributes_tag 7

/* Struct field encoding specification for nanopb */
#define opentelemetry_proto_metrics_v1_MetricsData_FIELDLIST(X, a) \
X(a, CALLBACK, REPEATED, MESSAGE,  resource_metrics,   1)
#define opentelemetry_proto_metrics_v1_MetricsData_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_MetricsData_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_MetricsData_resource_metrics_MSGTYPE opentelemetry_proto_metrics_v1_ResourceMetrics

#define opentelemetry_proto_metrics_v1_ResourceMetrics_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, MESSAGE,  resource,          1) \
X(a, CALLBACK, REPEATED, MESSAGE,  scope_metrics,     2) \
X(a, CALLBACK, SINGULAR, STRING,   schema_url,        3)
#define opentelemetry_proto_metrics_v1_ResourceMetrics_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_ResourceMetrics_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_ResourceMetrics_resource_MSGTYPE opentelemetry_proto_resource_v1_Resource
#define opentelemetry_proto_metrics_v1_ResourceMetrics_scope_metrics_MSGTYPE opentelemetry_proto_metrics_v1_ScopeMetrics

#define opentelemetry_proto_metrics_v1_ScopeMetrics_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, MESSAGE,  scope,             1) \
X(a, CALLBACK, REPEATED, MESSAGE,  metrics,           2) \
X(a, CALLBACK, SINGULAR, STRING,   schema_url,        3)
#define opentelemetry_proto_metrics_v1_ScopeMetrics_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_ScopeMetrics_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_ScopeMetrics_scope_MSGTYPE opentelemetry_proto_common_v1_InstrumentationScope
#define opentelemetry_proto_metrics_v1_ScopeMetrics_metrics_MSGTYPE opentelemetry_proto_metrics_v1_Metric

#define opentelemetry_proto_metrics_v1_Metric_FIELDLIST(X, a) \
X(a, CALLBACK, SINGULAR, STRING,   name,              1) \
X(a, CALLBACK, SINGULAR, STRING,   description,       2) \
X(a, CALLBACK, SINGULAR, STRING,   unit,              3) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (data,gauge,data.gauge),   5) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (data,sum,data.sum),   7) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (data,histogram,data.histogram),   9) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (data,exponential_histogram,data.exponential_histogram),  10) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (data,summary,data.summary),  11)
#define opentelemetry_proto_metrics_v1_Metric_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_Metric_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_Metric_data_gauge_MSGTYPE opentelemetry_proto_metrics_v1_Gauge
#define opentelemetry_proto_metrics_v1_Metric_data_sum_MSGTYPE opentelemetry_proto_metrics_v1_Sum
#define opentelemetry_proto_metrics_v1_Metric_data_histogram_MSGTYPE opentelemetry_proto_metrics_v1_Histogram
#define opentelemetry_proto_metrics_v1_Metric_data_exponential_histogram_MSGTYPE opentelemetry_proto_metrics_v1_ExponentialHistogram
#define opentelemetry_proto_metrics_v1_Metric_data_summary_MSGTYPE opentelemetry_proto_metrics_v1_Summary

#define opentelemetry_proto_metrics_v1_Gauge_FIELDLIST(X, a) \
X(a, CALLBACK, REPEATED, MESSAGE,  data_points,       1)
#define opentelemetry_proto_metrics_v1_Gauge_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_Gauge_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_Gauge_data_points_MSGTYPE opentelemetry_proto_metrics_v1_NumberDataPoint

#define opentelemetry_proto_metrics_v1_Sum_FIELDLIST(X, a) \
X(a, CALLBACK, REPEATED, MESSAGE,  data_points,       1) \
X(a, STATIC,   SINGULAR, UENUM,    aggregation_temporality,   2) \
X(a, STATIC,   SINGULAR, BOOL,     is_monotonic,      3)
#define opentelemetry_proto_metrics_v1_Sum_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_Sum_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_Sum_data_points_MSGTYPE opentelemetry_proto_metrics_v1_NumberDataPoint

#define opentelemetry_proto_metrics_v1_Histogram_FIELDLIST(X, a) \
X(a, CALLBACK, REPEATED, MESSAGE,  data_points,       1) \
X(a, STATIC,   SINGULAR, UENUM,    aggregation_temporality,   2)
#define opentelemetry_proto_metrics_v1_Histogram_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_Histogram_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_Histogram_data_points_MSGTYPE opentelemetry_proto_metrics_v1_HistogramDataPoint

#define opentelemetry_proto_metrics_v1_ExponentialHistogram_FIELDLIST(X, a) \
X(a, CALLBACK, REPEATED, MESSAGE,  data_points,       1) \
X(a, STATIC,   SINGULAR, UENUM,    aggregation_temporality,   2)
#define opentelemetry_proto_metrics_v1_ExponentialHistogram_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_ExponentialHistogram_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_ExponentialHistogram_data_points_MSGTYPE opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint

#define opentelemetry_proto_metrics_v1_Summary_FIELDLIST(X, a) \
X(a, CALLBACK, REPEATED, MESSAGE,  data_points,       1)
#define opentelemetry_proto_metrics_v1_Summary_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_Summary_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_Summary_data_points_MSGTYPE opentelemetry_proto_metrics_v1_SummaryDataPoint

#define opentelemetry_proto_metrics_v1_NumberDataPoint_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FIXED64,  start_time_unix_nano,   2) \
X(a, STATIC,   SINGULAR, FIXED64,  time_unix_nano,    3) \
X(a, STATIC,   ONEOF,    DOUBLE,   (value,as_double,value.as_double),   4) \
X(a, CALLBACK, REPEATED, MESSAGE,  exemplars,         5) \
X(a, STATIC,   ONEOF,    SFIXED64, (value,as_int,value.as_int),   6) \
X(a, CALLBACK, REPEATED, MESSAGE,  attributes,        7) \
X(a, STATIC,   SINGULAR, UINT32,   flags,             8)
#define opentelemetry_proto_metrics_v1_NumberDataPoint_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_NumberDataPoint_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_NumberDataPoint_exemplars_MSGTYPE opentelemetry_proto_metrics_v1_Exemplar
#define opentelemetry_proto_metrics_v1_NumberDataPoint_attributes_MSGTYPE opentelemetry_proto_common_v1_KeyValue

#define opentelemetry_proto_metrics_v1_HistogramDataPoint_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FIXED64,  start_time_unix_nano,   2) \
X(a, STATIC,   SINGULAR, FIXED64,  time_unix_nano,    3) \
X(a, STATIC,   SINGULAR, FIXED64,  count,             4) \
X(a, STATIC,   OPTIONAL, DOUBLE,   sum,               5) \
X(a, CALLBACK, REPEATED, FIXED64,  bucket_counts,     6) \
X(a, CALLBACK, REPEATED, DOUBLE,   explicit_bounds,   7) \
X(a, CALLBACK, REPEATED, MESSAGE,  exemplars,         8) \
X(a, CALLBACK, REPEATED, MESSAGE,  attributes,        9) \
X(a, STATIC,   SINGULAR, UINT32,   flags,            10) \
X(a, STATIC,   OPTIONAL, DOUBLE,   min,              11) \
X(a, STATIC,   OPTIONAL, DOUBLE,   max,              12)
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_exemplars_MSGTYPE opentelemetry_proto_metrics_v1_Exemplar
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_attributes_MSGTYPE opentelemetry_proto_common_v1_KeyValue

#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_FIELDLIST(X, a) \
X(a, CALLBACK, REPEATED, MESSAGE,  attributes,        1) \
X(a, STATIC,   SINGULAR, FIXED64,  start_time_unix_nano,   2) \
X(a, STATIC,   SINGULAR, FIXED64,  time_unix_nano,    3) \
X(a, STATIC,   SINGULAR, FIXED64,  count,             4) \
X(a, STATIC,   OPTIONAL, DOUBLE,   sum,               5) \
X(a, STATIC,   SINGULAR, SINT32,   scale,             6) \
X(a, STATIC,   SINGULAR, FIXED64,  zero_count,        7) \
X(a, STATIC,   OPTIONAL, MESSAGE,  positive,          8) \
X(a, STATIC,   OPTIONAL, MESSAGE,  negative,          9) \
X(a, STATIC,   SINGULAR, UINT32,   flags,            10) \
X(a, CALLBACK, REPEATED, MESSAGE,  exemplars,        11) \
X(a, STATIC,   OPTIONAL, DOUBLE,   min,              12) \
X(a, STATIC,   OPTIONAL, DOUBLE,   max,              13) \
X(a, STATIC,   SINGULAR, DOUBLE,   zero_threshold,   14)
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_attributes_MSGTYPE opentelemetry_proto_common_v1_KeyValue
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_positive_MSGTYPE opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_negative_MSGTYPE opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_exemplars_MSGTYPE opentelemetry_proto_metrics_v1_Exemplar

#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, SINT32,   offset,            1) \
X(a, CALLBACK, REPEATED, UINT64,   bucket_counts,     2)
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_DEFAULT NULL

#define opentelemetry_proto_metrics_v1_SummaryDataPoint_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FIXED64,  start_time_unix_nano,   2) \
X(a, STATIC,   SINGULAR, FIXED64,  time_unix_nano,    3) \
X(a, STATIC,   SINGULAR, FIXED64,  count,             4) \
X(a, STATIC,   SINGULAR, DOUBLE,   sum,               5) \
X(a, CALLBACK, REPEATED, MESSAGE,  quantile_values,   6) \
X(a, CALLBACK, REPEATED, MESSAGE,  attributes,        7) \
X(a, STATIC,   SINGULAR, UINT32,   flags,             8)
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_quantile_values_MSGTYPE opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_attributes_MSGTYPE opentelemetry_proto_common_v1_KeyValue

#define opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, DOUBLE,   quantile,          1) \
X(a, STATIC,   SINGULAR, DOUBLE,   value,             2)
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_CALLBACK NULL
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_DEFAULT NULL

#define opentelemetry_proto_metrics_v1_Exemplar_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FIXED64,  time_unix_nano,    2) \
X(a, STATIC,   ONEOF,    DOUBLE,   (value,as_double,value.as_double),   3) \
X(a, CALLBACK, SINGULAR, BYTES,    span_id,           4) \
X(a, CALLBACK, SINGULAR, BYTES,    trace_id,          5) \
X(a, STATIC,   ONEOF,    SFIXED64, (value,as_int,value.as_int),   6) \
X(a, CALLBACK, REPEATED, MESSAGE,  filtered_attributes,   7)
#define opentelemetry_proto_metrics_v1_Exemplar_CALLBACK pb_default_field_callback
#define opentelemetry_proto_metrics_v1_Exemplar_DEFAULT NULL
#define opentelemetry_proto_metrics_v1_Exemplar_filtered_attributes_MSGTYPE opentelemetry_proto_common_v1_KeyValue

extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_MetricsData_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_ResourceMetrics_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_ScopeMetrics_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_Metric_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_Gauge_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_Sum_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_Histogram_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_ExponentialHistogram_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_Summary_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_NumberDataPoint_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_HistogramDataPoint_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_SummaryDataPoint_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_msg;
extern const pb_msgdesc_t opentelemetry_proto_metrics_v1_Exemplar_msg;

/* Defines for backwards compatibility with code written before nanopb-0.4.0 */
#define opentelemetry_proto_metrics_v1_MetricsData_fields &opentelemetry_proto_metrics_v1_MetricsData_msg
#define opentelemetry_proto_metrics_v1_ResourceMetrics_fields &opentelemetry_proto_metrics_v1_ResourceMetrics_msg
#define opentelemetry_proto_metrics_v1_ScopeMetrics_fields &opentelemetry_proto_metrics_v1_ScopeMetrics_msg
#define opentelemetry_proto_metrics_v1_Metric_fields &opentelemetry_proto_metrics_v1_Metric_msg
#define opentelemetry_proto_metrics_v1_Gauge_fields &opentelemetry_proto_metrics_v1_Gauge_msg
#define opentelemetry_proto_metrics_v1_Sum_fields &opentelemetry_proto_metrics_v1_Sum_msg
#define opentelemetry_proto_metrics_v1_Histogram_fields &opentelemetry_proto_metrics_v1_Histogram_msg
#define opentelemetry_proto_metrics_v1_ExponentialHistogram_fields &opentelemetry_proto_metrics_v1_ExponentialHistogram_msg
#define opentelemetry_proto_metrics_v1_Summary_fields &opentelemetry_proto_metrics_v1_Summary_msg
#define opentelemetry_proto_metrics_v1_NumberDataPoint_fields &opentelemetry_proto_metrics_v1_NumberDataPoint_msg
#define opentelemetry_proto_metrics_v1_HistogramDataPoint_fields &opentelemetry_proto_metrics_v1_HistogramDataPoint_msg
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_fields &opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_msg
#define opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_fields &opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_msg
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_fields &opentelemetry_proto_metrics_v1_SummaryDataPoint_msg
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_fields &opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_msg
#define opentelemetry_proto_metrics_v1_Exemplar_fields &opentelemetry_proto_metrics_v1_Exemplar_msg

/* Maximum encoded size of messages (where known) */
/* opentelemetry_proto_metrics_v1_MetricsData_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_ResourceMetrics_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_ScopeMetrics_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_Metric_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_Gauge_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_Sum_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_Histogram_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_ExponentialHistogram_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_Summary_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_NumberDataPoint_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_HistogramDataPoint_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_ExponentialHistogramDataPoint_Buckets_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_SummaryDataPoint_size depends on runtime parameters */
/* opentelemetry_proto_metrics_v1_Exemplar_size depends on runtime parameters */
#define opentelemetry_proto_metrics_v1_SummaryDataPoint_ValueAtQuantile_size 18

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
