# This file should be included if the command line reads like this:
# x86_64-w64-mingw32.shared-cmake -DCMAKE_BUILD_TYPE=Release -DMXE=1 ..

message("MXE (M cross environment) https://mxe.cc/")
message("Please run the configuration like this:")
message("x86_64-w64-mingw32.shared-cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Release ../../development")

set(HOME_DEVEL_DIR $ENV{HOME}/devel)
set(MXE_SHIPPED_DLLS_DIR "$ENV{HOME}/devel/mxe/dlls-and-stuff-for-packages")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES ${HOME_DEVEL_DIR}/mxe/usr/x86_64-w64-mingw32.shared/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES ${HOME_DEVEL_DIR}/mxe/usr/x86_64-w64-mingw32.shared/include)

# This is used throughout all the build system files
set(TARGET ${CMAKE_PROJECT_NAME})

# Now that we have the TARGET variable contents, let's configure InnoSetup
configure_file(
    ${CMAKE_SOURCE_DIR}/CMakeStuff/${LOWCASE_PROJECT_NAME}-mxe.iss.in
    ${CMAKE_SOURCE_DIR}/winInstaller/${LOWCASE_PROJECT_NAME}-mxe.iss @ONLY
)


find_package(
    Qt6 REQUIRED
    COMPONENTS Widgets
               Xml
               Svg
               SvgWidgets
               PrintSupport
               Network
               Qml
               Sql
               Concurrent
               Core5Compat
               GLOBAL
)


set(IsoSpec++_FOUND 1)
set(IsoSpec++_INCLUDE_DIRS "${HOME_DEVEL_DIR}/isospec/development")
set(IsoSpec++_LIBRARIES "${MXE_SHIPPED_DLLS_DIR}/libIsoSpec++.dll")
if(NOT TARGET IsoSpec++::IsoSpec++)
  add_library(IsoSpec++::IsoSpec++ UNKNOWN IMPORTED)
  set_target_properties(IsoSpec++::IsoSpec++ PROPERTIES
    IMPORTED_LOCATION             "${IsoSpec++_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${IsoSpec++_INCLUDE_DIRS}")
endif()


set(PwizLite_FOUND 1)
set(PwizLite_INCLUDE_DIRS "${HOME_DEVEL_DIR}/pwizlite/development/src")
set(PwizLite_LIBRARIES "${HOME_DEVEL_DIR}/pwizlite/build-area/mxe/src/libpwizlite.dll")
if(NOT TARGET PwizLite::PwizLite)
    add_library(PwizLite::PwizLite UNKNOWN IMPORTED)
    set_target_properties(
        PwizLite::PwizLite PROPERTIES IMPORTED_LOCATION "${PwizLite_LIBRARIES}" INTERFACE_INCLUDE_DIRECTORIES
                                                                                "${PwizLite_INCLUDE_DIRS}"
    )
endif()

find_package(
    Boost
    COMPONENTS chrono
               container
               filesystem
               iostreams
               thread
    REQUIRED
)


find_package(SQLite3 REQUIRED)


set(QCustomPlotQt6_FOUND 1)
set(QCustomPlotQt6_INCLUDE_DIR "${HOME_DEVEL_DIR}/qcustomplot/development")
set(QCustomPlotQt6_LIBRARIES "${HOME_DEVEL_DIR}/qcustomplot/build-area/mxe/libQCustomPlotQt6.dll")
if(NOT TARGET QCustomPlotQt6::QCustomPlotQt6)
    add_library(QCustomPlotQt6::QCustomPlotQt6 UNKNOWN IMPORTED)
    set_target_properties(
        QCustomPlotQt6::QCustomPlotQt6
        PROPERTIES IMPORTED_LOCATION "${QCustomPlotQt6_LIBRARIES}"
                   INTERFACE_INCLUDE_DIRECTORIES "${QCustomPlotQt6_INCLUDE_DIR}"
                   INTERFACE_COMPILE_DEFINITIONS QCUSTOMPLOT_USE_LIBRARY
    )
endif()


find_package(ZLIB REQUIRED)


set(liblzf_FOUND 1)
set(liblzf_INCLUDE_DIRS "${HOME_DEVEL_DIR}/lzf/development")

set(liblzf_LIBRARIES "${HOME_DEVEL_DIR}/lzf/build-area/mxe/liblzf.dll")
if(NOT TARGET liblzf::liblzf)
    add_library(liblzf::liblzf UNKNOWN IMPORTED)
    set_target_properties(
        liblzf::liblzf
        PROPERTIES IMPORTED_LOCATION "${liblzf_LIBRARIES}"
                   INTERFACE_INCLUDE_DIRECTORIES "${liblzf_INCLUDE_DIRS}"
                   INTERFACE_COMPILE_DEFINITIONS LIBLZF_USE_LIBRARY
    )
endif()


set(OdsStream_FOUND 1)
set(OdsStream_INCLUDE_DIR "${HOME_DEVEL_DIR}/odsstream/development/src")
set(OdsStream_LIBRARIES "${HOME_DEVEL_DIR}/odsstream/build-area/mxe/src/libodsstream.dll")
if(NOT TARGET OdsStream::Core)
    add_library(OdsStream::Core UNKNOWN IMPORTED)
    set_target_properties(
        OdsStream::Core PROPERTIES IMPORTED_LOCATION "${OdsStream_LIBRARIES}" INTERFACE_INCLUDE_DIRECTORIES
                                                                              "${OdsStream_INCLUDE_DIR}"
    )
endif()


set(QUAZIP_FOUND 1)
set(QUAZIP_INCLUDE_DIR "${HOME_DEVEL_DIR}/quazip/development/quazip")
set(QUAZIP_LIBRARIES "${HOME_DEVEL_DIR}/quazip/build-area/mxe/quazip/libquazip1-qt6.dll")
set(QUAZIP_ZLIB_INCLUDE_DIR ${ZLIB_INCLUDE_DIRS})
set(QUAZIP_INCLUDE_DIRS ${QUAZIP_INCLUDE_DIR} ${QUAZIP_ZLIB_INCLUDE_DIR})

message(STATUS "QUAZIP_INCLUDE_DIR :${QUAZIP_INCLUDE_DIR}")

if(NOT TARGET QuaZip::QuaZip)
    add_library(QuaZip::QuaZip UNKNOWN IMPORTED)
    set_target_properties(
        QuaZip::QuaZip PROPERTIES IMPORTED_LOCATION ${QUAZIP_LIBRARIES} INTERFACE_INCLUDE_DIRECTORIES
                                                                        ${QUAZIP_INCLUDE_DIR}
    )
endif()


set(PappsoMSpp_FOUND 1)
set(PappsoMSpp_INCLUDE_DIRS "${HOME_DEVEL_DIR}/pappsomspp/development/src")
set(PappsoMSpp_LIBRARIES "${MXE_SHIPPED_DLLS_DIR}/libpappsomspp-core.dll")
if(NOT TARGET PappsoMSpp::Core)

    add_library(PappsoMSpp::Core UNKNOWN IMPORTED GLOBAL)
    set_target_properties(
        PappsoMSpp::Core PROPERTIES IMPORTED_LOCATION ${PappsoMSpp_LIBRARIES} INTERFACE_INCLUDE_DIRECTORIES
                                                                              ${PappsoMSpp_INCLUDE_DIRS}
    )

endif()

set(PappsoMSppWidget_FOUND 1)
set(PappsoMSppWidget_LIBRARIES "${MXE_SHIPPED_DLLS_DIR}/libpappsomspp-gui.dll")
if(NOT TARGET PappsoMSpp::Gui)

    add_library(PappsoMSpp::Gui UNKNOWN IMPORTED GLOBAL)
    set_target_properties(
        PappsoMSpp::Gui PROPERTIES IMPORTED_LOCATION ${PappsoMSppWidget_LIBRARIES} INTERFACE_INCLUDE_DIRECTORIES
                                                                                      ${PappsoMSpp_INCLUDE_DIRS}
    )

endif()

include_directories(${include_directories} ${PappsoMSpp_INCLUDE_DIRS} ${PappsoMSpp_INCLUDE_DIRS})

set(XpertMass_FOUND 1)
set(XpertMass_INCLUDE_DIRS "${HOME_DEVEL_DIR}/xpertmass/development/source/XpertMassCore/includes")
set(XpertMass_LIBRARIES "${MXE_SHIPPED_DLLS_DIR}/libXpertMassCore.dll")
if(NOT TARGET XpertMass::Core)

    add_library(XpertMass::Core UNKNOWN IMPORTED GLOBAL)
    set_target_properties(
        XpertMass::Core PROPERTIES IMPORTED_LOCATION ${XpertMass_LIBRARIES} INTERFACE_INCLUDE_DIRECTORIES
                                                                            ${XpertMass_INCLUDE_DIRS}
    )

    get_target_property(CORE_IMPORTED_LOCATION XpertMass::Core IMPORTED_LOCATION)
    message(STATUS "Imported XpertMass::Core: ${CORE_IMPORTED_LOCATION}")

endif()

set(XpertMassGui_INCLUDE_DIRS "${HOME_DEVEL_DIR}/xpertmass/development/source/XpertMassGui/includes")
set(XpertMassGui_LIBRARIES "${MXE_SHIPPED_DLLS_DIR}/libXpertMassGui.dll")
if(NOT TARGET XpertMass::Gui)

    add_library(XpertMass::Gui UNKNOWN IMPORTED GLOBAL)
    set_target_properties(
        XpertMass::Gui PROPERTIES IMPORTED_LOCATION ${XpertMassGui_LIBRARIES} INTERFACE_INCLUDE_DIRECTORIES
                                                                              ${XpertMassGui_INCLUDE_DIRS}
    )

    get_target_property(GUI_IMPORTED_LOCATION XpertMass::Gui IMPORTED_LOCATION)
    message(STATUS "Imported XpertMass::Gui: ${GUI_IMPORTED_LOCATION}")

endif()

include_directories(${include_directories} ${XpertMass_INCLUDE_DIRS} ${XpertMassGui_INCLUDE_DIRS})

#OPENMP
message(STATUS "${BoldYellow}OpenMP support is compulsory.${ColourReset}")
#message(STATUS "CMAKE_MODULE_PATH: ${CMAKE_MODULE_PATH}")
#set(OpenMP_DIR ${CMAKE_MODULE_PATH})

find_package(OpenMP REQUIRED)

## We can build the package setup executable with this specific command.
add_custom_target(
    winpackage
    COMMAND wine $ENV{HOME}/.wine/drive_c/Program\ Files\ \(x86\)/Inno\ Setup\ 6/Compil32.exe /cc
            "z:devel/${LOWCASE_PROJECT_NAME}/development/winInstaller/${LOWCASE_PROJECT_NAME}-mxe.iss"
    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}/winInstaller
    COMMENT "Build of the Windows Package Setup executable"
    VERBATIM
)

## INSTALL directories
# This is the default on windows, but set it nonetheless.
set(CMAKE_INSTALL_PREFIX "C:/Program Files/${CMAKE_PROJECT_NAME}")
set(PROJECT_INSTALL_TOP_DIR "${CMAKE_INSTALL_PREFIX}")
set(PROJECT_INSTALL_BIN_DIR "${CMAKE_INSTALL_PREFIX}/${CMAKE_INSTALL_BINDIR}")
set(PROJECT_INSTALL_DATA_DIR "${CMAKE_INSTALL_PREFIX}")
set(PROJECT_INSTALL_LIB_DIR "${CMAKE_INSTALL_PREFIX}/${CMAKE_INSTALL_LIBDIR}")
set(PROJECT_INSTALL_LIB_QML_DIR "${PROJECT_INSTALL_LIB_DIR}/qml")
set(PROJECT_INSTALL_DOC_DIR "${PROJECT_INSTALL_DATA_DIR}/doc")

# On Win10 all the code is relocatable.
remove_definitions(-fPIC)
