"""Probe plugins for job submission and monitoring."""

from arcnagios.ce.jobplugins.scripted import ScriptedJobPlugin
from arcnagios.ce.jobplugins.staging import StagingJobPlugin

_jobplugins_by_name = {
    'scripted': ScriptedJobPlugin,
    'staging': StagingJobPlugin,
}

def register_jobplugin(cls):
    _jobplugins_by_name[cls.name] = cls

def load_jobplugin(name):
    return _jobplugins_by_name[name]
