/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  /opt/homebrew/bin/gengetopt --file-name=npa-tool-cmdline --output-dir=. 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "npa-tool-cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: npa-tool [OPTION]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "  -r, --reader=STRING           Number of the reader to use. By default, the\n                                  first reader with a present card is used. If\n                                  the argument is an ATR, the reader with a\n                                  matching card will be chosen.",
  "  -v, --verbose                 Use (several times) to be more verbose",
  "\nPassword Authenticated Connection Establishment (PACE):",
  "  -p, --pin[=STRING]            Run PACE with (transport) eID-PIN",
  "  -u, --puk[=STRING]            Run PACE with PUK",
  "  -c, --can[=STRING]            Run PACE with CAN",
  "  -m, --mrz[=STRING]            Run PACE with MRZ (insert MRZ without newlines)",
  "      --env                     Whether to use environment variables PIN, PUK,\n                                  CAN, MRZ and NEWPIN. You may want to clean\n                                  your environment before enabling this.\n                                  (default=off)",
  "\nPIN management:",
  "  -N, --new-pin[=STRING]        Install a new PIN",
  "  -R, --resume                  Resume eID-PIN (uses CAN to activate last\n                                  retry)  (default=off)",
  "  -U, --unblock                 Unblock PIN (uses PUK to activate three more\n                                  retries)  (default=off)",
  "\nTerminal Authentication (TA) and Chip Authentication (CA):",
  "  -C, --cv-certificate=FILENAME Card Verifiable Certificate to create a\n                                  certificate chain. Can be used multiple times\n                                  (order is important).",
  "      --cert-desc=HEX_STRING    Certificate description to show for Terminal\n                                  Authentication",
  "      --chat=HEX_STRING         Card holder authorization template to use\n                                  (default is terminal's CHAT). Use\n                                  7F4C0E060904007F000703010203530103 to trigger\n                                  EAC on the CAT-C (Komfortleser).",
  "  -A, --auxiliary-data=HEX_STRING\n                                Terminal's auxiliary data (default is\n                                  determined by verification of validity, age\n                                  and community ID).",
  "  -P, --private-key=FILENAME    Terminal's private key",
  "      --cvc-dir=DIRECTORY       Where to look for the CVCA's certificate\n                                  (default=`')",
  "      --x509-dir=DIRECTORY      Where to look for the CSCA's certificate\n                                  (default=`')",
  "      --disable-ta-checks       Disable checking the validity period of CV\n                                  certificates  (default=off)",
  "      --disable-ca-checks       Disable passive authentication  (default=off)",
  "\nRead and write data groups:",
  "      --read-dg1                Read DG 1   (Document Type)  (default=off)",
  "      --read-dg2                Read DG 2   (Issuing State)  (default=off)",
  "      --read-dg3                Read DG 3   (Date of Expiry)  (default=off)",
  "      --read-dg4                Read DG 4   (Given Names)  (default=off)",
  "      --read-dg5                Read DG 5   (Family Names)  (default=off)",
  "      --read-dg6                Read DG 6   (Religious/Artistic Name)\n                                  (default=off)",
  "      --read-dg7                Read DG 7   (Academic Title)  (default=off)",
  "      --read-dg8                Read DG 8   (Date of Birth)  (default=off)",
  "      --read-dg9                Read DG 9   (Place of Birth)  (default=off)",
  "      --read-dg10               Read DG 10  (Nationality)  (default=off)",
  "      --read-dg11               Read DG 11  (Sex)  (default=off)",
  "      --read-dg12               Read DG 12  (Optional Data)  (default=off)",
  "      --read-dg13               Read DG 13  (Birth Name)  (default=off)",
  "      --read-dg14               Read DG 14  (default=off)",
  "      --read-dg15               Read DG 15  (default=off)",
  "      --read-dg16               Read DG 16  (default=off)",
  "      --read-dg17               Read DG 17  (Normal Place of Residence)\n                                  (default=off)",
  "      --read-dg18               Read DG 18  (Community ID)  (default=off)",
  "      --read-dg19               Read DG 19  (Residence Permit I)  (default=off)",
  "      --read-dg20               Read DG 20  (Residence Permit II)\n                                  (default=off)",
  "      --read-dg21               Read DG 21  (Optional Data)  (default=off)",
  "      --write-dg17=HEX_STRING   Write DG 17 (Normal Place of Residence)",
  "      --write-dg18=HEX_STRING   Write DG 18 (Community ID)",
  "      --write-dg19=HEX_STRING   Write DG 19 (Residence Permit I)",
  "      --write-dg20=HEX_STRING   Write DG 20 (Residence Permit II)",
  "      --write-dg21=HEX_STRING   Write DG 21 (Optional Data)",
  "\nVerification of validity, age and community ID:",
  "      --verify-validity=YYYYMMDD\n                                Verify chip's validity with a reference date",
  "      --older-than=YYYYMMDD     Verify age with a reference date",
  "      --verify-community=HEX_STRING\n                                Verify community ID with a reference ID",
  "\nSpecial options, not always useful:",
  "  -b, --break                   Brute force PIN, CAN or PUK. Use together with\n                                  -p, -a or -u  (default=off)",
  "  -t, --translate=FILENAME      File with APDUs of HEX_STRINGs to send through\n                                  the secure channel  (default=`stdin')",
  "      --tr-03110v201            Force compliance to BSI TR-03110 version 2.01\n                                  (default=off)",
  "\nReport bugs to https://github.com/OpenSC/OpenSC/issues\n\nWritten by Frank Morgner <frankmorgner@gmail.com>",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->reader_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->pin_given = 0 ;
  args_info->puk_given = 0 ;
  args_info->can_given = 0 ;
  args_info->mrz_given = 0 ;
  args_info->env_given = 0 ;
  args_info->new_pin_given = 0 ;
  args_info->resume_given = 0 ;
  args_info->unblock_given = 0 ;
  args_info->cv_certificate_given = 0 ;
  args_info->cert_desc_given = 0 ;
  args_info->chat_given = 0 ;
  args_info->auxiliary_data_given = 0 ;
  args_info->private_key_given = 0 ;
  args_info->cvc_dir_given = 0 ;
  args_info->x509_dir_given = 0 ;
  args_info->disable_ta_checks_given = 0 ;
  args_info->disable_ca_checks_given = 0 ;
  args_info->read_dg1_given = 0 ;
  args_info->read_dg2_given = 0 ;
  args_info->read_dg3_given = 0 ;
  args_info->read_dg4_given = 0 ;
  args_info->read_dg5_given = 0 ;
  args_info->read_dg6_given = 0 ;
  args_info->read_dg7_given = 0 ;
  args_info->read_dg8_given = 0 ;
  args_info->read_dg9_given = 0 ;
  args_info->read_dg10_given = 0 ;
  args_info->read_dg11_given = 0 ;
  args_info->read_dg12_given = 0 ;
  args_info->read_dg13_given = 0 ;
  args_info->read_dg14_given = 0 ;
  args_info->read_dg15_given = 0 ;
  args_info->read_dg16_given = 0 ;
  args_info->read_dg17_given = 0 ;
  args_info->read_dg18_given = 0 ;
  args_info->read_dg19_given = 0 ;
  args_info->read_dg20_given = 0 ;
  args_info->read_dg21_given = 0 ;
  args_info->write_dg17_given = 0 ;
  args_info->write_dg18_given = 0 ;
  args_info->write_dg19_given = 0 ;
  args_info->write_dg20_given = 0 ;
  args_info->write_dg21_given = 0 ;
  args_info->verify_validity_given = 0 ;
  args_info->older_than_given = 0 ;
  args_info->verify_community_given = 0 ;
  args_info->break_given = 0 ;
  args_info->translate_given = 0 ;
  args_info->tr_03110v201_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->reader_arg = NULL;
  args_info->reader_orig = NULL;
  args_info->pin_arg = NULL;
  args_info->pin_orig = NULL;
  args_info->puk_arg = NULL;
  args_info->puk_orig = NULL;
  args_info->can_arg = NULL;
  args_info->can_orig = NULL;
  args_info->mrz_arg = NULL;
  args_info->mrz_orig = NULL;
  args_info->env_flag = 0;
  args_info->new_pin_arg = NULL;
  args_info->new_pin_orig = NULL;
  args_info->resume_flag = 0;
  args_info->unblock_flag = 0;
  args_info->cv_certificate_arg = NULL;
  args_info->cv_certificate_orig = NULL;
  args_info->cert_desc_arg = NULL;
  args_info->cert_desc_orig = NULL;
  args_info->chat_arg = NULL;
  args_info->chat_orig = NULL;
  args_info->auxiliary_data_arg = NULL;
  args_info->auxiliary_data_orig = NULL;
  args_info->private_key_arg = NULL;
  args_info->private_key_orig = NULL;
  args_info->cvc_dir_arg = gengetopt_strdup ("");
  args_info->cvc_dir_orig = NULL;
  args_info->x509_dir_arg = gengetopt_strdup ("");
  args_info->x509_dir_orig = NULL;
  args_info->disable_ta_checks_flag = 0;
  args_info->disable_ca_checks_flag = 0;
  args_info->read_dg1_flag = 0;
  args_info->read_dg2_flag = 0;
  args_info->read_dg3_flag = 0;
  args_info->read_dg4_flag = 0;
  args_info->read_dg5_flag = 0;
  args_info->read_dg6_flag = 0;
  args_info->read_dg7_flag = 0;
  args_info->read_dg8_flag = 0;
  args_info->read_dg9_flag = 0;
  args_info->read_dg10_flag = 0;
  args_info->read_dg11_flag = 0;
  args_info->read_dg12_flag = 0;
  args_info->read_dg13_flag = 0;
  args_info->read_dg14_flag = 0;
  args_info->read_dg15_flag = 0;
  args_info->read_dg16_flag = 0;
  args_info->read_dg17_flag = 0;
  args_info->read_dg18_flag = 0;
  args_info->read_dg19_flag = 0;
  args_info->read_dg20_flag = 0;
  args_info->read_dg21_flag = 0;
  args_info->write_dg17_arg = NULL;
  args_info->write_dg17_orig = NULL;
  args_info->write_dg18_arg = NULL;
  args_info->write_dg18_orig = NULL;
  args_info->write_dg19_arg = NULL;
  args_info->write_dg19_orig = NULL;
  args_info->write_dg20_arg = NULL;
  args_info->write_dg20_orig = NULL;
  args_info->write_dg21_arg = NULL;
  args_info->write_dg21_orig = NULL;
  args_info->verify_validity_arg = NULL;
  args_info->verify_validity_orig = NULL;
  args_info->older_than_arg = NULL;
  args_info->older_than_orig = NULL;
  args_info->verify_community_arg = NULL;
  args_info->verify_community_orig = NULL;
  args_info->break_flag = 0;
  args_info->translate_arg = gengetopt_strdup ("stdin");
  args_info->translate_orig = NULL;
  args_info->tr_03110v201_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->reader_help = gengetopt_args_info_help[2] ;
  args_info->verbose_help = gengetopt_args_info_help[3] ;
  args_info->verbose_min = 0;
  args_info->verbose_max = 0;
  args_info->pin_help = gengetopt_args_info_help[5] ;
  args_info->puk_help = gengetopt_args_info_help[6] ;
  args_info->can_help = gengetopt_args_info_help[7] ;
  args_info->mrz_help = gengetopt_args_info_help[8] ;
  args_info->env_help = gengetopt_args_info_help[9] ;
  args_info->new_pin_help = gengetopt_args_info_help[11] ;
  args_info->resume_help = gengetopt_args_info_help[12] ;
  args_info->unblock_help = gengetopt_args_info_help[13] ;
  args_info->cv_certificate_help = gengetopt_args_info_help[15] ;
  args_info->cv_certificate_min = 0;
  args_info->cv_certificate_max = 0;
  args_info->cert_desc_help = gengetopt_args_info_help[16] ;
  args_info->chat_help = gengetopt_args_info_help[17] ;
  args_info->auxiliary_data_help = gengetopt_args_info_help[18] ;
  args_info->private_key_help = gengetopt_args_info_help[19] ;
  args_info->cvc_dir_help = gengetopt_args_info_help[20] ;
  args_info->x509_dir_help = gengetopt_args_info_help[21] ;
  args_info->disable_ta_checks_help = gengetopt_args_info_help[22] ;
  args_info->disable_ca_checks_help = gengetopt_args_info_help[23] ;
  args_info->read_dg1_help = gengetopt_args_info_help[25] ;
  args_info->read_dg2_help = gengetopt_args_info_help[26] ;
  args_info->read_dg3_help = gengetopt_args_info_help[27] ;
  args_info->read_dg4_help = gengetopt_args_info_help[28] ;
  args_info->read_dg5_help = gengetopt_args_info_help[29] ;
  args_info->read_dg6_help = gengetopt_args_info_help[30] ;
  args_info->read_dg7_help = gengetopt_args_info_help[31] ;
  args_info->read_dg8_help = gengetopt_args_info_help[32] ;
  args_info->read_dg9_help = gengetopt_args_info_help[33] ;
  args_info->read_dg10_help = gengetopt_args_info_help[34] ;
  args_info->read_dg11_help = gengetopt_args_info_help[35] ;
  args_info->read_dg12_help = gengetopt_args_info_help[36] ;
  args_info->read_dg13_help = gengetopt_args_info_help[37] ;
  args_info->read_dg14_help = gengetopt_args_info_help[38] ;
  args_info->read_dg15_help = gengetopt_args_info_help[39] ;
  args_info->read_dg16_help = gengetopt_args_info_help[40] ;
  args_info->read_dg17_help = gengetopt_args_info_help[41] ;
  args_info->read_dg18_help = gengetopt_args_info_help[42] ;
  args_info->read_dg19_help = gengetopt_args_info_help[43] ;
  args_info->read_dg20_help = gengetopt_args_info_help[44] ;
  args_info->read_dg21_help = gengetopt_args_info_help[45] ;
  args_info->write_dg17_help = gengetopt_args_info_help[46] ;
  args_info->write_dg18_help = gengetopt_args_info_help[47] ;
  args_info->write_dg19_help = gengetopt_args_info_help[48] ;
  args_info->write_dg20_help = gengetopt_args_info_help[49] ;
  args_info->write_dg21_help = gengetopt_args_info_help[50] ;
  args_info->verify_validity_help = gengetopt_args_info_help[52] ;
  args_info->older_than_help = gengetopt_args_info_help[53] ;
  args_info->verify_community_help = gengetopt_args_info_help[54] ;
  args_info->break_help = gengetopt_args_info_help[56] ;
  args_info->translate_help = gengetopt_args_info_help[57] ;
  args_info->tr_03110v201_help = gengetopt_args_info_help[58] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->reader_arg));
  free_string_field (&(args_info->reader_orig));
  free_string_field (&(args_info->pin_arg));
  free_string_field (&(args_info->pin_orig));
  free_string_field (&(args_info->puk_arg));
  free_string_field (&(args_info->puk_orig));
  free_string_field (&(args_info->can_arg));
  free_string_field (&(args_info->can_orig));
  free_string_field (&(args_info->mrz_arg));
  free_string_field (&(args_info->mrz_orig));
  free_string_field (&(args_info->new_pin_arg));
  free_string_field (&(args_info->new_pin_orig));
  free_multiple_string_field (args_info->cv_certificate_given, &(args_info->cv_certificate_arg), &(args_info->cv_certificate_orig));
  free_string_field (&(args_info->cert_desc_arg));
  free_string_field (&(args_info->cert_desc_orig));
  free_string_field (&(args_info->chat_arg));
  free_string_field (&(args_info->chat_orig));
  free_string_field (&(args_info->auxiliary_data_arg));
  free_string_field (&(args_info->auxiliary_data_orig));
  free_string_field (&(args_info->private_key_arg));
  free_string_field (&(args_info->private_key_orig));
  free_string_field (&(args_info->cvc_dir_arg));
  free_string_field (&(args_info->cvc_dir_orig));
  free_string_field (&(args_info->x509_dir_arg));
  free_string_field (&(args_info->x509_dir_orig));
  free_string_field (&(args_info->write_dg17_arg));
  free_string_field (&(args_info->write_dg17_orig));
  free_string_field (&(args_info->write_dg18_arg));
  free_string_field (&(args_info->write_dg18_orig));
  free_string_field (&(args_info->write_dg19_arg));
  free_string_field (&(args_info->write_dg19_orig));
  free_string_field (&(args_info->write_dg20_arg));
  free_string_field (&(args_info->write_dg20_orig));
  free_string_field (&(args_info->write_dg21_arg));
  free_string_field (&(args_info->write_dg21_orig));
  free_string_field (&(args_info->verify_validity_arg));
  free_string_field (&(args_info->verify_validity_orig));
  free_string_field (&(args_info->older_than_arg));
  free_string_field (&(args_info->older_than_orig));
  free_string_field (&(args_info->verify_community_arg));
  free_string_field (&(args_info->verify_community_orig));
  free_string_field (&(args_info->translate_arg));
  free_string_field (&(args_info->translate_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->reader_given)
    write_into_file(outfile, "reader", args_info->reader_orig, 0);
  write_multiple_into_file(outfile, args_info->verbose_given, "verbose", 0, 0);
  if (args_info->pin_given)
    write_into_file(outfile, "pin", args_info->pin_orig, 0);
  if (args_info->puk_given)
    write_into_file(outfile, "puk", args_info->puk_orig, 0);
  if (args_info->can_given)
    write_into_file(outfile, "can", args_info->can_orig, 0);
  if (args_info->mrz_given)
    write_into_file(outfile, "mrz", args_info->mrz_orig, 0);
  if (args_info->env_given)
    write_into_file(outfile, "env", 0, 0 );
  if (args_info->new_pin_given)
    write_into_file(outfile, "new-pin", args_info->new_pin_orig, 0);
  if (args_info->resume_given)
    write_into_file(outfile, "resume", 0, 0 );
  if (args_info->unblock_given)
    write_into_file(outfile, "unblock", 0, 0 );
  write_multiple_into_file(outfile, args_info->cv_certificate_given, "cv-certificate", args_info->cv_certificate_orig, 0);
  if (args_info->cert_desc_given)
    write_into_file(outfile, "cert-desc", args_info->cert_desc_orig, 0);
  if (args_info->chat_given)
    write_into_file(outfile, "chat", args_info->chat_orig, 0);
  if (args_info->auxiliary_data_given)
    write_into_file(outfile, "auxiliary-data", args_info->auxiliary_data_orig, 0);
  if (args_info->private_key_given)
    write_into_file(outfile, "private-key", args_info->private_key_orig, 0);
  if (args_info->cvc_dir_given)
    write_into_file(outfile, "cvc-dir", args_info->cvc_dir_orig, 0);
  if (args_info->x509_dir_given)
    write_into_file(outfile, "x509-dir", args_info->x509_dir_orig, 0);
  if (args_info->disable_ta_checks_given)
    write_into_file(outfile, "disable-ta-checks", 0, 0 );
  if (args_info->disable_ca_checks_given)
    write_into_file(outfile, "disable-ca-checks", 0, 0 );
  if (args_info->read_dg1_given)
    write_into_file(outfile, "read-dg1", 0, 0 );
  if (args_info->read_dg2_given)
    write_into_file(outfile, "read-dg2", 0, 0 );
  if (args_info->read_dg3_given)
    write_into_file(outfile, "read-dg3", 0, 0 );
  if (args_info->read_dg4_given)
    write_into_file(outfile, "read-dg4", 0, 0 );
  if (args_info->read_dg5_given)
    write_into_file(outfile, "read-dg5", 0, 0 );
  if (args_info->read_dg6_given)
    write_into_file(outfile, "read-dg6", 0, 0 );
  if (args_info->read_dg7_given)
    write_into_file(outfile, "read-dg7", 0, 0 );
  if (args_info->read_dg8_given)
    write_into_file(outfile, "read-dg8", 0, 0 );
  if (args_info->read_dg9_given)
    write_into_file(outfile, "read-dg9", 0, 0 );
  if (args_info->read_dg10_given)
    write_into_file(outfile, "read-dg10", 0, 0 );
  if (args_info->read_dg11_given)
    write_into_file(outfile, "read-dg11", 0, 0 );
  if (args_info->read_dg12_given)
    write_into_file(outfile, "read-dg12", 0, 0 );
  if (args_info->read_dg13_given)
    write_into_file(outfile, "read-dg13", 0, 0 );
  if (args_info->read_dg14_given)
    write_into_file(outfile, "read-dg14", 0, 0 );
  if (args_info->read_dg15_given)
    write_into_file(outfile, "read-dg15", 0, 0 );
  if (args_info->read_dg16_given)
    write_into_file(outfile, "read-dg16", 0, 0 );
  if (args_info->read_dg17_given)
    write_into_file(outfile, "read-dg17", 0, 0 );
  if (args_info->read_dg18_given)
    write_into_file(outfile, "read-dg18", 0, 0 );
  if (args_info->read_dg19_given)
    write_into_file(outfile, "read-dg19", 0, 0 );
  if (args_info->read_dg20_given)
    write_into_file(outfile, "read-dg20", 0, 0 );
  if (args_info->read_dg21_given)
    write_into_file(outfile, "read-dg21", 0, 0 );
  if (args_info->write_dg17_given)
    write_into_file(outfile, "write-dg17", args_info->write_dg17_orig, 0);
  if (args_info->write_dg18_given)
    write_into_file(outfile, "write-dg18", args_info->write_dg18_orig, 0);
  if (args_info->write_dg19_given)
    write_into_file(outfile, "write-dg19", args_info->write_dg19_orig, 0);
  if (args_info->write_dg20_given)
    write_into_file(outfile, "write-dg20", args_info->write_dg20_orig, 0);
  if (args_info->write_dg21_given)
    write_into_file(outfile, "write-dg21", args_info->write_dg21_orig, 0);
  if (args_info->verify_validity_given)
    write_into_file(outfile, "verify-validity", args_info->verify_validity_orig, 0);
  if (args_info->older_than_given)
    write_into_file(outfile, "older-than", args_info->older_than_orig, 0);
  if (args_info->verify_community_given)
    write_into_file(outfile, "verify-community", args_info->verify_community_orig, 0);
  if (args_info->break_given)
    write_into_file(outfile, "break", 0, 0 );
  if (args_info->translate_given)
    write_into_file(outfile, "translate", args_info->translate_orig, 0);
  if (args_info->tr_03110v201_given)
    write_into_file(outfile, "tr-03110v201", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->verbose_given, args_info->verbose_min, args_info->verbose_max, "'--verbose' ('-v')"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->cv_certificate_given, args_info->cv_certificate_min, args_info->cv_certificate_max, "'--cv-certificate' ('-C')"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

	FIX_UNUSED(stop_char);
	
  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * cv_certificate_list = NULL;
  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "reader",	1, NULL, 'r' },
        { "verbose",	0, NULL, 'v' },
        { "pin",	2, NULL, 'p' },
        { "puk",	2, NULL, 'u' },
        { "can",	2, NULL, 'c' },
        { "mrz",	2, NULL, 'm' },
        { "env",	0, NULL, 0 },
        { "new-pin",	2, NULL, 'N' },
        { "resume",	0, NULL, 'R' },
        { "unblock",	0, NULL, 'U' },
        { "cv-certificate",	1, NULL, 'C' },
        { "cert-desc",	1, NULL, 0 },
        { "chat",	1, NULL, 0 },
        { "auxiliary-data",	1, NULL, 'A' },
        { "private-key",	1, NULL, 'P' },
        { "cvc-dir",	1, NULL, 0 },
        { "x509-dir",	1, NULL, 0 },
        { "disable-ta-checks",	0, NULL, 0 },
        { "disable-ca-checks",	0, NULL, 0 },
        { "read-dg1",	0, NULL, 0 },
        { "read-dg2",	0, NULL, 0 },
        { "read-dg3",	0, NULL, 0 },
        { "read-dg4",	0, NULL, 0 },
        { "read-dg5",	0, NULL, 0 },
        { "read-dg6",	0, NULL, 0 },
        { "read-dg7",	0, NULL, 0 },
        { "read-dg8",	0, NULL, 0 },
        { "read-dg9",	0, NULL, 0 },
        { "read-dg10",	0, NULL, 0 },
        { "read-dg11",	0, NULL, 0 },
        { "read-dg12",	0, NULL, 0 },
        { "read-dg13",	0, NULL, 0 },
        { "read-dg14",	0, NULL, 0 },
        { "read-dg15",	0, NULL, 0 },
        { "read-dg16",	0, NULL, 0 },
        { "read-dg17",	0, NULL, 0 },
        { "read-dg18",	0, NULL, 0 },
        { "read-dg19",	0, NULL, 0 },
        { "read-dg20",	0, NULL, 0 },
        { "read-dg21",	0, NULL, 0 },
        { "write-dg17",	1, NULL, 0 },
        { "write-dg18",	1, NULL, 0 },
        { "write-dg19",	1, NULL, 0 },
        { "write-dg20",	1, NULL, 0 },
        { "write-dg21",	1, NULL, 0 },
        { "verify-validity",	1, NULL, 0 },
        { "older-than",	1, NULL, 0 },
        { "verify-community",	1, NULL, 0 },
        { "break",	0, NULL, 'b' },
        { "translate",	1, NULL, 't' },
        { "tr-03110v201",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVr:vp::u::c::m::N::RUC:A:P:bt:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'r':	/* Number of the reader to use. By default, the first reader with a present card is used. If the argument is an ATR, the reader with a matching card will be chosen..  */
        
        
          if (update_arg( (void *)&(args_info->reader_arg), 
               &(args_info->reader_orig), &(args_info->reader_given),
              &(local_args_info.reader_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "reader", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Use (several times) to be more verbose.  */
        
          local_args_info.verbose_given++;
        
          break;
        case 'p':	/* Run PACE with (transport) eID-PIN.  */
        
        
          if (update_arg( (void *)&(args_info->pin_arg), 
               &(args_info->pin_orig), &(args_info->pin_given),
              &(local_args_info.pin_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "pin", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'u':	/* Run PACE with PUK.  */
        
        
          if (update_arg( (void *)&(args_info->puk_arg), 
               &(args_info->puk_orig), &(args_info->puk_given),
              &(local_args_info.puk_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "puk", 'u',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Run PACE with CAN.  */
        
        
          if (update_arg( (void *)&(args_info->can_arg), 
               &(args_info->can_orig), &(args_info->can_given),
              &(local_args_info.can_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "can", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* Run PACE with MRZ (insert MRZ without newlines).  */
        
        
          if (update_arg( (void *)&(args_info->mrz_arg), 
               &(args_info->mrz_orig), &(args_info->mrz_given),
              &(local_args_info.mrz_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "mrz", 'm',
              additional_error))
            goto failure;
        
          break;
        case 'N':	/* Install a new PIN.  */
        
        
          if (update_arg( (void *)&(args_info->new_pin_arg), 
               &(args_info->new_pin_orig), &(args_info->new_pin_given),
              &(local_args_info.new_pin_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "new-pin", 'N',
              additional_error))
            goto failure;
        
          break;
        case 'R':	/* Resume eID-PIN (uses CAN to activate last retry).  */
        
        
          if (update_arg((void *)&(args_info->resume_flag), 0, &(args_info->resume_given),
              &(local_args_info.resume_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "resume", 'R',
              additional_error))
            goto failure;
        
          break;
        case 'U':	/* Unblock PIN (uses PUK to activate three more retries).  */
        
        
          if (update_arg((void *)&(args_info->unblock_flag), 0, &(args_info->unblock_given),
              &(local_args_info.unblock_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "unblock", 'U',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* Card Verifiable Certificate to create a certificate chain. Can be used multiple times (order is important)..  */
        
          if (update_multiple_arg_temp(&cv_certificate_list, 
              &(local_args_info.cv_certificate_given), optarg, 0, 0, ARG_STRING,
              "cv-certificate", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'A':	/* Terminal's auxiliary data (default is determined by verification of validity, age and community ID)..  */
        
        
          if (update_arg( (void *)&(args_info->auxiliary_data_arg), 
               &(args_info->auxiliary_data_orig), &(args_info->auxiliary_data_given),
              &(local_args_info.auxiliary_data_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "auxiliary-data", 'A',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Terminal's private key.  */
        
        
          if (update_arg( (void *)&(args_info->private_key_arg), 
               &(args_info->private_key_orig), &(args_info->private_key_given),
              &(local_args_info.private_key_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "private-key", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* Brute force PIN, CAN or PUK. Use together with -p, -a or -u.  */
        
        
          if (update_arg((void *)&(args_info->break_flag), 0, &(args_info->break_given),
              &(local_args_info.break_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "break", 'b',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* File with APDUs of HEX_STRINGs to send through the secure channel.  */
        
        
          if (update_arg( (void *)&(args_info->translate_arg), 
               &(args_info->translate_orig), &(args_info->translate_given),
              &(local_args_info.translate_given), optarg, 0, "stdin", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "translate", 't',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Whether to use environment variables PIN, PUK, CAN, MRZ and NEWPIN. You may want to clean your environment before enabling this..  */
          if (strcmp (long_options[option_index].name, "env") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->env_flag), 0, &(args_info->env_given),
                &(local_args_info.env_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "env", '-',
                additional_error))
              goto failure;
          
          }
          /* Certificate description to show for Terminal Authentication.  */
          else if (strcmp (long_options[option_index].name, "cert-desc") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cert_desc_arg), 
                 &(args_info->cert_desc_orig), &(args_info->cert_desc_given),
                &(local_args_info.cert_desc_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "cert-desc", '-',
                additional_error))
              goto failure;
          
          }
          /* Card holder authorization template to use (default is terminal's CHAT). Use 7F4C0E060904007F000703010203530103 to trigger EAC on the CAT-C (Komfortleser)..  */
          else if (strcmp (long_options[option_index].name, "chat") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->chat_arg), 
                 &(args_info->chat_orig), &(args_info->chat_given),
                &(local_args_info.chat_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "chat", '-',
                additional_error))
              goto failure;
          
          }
          /* Where to look for the CVCA's certificate.  */
          else if (strcmp (long_options[option_index].name, "cvc-dir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cvc_dir_arg), 
                 &(args_info->cvc_dir_orig), &(args_info->cvc_dir_given),
                &(local_args_info.cvc_dir_given), optarg, 0, "", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "cvc-dir", '-',
                additional_error))
              goto failure;
          
          }
          /* Where to look for the CSCA's certificate.  */
          else if (strcmp (long_options[option_index].name, "x509-dir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->x509_dir_arg), 
                 &(args_info->x509_dir_orig), &(args_info->x509_dir_given),
                &(local_args_info.x509_dir_given), optarg, 0, "", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "x509-dir", '-',
                additional_error))
              goto failure;
          
          }
          /* Disable checking the validity period of CV certificates.  */
          else if (strcmp (long_options[option_index].name, "disable-ta-checks") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->disable_ta_checks_flag), 0, &(args_info->disable_ta_checks_given),
                &(local_args_info.disable_ta_checks_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "disable-ta-checks", '-',
                additional_error))
              goto failure;
          
          }
          /* Disable passive authentication.  */
          else if (strcmp (long_options[option_index].name, "disable-ca-checks") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->disable_ca_checks_flag), 0, &(args_info->disable_ca_checks_given),
                &(local_args_info.disable_ca_checks_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "disable-ca-checks", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 1   (Document Type).  */
          else if (strcmp (long_options[option_index].name, "read-dg1") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg1_flag), 0, &(args_info->read_dg1_given),
                &(local_args_info.read_dg1_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg1", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 2   (Issuing State).  */
          else if (strcmp (long_options[option_index].name, "read-dg2") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg2_flag), 0, &(args_info->read_dg2_given),
                &(local_args_info.read_dg2_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg2", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 3   (Date of Expiry).  */
          else if (strcmp (long_options[option_index].name, "read-dg3") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg3_flag), 0, &(args_info->read_dg3_given),
                &(local_args_info.read_dg3_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg3", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 4   (Given Names).  */
          else if (strcmp (long_options[option_index].name, "read-dg4") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg4_flag), 0, &(args_info->read_dg4_given),
                &(local_args_info.read_dg4_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg4", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 5   (Family Names).  */
          else if (strcmp (long_options[option_index].name, "read-dg5") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg5_flag), 0, &(args_info->read_dg5_given),
                &(local_args_info.read_dg5_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg5", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 6   (Religious/Artistic Name).  */
          else if (strcmp (long_options[option_index].name, "read-dg6") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg6_flag), 0, &(args_info->read_dg6_given),
                &(local_args_info.read_dg6_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg6", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 7   (Academic Title).  */
          else if (strcmp (long_options[option_index].name, "read-dg7") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg7_flag), 0, &(args_info->read_dg7_given),
                &(local_args_info.read_dg7_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg7", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 8   (Date of Birth).  */
          else if (strcmp (long_options[option_index].name, "read-dg8") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg8_flag), 0, &(args_info->read_dg8_given),
                &(local_args_info.read_dg8_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg8", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 9   (Place of Birth).  */
          else if (strcmp (long_options[option_index].name, "read-dg9") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg9_flag), 0, &(args_info->read_dg9_given),
                &(local_args_info.read_dg9_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg9", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 10  (Nationality).  */
          else if (strcmp (long_options[option_index].name, "read-dg10") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg10_flag), 0, &(args_info->read_dg10_given),
                &(local_args_info.read_dg10_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg10", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 11  (Sex).  */
          else if (strcmp (long_options[option_index].name, "read-dg11") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg11_flag), 0, &(args_info->read_dg11_given),
                &(local_args_info.read_dg11_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg11", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 12  (Optional Data).  */
          else if (strcmp (long_options[option_index].name, "read-dg12") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg12_flag), 0, &(args_info->read_dg12_given),
                &(local_args_info.read_dg12_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg12", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 13  (Birth Name).  */
          else if (strcmp (long_options[option_index].name, "read-dg13") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg13_flag), 0, &(args_info->read_dg13_given),
                &(local_args_info.read_dg13_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg13", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 14.  */
          else if (strcmp (long_options[option_index].name, "read-dg14") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg14_flag), 0, &(args_info->read_dg14_given),
                &(local_args_info.read_dg14_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg14", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 15.  */
          else if (strcmp (long_options[option_index].name, "read-dg15") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg15_flag), 0, &(args_info->read_dg15_given),
                &(local_args_info.read_dg15_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg15", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 16.  */
          else if (strcmp (long_options[option_index].name, "read-dg16") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg16_flag), 0, &(args_info->read_dg16_given),
                &(local_args_info.read_dg16_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg16", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 17  (Normal Place of Residence).  */
          else if (strcmp (long_options[option_index].name, "read-dg17") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg17_flag), 0, &(args_info->read_dg17_given),
                &(local_args_info.read_dg17_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg17", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 18  (Community ID).  */
          else if (strcmp (long_options[option_index].name, "read-dg18") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg18_flag), 0, &(args_info->read_dg18_given),
                &(local_args_info.read_dg18_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg18", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 19  (Residence Permit I).  */
          else if (strcmp (long_options[option_index].name, "read-dg19") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg19_flag), 0, &(args_info->read_dg19_given),
                &(local_args_info.read_dg19_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg19", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 20  (Residence Permit II).  */
          else if (strcmp (long_options[option_index].name, "read-dg20") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg20_flag), 0, &(args_info->read_dg20_given),
                &(local_args_info.read_dg20_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg20", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 21  (Optional Data).  */
          else if (strcmp (long_options[option_index].name, "read-dg21") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg21_flag), 0, &(args_info->read_dg21_given),
                &(local_args_info.read_dg21_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg21", '-',
                additional_error))
              goto failure;
          
          }
          /* Write DG 17 (Normal Place of Residence).  */
          else if (strcmp (long_options[option_index].name, "write-dg17") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->write_dg17_arg), 
                 &(args_info->write_dg17_orig), &(args_info->write_dg17_given),
                &(local_args_info.write_dg17_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-dg17", '-',
                additional_error))
              goto failure;
          
          }
          /* Write DG 18 (Community ID).  */
          else if (strcmp (long_options[option_index].name, "write-dg18") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->write_dg18_arg), 
                 &(args_info->write_dg18_orig), &(args_info->write_dg18_given),
                &(local_args_info.write_dg18_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-dg18", '-',
                additional_error))
              goto failure;
          
          }
          /* Write DG 19 (Residence Permit I).  */
          else if (strcmp (long_options[option_index].name, "write-dg19") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->write_dg19_arg), 
                 &(args_info->write_dg19_orig), &(args_info->write_dg19_given),
                &(local_args_info.write_dg19_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-dg19", '-',
                additional_error))
              goto failure;
          
          }
          /* Write DG 20 (Residence Permit II).  */
          else if (strcmp (long_options[option_index].name, "write-dg20") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->write_dg20_arg), 
                 &(args_info->write_dg20_orig), &(args_info->write_dg20_given),
                &(local_args_info.write_dg20_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-dg20", '-',
                additional_error))
              goto failure;
          
          }
          /* Write DG 21 (Optional Data).  */
          else if (strcmp (long_options[option_index].name, "write-dg21") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->write_dg21_arg), 
                 &(args_info->write_dg21_orig), &(args_info->write_dg21_given),
                &(local_args_info.write_dg21_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-dg21", '-',
                additional_error))
              goto failure;
          
          }
          /* Verify chip's validity with a reference date.  */
          else if (strcmp (long_options[option_index].name, "verify-validity") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->verify_validity_arg), 
                 &(args_info->verify_validity_orig), &(args_info->verify_validity_given),
                &(local_args_info.verify_validity_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "verify-validity", '-',
                additional_error))
              goto failure;
          
          }
          /* Verify age with a reference date.  */
          else if (strcmp (long_options[option_index].name, "older-than") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->older_than_arg), 
                 &(args_info->older_than_orig), &(args_info->older_than_given),
                &(local_args_info.older_than_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "older-than", '-',
                additional_error))
              goto failure;
          
          }
          /* Verify community ID with a reference ID.  */
          else if (strcmp (long_options[option_index].name, "verify-community") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->verify_community_arg), 
                 &(args_info->verify_community_orig), &(args_info->verify_community_given),
                &(local_args_info.verify_community_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "verify-community", '-',
                additional_error))
              goto failure;
          
          }
          /* Force compliance to BSI TR-03110 version 2.01.  */
          else if (strcmp (long_options[option_index].name, "tr-03110v201") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->tr_03110v201_flag), 0, &(args_info->tr_03110v201_given),
                &(local_args_info.tr_03110v201_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "tr-03110v201", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->cv_certificate_arg),
    &(args_info->cv_certificate_orig), args_info->cv_certificate_given,
    local_args_info.cv_certificate_given, 0,
    ARG_STRING, cv_certificate_list);

  args_info->verbose_given += local_args_info.verbose_given;
  local_args_info.verbose_given = 0;
  args_info->cv_certificate_given += local_args_info.cv_certificate_given;
  local_args_info.cv_certificate_given = 0;
  
  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (cv_certificate_list, 1 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
