%feature("docstring") OT::NonCenteredFiniteDifferenceGradient
R"RAW(First order non-centered finite-difference scheme.

Available constructors:
    NonCenteredFiniteDifferenceGradient(*epsilon, evalImpl*)

    NonCenteredFiniteDifferenceGradient(*step, evalImpl*)

Parameters
----------
evalImpl : :class:`~openturns.EvaluationImplementation`
    Implementation of the evaluation of a function.
epsilon : float, sequence of float
    Finite difference steps for each dimension.
step : :class:`~openturns.FiniteDifferenceStep`
    Defines how finite difference steps values are computed.

Notes
-----
*NonCenteredFiniteDifferenceGradient* provides a first order non-centered
finite-difference scheme:

.. math::

    \frac{\partial f_j}{\partial x_i} \approx \frac{f_j(x + \epsilon_i) - f_j(x)}
                                                   {\epsilon_i}

Examples
--------
>>> import openturns as ot
>>> formulas = ['x1 * sin(x2)', 'cos(x1 + x2)', '(x2 + 1) * exp(x1 - 2 * x2)']
>>> myFunc = ot.SymbolicFunction(['x1', 'x2'], formulas)
>>> epsilon = [0.01]*2
>>> myGradient = ot.NonCenteredFiniteDifferenceGradient(epsilon, myFunc.getEvaluation())
>>> inPoint = [1.0]*2
>>> print(myGradient.gradient(inPoint))
[[  0.841471 -0.907202  0.73945  ]
 [  0.536086 -0.907202 -1.09631  ]])RAW"
